//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// PrivateEndpointConnectionsPrivateLinkHubServer is a fake server for instances of the armsynapse.PrivateEndpointConnectionsPrivateLinkHubClient type.
type PrivateEndpointConnectionsPrivateLinkHubServer struct {
	// Get is the fake for method PrivateEndpointConnectionsPrivateLinkHubClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, privateLinkHubName string, privateEndpointConnectionName string, options *armsynapse.PrivateEndpointConnectionsPrivateLinkHubClientGetOptions) (resp azfake.Responder[armsynapse.PrivateEndpointConnectionsPrivateLinkHubClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method PrivateEndpointConnectionsPrivateLinkHubClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, privateLinkHubName string, options *armsynapse.PrivateEndpointConnectionsPrivateLinkHubClientListOptions) (resp azfake.PagerResponder[armsynapse.PrivateEndpointConnectionsPrivateLinkHubClientListResponse])
}

// NewPrivateEndpointConnectionsPrivateLinkHubServerTransport creates a new instance of PrivateEndpointConnectionsPrivateLinkHubServerTransport with the provided implementation.
// The returned PrivateEndpointConnectionsPrivateLinkHubServerTransport instance is connected to an instance of armsynapse.PrivateEndpointConnectionsPrivateLinkHubClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrivateEndpointConnectionsPrivateLinkHubServerTransport(srv *PrivateEndpointConnectionsPrivateLinkHubServer) *PrivateEndpointConnectionsPrivateLinkHubServerTransport {
	return &PrivateEndpointConnectionsPrivateLinkHubServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armsynapse.PrivateEndpointConnectionsPrivateLinkHubClientListResponse]](),
	}
}

// PrivateEndpointConnectionsPrivateLinkHubServerTransport connects instances of armsynapse.PrivateEndpointConnectionsPrivateLinkHubClient to instances of PrivateEndpointConnectionsPrivateLinkHubServer.
// Don't use this type directly, use NewPrivateEndpointConnectionsPrivateLinkHubServerTransport instead.
type PrivateEndpointConnectionsPrivateLinkHubServerTransport struct {
	srv          *PrivateEndpointConnectionsPrivateLinkHubServer
	newListPager *tracker[azfake.PagerResponder[armsynapse.PrivateEndpointConnectionsPrivateLinkHubClientListResponse]]
}

// Do implements the policy.Transporter interface for PrivateEndpointConnectionsPrivateLinkHubServerTransport.
func (p *PrivateEndpointConnectionsPrivateLinkHubServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrivateEndpointConnectionsPrivateLinkHubClient.Get":
		resp, err = p.dispatchGet(req)
	case "PrivateEndpointConnectionsPrivateLinkHubClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrivateEndpointConnectionsPrivateLinkHubServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/privateLinkHubs/(?P<privateLinkHubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections/(?P<privateEndpointConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	privateLinkHubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateLinkHubName")])
	if err != nil {
		return nil, err
	}
	privateEndpointConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateEndpointConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, privateLinkHubNameParam, privateEndpointConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateEndpointConnectionForPrivateLinkHub, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PrivateEndpointConnectionsPrivateLinkHubServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/privateLinkHubs/(?P<privateLinkHubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndpointConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		privateLinkHubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("privateLinkHubName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListPager(resourceGroupNameParam, privateLinkHubNameParam, nil)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsynapse.PrivateEndpointConnectionsPrivateLinkHubClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}
