//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ListSqlPoolOperations.json
func ExampleSQLPoolOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSQLPoolOperationsClient().NewListPager("sqlcrudtest-7398", "sqlcrudtest-4645", "testdb", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SQLPoolBlobAuditingPolicySQLPoolOperationListResult = armsynapse.SQLPoolBlobAuditingPolicySQLPoolOperationListResult{
		// 	Value: []*armsynapse.SQLPoolOperation{
		// 		{
		// 			Name: to.Ptr("11111111-1111-1111-1111-111111111111"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/operations"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-7398/providers/Microsoft.Synapse/workspaces/sqlcrudtest-4645/sqlPools/testdb/operations/11111111-1111-1111-1111-111111111111"),
		// 			Properties: &armsynapse.SQLPoolOperationProperties{
		// 				Description: to.Ptr("UpdateLogicalDatabase on 'testdb', target ServiceLevelObjective S3"),
		// 				DatabaseName: to.Ptr("testdb"),
		// 				EstimatedCompletionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T13:10:10.000Z"); return t}()),
		// 				IsCancellable: to.Ptr(false),
		// 				Operation: to.Ptr("UpdateLogicalDatabase"),
		// 				OperationFriendlyName: to.Ptr("ALTER DATABASE"),
		// 				PercentComplete: to.Ptr[int32](100),
		// 				ServerName: to.Ptr("sqlcrudtest-4645"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T09:10:08.100Z"); return t}()),
		// 				State: to.Ptr(armsynapse.ManagementOperationStateSucceeded),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("55555555-5555-5555-5555-555555555555"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/operations"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/sqlcrudtest-7398/providers/Microsoft.Synapse/workspaces/sqlcrudtest-4645/sqlPools/testdb/operations/55555555-5555-5555-5555-555555555555"),
		// 			Properties: &armsynapse.SQLPoolOperationProperties{
		// 				Description: to.Ptr("UpdateLogicalDatabase on 'testdb', target ServiceLevelObjective S3"),
		// 				DatabaseName: to.Ptr("testdb"),
		// 				EstimatedCompletionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T13:10:10.000Z"); return t}()),
		// 				IsCancellable: to.Ptr(true),
		// 				Operation: to.Ptr("UpdateLogicalDatabase"),
		// 				OperationFriendlyName: to.Ptr("ALTER DATABASE"),
		// 				PercentComplete: to.Ptr[int32](19),
		// 				ServerName: to.Ptr("sqlcrudtest-4645"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-06-01T10:10:08.100Z"); return t}()),
		// 				State: to.Ptr(armsynapse.ManagementOperationStateInProgress),
		// 			},
		// 	}},
		// }
	}
}
