//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtestbase

import "time"

// AccountListResult - A list of Test Base Accounts.
type AccountListResult struct {
	// The list of Test Base Accounts.
	Value []*AccountResource

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// AccountResource - The Test Base Account resource.
type AccountResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Properties of a Test Base Account.
	Properties *AccountResourceProperties

	// The tags of the resource.
	Tags map[string]*string

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// AccountResourceProperties - The properties of a Test Base Account resource.
type AccountResourceProperties struct {
	// REQUIRED; The SKU of the Test Base Account.
	SKU *AccountSKU

	// READ-ONLY; The access level of the Test Base Account.
	AccessLevel *string

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// AccountSKU - Describes a Test Base Account SKU.
type AccountSKU struct {
	// REQUIRED; The name of the SKU. This is typically a letter + number code, such as B0 or S0.
	Name *string

	// REQUIRED; The tier of this particular SKU.
	Tier *Tier

	// The locations that the SKU is available.
	Locations []*string

	// The type of resource the SKU applies to.
	ResourceType *string

	// READ-ONLY; The capabilities of a SKU.
	Capabilities []*AccountSKUCapability
}

// AccountSKUCapability - Properties of the Test Base Account SKU Capability.
type AccountSKUCapability struct {
	// REQUIRED; An invariant to describe the feature, such as 'SLA'.
	Name *string

	// REQUIRED; An invariant if the feature is measured by quantity, such as 99.9%.
	Value *string
}

// AccountSKUListResult - A list of Test Base Account SKUs.
type AccountSKUListResult struct {
	// The list of Test Base Account SKUs.
	Value []*AccountSKU

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// AccountUpdateParameterProperties - Parameters supplied to update a Test Base Account.
type AccountUpdateParameterProperties struct {
	// The SKU of the Test Base Account.
	SKU *AccountSKU
}

// AccountUpdateParameters - Parameters supplied to update a Test Base Account.
type AccountUpdateParameters struct {
	// Test Base Account update parameters.
	Properties *AccountUpdateParameterProperties

	// The tags of the Test Base Account.
	Tags map[string]*string
}

// AccountUsageData - The usage data of a Test Base Account.
type AccountUsageData struct {
	// Current value for the usage quota.
	CurrentValue *int64

	// Fully qualified ARM resource id
	ID *string

	// The maximum permitted value for the usage quota. If there is no limit, this value will be -1.
	Limit *int64

	// Localizable String object containing the name and a localized value.
	Name *AccountUsageName

	// Representing the units of the usage quota. Possible values are: Count, Bytes, Seconds, Percent, CountPerSecond, BytesPerSecond.
	Unit *string
}

// AccountUsageDataList - A list of Test Base Account usage data.
type AccountUsageDataList struct {
	// The list of Test Base Account usage data.
	Value []*AccountUsageData

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// AccountUsageName - Localizable String object containing the name and a localized value.
type AccountUsageName struct {
	// Localized name of the usage.
	LocalizedValue *string

	// The identifier of the usage.
	Value *string
}

// AnalysisResultListResult - A list of Analysis Results. It will only contain one element as all the data will be nested
// in a singleton object.
type AnalysisResultListResult struct {
	// The list of Analysis Results.
	Value []*AnalysisResultSingletonResource

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// AnalysisResultSingletonResource - The Analysis Result Singleton Resource.
type AnalysisResultSingletonResource struct {
	// Properties of an Analysis Result.
	Properties AnalysisResultSingletonResourcePropertiesClassification

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// AnalysisResultSingletonResourceProperties - The properties of Analysis Result resource.
type AnalysisResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType

	// The grade of the test.
	Grade *Grade
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type AnalysisResultSingletonResourceProperties.
func (a *AnalysisResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return a
}

// AvailableOSListResult - A list of available OSs.
type AvailableOSListResult struct {
	// The list of available OSs.
	Value []*AvailableOSResource

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// AvailableOSProperties - The Available OS properties.
type AvailableOSProperties struct {
	// The insider channel of an Available OS of a Test Base Account.
	InsiderChannel *string

	// The Id of an Available OS of a Test Base Account.
	OSID *string

	// The name of an Available OS of a Test Base Account.
	OSName *string

	// The Platform of an Available OS of a Test Base Account.
	OSPlatform *string

	// The OS update type of an Available OS of a Test Base Account.
	OSUpdateType *string

	// The version of an Available OS of a Test Base Account.
	OSVersion *string
}

// AvailableOSResource - The Available OS resource.
type AvailableOSResource struct {
	// Available OS properties.
	Properties *AvailableOSProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// CPURegressionResultSingletonResourceProperties - The properties of CPU Regression Result.
type CPURegressionResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType

	// The result array data.
	CPURegressionResults []*RegressionResult

	// The grade of the test.
	Grade *Grade
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type CPURegressionResultSingletonResourceProperties.
func (c *CPURegressionResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		AnalysisResultType: c.AnalysisResultType,
		Grade:              c.Grade,
	}
}

// CPUUtilizationResultSingletonResourceProperties - The properties of CPU Utilization Result.
type CPUUtilizationResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType

	// The result array data.
	CPUUtilizationResults []*UtilizationResult

	// The grade of the test.
	Grade *Grade
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type CPUUtilizationResultSingletonResourceProperties.
func (c *CPUUtilizationResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		AnalysisResultType: c.AnalysisResultType,
		Grade:              c.Grade,
	}
}

// CheckNameAvailabilityResult - Description of a Check Name availability response properties.
type CheckNameAvailabilityResult struct {
	// Value indicating the availability of the name: true if the name is available; otherwise, false.
	NameAvailable *bool

	// The reason for unavailability of a name. Required if nameAvailable == false.
	Reason *Reason

	// READ-ONLY; The detailed info regarding the reason associated with the name. Required if nameAvailable == false.
	Message *string
}

// Command - The command used in the test
type Command struct {
	// REQUIRED; The action of the command.
	Action *Action

	// REQUIRED; The content of the command. The content depends on source type.
	Content *string

	// REQUIRED; The type of command content.
	ContentType *ContentType

	// REQUIRED; The name of the command.
	Name *string

	// Specifies whether to run the command even if a previous command is failed.
	AlwaysRun *bool

	// Specifies whether to apply update before the command.
	ApplyUpdateBefore *bool

	// Specifies the max run time of the command.
	MaxRunTime *int32

	// Specifies whether to restart the VM after the command executed.
	RestartAfter *bool

	// Specifies whether to run the command in interactive mode.
	RunAsInteractive *bool

	// Specifies whether to run the command as administrator.
	RunElevated *bool
}

// CustomerEventListResult - A list of Test Base Customer Events.
type CustomerEventListResult struct {
	// The list of Test Base Customer Events.
	Value []*CustomerEventResource

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// CustomerEventProperties - A notification events subscribed to be received by customer.
type CustomerEventProperties struct {
	// REQUIRED; The name of the event subscribed to.
	EventName *string

	// REQUIRED; The notification event receivers.
	Receivers []*NotificationEventReceiver
}

// CustomerEventResource - The Customer Notification Event resource.
type CustomerEventResource struct {
	// Customer Notification Event properties.
	Properties *CustomerEventProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// DistributionGroupListReceiverValue - The user object receiver value.
type DistributionGroupListReceiverValue struct {
	// The list of distribution groups.
	DistributionGroups []*string
}

// DownloadURLResponse - The response of getting a download URL.
type DownloadURLResponse struct {
	// READ-ONLY; The download URL.
	DownloadURL *string

	// READ-ONLY; Expiry date of the download URL.
	ExpirationTime *time.Time
}

// EmailEventListResult - A list of email events.
type EmailEventListResult struct {
	// The list of email events.
	Value []*EmailEventResource

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// EmailEventProperties - The Email Event properties.
type EmailEventProperties struct {
	// The display name of the email event.
	DisplayName *string

	// The identifier of the email event.
	EventID *string

	// The name of the email event.
	EventName *string
}

// EmailEventResource - The email event resource.
type EmailEventResource struct {
	// Email Event properties.
	Properties *EmailEventProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// ErrorDefinition - Error definition.
type ErrorDefinition struct {
	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDefinition

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The target of the particular error.
	Target *string
}

// ErrorResponse - The error response send when an operation fails.
type ErrorResponse struct {
	// The error details.
	Error *ErrorDefinition
}

// FavoriteProcessListResult - A list of favorite processes for a package.
type FavoriteProcessListResult struct {
	// The list of favorite processes for a package.
	Value []*FavoriteProcessResource

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// FavoriteProcessProperties - Properties of a favorite process identifier.
type FavoriteProcessProperties struct {
	// REQUIRED; The actual name of the favorite process. It will be equal to resource name except for the scenario that the process
	// name contains characters that are not allowed in the resource name.
	ActualProcessName *string
}

// FavoriteProcessResource - A favorite process identifier.
type FavoriteProcessResource struct {
	// Properties of a favorite process identifier.
	Properties *FavoriteProcessProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// FileUploadURLResponse - The URL response
type FileUploadURLResponse struct {
	// READ-ONLY; The blob path of the uploaded package. It will be used as the 'blobPath' property of PackageResource.
	BlobPath *string

	// READ-ONLY; The URL used for uploading the package.
	UploadURL *string
}

// FlightingRingListResult - A list of flighting rings.
type FlightingRingListResult struct {
	// The list of flighting rings.
	Value []*FlightingRingResource

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// FlightingRingProperties - The Flighting Ring properties.
type FlightingRingProperties struct {
	// The actual name of a flighting ring of a Test Base Account.
	ActualFlightingRingName *string
}

// FlightingRingResource - The flighting ring resource.
type FlightingRingResource struct {
	// Flighting Ring properties.
	Properties *FlightingRingProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// GetFileUploadURLParameters - The parameters supplied to the Test Base Account GetFileUploadURL action.
type GetFileUploadURLParameters struct {
	// The custom file name of the uploaded blob.
	BlobName *string
}

// IdentifiedFailure - The failure identified.
type IdentifiedFailure struct {
	// The category of the failure.
	Category *Category

	// Message that shows information about the failure.
	ErrorMessage *string

	// The Failure Id.
	FailureID *string

	// Guidance that shows what the customer needs to do for this failure.
	Guidance *string
}

// MemoryRegressionResultSingletonResourceProperties - The properties of Memory Regression Result.
type MemoryRegressionResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType

	// The grade of the test.
	Grade *Grade

	// The result array data.
	MemoryRegressionResults []*RegressionResult
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type MemoryRegressionResultSingletonResourceProperties.
func (m *MemoryRegressionResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		AnalysisResultType: m.AnalysisResultType,
		Grade:              m.Grade,
	}
}

// MemoryUtilizationResultSingletonResourceProperties - The properties of Memory Utilization Result.
type MemoryUtilizationResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType

	// The grade of the test.
	Grade *Grade

	// The result array data.
	MemoryUtilizationResults []*UtilizationResult
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type MemoryUtilizationResultSingletonResourceProperties.
func (m *MemoryUtilizationResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		AnalysisResultType: m.AnalysisResultType,
		Grade:              m.Grade,
	}
}

// NotificationEventReceiver - A notification event receivers.
type NotificationEventReceiver struct {
	// The type of the notification event receiver.
	ReceiverType *string

	// The notification event receiver value.
	ReceiverValue *NotificationReceiverValue
}

// NotificationReceiverValue - A notification event receiver value.
type NotificationReceiverValue struct {
	// The user object receiver value.
	DistributionGroupListReceiverValue *DistributionGroupListReceiverValue

	// The user object receiver value.
	SubscriptionReceiverValue *SubscriptionReceiverValue

	// The user object receiver value.
	UserObjectReceiverValue *UserObjectReceiverValue
}

// OSUpdateListResult - A list of OS Updates.
type OSUpdateListResult struct {
	// The list of OS Updates.
	Value []*OSUpdateResource

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// OSUpdateProperties - Properties of an OS Update.
type OSUpdateProperties struct {
	// The build revision of the tested release (OS update)
	BuildRevision *string

	// The build version of the tested release (OS update).
	BuildVersion *string

	// The flighting ring, only for release of feature updates.
	FlightingRing *string

	// The name of the OS.
	OSName *string

	// The name of tested release.
	Release *string

	// The release version date the tested release (OS update)
	ReleaseVersionDate *time.Time

	// The type of this release (OS update).
	Type *Type
}

// OSUpdateResource - An OS Update.
type OSUpdateResource struct {
	// Properties of an OS Update.
	Properties *OSUpdateProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// OSUpdateTestSummary - The summary of a test.
type OSUpdateTestSummary struct {
	// The build revision of the tested release (OS update)
	BuildRevision *string

	// The build version of the tested release (OS update)
	BuildVersion *string

	// The execution status of the test.
	ExecutionStatus *ExecutionStatus

	// The flighting ring, only for release of feature updates.
	FlightingRing *string

	// The grade of the test.
	Grade *Grade

	// The operating system name. e.g. Windows 10 1809.
	OSName *string

	// The name of the tested release (OS update).
	ReleaseName *string

	// The release version date.
	ReleaseVersionDate *time.Time

	// The run time of the test.
	TestRunTime *string

	// The status of the test.
	TestStatus *TestStatus

	// The test type of the package
	TestType *string
}

// OSUpdatesTestSummary - The summary of some tests.
type OSUpdatesTestSummary struct {
	// The status of the last test.
	ExecutionStatus *ExecutionStatus

	// The grade of last test.
	Grade *Grade

	// Detailed summary for each OS update
	OSUpdateTestSummaries []*OSUpdateTestSummary

	// The run time of the last test.
	TestRunTime *string

	// The status of last test.
	TestStatus *TestStatus
}

// Operation - REST API operation
type Operation struct {
	// The object that describes the operation.
	Display *OperationDisplay

	// Extra properties of the operation.
	Properties any

	// READ-ONLY; Indicates whether the operation is a data action
	IsDataAction *bool

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string

	// READ-ONLY; Origin of the operation
	Origin *string
}

// OperationDisplay - The object that describes the operation.
type OperationDisplay struct {
	// READ-ONLY; Friendly name of the operation.
	Description *string

	// READ-ONLY; Operation type: read, write, delete, listPackages, etc.
	Operation *string

	// READ-ONLY; The resource provider name: Microsoft.TestBase.
	Provider *string

	// READ-ONLY; Resource type on which the operation is performed.
	Resource *string
}

// OperationListResult - A list of operations supported by the resource provider.
type OperationListResult struct {
	// List of operations supported by the Test Base resource provider.
	Value []*Operation

	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string
}

// PackageCheckNameAvailabilityParameters - Parameters body to pass for Test Base Package name availability check.
type PackageCheckNameAvailabilityParameters struct {
	// REQUIRED; Application name to verify.
	ApplicationName *string

	// REQUIRED; Resource name to verify.
	Name *string

	// REQUIRED; fully qualified resource type which includes provider namespace.
	Type *string

	// REQUIRED; Version name to verify.
	Version *string
}

// PackageListResult - A list of Test Base Packages.
type PackageListResult struct {
	// The list of Test Base Packages.
	Value []*PackageResource

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// PackageProperties - The properties of the Test Base Package.
type PackageProperties struct {
	// REQUIRED; Application name
	ApplicationName *string

	// REQUIRED; The file path of the package.
	BlobPath *string

	// REQUIRED; The flighting ring for feature update.
	FlightingRing *string

	// REQUIRED; Specifies the target OSs of specific OS Update types.
	TargetOSList []*TargetOSInfo

	// REQUIRED; The detailed test information.
	Tests []*Test

	// REQUIRED; Application version
	Version *string

	// READ-ONLY; Flag showing that whether the package is enabled. It doesn't schedule test for package which is not enabled.
	IsEnabled *bool

	// READ-ONLY; The UTC timestamp when the package was last modified.
	LastModifiedTime *time.Time

	// READ-ONLY; The status of the package.
	PackageStatus *PackageStatus

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; OOB, functional or both. Mapped to the data in 'tests' property.
	TestTypes []*TestType

	// READ-ONLY; The validation results. There's validation on package when it's created or updated.
	ValidationResults []*PackageValidationResult
}

// PackageResource - The Test Base Package resource.
type PackageResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Test Base Package properties.
	Properties *PackageProperties

	// The tags of the resource.
	Tags map[string]*string

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// PackageUpdateParameterProperties - Parameters supplied to update a Test Base Package.
type PackageUpdateParameterProperties struct {
	// The file name of the package.
	BlobPath *string

	// The flighting ring for feature update.
	FlightingRing *string

	// Specifies whether the package is enabled. It doesn't schedule test for package which is not enabled.
	IsEnabled *bool

	// Specifies the target OSs of specific OS Update types.
	TargetOSList []*TargetOSInfo

	// The detailed test information.
	Tests []*Test
}

// PackageUpdateParameters - Parameters supplied to update a Test Base Package.
type PackageUpdateParameters struct {
	// Test Base Package update parameters.
	Properties *PackageUpdateParameterProperties

	// The tags of the Package.
	Tags map[string]*string
}

// PackageValidationResult - The validation results. There's validation on package when it's created or updated.
type PackageValidationResult struct {
	// READ-ONLY; Error information.
	Errors []*string

	// READ-ONLY; Indicates whether the package passed the validation.
	IsValid *bool

	// READ-ONLY; Validation name.
	ValidationName *string
}

// ProxyResource - The resource model definition for an ARM proxy resource. It will have everything other than required location
// and tags
type ProxyResource struct {
	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// RegressionResult - The regression result.
type RegressionResult struct {
	// Message that facilitates debugging a particular regression, if any was inferred.
	Details *string

	// Difference between the two datasets being analyzed.
	Diff *float64

	// FileName of the binary being analyzed.
	FileName *string

	// The grade of the test.
	Grade *Grade

	// Indicates if a regression was inferred.
	IsRegressed *bool
}

// RegressionTestDetails - The details of a regression test.
type RegressionTestDetails struct {
	// Difference between the two datasets being analyzed.
	Diff *float64

	// Indicates if a regression was inferred.
	IsRegressed *bool
}

// ReliabilityResult - The Reliability Result.
type ReliabilityResult struct {
	// Count of number of crashes.
	CrashCount *int32

	// The statistic regression grade for crash signal.
	CrashRegressionGrade *Grade

	// Details related to the crash regression analysis.
	CrashRegressionTestDetails *RegressionTestDetails

	// File name.
	FileName *string

	// Count of number of hangs.
	HangCount *int32

	// The statistic regression grade for hang signal.
	HangRegressionGrade *Grade

	// Details related to the hang regression analysis.
	HangRegressionTestDetails *RegressionTestDetails

	// Count of number of launches.
	LaunchCount *int32

	// The regression grade.
	RegressionGrade *Grade
}

// ReliabilityResultSingletonResourceProperties - The properties of Reliability Result.
type ReliabilityResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType

	// The grade of the test.
	Grade *Grade

	// The result array data.
	ReliabilityResults []*ReliabilityResult
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type ReliabilityResultSingletonResourceProperties.
func (r *ReliabilityResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		AnalysisResultType: r.AnalysisResultType,
		Grade:              r.Grade,
	}
}

// Resource - The Resource definition.
type Resource struct {
	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ScriptExecutionResult - The Script Execution Result.
type ScriptExecutionResult struct {
	// End time of script execution.
	EndTime *time.Time

	// Exit code.
	ExitCode *int32

	// Name of script.
	ScriptName *string

	// Start time of script execution.
	StartTime *time.Time

	// Whether the script execution is timed out.
	TimedOut *bool
}

// ScriptExecutionResultSingletonResourceProperties - The properties of Script Execution Result.
type ScriptExecutionResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType

	// The grade of the test.
	Grade *Grade

	// The result array data.
	ScriptExecutionResults []*ScriptExecutionResult
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type ScriptExecutionResultSingletonResourceProperties.
func (s *ScriptExecutionResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		AnalysisResultType: s.AnalysisResultType,
		Grade:              s.Grade,
	}
}

// SubscriptionReceiverValue - The subscription role receiver value.
type SubscriptionReceiverValue struct {
	// The role of the notification receiver.
	Role *string

	// The subscription id of the notification receiver.
	SubscriptionID *string

	// The subscription name of the notification receiver.
	SubscriptionName *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The type of identity that last modified the resource.
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TargetOSInfo - The information of the target OS to be tested.
type TargetOSInfo struct {
	// REQUIRED; Specifies the OS update type to test against, e.g., 'Security updates' or 'Feature updates'.
	OSUpdateType *string

	// REQUIRED; Specifies the target OSs to be tested.
	TargetOSs []*string
}

// Test - The definition of a Test.
type Test struct {
	// REQUIRED; The commands used in the test.
	Commands []*Command

	// REQUIRED; The type of the test.
	TestType *TestType

	// Indicates if this test is active.It doesn't schedule test for not active Test.
	IsActive *bool

	// READ-ONLY; The status of the validation run of the package.
	ValidationRunStatus *ValidationRunStatus
}

// TestAnalysisResult - The test analysis result.
type TestAnalysisResult struct {
	// The data to provide more failure analysis information.
	BlobData *string

	// The array of identified failures.
	IdentifiedFailures []*IdentifiedFailure

	// The status of the analysis.
	TestAnalysisStatus *TestAnalysisStatus
}

// TestAnalysisResultSingletonResourceProperties - The properties of Test Analysis Result.
type TestAnalysisResultSingletonResourceProperties struct {
	// REQUIRED; Type of the Analysis Result.
	AnalysisResultType *AnalysisResultType

	// The grade of the test.
	Grade *Grade

	// The result of test analysis.
	TestAnalysisResult *TestAnalysisResult
}

// GetAnalysisResultSingletonResourceProperties implements the AnalysisResultSingletonResourcePropertiesClassification interface
// for type TestAnalysisResultSingletonResourceProperties.
func (t *TestAnalysisResultSingletonResourceProperties) GetAnalysisResultSingletonResourceProperties() *AnalysisResultSingletonResourceProperties {
	return &AnalysisResultSingletonResourceProperties{
		AnalysisResultType: t.AnalysisResultType,
		Grade:              t.Grade,
	}
}

// TestResultAnalysisSummary - The summary of a Test Analysis Result.
type TestResultAnalysisSummary struct {
	// The analysis status.
	AnalysisStatus *AnalysisStatus

	// The grade of the test result.
	Grade *Grade

	// Metric name
	Name *string
}

// TestResultListResult - A list of Test Results.
type TestResultListResult struct {
	// The list of Test Results.
	Value []*TestResultResource

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// TestResultProperties - The properties of a Test Result.
type TestResultProperties struct {
	// List of analysis summaries.
	AnalysisSummaries []*TestResultAnalysisSummary

	// Application name.
	ApplicationName *string

	// Application version.
	ApplicationVersion *string

	// Azure Id of the baseline test result.
	BaselineTestResultID *string

	// The build revision of the tested release (OS update).
	BuildRevision *string

	// The build version of the tested release (OS update).
	BuildVersion *string

	// The execution status of the test.
	ExecutionStatus *ExecutionStatus

	// The flighting ring, only for release of feature updates.
	FlightingRing *string

	// The grade of the test.
	Grade *Grade

	// Whether download data is available.
	IsDownloadDataAvailable *bool

	// Whether video data is available.
	IsVideoAvailable *bool

	// KB number.
	KbNumber *string

	// The operating system name, e.g. Windows 10 1809.
	OSName *string

	// Resource Id of the package.
	PackageID *string

	// The version of the Windows update package.
	PackageVersion *string

	// The name of the tested release (OS update).
	ReleaseName *string

	// The release version date of the tested release.
	ReleaseVersionDate *time.Time

	// The run time of the test.
	TestRunTime *string

	// The status of the test.
	TestStatus *TestStatus

	// Test type. E.g. 'Out of box test' or 'Functional test'.
	TestType *string
}

// TestResultResource - The Test Result Resource.
type TestResultResource struct {
	// The properties of a Test Result.
	Properties *TestResultProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// TestSummaryListResult - A list of Test Summaries.
type TestSummaryListResult struct {
	// The list of Test Summaries.
	Value []*TestSummaryResource

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// TestSummaryProperties - Properties of a Test Summary.
type TestSummaryProperties struct {
	// Application name.
	ApplicationName *string

	// Application version.
	ApplicationVersion *string

	// The execution status of last test.
	ExecutionStatus *ExecutionStatus

	// The result summary of tests triggered by feature updates
	FeatureUpdatesTestSummary *OSUpdatesTestSummary

	// The grade of the test.
	Grade *Grade

	// The Azure resource Id of package.
	PackageID *string

	// The result summary of tests triggered by security updates
	SecurityUpdatesTestSummary *OSUpdatesTestSummary

	// The run time of the last test.
	TestRunTime *string

	// The status of last test.
	TestStatus *TestStatus

	// The Id of the current Test Summary.
	TestSummaryID *string
}

// TestSummaryResource - Summary of a Test.
type TestSummaryResource struct {
	// Properties of a Test Summary.
	Properties *TestSummaryProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// TestTypeListResult - A list of test types.
type TestTypeListResult struct {
	// The list of test types.
	Value []*TestTypeResource

	// READ-ONLY; Link to the next set of results. Not empty if value contains incomplete list of results.
	NextLink *string
}

// TestTypeProperties - The Test Type properties.
type TestTypeProperties struct {
	// The actual name of a test type of a Test Base Account.
	ActualTestTypeName *string
}

// TestTypeResource - The test type resource.
type TestTypeResource struct {
	// Test Type properties.
	Properties *TestTypeProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// TrackedResource - The resource model definition for an ARM tracked top level resource
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The tags of the resource.
	Tags map[string]*string

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// UserObjectReceiverValue - The user object receiver value.
type UserObjectReceiverValue struct {
	// user object ids.
	UserObjectIDs []*string
}

// UtilizationBound - The bound of a utilization result.
type UtilizationBound struct {
	// The percentile of the bound.
	Percentile *float64

	// The value of the bound.
	Value *float64
}

// UtilizationEntry - The utilization entry.
type UtilizationEntry struct {
	// The timestamp.
	Timestamp *time.Time

	// The value.
	Value *float64
}

// UtilizationResult - The Utilization Result.
type UtilizationResult struct {
	// Lower bound
	LowerBound *UtilizationBound

	// Process name, or '_total' for all processes
	Process *string

	// Upper bound
	UpperBound *UtilizationBound

	// Utilization data
	Utilization []*UtilizationEntry
}
