//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtimeseriesinsights

import "encoding/json"

// AccessPoliciesClientCreateOrUpdateResponse contains the response from method AccessPoliciesClient.CreateOrUpdate.
type AccessPoliciesClientCreateOrUpdateResponse struct {
	// An access policy is used to grant users and applications access to the environment. Roles are assigned to service principals
	// in Azure Active Directory. These roles define the actions the principal can perform through the Time Series Insights data
	// plane APIs.
	AccessPolicyResource
}

// AccessPoliciesClientDeleteResponse contains the response from method AccessPoliciesClient.Delete.
type AccessPoliciesClientDeleteResponse struct {
	// placeholder for future response values
}

// AccessPoliciesClientGetResponse contains the response from method AccessPoliciesClient.Get.
type AccessPoliciesClientGetResponse struct {
	// An access policy is used to grant users and applications access to the environment. Roles are assigned to service principals
	// in Azure Active Directory. These roles define the actions the principal can perform through the Time Series Insights data
	// plane APIs.
	AccessPolicyResource
}

// AccessPoliciesClientListByEnvironmentResponse contains the response from method AccessPoliciesClient.ListByEnvironment.
type AccessPoliciesClientListByEnvironmentResponse struct {
	// The response of the List access policies operation.
	AccessPolicyListResponse
}

// AccessPoliciesClientUpdateResponse contains the response from method AccessPoliciesClient.Update.
type AccessPoliciesClientUpdateResponse struct {
	// An access policy is used to grant users and applications access to the environment. Roles are assigned to service principals
	// in Azure Active Directory. These roles define the actions the principal can perform through the Time Series Insights data
	// plane APIs.
	AccessPolicyResource
}

// EnvironmentsClientCreateOrUpdateResponse contains the response from method EnvironmentsClient.BeginCreateOrUpdate.
type EnvironmentsClientCreateOrUpdateResponse struct {
	// An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource.
	EnvironmentResourceClassification
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentsClientCreateOrUpdateResponse.
func (e EnvironmentsClientCreateOrUpdateResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(e.EnvironmentResourceClassification)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentsClientCreateOrUpdateResponse.
func (e *EnvironmentsClientCreateOrUpdateResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalEnvironmentResourceClassification(data)
	if err != nil {
		return err
	}
	e.EnvironmentResourceClassification = res
	return nil
}

// EnvironmentsClientDeleteResponse contains the response from method EnvironmentsClient.Delete.
type EnvironmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// EnvironmentsClientGetResponse contains the response from method EnvironmentsClient.Get.
type EnvironmentsClientGetResponse struct {
	// An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource.
	EnvironmentResourceClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentsClientGetResponse.
func (e *EnvironmentsClientGetResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalEnvironmentResourceClassification(data)
	if err != nil {
		return err
	}
	e.EnvironmentResourceClassification = res
	return nil
}

// EnvironmentsClientListByResourceGroupResponse contains the response from method EnvironmentsClient.ListByResourceGroup.
type EnvironmentsClientListByResourceGroupResponse struct {
	// The response of the List Environments operation.
	EnvironmentListResponse
}

// EnvironmentsClientListBySubscriptionResponse contains the response from method EnvironmentsClient.ListBySubscription.
type EnvironmentsClientListBySubscriptionResponse struct {
	// The response of the List Environments operation.
	EnvironmentListResponse
}

// EnvironmentsClientUpdateResponse contains the response from method EnvironmentsClient.BeginUpdate.
type EnvironmentsClientUpdateResponse struct {
	// An environment is a set of time-series data available for query, and is the top level Azure Time Series Insights resource.
	EnvironmentResourceClassification
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentsClientUpdateResponse.
func (e EnvironmentsClientUpdateResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(e.EnvironmentResourceClassification)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentsClientUpdateResponse.
func (e *EnvironmentsClientUpdateResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalEnvironmentResourceClassification(data)
	if err != nil {
		return err
	}
	e.EnvironmentResourceClassification = res
	return nil
}

// EventSourcesClientCreateOrUpdateResponse contains the response from method EventSourcesClient.CreateOrUpdate.
type EventSourcesClientCreateOrUpdateResponse struct {
	// An environment receives data from one or more event sources. Each event source has associated connection info that allows
	// the Time Series Insights ingress pipeline to connect to and pull data from the event source
	EventSourceResourceClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSourcesClientCreateOrUpdateResponse.
func (e *EventSourcesClientCreateOrUpdateResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalEventSourceResourceClassification(data)
	if err != nil {
		return err
	}
	e.EventSourceResourceClassification = res
	return nil
}

// EventSourcesClientDeleteResponse contains the response from method EventSourcesClient.Delete.
type EventSourcesClientDeleteResponse struct {
	// placeholder for future response values
}

// EventSourcesClientGetResponse contains the response from method EventSourcesClient.Get.
type EventSourcesClientGetResponse struct {
	// An environment receives data from one or more event sources. Each event source has associated connection info that allows
	// the Time Series Insights ingress pipeline to connect to and pull data from the event source
	EventSourceResourceClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSourcesClientGetResponse.
func (e *EventSourcesClientGetResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalEventSourceResourceClassification(data)
	if err != nil {
		return err
	}
	e.EventSourceResourceClassification = res
	return nil
}

// EventSourcesClientListByEnvironmentResponse contains the response from method EventSourcesClient.ListByEnvironment.
type EventSourcesClientListByEnvironmentResponse struct {
	// The response of the List EventSources operation.
	EventSourceListResponse
}

// EventSourcesClientUpdateResponse contains the response from method EventSourcesClient.Update.
type EventSourcesClientUpdateResponse struct {
	// An environment receives data from one or more event sources. Each event source has associated connection info that allows
	// the Time Series Insights ingress pipeline to connect to and pull data from the event source
	EventSourceResourceClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSourcesClientUpdateResponse.
func (e *EventSourcesClientUpdateResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalEventSourceResourceClassification(data)
	if err != nil {
		return err
	}
	e.EventSourceResourceClassification = res
	return nil
}

// OperationsClientListResponse contains the response from method OperationsClient.NewListPager.
type OperationsClientListResponse struct {
	// Result of the request to list Time Series Insights operations. It contains a list of operations and a URL link to get the
	// next set of results.
	OperationListResult
}

// ReferenceDataSetsClientCreateOrUpdateResponse contains the response from method ReferenceDataSetsClient.CreateOrUpdate.
type ReferenceDataSetsClientCreateOrUpdateResponse struct {
	// A reference data set provides metadata about the events in an environment. Metadata in the reference data set will be joined
	// with events as they are read from event sources. The metadata that makes up the reference data set is uploaded or modified
	// through the Time Series Insights data plane APIs.
	ReferenceDataSetResource
}

// ReferenceDataSetsClientDeleteResponse contains the response from method ReferenceDataSetsClient.Delete.
type ReferenceDataSetsClientDeleteResponse struct {
	// placeholder for future response values
}

// ReferenceDataSetsClientGetResponse contains the response from method ReferenceDataSetsClient.Get.
type ReferenceDataSetsClientGetResponse struct {
	// A reference data set provides metadata about the events in an environment. Metadata in the reference data set will be joined
	// with events as they are read from event sources. The metadata that makes up the reference data set is uploaded or modified
	// through the Time Series Insights data plane APIs.
	ReferenceDataSetResource
}

// ReferenceDataSetsClientListByEnvironmentResponse contains the response from method ReferenceDataSetsClient.ListByEnvironment.
type ReferenceDataSetsClientListByEnvironmentResponse struct {
	// The response of the List Reference Data Sets operation.
	ReferenceDataSetListResponse
}

// ReferenceDataSetsClientUpdateResponse contains the response from method ReferenceDataSetsClient.Update.
type ReferenceDataSetsClientUpdateResponse struct {
	// A reference data set provides metadata about the events in an environment. Metadata in the reference data set will be joined
	// with events as they are read from event sources. The metadata that makes up the reference data set is uploaded or modified
	// through the Time Series Insights data plane APIs.
	ReferenceDataSetResource
}
