//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/workloadssapvirtualinstance/armworkloadssapvirtualinstance"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// SAPDatabaseInstancesServer is a fake server for instances of the armworkloadssapvirtualinstance.SAPDatabaseInstancesClient type.
type SAPDatabaseInstancesServer struct {
	// BeginCreate is the fake for method SAPDatabaseInstancesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, sapVirtualInstanceName string, databaseInstanceName string, body armworkloadssapvirtualinstance.SAPDatabaseInstance, options *armworkloadssapvirtualinstance.SAPDatabaseInstancesClientBeginCreateOptions) (resp azfake.PollerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method SAPDatabaseInstancesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, sapVirtualInstanceName string, databaseInstanceName string, options *armworkloadssapvirtualinstance.SAPDatabaseInstancesClientBeginDeleteOptions) (resp azfake.PollerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SAPDatabaseInstancesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, sapVirtualInstanceName string, databaseInstanceName string, options *armworkloadssapvirtualinstance.SAPDatabaseInstancesClientGetOptions) (resp azfake.Responder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method SAPDatabaseInstancesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, sapVirtualInstanceName string, options *armworkloadssapvirtualinstance.SAPDatabaseInstancesClientListOptions) (resp azfake.PagerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientListResponse])

	// BeginStartInstance is the fake for method SAPDatabaseInstancesClient.BeginStartInstance
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStartInstance func(ctx context.Context, resourceGroupName string, sapVirtualInstanceName string, databaseInstanceName string, options *armworkloadssapvirtualinstance.SAPDatabaseInstancesClientBeginStartInstanceOptions) (resp azfake.PollerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientStartInstanceResponse], errResp azfake.ErrorResponder)

	// BeginStopInstance is the fake for method SAPDatabaseInstancesClient.BeginStopInstance
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStopInstance func(ctx context.Context, resourceGroupName string, sapVirtualInstanceName string, databaseInstanceName string, options *armworkloadssapvirtualinstance.SAPDatabaseInstancesClientBeginStopInstanceOptions) (resp azfake.PollerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientStopInstanceResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method SAPDatabaseInstancesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, sapVirtualInstanceName string, databaseInstanceName string, body armworkloadssapvirtualinstance.UpdateSAPDatabaseInstanceRequest, options *armworkloadssapvirtualinstance.SAPDatabaseInstancesClientUpdateOptions) (resp azfake.Responder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewSAPDatabaseInstancesServerTransport creates a new instance of SAPDatabaseInstancesServerTransport with the provided implementation.
// The returned SAPDatabaseInstancesServerTransport instance is connected to an instance of armworkloadssapvirtualinstance.SAPDatabaseInstancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSAPDatabaseInstancesServerTransport(srv *SAPDatabaseInstancesServer) *SAPDatabaseInstancesServerTransport {
	return &SAPDatabaseInstancesServerTransport{
		srv:                srv,
		beginCreate:        newTracker[azfake.PollerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientCreateResponse]](),
		beginDelete:        newTracker[azfake.PollerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientDeleteResponse]](),
		newListPager:       newTracker[azfake.PagerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientListResponse]](),
		beginStartInstance: newTracker[azfake.PollerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientStartInstanceResponse]](),
		beginStopInstance:  newTracker[azfake.PollerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientStopInstanceResponse]](),
	}
}

// SAPDatabaseInstancesServerTransport connects instances of armworkloadssapvirtualinstance.SAPDatabaseInstancesClient to instances of SAPDatabaseInstancesServer.
// Don't use this type directly, use NewSAPDatabaseInstancesServerTransport instead.
type SAPDatabaseInstancesServerTransport struct {
	srv                *SAPDatabaseInstancesServer
	beginCreate        *tracker[azfake.PollerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientCreateResponse]]
	beginDelete        *tracker[azfake.PollerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientDeleteResponse]]
	newListPager       *tracker[azfake.PagerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientListResponse]]
	beginStartInstance *tracker[azfake.PollerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientStartInstanceResponse]]
	beginStopInstance  *tracker[azfake.PollerResponder[armworkloadssapvirtualinstance.SAPDatabaseInstancesClientStopInstanceResponse]]
}

// Do implements the policy.Transporter interface for SAPDatabaseInstancesServerTransport.
func (s *SAPDatabaseInstancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SAPDatabaseInstancesClient.BeginCreate":
		resp, err = s.dispatchBeginCreate(req)
	case "SAPDatabaseInstancesClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "SAPDatabaseInstancesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SAPDatabaseInstancesClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	case "SAPDatabaseInstancesClient.BeginStartInstance":
		resp, err = s.dispatchBeginStartInstance(req)
	case "SAPDatabaseInstancesClient.BeginStopInstance":
		resp, err = s.dispatchBeginStopInstance(req)
	case "SAPDatabaseInstancesClient.Update":
		resp, err = s.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SAPDatabaseInstancesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := s.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseInstances/(?P<databaseInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armworkloadssapvirtualinstance.SAPDatabaseInstance](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreate(req.Context(), resourceGroupNameParam, sapVirtualInstanceNameParam, databaseInstanceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		s.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		s.beginCreate.remove(req)
	}

	return resp, nil
}

func (s *SAPDatabaseInstancesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseInstances/(?P<databaseInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, sapVirtualInstanceNameParam, databaseInstanceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *SAPDatabaseInstancesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseInstances/(?P<databaseInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
	if err != nil {
		return nil, err
	}
	databaseInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, sapVirtualInstanceNameParam, databaseInstanceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SAPDatabaseInstance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SAPDatabaseInstancesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseInstances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListPager(resourceGroupNameParam, sapVirtualInstanceNameParam, nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armworkloadssapvirtualinstance.SAPDatabaseInstancesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}

func (s *SAPDatabaseInstancesServerTransport) dispatchBeginStartInstance(req *http.Request) (*http.Response, error) {
	if s.srv.BeginStartInstance == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStartInstance not implemented")}
	}
	beginStartInstance := s.beginStartInstance.get(req)
	if beginStartInstance == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseInstances/(?P<databaseInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armworkloadssapvirtualinstance.StartRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseInstanceName")])
		if err != nil {
			return nil, err
		}
		var options *armworkloadssapvirtualinstance.SAPDatabaseInstancesClientBeginStartInstanceOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armworkloadssapvirtualinstance.SAPDatabaseInstancesClientBeginStartInstanceOptions{
				Body: &body,
			}
		}
		respr, errRespr := s.srv.BeginStartInstance(req.Context(), resourceGroupNameParam, sapVirtualInstanceNameParam, databaseInstanceNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStartInstance = &respr
		s.beginStartInstance.add(req, beginStartInstance)
	}

	resp, err := server.PollerResponderNext(beginStartInstance, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginStartInstance.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStartInstance) {
		s.beginStartInstance.remove(req)
	}

	return resp, nil
}

func (s *SAPDatabaseInstancesServerTransport) dispatchBeginStopInstance(req *http.Request) (*http.Response, error) {
	if s.srv.BeginStopInstance == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStopInstance not implemented")}
	}
	beginStopInstance := s.beginStopInstance.get(req)
	if beginStopInstance == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseInstances/(?P<databaseInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armworkloadssapvirtualinstance.StopRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseInstanceName")])
		if err != nil {
			return nil, err
		}
		var options *armworkloadssapvirtualinstance.SAPDatabaseInstancesClientBeginStopInstanceOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armworkloadssapvirtualinstance.SAPDatabaseInstancesClientBeginStopInstanceOptions{
				Body: &body,
			}
		}
		respr, errRespr := s.srv.BeginStopInstance(req.Context(), resourceGroupNameParam, sapVirtualInstanceNameParam, databaseInstanceNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStopInstance = &respr
		s.beginStopInstance.add(req, beginStopInstance)
	}

	resp, err := server.PollerResponderNext(beginStopInstance, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginStopInstance.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStopInstance) {
		s.beginStopInstance.remove(req)
	}

	return resp, nil
}

func (s *SAPDatabaseInstancesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapVirtualInstances/(?P<sapVirtualInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databaseInstances/(?P<databaseInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armworkloadssapvirtualinstance.UpdateSAPDatabaseInstanceRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	sapVirtualInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapVirtualInstanceName")])
	if err != nil {
		return nil, err
	}
	databaseInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Update(req.Context(), resourceGroupNameParam, sapVirtualInstanceNameParam, databaseInstanceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SAPDatabaseInstance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
