//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package backup

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// Client contains the methods for the Client group.
// Don't use this type directly, use a constructor function instead.
type Client struct {
	internal *azcore.Client
	endpoint string
}

// BeginFullBackup - Creates a full backup using a user-provided SAS token to an Azure blob storage container.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - azureStorageBlobContainerURI - Azure blob shared access signature token pointing to a valid Azure blob container where
//     full backup needs to be stored. This token needs to be valid for at least next 24 hours from the time of making
//     this call
//   - options - BeginFullBackupOptions contains the optional parameters for the Client.BeginFullBackup method.
func (client *Client) BeginFullBackup(ctx context.Context, azureStorageBlobContainerURI SASTokenParameters, options *BeginFullBackupOptions) (*runtime.Poller[FullBackupResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.fullBackup(ctx, azureStorageBlobContainerURI, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[FullBackupResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[FullBackupResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// FullBackup - Creates a full backup using a user-provided SAS token to an Azure blob storage container.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
func (client *Client) fullBackup(ctx context.Context, azureStorageBlobContainerURI SASTokenParameters, options *BeginFullBackupOptions) (*http.Response, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "backup.Client.BeginFullBackup", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.fullBackupCreateRequest(ctx, azureStorageBlobContainerURI, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// fullBackupCreateRequest creates the FullBackup request.
func (client *Client) fullBackupCreateRequest(ctx context.Context, azureStorageBlobContainerURI SASTokenParameters, options *BeginFullBackupOptions) (*policy.Request, error) {
	urlPath := "/backup"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, azureStorageBlobContainerURI); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginFullRestore - Restores all key materials using the SAS token pointing to a previously stored Azure Blob storage backup
// folder
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - restoreBlobDetails - The Azure blob SAS token pointing to a folder where the previous successful full backup was stored
//   - options - BeginFullRestoreOptions contains the optional parameters for the Client.BeginFullRestore method.
func (client *Client) BeginFullRestore(ctx context.Context, restoreBlobDetails RestoreOperationParameters, options *BeginFullRestoreOptions) (*runtime.Poller[FullRestoreResponse], error) {
	return client.beginFullRestore(ctx, restoreBlobDetails, options)
}

// FullRestore - Restores all key materials using the SAS token pointing to a previously stored Azure Blob storage backup
// folder
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
func (client *Client) fullRestore(ctx context.Context, restoreBlobDetails RestoreOperationParameters, options *BeginFullRestoreOptions) (*http.Response, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "backup.Client.BeginFullRestore", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.fullRestoreCreateRequest(ctx, restoreBlobDetails, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// fullRestoreCreateRequest creates the FullRestore request.
func (client *Client) fullRestoreCreateRequest(ctx context.Context, restoreBlobDetails RestoreOperationParameters, options *BeginFullRestoreOptions) (*policy.Request, error) {
	urlPath := "/restore"
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, restoreBlobDetails); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginSelectiveKeyRestore - Restores all key versions of a given key using user supplied SAS token pointing to a previously
// stored Azure Blob storage backup folder
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - keyName - The name of the key to be restored from the user supplied backup
//   - restoreBlobDetails - The Azure blob SAS token pointing to a folder where the previous successful full backup was stored
//   - options - BeginSelectiveKeyRestoreOptions contains the optional parameters for the Client.BeginSelectiveKeyRestore
//     method.
func (client *Client) BeginSelectiveKeyRestore(ctx context.Context, keyName string, restoreBlobDetails SelectiveKeyRestoreOperationParameters, options *BeginSelectiveKeyRestoreOptions) (*runtime.Poller[SelectiveKeyRestoreResponse], error) {
	return client.beginSelectiveKeyRestore(ctx, keyName, restoreBlobDetails, options)
}

// SelectiveKeyRestore - Restores all key versions of a given key using user supplied SAS token pointing to a previously stored
// Azure Blob storage backup folder
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
func (client *Client) selectiveKeyRestore(ctx context.Context, keyName string, restoreBlobDetails SelectiveKeyRestoreOperationParameters, options *BeginSelectiveKeyRestoreOptions) (*http.Response, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "backup.Client.BeginSelectiveKeyRestore", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.selectiveKeyRestoreCreateRequest(ctx, keyName, restoreBlobDetails, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// selectiveKeyRestoreCreateRequest creates the SelectiveKeyRestore request.
func (client *Client) selectiveKeyRestoreCreateRequest(ctx context.Context, keyName string, restoreBlobDetails SelectiveKeyRestoreOperationParameters, options *BeginSelectiveKeyRestoreOptions) (*policy.Request, error) {
	urlPath := "/keys/{keyName}/restore"
	if keyName == "" {
		return nil, errors.New("parameter keyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{keyName}", url.PathEscape(keyName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, restoreBlobDetails); err != nil {
		return nil, err
	}
	return req, nil
}
