// Code generated by smithy-go-codegen DO NOT EDIT.

package awsrestjson

import (
	"bytes"
	"context"
	"github.com/aws/aws-sdk-go-v2/aws"
	protocoltesthttp "github.com/aws/aws-sdk-go-v2/internal/protocoltest"
	"github.com/aws/aws-sdk-go-v2/internal/protocoltest/awsrestjson/types"
	"github.com/aws/smithy-go/middleware"
	smithyprivateprotocol "github.com/aws/smithy-go/private/protocol"
	"github.com/aws/smithy-go/ptr"
	smithyrand "github.com/aws/smithy-go/rand"
	smithytesting "github.com/aws/smithy-go/testing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"io/ioutil"
	"net/http"
	"net/url"
	"testing"
)

func TestClient_SparseJsonMaps_awsRestjson1Serialize(t *testing.T) {
	cases := map[string]struct {
		Params        *SparseJsonMapsInput
		ExpectMethod  string
		ExpectURIPath string
		ExpectQuery   []smithytesting.QueryItem
		RequireQuery  []string
		ForbidQuery   []string
		ExpectHeader  http.Header
		RequireHeader []string
		ForbidHeader  []string
		Host          *url.URL
		BodyMediaType string
		BodyAssert    func(io.Reader) error
	}{
		// Serializes JSON maps
		"RestJsonSparseJsonMaps": {
			Params: &SparseJsonMapsInput{
				SparseStructMap: map[string]*types.GreetingStruct{
					"foo": {
						Hi: ptr.String("there"),
					},
					"baz": {
						Hi: ptr.String("bye"),
					},
				},
			},
			ExpectMethod:  "POST",
			ExpectURIPath: "/SparseJsonMaps",
			ExpectQuery:   []smithytesting.QueryItem{},
			ExpectHeader: http.Header{
				"Content-Type": []string{"application/json"},
			},
			BodyMediaType: "application/json",
			BodyAssert: func(actual io.Reader) error {
				return smithytesting.CompareJSONReaderBytes(actual, []byte(`{
			    "sparseStructMap": {
			        "foo": {
			            "hi": "there"
			        },
			        "baz": {
			            "hi": "bye"
			        }
			    }
			}`))
			},
		},
		// Serializes JSON map values in sparse maps
		"RestJsonSerializesSparseNullMapValues": {
			Params: &SparseJsonMapsInput{
				SparseBooleanMap: map[string]*bool{
					"x": nil,
				},
				SparseNumberMap: map[string]*int32{
					"x": nil,
				},
				SparseStringMap: map[string]*string{
					"x": nil,
				},
				SparseStructMap: map[string]*types.GreetingStruct{
					"x": nil,
				},
			},
			ExpectMethod:  "POST",
			ExpectURIPath: "/SparseJsonMaps",
			ExpectQuery:   []smithytesting.QueryItem{},
			ExpectHeader: http.Header{
				"Content-Type": []string{"application/json"},
			},
			BodyMediaType: "application/json",
			BodyAssert: func(actual io.Reader) error {
				return smithytesting.CompareJSONReaderBytes(actual, []byte(`{
			    "sparseBooleanMap": {
			        "x": null
			    },
			    "sparseNumberMap": {
			        "x": null
			    },
			    "sparseStringMap": {
			        "x": null
			    },
			    "sparseStructMap": {
			        "x": null
			    }
			}`))
			},
		},
		// Ensure that 0 and false are sent over the wire in all maps and lists
		"RestJsonSerializesZeroValuesInSparseMaps": {
			Params: &SparseJsonMapsInput{
				SparseNumberMap: map[string]*int32{
					"x": ptr.Int32(0),
				},
				SparseBooleanMap: map[string]*bool{
					"x": ptr.Bool(false),
				},
			},
			ExpectMethod:  "POST",
			ExpectURIPath: "/SparseJsonMaps",
			ExpectQuery:   []smithytesting.QueryItem{},
			ExpectHeader: http.Header{
				"Content-Type": []string{"application/json"},
			},
			BodyMediaType: "application/json",
			BodyAssert: func(actual io.Reader) error {
				return smithytesting.CompareJSONReaderBytes(actual, []byte(`{
			    "sparseNumberMap": {
			        "x": 0
			    },
			    "sparseBooleanMap": {
			        "x": false
			    }
			}`))
			},
		},
		// A request that contains a sparse map of sets
		"RestJsonSerializesSparseSetMap": {
			Params: &SparseJsonMapsInput{
				SparseSetMap: map[string][]string{
					"x": {},
					"y": {
						"a",
						"b",
					},
				},
			},
			ExpectMethod:  "POST",
			ExpectURIPath: "/SparseJsonMaps",
			ExpectQuery:   []smithytesting.QueryItem{},
			ExpectHeader: http.Header{
				"Content-Type": []string{"application/json"},
			},
			BodyMediaType: "application/json",
			BodyAssert: func(actual io.Reader) error {
				return smithytesting.CompareJSONReaderBytes(actual, []byte(`{
			    "sparseSetMap": {
			        "x": [],
			        "y": ["a", "b"]
			    }
			}`))
			},
		},
		// A request that contains a sparse map of sets.
		"RestJsonSerializesSparseSetMapAndRetainsNull": {
			Params: &SparseJsonMapsInput{
				SparseSetMap: map[string][]string{
					"x": {},
					"y": {
						"a",
						"b",
					},
					"z": nil,
				},
			},
			ExpectMethod:  "POST",
			ExpectURIPath: "/SparseJsonMaps",
			ExpectQuery:   []smithytesting.QueryItem{},
			ExpectHeader: http.Header{
				"Content-Type": []string{"application/json"},
			},
			BodyMediaType: "application/json",
			BodyAssert: func(actual io.Reader) error {
				return smithytesting.CompareJSONReaderBytes(actual, []byte(`{
			    "sparseSetMap": {
			        "x": [],
			        "y": ["a", "b"],
			        "z": null
			    }
			}`))
			},
		},
	}
	for name, c := range cases {
		t.Run(name, func(t *testing.T) {
			actualReq := &http.Request{}
			serverURL := "http://localhost:8888/"
			if c.Host != nil {
				u, err := url.Parse(serverURL)
				if err != nil {
					t.Fatalf("expect no error, got %v", err)
				}
				u.Path = c.Host.Path
				u.RawPath = c.Host.RawPath
				u.RawQuery = c.Host.RawQuery
				serverURL = u.String()
			}
			client := New(Options{
				APIOptions: []func(*middleware.Stack) error{
					func(s *middleware.Stack) error {
						s.Finalize.Clear()
						s.Initialize.Remove(`OperationInputValidation`)
						return nil
					},
				},
				EndpointResolver: EndpointResolverFunc(func(region string, options EndpointResolverOptions) (e aws.Endpoint, err error) {
					e.URL = serverURL
					e.SigningRegion = "us-west-2"
					return e, err
				}),
				HTTPClient:               protocoltesthttp.NewClient(),
				IdempotencyTokenProvider: smithyrand.NewUUIDIdempotencyToken(&smithytesting.ByteLoop{}),
				Region:                   "us-west-2",
			})
			result, err := client.SparseJsonMaps(context.Background(), c.Params, func(options *Options) {
				options.APIOptions = append(options.APIOptions, func(stack *middleware.Stack) error {
					return smithyprivateprotocol.AddCaptureRequestMiddleware(stack, actualReq)
				})
			})
			if err != nil {
				t.Fatalf("expect nil err, got %v", err)
			}
			if result == nil {
				t.Fatalf("expect not nil result")
			}
			if e, a := c.ExpectMethod, actualReq.Method; e != a {
				t.Errorf("expect %v method, got %v", e, a)
			}
			if e, a := c.ExpectURIPath, actualReq.URL.RawPath; e != a {
				t.Errorf("expect %v path, got %v", e, a)
			}
			queryItems := smithytesting.ParseRawQuery(actualReq.URL.RawQuery)
			smithytesting.AssertHasQuery(t, c.ExpectQuery, queryItems)
			smithytesting.AssertHasQueryKeys(t, c.RequireQuery, queryItems)
			smithytesting.AssertNotHaveQueryKeys(t, c.ForbidQuery, queryItems)
			smithytesting.AssertHasHeader(t, c.ExpectHeader, actualReq.Header)
			smithytesting.AssertHasHeaderKeys(t, c.RequireHeader, actualReq.Header)
			smithytesting.AssertNotHaveHeaderKeys(t, c.ForbidHeader, actualReq.Header)
			if c.BodyAssert != nil {
				if err := c.BodyAssert(actualReq.Body); err != nil {
					t.Errorf("expect body equal, got %v", err)
				}
			}
		})
	}
}

func TestClient_SparseJsonMaps_awsRestjson1Deserialize(t *testing.T) {
	cases := map[string]struct {
		StatusCode    int
		Header        http.Header
		BodyMediaType string
		Body          []byte
		ExpectResult  *SparseJsonMapsOutput
	}{
		// Deserializes JSON maps
		"RestJsonSparseJsonMaps": {
			StatusCode: 200,
			Header: http.Header{
				"Content-Type": []string{"application/json"},
			},
			BodyMediaType: "application/json",
			Body: []byte(`{
			    "sparseStructMap": {
			        "foo": {
			            "hi": "there"
			        },
			        "baz": {
			            "hi": "bye"
			        }
			   }
			}`),
			ExpectResult: &SparseJsonMapsOutput{
				SparseStructMap: map[string]*types.GreetingStruct{
					"foo": {
						Hi: ptr.String("there"),
					},
					"baz": {
						Hi: ptr.String("bye"),
					},
				},
			},
		},
		// Deserializes null JSON map values
		"RestJsonDeserializesSparseNullMapValues": {
			StatusCode: 200,
			Header: http.Header{
				"Content-Type": []string{"application/json"},
			},
			BodyMediaType: "application/json",
			Body: []byte(`{
			    "sparseBooleanMap": {
			        "x": null
			    },
			    "sparseNumberMap": {
			        "x": null
			    },
			    "sparseStringMap": {
			        "x": null
			    },
			    "sparseStructMap": {
			        "x": null
			    }
			}`),
			ExpectResult: &SparseJsonMapsOutput{
				SparseBooleanMap: map[string]*bool{
					"x": nil,
				},
				SparseNumberMap: map[string]*int32{
					"x": nil,
				},
				SparseStringMap: map[string]*string{
					"x": nil,
				},
				SparseStructMap: map[string]*types.GreetingStruct{
					"x": nil,
				},
			},
		},
		// Ensure that 0 and false are sent over the wire in all maps and lists
		"RestJsonDeserializesZeroValuesInSparseMaps": {
			StatusCode: 200,
			Header: http.Header{
				"Content-Type": []string{"application/json"},
			},
			BodyMediaType: "application/json",
			Body: []byte(`{
			    "sparseNumberMap": {
			        "x": 0
			    },
			    "sparseBooleanMap": {
			        "x": false
			    }
			}`),
			ExpectResult: &SparseJsonMapsOutput{
				SparseNumberMap: map[string]*int32{
					"x": ptr.Int32(0),
				},
				SparseBooleanMap: map[string]*bool{
					"x": ptr.Bool(false),
				},
			},
		},
		// A response that contains a sparse map of sets
		"RestJsonDeserializesSparseSetMap": {
			StatusCode: 200,
			Header: http.Header{
				"Content-Type": []string{"application/json"},
			},
			BodyMediaType: "application/json",
			Body: []byte(`{
			    "sparseSetMap": {
			        "x": [],
			        "y": ["a", "b"]
			    }
			}`),
			ExpectResult: &SparseJsonMapsOutput{
				SparseSetMap: map[string][]string{
					"x": {},
					"y": {
						"a",
						"b",
					},
				},
			},
		},
		// A response that contains a sparse map of sets.
		"RestJsonDeserializesSparseSetMapAndRetainsNull": {
			StatusCode: 200,
			Header: http.Header{
				"Content-Type": []string{"application/json"},
			},
			BodyMediaType: "application/json",
			Body: []byte(`{
			    "sparseSetMap": {
			        "x": [],
			        "y": ["a", "b"],
			        "z": null
			    }
			}`),
			ExpectResult: &SparseJsonMapsOutput{
				SparseSetMap: map[string][]string{
					"x": {},
					"y": {
						"a",
						"b",
					},
					"z": nil,
				},
			},
		},
	}
	for name, c := range cases {
		t.Run(name, func(t *testing.T) {
			serverURL := "http://localhost:8888/"
			client := New(Options{
				HTTPClient: smithyhttp.ClientDoFunc(func(r *http.Request) (*http.Response, error) {
					headers := http.Header{}
					for k, vs := range c.Header {
						for _, v := range vs {
							headers.Add(k, v)
						}
					}
					if len(c.BodyMediaType) != 0 && len(headers.Values("Content-Type")) == 0 {
						headers.Set("Content-Type", c.BodyMediaType)
					}
					response := &http.Response{
						StatusCode: c.StatusCode,
						Header:     headers,
						Request:    r,
					}
					if len(c.Body) != 0 {
						response.ContentLength = int64(len(c.Body))
						response.Body = ioutil.NopCloser(bytes.NewReader(c.Body))
					} else {

						response.Body = http.NoBody
					}
					return response, nil
				}),
				APIOptions: []func(*middleware.Stack) error{
					func(s *middleware.Stack) error {
						s.Finalize.Clear()
						s.Initialize.Remove(`OperationInputValidation`)
						return nil
					},
				},
				EndpointResolver: EndpointResolverFunc(func(region string, options EndpointResolverOptions) (e aws.Endpoint, err error) {
					e.URL = serverURL
					e.SigningRegion = "us-west-2"
					return e, err
				}),
				IdempotencyTokenProvider: smithyrand.NewUUIDIdempotencyToken(&smithytesting.ByteLoop{}),
				Region:                   "us-west-2",
			})
			var params SparseJsonMapsInput
			result, err := client.SparseJsonMaps(context.Background(), &params)
			if err != nil {
				t.Fatalf("expect nil err, got %v", err)
			}
			if result == nil {
				t.Fatalf("expect not nil result")
			}
			if err := smithytesting.CompareValues(c.ExpectResult, result); err != nil {
				t.Errorf("expect c.ExpectResult value match:\n%v", err)
			}
		})
	}
}
