// Code generated by smithy-go-codegen DO NOT EDIT.

package appsync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/appsync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a GraphqlApi object.
func (c *Client) CreateGraphqlApi(ctx context.Context, params *CreateGraphqlApiInput, optFns ...func(*Options)) (*CreateGraphqlApiOutput, error) {
	if params == nil {
		params = &CreateGraphqlApiInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateGraphqlApi", params, optFns, c.addOperationCreateGraphqlApiMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateGraphqlApiOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateGraphqlApiInput struct {

	// The authentication type: API key, Identity and Access Management (IAM), OpenID
	// Connect (OIDC), Amazon Cognito user pools, or Lambda.
	//
	// This member is required.
	AuthenticationType types.AuthenticationType

	// A user-supplied name for the GraphqlApi .
	//
	// This member is required.
	Name *string

	// A list of additional authentication providers for the GraphqlApi API.
	AdditionalAuthenticationProviders []types.AdditionalAuthenticationProvider

	// The value that indicates whether the GraphQL API is a standard API ( GRAPHQL )
	// or merged API ( MERGED ).
	ApiType types.GraphQLApiType

	// The enhancedMetricsConfig object.
	EnhancedMetricsConfig *types.EnhancedMetricsConfig

	// Sets the value of the GraphQL API to enable ( ENABLED ) or disable ( DISABLED )
	// introspection. If no value is provided, the introspection configuration will be
	// set to ENABLED by default. This field will produce an error if the operation
	// attempts to use the introspection feature while this field is disabled.
	//
	// For more information about introspection, see [GraphQL introspection].
	//
	// [GraphQL introspection]: https://graphql.org/learn/introspection/
	IntrospectionConfig types.GraphQLApiIntrospectionConfig

	// Configuration for Lambda function authorization.
	LambdaAuthorizerConfig *types.LambdaAuthorizerConfig

	// The Amazon CloudWatch Logs configuration.
	LogConfig *types.LogConfig

	// The Identity and Access Management service role ARN for a merged API. The
	// AppSync service assumes this role on behalf of the Merged API to validate access
	// to source APIs at runtime and to prompt the AUTO_MERGE to update the merged API
	// endpoint with the source API changes automatically.
	MergedApiExecutionRoleArn *string

	// The OIDC configuration.
	OpenIDConnectConfig *types.OpenIDConnectConfig

	// The owner contact information for an API resource.
	//
	// This field accepts any string input with a length of 0 - 256 characters.
	OwnerContact *string

	// The maximum depth a query can have in a single request. Depth refers to the
	// amount of nested levels allowed in the body of query. The default value is 0
	// (or unspecified), which indicates there's no depth limit. If you set a limit, it
	// can be between 1 and 75 nested levels. This field will produce a limit error if
	// the operation falls out of bounds.
	//
	// Note that fields can still be set to nullable or non-nullable. If a
	// non-nullable field produces an error, the error will be thrown upwards to the
	// first nullable field available.
	QueryDepthLimit int32

	// The maximum number of resolvers that can be invoked in a single request. The
	// default value is 0 (or unspecified), which will set the limit to 10000 . When
	// specified, the limit value can be between 1 and 10000 . This field will produce
	// a limit error if the operation falls out of bounds.
	ResolverCountLimit int32

	// A TagMap object.
	Tags map[string]string

	// The Amazon Cognito user pool configuration.
	UserPoolConfig *types.UserPoolConfig

	// Sets the value of the GraphQL API to public ( GLOBAL ) or private ( PRIVATE ).
	// If no value is provided, the visibility will be set to GLOBAL by default. This
	// value cannot be changed once the API has been created.
	Visibility types.GraphQLApiVisibility

	// A flag indicating whether to use X-Ray tracing for the GraphqlApi .
	XrayEnabled bool

	noSmithyDocumentSerde
}

type CreateGraphqlApiOutput struct {

	// The GraphqlApi .
	GraphqlApi *types.GraphqlApi

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateGraphqlApiMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateGraphqlApi{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateGraphqlApi{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateGraphqlApi"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateGraphqlApiValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateGraphqlApi(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateGraphqlApi(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateGraphqlApi",
	}
}
