// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The backup options for each resource type.
type AdvancedBackupSetting struct {

	// Specifies the backup option for a selected resource. This option is only
	// available for Windows VSS backup jobs.
	//
	// Valid values:
	//
	// Set to "WindowsVSS":"enabled" to enable the WindowsVSS backup option and create
	// a Windows VSS backup.
	//
	// Set to "WindowsVSS":"disabled" to create a regular backup. The WindowsVSS
	// option is not enabled by default.
	//
	// If you specify an invalid option, you get an InvalidParameterValueException
	// exception.
	//
	// For more information about Windows VSS backups, see [Creating a VSS-Enabled Windows Backup].
	//
	// [Creating a VSS-Enabled Windows Backup]: https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html
	BackupOptions map[string]string

	// Specifies an object containing resource type and backup options. The only
	// supported resource type is Amazon EC2 instances with Windows Volume Shadow Copy
	// Service (VSS). For a CloudFormation example, see the [sample CloudFormation template to enable Windows VSS]in the Backup User Guide.
	//
	// Valid values: EC2 .
	//
	// [sample CloudFormation template to enable Windows VSS]: https://docs.aws.amazon.com/aws-backup/latest/devguide/integrate-cloudformation-with-aws-backup.html
	ResourceType *string

	noSmithyDocumentSerde
}

// Contains detailed information about a backup job.
type BackupJob struct {

	// The account ID that owns the backup job.
	AccountId *string

	// Uniquely identifies a request to Backup to back up a resource.
	BackupJobId *string

	// Specifies the backup option for a selected resource. This option is only
	// available for Windows Volume Shadow Copy Service (VSS) backup jobs.
	//
	// Valid values: Set to "WindowsVSS":"enabled" to enable the WindowsVSS backup
	// option and create a Windows VSS backup. Set to "WindowsVSS":"disabled" to
	// create a regular backup. If you specify an invalid option, you get an
	// InvalidParameterValueException exception.
	BackupOptions map[string]string

	// The size, in bytes, of a backup (recovery point).
	//
	// This value can render differently depending on the resource type as Backup
	// pulls in data information from other Amazon Web Services services. For example,
	// the value returned may show a value of 0 , which may differ from the anticipated
	// value.
	//
	// The expected behavior for values by resource type are described as follows:
	//
	//   - Amazon Aurora, Amazon DocumentDB, and Amazon Neptune do not have this value
	//   populate from the operation GetBackupJobStatus .
	//
	//   - For Amazon DynamoDB with advanced features, this value refers to the size
	//   of the recovery point (backup).
	//
	//   - Amazon EC2 and Amazon EBS show volume size (provisioned storage) returned
	//   as part of this value. Amazon EBS does not return backup size information;
	//   snapshot size will have the same value as the original resource that was backed
	//   up.
	//
	//   - For Amazon EFS, this value refers to the delta bytes transferred during a
	//   backup.
	//
	//   - Amazon FSx does not populate this value from the operation
	//   GetBackupJobStatus for FSx file systems.
	//
	//   - An Amazon RDS instance will show as 0 .
	//
	//   - For virtual machines running VMware, this value is passed to Backup through
	//   an asynchronous workflow, which can mean this displayed value can
	//   under-represent the actual backup size.
	BackupSizeInBytes *int64

	// Represents the type of backup for a backup job.
	BackupType *string

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault .
	BackupVaultArn *string

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created.
	BackupVaultName *string

	// The size in bytes transferred to a backup vault at the time that the job status
	// was queried.
	BytesTransferred *int64

	// The date and time a job to create a backup job is completed, in Unix format and
	// Coordinated Universal Time (UTC). The value of CompletionDate is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time

	// Contains identifying information about the creation of a backup job, including
	// the BackupPlanArn , BackupPlanId , BackupPlanVersion , and BackupRuleId of the
	// backup plan used to create it.
	CreatedBy *RecoveryPointCreator

	// The date and time a backup job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// The date and time a job to back up resources is expected to be completed, in
	// Unix format and Coordinated Universal Time (UTC). The value of
	// ExpectedCompletionDate is accurate to milliseconds. For example, the value
	// 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	ExpectedCompletionDate *time.Time

	// Specifies the IAM role ARN used to create the target recovery point. IAM roles
	// other than the default role must include either AWSBackup or AwsBackup in the
	// role name. For example, arn:aws:iam::123456789012:role/AWSBackupRDSAccess . Role
	// names without those strings lack permissions to perform backup jobs.
	IamRoleArn *string

	// The date on which the backup job was initiated.
	InitiationDate *time.Time

	// This is a boolean value indicating this is a parent (composite) backup job.
	IsParent bool

	// This parameter is the job count for the specified message category.
	//
	// Example strings may include AccessDenied , SUCCESS , AGGREGATE_ALL , and
	// INVALIDPARAMETERS . See [Monitoring] for a list of MessageCategory strings.
	//
	// The the value ANY returns count of all message categories.
	//
	// AGGREGATE_ALL aggregates job counts for all message categories and returns the
	// sum.
	//
	// [Monitoring]: https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html
	MessageCategory *string

	// This uniquely identifies a request to Backup to back up a resource. The return
	// will be the parent (composite) job ID.
	ParentJobId *string

	// Contains an estimated percentage complete of a job at the time the job status
	// was queried.
	PercentDone *string

	// An ARN that uniquely identifies a recovery point; for example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45
	// .
	RecoveryPointArn *string

	// An ARN that uniquely identifies a resource. The format of the ARN depends on
	// the resource type.
	ResourceArn *string

	// The non-unique name of the resource that belongs to the specified backup.
	ResourceName *string

	// The type of Amazon Web Services resource to be backed up; for example, an
	// Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database
	// Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS)
	// backups, the only supported resource type is Amazon EC2.
	ResourceType *string

	// Specifies the time in Unix format and Coordinated Universal Time (UTC) when a
	// backup job must be started before it is canceled. The value is calculated by
	// adding the start window to the scheduled time. So if the scheduled time were
	// 6:00 PM and the start window is 2 hours, the StartBy time would be 8:00 PM on
	// the date specified. The value of StartBy is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	StartBy *time.Time

	// The current state of a backup job.
	State BackupJobState

	// A detailed message explaining the status of the job to back up a resource.
	StatusMessage *string

	noSmithyDocumentSerde
}

// This is a summary of jobs created or running within the most recent 30 days.
//
// The returned summary may contain the following: Region, Account, State,
// RestourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
type BackupJobSummary struct {

	// The account ID that owns the jobs within the summary.
	AccountId *string

	// The value as a number of jobs in a job summary.
	Count int32

	// The value of time in number format of a job end time.
	//
	// This value is the time in Unix format, Coordinated Universal Time (UTC), and
	// accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	EndTime *time.Time

	// This parameter is the job count for the specified message category.
	//
	// Example strings include AccessDenied , Success , and InvalidParameters . See [Monitoring]
	// for a list of MessageCategory strings.
	//
	// The the value ANY returns count of all message categories.
	//
	// AGGREGATE_ALL aggregates job counts for all message categories and returns the
	// sum.
	//
	// [Monitoring]: https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html
	MessageCategory *string

	// The Amazon Web Services Regions within the job summary.
	Region *string

	// This value is the job count for the specified resource type. The request
	// GetSupportedResourceTypes returns strings for supported resource types.
	ResourceType *string

	// The value of time in number format of a job start time.
	//
	// This value is the time in Unix format, Coordinated Universal Time (UTC), and
	// accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	StartTime *time.Time

	// This value is job count for jobs with the specified state.
	State BackupJobStatus

	noSmithyDocumentSerde
}

// Contains an optional backup plan display name and an array of BackupRule
// objects, each of which specifies a backup rule. Each rule in a backup plan is a
// separate scheduled task and can back up a different selection of Amazon Web
// Services resources.
type BackupPlan struct {

	// The display name of a backup plan. Must contain only alphanumeric or '-_.'
	// special characters.
	//
	// If this is set in the console, it can contain 1 to 50 characters; if this is
	// set through CLI or API, it can contain 1 to 200 characters.
	//
	// This member is required.
	BackupPlanName *string

	// An array of BackupRule objects, each of which specifies a scheduled task that
	// is used to back up a selection of resources.
	//
	// This member is required.
	Rules []BackupRule

	// Contains a list of BackupOptions for each resource type.
	AdvancedBackupSettings []AdvancedBackupSetting

	noSmithyDocumentSerde
}

// Contains an optional backup plan display name and an array of BackupRule
// objects, each of which specifies a backup rule. Each rule in a backup plan is a
// separate scheduled task.
type BackupPlanInput struct {

	// The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.'
	// characters.
	//
	// This member is required.
	BackupPlanName *string

	// An array of BackupRule objects, each of which specifies a scheduled task that
	// is used to back up a selection of resources.
	//
	// This member is required.
	Rules []BackupRuleInput

	// Specifies a list of BackupOptions for each resource type. These settings are
	// only available for Windows Volume Shadow Copy Service (VSS) backup jobs.
	AdvancedBackupSettings []AdvancedBackupSetting

	noSmithyDocumentSerde
}

// Contains metadata about a backup plan.
type BackupPlansListMember struct {

	// Contains a list of BackupOptions for a resource type.
	AdvancedBackupSettings []AdvancedBackupSetting

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for
	// example,
	// arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50 .
	BackupPlanArn *string

	// Uniquely identifies a backup plan.
	BackupPlanId *string

	// The display name of a saved backup plan.
	BackupPlanName *string

	// The date and time a resource backup plan is created, in Unix format and
	// Coordinated Universal Time (UTC). The value of CreationDate is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	CreationDate *time.Time

	// A unique string that identifies the request and allows failed requests to be
	// retried without the risk of running the operation twice. This parameter is
	// optional.
	//
	// If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
	CreatorRequestId *string

	// The date and time a backup plan is deleted, in Unix format and Coordinated
	// Universal Time (UTC). The value of DeletionDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	DeletionDate *time.Time

	// The last time this backup plan was run. A date and time, in Unix format and
	// Coordinated Universal Time (UTC). The value of LastExecutionDate is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	LastExecutionDate *time.Time

	// Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most
	// 1,024 bytes long. Version IDs cannot be edited.
	VersionId *string

	noSmithyDocumentSerde
}

// An object specifying metadata associated with a backup plan template.
type BackupPlanTemplatesListMember struct {

	// Uniquely identifies a stored backup plan template.
	BackupPlanTemplateId *string

	// The optional display name of a backup plan template.
	BackupPlanTemplateName *string

	noSmithyDocumentSerde
}

// Specifies a scheduled task used to back up a selection of resources.
type BackupRule struct {

	// A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.'
	// characters.
	//
	// This member is required.
	RuleName *string

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created.
	//
	// This member is required.
	TargetBackupVaultName *string

	// A value in minutes after a backup job is successfully started before it must be
	// completed or it will be canceled by Backup. This value is optional.
	CompletionWindowMinutes *int64

	// An array of CopyAction objects, which contains the details of the copy
	// operation.
	CopyActions []CopyAction

	// Specifies whether Backup creates continuous backups. True causes Backup to
	// create continuous backups capable of point-in-time restore (PITR). False (or not
	// specified) causes Backup to create snapshot backups.
	EnableContinuousBackup *bool

	// IndexActions is an array you use to specify how backup data should be indexed.
	//
	// eEach BackupRule can have 0 or 1 IndexAction, as each backup can have up to one
	// index associated with it.
	//
	// Within the array is ResourceType. Only one will be accepted for each BackupRule.
	IndexActions []IndexAction

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. Backup transitions and expires backups automatically
	// according to the lifecycle that you define.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, the “retention” setting must be 90 days greater
	// than the “transition to cold after days” setting. The “transition to cold after
	// days” setting cannot be changed after a backup has been transitioned to cold.
	//
	// Resource types that can transition to cold storage are listed in the [Feature availability by resource] table.
	// Backup ignores this expression for other resource types.
	//
	// [Feature availability by resource]: https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource
	Lifecycle *Lifecycle

	// The tags that are assigned to resources that are associated with this rule when
	// restored from backup.
	RecoveryPointTags map[string]string

	// Uniquely identifies a rule that is used to schedule the backup of a selection
	// of resources.
	RuleId *string

	// A cron expression in UTC specifying when Backup initiates a backup job. When no
	// CRON expression is provided, Backup will use the default expression cron(0 5 ?
	// * * *) .
	//
	// For more information about Amazon Web Services cron expressions, see [Schedule Expressions for Rules] in the
	// Amazon CloudWatch Events User Guide.
	//
	// Two examples of Amazon Web Services cron expressions are  15 * ? * * * (take a
	// backup every hour at 15 minutes past the hour) and 0 12 * * ? * (take a backup
	// every day at 12 noon UTC).
	//
	// For a table of examples, click the preceding link and scroll down the page.
	//
	// [Schedule Expressions for Rules]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html
	ScheduleExpression *string

	// The timezone in which the schedule expression is set. By default,
	// ScheduleExpressions are in UTC. You can modify this to a specified timezone.
	ScheduleExpressionTimezone *string

	// A value in minutes after a backup is scheduled before a job will be canceled if
	// it doesn't start successfully. This value is optional. If this value is
	// included, it must be at least 60 minutes to avoid errors.
	//
	// During the start window, the backup job status remains in CREATED status until
	// it has successfully begun or until the start window time has run out. If within
	// the start window time Backup receives an error that allows the job to be
	// retried, Backup will automatically retry to begin the job at least every 10
	// minutes until the backup successfully begins (the job status changes to RUNNING
	// ) or until the job status changes to EXPIRED (which is expected to occur when
	// the start window time is over).
	StartWindowMinutes *int64

	noSmithyDocumentSerde
}

// Specifies a scheduled task used to back up a selection of resources.
type BackupRuleInput struct {

	// A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.'
	// characters.
	//
	// This member is required.
	RuleName *string

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created.
	//
	// This member is required.
	TargetBackupVaultName *string

	// A value in minutes after a backup job is successfully started before it must be
	// completed or it will be canceled by Backup. This value is optional.
	CompletionWindowMinutes *int64

	// An array of CopyAction objects, which contains the details of the copy
	// operation.
	CopyActions []CopyAction

	// Specifies whether Backup creates continuous backups. True causes Backup to
	// create continuous backups capable of point-in-time restore (PITR). False (or not
	// specified) causes Backup to create snapshot backups.
	EnableContinuousBackup *bool

	// There can up to one IndexAction in each BackupRule, as each backup can have 0
	// or 1 backup index associated with it.
	//
	// Within the array is ResourceTypes. Only 1 resource type will be accepted for
	// each BackupRule. Valid values:
	//
	//   - EBS for Amazon Elastic Block Store
	//
	//   - S3 for Amazon Simple Storage Service (Amazon S3)
	IndexActions []IndexAction

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. Backup will transition and expire backups automatically
	// according to the lifecycle that you define.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, the “retention” setting must be 90 days greater
	// than the “transition to cold after days” setting. The “transition to cold after
	// days” setting cannot be changed after a backup has been transitioned to cold
	// storage.
	//
	// Resource types that can transition to cold storage are listed in the [Feature availability by resource] table.
	// Backup ignores this expression for other resource types.
	//
	// This parameter has a maximum value of 100 years (36,500 days).
	//
	// [Feature availability by resource]: https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource
	Lifecycle *Lifecycle

	// The tags to assign to the resources.
	RecoveryPointTags map[string]string

	// A CRON expression in UTC specifying when Backup initiates a backup job. When no
	// CRON expression is provided, Backup will use the default expression cron(0 5 ?
	// * * *) .
	ScheduleExpression *string

	// The timezone in which the schedule expression is set. By default,
	// ScheduleExpressions are in UTC. You can modify this to a specified timezone.
	ScheduleExpressionTimezone *string

	// A value in minutes after a backup is scheduled before a job will be canceled if
	// it doesn't start successfully. This value is optional. If this value is
	// included, it must be at least 60 minutes to avoid errors.
	//
	// This parameter has a maximum value of 100 years (52,560,000 minutes).
	//
	// During the start window, the backup job status remains in CREATED status until
	// it has successfully begun or until the start window time has run out. If within
	// the start window time Backup receives an error that allows the job to be
	// retried, Backup will automatically retry to begin the job at least every 10
	// minutes until the backup successfully begins (the job status changes to RUNNING
	// ) or until the job status changes to EXPIRED (which is expected to occur when
	// the start window time is over).
	StartWindowMinutes *int64

	noSmithyDocumentSerde
}

// Used to specify a set of resources to a backup plan.
//
// We recommend that you specify conditions, tags, or resources to include or
// exclude. Otherwise, Backup attempts to select all supported and opted-in storage
// resources, which could have unintended cost implications.
//
// For more information, see [Assigning resources programmatically].
//
// [Assigning resources programmatically]: https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json
type BackupSelection struct {

	// The ARN of the IAM role that Backup uses to authenticate when backing up the
	// target resource; for example, arn:aws:iam::123456789012:role/S3Access .
	//
	// This member is required.
	IamRoleArn *string

	// The display name of a resource selection document. Must contain 1 to 50
	// alphanumeric or '-_.' characters.
	//
	// This member is required.
	SelectionName *string

	// The conditions that you define to assign resources to your backup plans using
	// tags. For example, "StringEquals": { "ConditionKey": "aws:ResourceTag/backup",
	// "ConditionValue": "daily" } .
	//
	// Conditions supports StringEquals , StringLike , StringNotEquals , and
	// StringNotLike . Condition operators are case sensitive.
	//
	// If you specify multiple conditions, the resources much match all conditions
	// (AND logic).
	Conditions *Conditions

	// The conditions that you define to assign resources to your backup plans using
	// tags. For example, "StringEquals": { "ConditionKey": "backup",
	// "ConditionValue": "daily"} .
	//
	// ListOfTags supports only StringEquals . Condition operators are case sensitive.
	//
	// If you specify multiple conditions, the resources much match any of the
	// conditions (OR logic).
	ListOfTags []Condition

	// The Amazon Resource Names (ARNs) of the resources to exclude from a backup
	// plan. The maximum number of ARNs is 500 without wildcards, or 30 ARNs with
	// wildcards.
	//
	// If you need to exclude many resources from a backup plan, consider a different
	// resource selection strategy, such as assigning only one or a few resource types
	// or refining your resource selection using tags.
	NotResources []string

	// The Amazon Resource Names (ARNs) of the resources to assign to a backup plan.
	// The maximum number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.
	//
	// If you need to assign many resources to a backup plan, consider a different
	// resource selection strategy, such as assigning all resources of a resource type
	// or refining your resource selection using tags.
	//
	// If you specify multiple ARNs, the resources much match any of the ARNs (OR
	// logic).
	Resources []string

	noSmithyDocumentSerde
}

// Contains metadata about a BackupSelection object.
type BackupSelectionsListMember struct {

	// Uniquely identifies a backup plan.
	BackupPlanId *string

	// The date and time a backup plan is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// A unique string that identifies the request and allows failed requests to be
	// retried without the risk of running the operation twice. This parameter is
	// optional.
	//
	// If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
	CreatorRequestId *string

	// Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery
	// point; for example, arn:aws:iam::123456789012:role/S3Access .
	IamRoleArn *string

	// Uniquely identifies a request to assign a set of resources to a backup plan.
	SelectionId *string

	// The display name of a resource selection document.
	SelectionName *string

	noSmithyDocumentSerde
}

// Contains metadata about a backup vault.
type BackupVaultListMember struct {

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault .
	BackupVaultArn *string

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created.
	BackupVaultName *string

	// The date and time a resource backup is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// A unique string that identifies the request and allows failed requests to be
	// retried without the risk of running the operation twice. This parameter is
	// optional.
	//
	// If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
	CreatorRequestId *string

	// A server-side encryption key you can specify to encrypt your backups from
	// services that support full Backup management; for example,
	// arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab . If
	// you specify a key, you must specify its ARN, not its alias. If you do not
	// specify a key, Backup creates a KMS key for you by default.
	//
	// To learn which Backup services support full Backup management and how Backup
	// handles encryption for backups from services that do not yet support full
	// Backup, see [Encryption for backups in Backup]
	//
	// [Encryption for backups in Backup]: https://docs.aws.amazon.com/aws-backup/latest/devguide/encryption.html
	EncryptionKeyArn *string

	// The date and time when Backup Vault Lock configuration becomes immutable,
	// meaning it cannot be changed or deleted.
	//
	// If you applied Vault Lock to your vault without specifying a lock date, you can
	// change your Vault Lock settings, or delete Vault Lock from the vault entirely,
	// at any time.
	//
	// This value is in Unix format, Coordinated Universal Time (UTC), and accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	LockDate *time.Time

	// A Boolean value that indicates whether Backup Vault Lock applies to the
	// selected backup vault. If true , Vault Lock prevents delete and update
	// operations on the recovery points in the selected vault.
	Locked *bool

	// The Backup Vault Lock setting that specifies the maximum retention period that
	// the vault retains its recovery points. If this parameter is not specified, Vault
	// Lock does not enforce a maximum retention period on the recovery points in the
	// vault (allowing indefinite storage).
	//
	// If specified, any backup or copy job to the vault must have a lifecycle policy
	// with a retention period equal to or shorter than the maximum retention period.
	// If the job's retention period is longer than that maximum retention period, then
	// the vault fails the backup or copy job, and you should either modify your
	// lifecycle settings or use a different vault. Recovery points already stored in
	// the vault prior to Vault Lock are not affected.
	MaxRetentionDays *int64

	// The Backup Vault Lock setting that specifies the minimum retention period that
	// the vault retains its recovery points. If this parameter is not specified, Vault
	// Lock does not enforce a minimum retention period.
	//
	// If specified, any backup or copy job to the vault must have a lifecycle policy
	// with a retention period equal to or longer than the minimum retention period. If
	// the job's retention period is shorter than that minimum retention period, then
	// the vault fails the backup or copy job, and you should either modify your
	// lifecycle settings or use a different vault. Recovery points already stored in
	// the vault prior to Vault Lock are not affected.
	MinRetentionDays *int64

	// The number of recovery points that are stored in a backup vault.
	NumberOfRecoveryPoints int64

	// The current state of the vault.
	VaultState VaultState

	// The type of vault in which the described recovery point is stored.
	VaultType VaultType

	noSmithyDocumentSerde
}

// Contains DeleteAt and MoveToColdStorageAt timestamps, which are used to specify
// a lifecycle for a recovery point.
//
// The lifecycle defines when a protected resource is transitioned to cold storage
// and when it expires. Backup transitions and expires backups automatically
// according to the lifecycle that you define.
//
// Backups transitioned to cold storage must be stored in cold storage for a
// minimum of 90 days. Therefore, the “retention” setting must be 90 days greater
// than the “transition to cold after days” setting. The “transition to cold after
// days” setting cannot be changed after a backup has been transitioned to cold.
//
// Resource types that can transition to cold storage are listed in the [Feature availability by resource] table.
// Backup ignores this expression for other resource types.
//
// [Feature availability by resource]: https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource
type CalculatedLifecycle struct {

	// A timestamp that specifies when to delete a recovery point.
	DeleteAt *time.Time

	// A timestamp that specifies when to transition a recovery point to cold storage.
	MoveToColdStorageAt *time.Time

	noSmithyDocumentSerde
}

// Contains an array of triplets made up of a condition type (such as StringEquals
// ), a key, and a value. Used to filter resources using their tags and assign them
// to a backup plan. Case sensitive.
type Condition struct {

	// The key in a key-value pair. For example, in the tag Department: Accounting ,
	// Department is the key.
	//
	// This member is required.
	ConditionKey *string

	// An operation applied to a key-value pair used to assign resources to your
	// backup plan. Condition only supports StringEquals . For more flexible assignment
	// options, including StringLike and the ability to exclude resources from your
	// backup plan, use Conditions (with an "s" on the end) for your [BackupSelection]BackupSelection .
	//
	// [BackupSelection]: https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BackupSelection.html
	//
	// This member is required.
	ConditionType ConditionType

	// The value in a key-value pair. For example, in the tag Department: Accounting ,
	// Accounting is the value.
	//
	// This member is required.
	ConditionValue *string

	noSmithyDocumentSerde
}

// Includes information about tags you define to assign tagged resources to a
// backup plan.
//
// Include the prefix aws:ResourceTag in your tags. For example,
// "aws:ResourceTag/TagKey1": "Value1" .
type ConditionParameter struct {

	// The key in a key-value pair. For example, in the tag Department: Accounting ,
	// Department is the key.
	ConditionKey *string

	// The value in a key-value pair. For example, in the tag Department: Accounting ,
	// Accounting is the value.
	ConditionValue *string

	noSmithyDocumentSerde
}

// Contains information about which resources to include or exclude from a backup
// plan using their tags. Conditions are case sensitive.
type Conditions struct {

	// Filters the values of your tagged resources for only those resources that you
	// tagged with the same value. Also called "exact matching."
	StringEquals []ConditionParameter

	// Filters the values of your tagged resources for matching tag values with the
	// use of a wildcard character (*) anywhere in the string. For example, "prod*" or
	// "*rod*" matches the tag value "production".
	StringLike []ConditionParameter

	// Filters the values of your tagged resources for only those resources that you
	// tagged that do not have the same value. Also called "negated matching."
	StringNotEquals []ConditionParameter

	// Filters the values of your tagged resources for non-matching tag values with
	// the use of a wildcard character (*) anywhere in the string.
	StringNotLike []ConditionParameter

	noSmithyDocumentSerde
}

// The parameters for a control. A control can have zero, one, or more than one
// parameter. An example of a control with two parameters is: "backup plan
// frequency is at least daily and the retention period is at least 1 year ". The
// first parameter is daily . The second parameter is 1 year .
type ControlInputParameter struct {

	// The name of a parameter, for example, BackupPlanFrequency .
	ParameterName *string

	// The value of parameter, for example, hourly .
	ParameterValue *string

	noSmithyDocumentSerde
}

// A framework consists of one or more controls. Each control has its own control
// scope. The control scope can include one or more resource types, a combination
// of a tag key and value, or a combination of one resource type and one resource
// ID. If no scope is specified, evaluations for the rule are triggered when any
// resource in your recording group changes in configuration.
//
// To set a control scope that includes all of a particular resource, leave the
// ControlScope empty or do not pass it when calling CreateFramework .
type ControlScope struct {

	// The ID of the only Amazon Web Services resource that you want your control
	// scope to contain.
	ComplianceResourceIds []string

	// Describes whether the control scope includes one or more types of resources,
	// such as EFS or RDS .
	ComplianceResourceTypes []string

	// The tag key-value pair applied to those Amazon Web Services resources that you
	// want to trigger an evaluation for a rule. A maximum of one key-value pair can be
	// provided. The tag value is optional, but it cannot be an empty string if you are
	// creating or editing a framework from the console (though the value can be an
	// empty string when included in a CloudFormation template).
	//
	// The structure to assign a tag is: [{"Key":"string","Value":"string"}] .
	Tags map[string]string

	noSmithyDocumentSerde
}

// The details of the copy operation.
type CopyAction struct {

	// An Amazon Resource Name (ARN) that uniquely identifies the destination backup
	// vault for the copied backup. For example,
	// arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault .
	//
	// This member is required.
	DestinationBackupVaultArn *string

	// Specifies the time period, in days, before a recovery point transitions to cold
	// storage or is deleted.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, on the console, the retention setting must be 90
	// days greater than the transition to cold after days setting. The transition to
	// cold after days setting can't be changed after a backup has been transitioned to
	// cold.
	//
	// Resource types that can transition to cold storage are listed in the [Feature availability by resource] table.
	// Backup ignores this expression for other resource types.
	//
	// To remove the existing lifecycle and retention periods and keep your recovery
	// points indefinitely, specify -1 for MoveToColdStorageAfterDays and
	// DeleteAfterDays .
	//
	// [Feature availability by resource]: https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource
	Lifecycle *Lifecycle

	noSmithyDocumentSerde
}

// Contains detailed information about a copy job.
type CopyJob struct {

	// The account ID that owns the copy job.
	AccountId *string

	// The size, in bytes, of a copy job.
	BackupSizeInBytes *int64

	// This returns the statistics of the included child (nested) copy jobs.
	ChildJobsInState map[string]int64

	// The date and time a copy job is completed, in Unix format and Coordinated
	// Universal Time (UTC). The value of CompletionDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CompletionDate *time.Time

	// The identifier of a resource within a composite group, such as nested (child)
	// recovery point belonging to a composite (parent) stack. The ID is transferred
	// from the [logical ID]within a stack.
	//
	// [logical ID]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax
	CompositeMemberIdentifier *string

	// Uniquely identifies a copy job.
	CopyJobId *string

	// Contains information about the backup plan and rule that Backup used to
	// initiate the recovery point backup.
	CreatedBy *RecoveryPointCreator

	// The date and time a copy job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// An Amazon Resource Name (ARN) that uniquely identifies a destination copy
	// vault; for example,
	// arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault .
	DestinationBackupVaultArn *string

	// An ARN that uniquely identifies a destination recovery point; for example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45
	// .
	DestinationRecoveryPointArn *string

	// Specifies the IAM role ARN used to copy the target recovery point; for example,
	// arn:aws:iam::123456789012:role/S3Access .
	IamRoleArn *string

	// This is a boolean value indicating this is a parent (composite) copy job.
	IsParent bool

	// This parameter is the job count for the specified message category.
	//
	// Example strings may include AccessDenied , SUCCESS , AGGREGATE_ALL , and
	// InvalidParameters . See [Monitoring] for a list of MessageCategory strings.
	//
	// The the value ANY returns count of all message categories.
	//
	// AGGREGATE_ALL aggregates job counts for all message categories and returns the
	// sum
	//
	// [Monitoring]: https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html
	MessageCategory *string

	// The number of child (nested) copy jobs.
	NumberOfChildJobs *int64

	// This uniquely identifies a request to Backup to copy a resource. The return
	// will be the parent (composite) job ID.
	ParentJobId *string

	// The Amazon Web Services resource to be copied; for example, an Amazon Elastic
	// Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon
	// RDS) database.
	ResourceArn *string

	// The non-unique name of the resource that belongs to the specified backup.
	ResourceName *string

	// The type of Amazon Web Services resource to be copied; for example, an Amazon
	// Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service
	// (Amazon RDS) database.
	ResourceType *string

	// An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for
	// example, arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault .
	SourceBackupVaultArn *string

	// An ARN that uniquely identifies a source recovery point; for example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45
	// .
	SourceRecoveryPointArn *string

	// The current state of a copy job.
	State CopyJobState

	// A detailed message explaining the status of the job to copy a resource.
	StatusMessage *string

	noSmithyDocumentSerde
}

// This is a summary of copy jobs created or running within the most recent 30
// days.
//
// The returned summary may contain the following: Region, Account, State,
// RestourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
type CopyJobSummary struct {

	// The account ID that owns the jobs within the summary.
	AccountId *string

	// The value as a number of jobs in a job summary.
	Count int32

	// The value of time in number format of a job end time.
	//
	// This value is the time in Unix format, Coordinated Universal Time (UTC), and
	// accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	EndTime *time.Time

	// This parameter is the job count for the specified message category.
	//
	// Example strings include AccessDenied , Success , and InvalidParameters . See [Monitoring]
	// for a list of MessageCategory strings.
	//
	// The the value ANY returns count of all message categories.
	//
	// AGGREGATE_ALL aggregates job counts for all message categories and returns the
	// sum.
	//
	// [Monitoring]: https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html
	MessageCategory *string

	// The Amazon Web Services Regions within the job summary.
	Region *string

	// This value is the job count for the specified resource type. The request
	// GetSupportedResourceTypes returns strings for supported resource types
	ResourceType *string

	// The value of time in number format of a job start time.
	//
	// This value is the time in Unix format, Coordinated Universal Time (UTC), and
	// accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	StartTime *time.Time

	// This value is job count for jobs with the specified state.
	State CopyJobStatus

	noSmithyDocumentSerde
}

// This is a resource filter containing FromDate: DateTime and ToDate: DateTime.
// Both values are required. Future DateTime values are not permitted.
//
// The date and time are in Unix format and Coordinated Universal Time (UTC), and
// it is accurate to milliseconds ((milliseconds are optional). For example, the
// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
type DateRange struct {

	// This value is the beginning date, inclusive.
	//
	// The date and time are in Unix format and Coordinated Universal Time (UTC), and
	// it is accurate to milliseconds (milliseconds are optional).
	//
	// This member is required.
	FromDate *time.Time

	// This value is the end date, inclusive.
	//
	// The date and time are in Unix format and Coordinated Universal Time (UTC), and
	// it is accurate to milliseconds (milliseconds are optional).
	//
	// This member is required.
	ToDate *time.Time

	noSmithyDocumentSerde
}

// Contains detailed information about a framework. Frameworks contain controls,
// which evaluate and report on your backup events and resources. Frameworks
// generate daily compliance results.
type Framework struct {

	// The date and time that a framework is created, in ISO 8601 representation. The
	// value of CreationTime is accurate to milliseconds. For example,
	// 2020-07-10T15:00:00.000-08:00 represents the 10th of July 2020 at 3:00 PM 8
	// hours behind UTC.
	CreationTime *time.Time

	// The deployment status of a framework. The statuses are:
	//
	//     CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED |
	//     FAILED
	DeploymentStatus *string

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	FrameworkArn *string

	// An optional description of the framework with a maximum 1,024 characters.
	FrameworkDescription *string

	// The unique name of a framework. This name is between 1 and 256 characters,
	// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
	// underscores (_).
	FrameworkName *string

	// The number of controls contained by the framework.
	NumberOfControls int32

	noSmithyDocumentSerde
}

// Contains detailed information about all of the controls of a framework. Each
// framework must contain at least one control.
type FrameworkControl struct {

	// The name of a control. This name is between 1 and 256 characters.
	//
	// This member is required.
	ControlName *string

	// The name/value pairs.
	ControlInputParameters []ControlInputParameter

	// The scope of a control. The control scope defines what the control will
	// evaluate. Three examples of control scopes are: a specific backup plan, all
	// backup plans with a specific tag, or all backup plans.
	//
	// For more information, see [ControlScope.]ControlScope
	//
	// [ControlScope.]: https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ControlScope.html
	ControlScope *ControlScope

	noSmithyDocumentSerde
}

// This is an optional array within a BackupRule.
//
// IndexAction consists of one ResourceTypes.
type IndexAction struct {

	// 0 or 1 index action will be accepted for each BackupRule.
	//
	// Valid values:
	//
	//   - EBS for Amazon Elastic Block Store
	//
	//   - S3 for Amazon Simple Storage Service (Amazon S3)
	ResourceTypes []string

	noSmithyDocumentSerde
}

// This is a recovery point that has an associated backup index.
//
// Only recovery points with a backup index can be included in a search.
type IndexedRecoveryPoint struct {

	// The date and time that a backup was created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	BackupCreationDate *time.Time

	// An ARN that uniquely identifies the backup vault where the recovery point index
	// is stored.
	//
	// For example, arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault .
	BackupVaultArn *string

	// This specifies the IAM role ARN used for this operation.
	//
	// For example, arn:aws:iam::123456789012:role/S3Access
	IamRoleArn *string

	// The date and time that a backup index was created, in Unix format and
	// Coordinated Universal Time (UTC). The value of CreationDate is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	IndexCreationDate *time.Time

	// This is the current status for the backup index associated with the specified
	// recovery point.
	//
	// Statuses are: PENDING | ACTIVE | FAILED | DELETING
	//
	// A recovery point with an index that has the status of ACTIVE can be included in
	// a search.
	IndexStatus IndexStatus

	// A string in the form of a detailed message explaining the status of a backup
	// index associated with the recovery point.
	IndexStatusMessage *string

	// An ARN that uniquely identifies a recovery point; for example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45
	RecoveryPointArn *string

	// The resource type of the indexed recovery point.
	//
	//   - EBS for Amazon Elastic Block Store
	//
	//   - S3 for Amazon Simple Storage Service (Amazon S3)
	ResourceType *string

	// A string of the Amazon Resource Name (ARN) that uniquely identifies the source
	// resource.
	SourceResourceArn *string

	noSmithyDocumentSerde
}

// Pair of two related strings. Allowed characters are letters, white space, and
// numbers that can be represented in UTF-8 and the following characters: + - = .
// _ : /
type KeyValue struct {

	// The tag key (String). The key can't start with aws: .
	//
	// Length Constraints: Minimum length of 1. Maximum length of 128.
	//
	// Pattern: ^(?![aA]{1}[wW]{1}[sS]{1}:)([\p{L}\p{Z}\p{N}_.:/=+\-@]+)$
	//
	// This member is required.
	Key *string

	// The value of the key.
	//
	// Length Constraints: Maximum length of 256.
	//
	// Pattern: ^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about the latest update to an MPA approval team
// association.
type LatestMpaApprovalTeamUpdate struct {

	// The date and time when the MPA approval team update will expire.
	ExpiryDate *time.Time

	// The date and time when the MPA approval team update was initiated.
	InitiationDate *time.Time

	// The ARN of the MPA session associated with this update.
	MpaSessionArn *string

	// The current status of the MPA approval team update.
	Status MpaSessionStatus

	// A message describing the current status of the MPA approval team update.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Contains information about the latest request to revoke access to a backup
// vault.
type LatestRevokeRequest struct {

	// The date and time when the revoke request will expire.
	ExpiryDate *time.Time

	// The date and time when the revoke request was initiated.
	InitiationDate *time.Time

	// The ARN of the MPA session associated with this revoke request.
	MpaSessionArn *string

	// The current status of the revoke request.
	Status MpaRevokeSessionStatus

	// A message describing the current status of the revoke request.
	StatusMessage *string

	noSmithyDocumentSerde
}

// A legal hold is an administrative tool that helps prevent backups from being
// deleted while under a hold. While the hold is in place, backups under a hold
// cannot be deleted and lifecycle policies that would alter the backup status
// (such as transition to cold storage) are delayed until the legal hold is
// removed. A backup can have more than one legal hold. Legal holds are applied to
// one or more backups (also known as recovery points). These backups can be
// filtered by resource types and by resource IDs.
type LegalHold struct {

	// The time when the legal hold was cancelled.
	CancellationDate *time.Time

	// The time when the legal hold was created.
	CreationDate *time.Time

	// The description of a legal hold.
	Description *string

	// The Amazon Resource Name (ARN) of the legal hold; for example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45
	// .
	LegalHoldArn *string

	// The ID of the legal hold.
	LegalHoldId *string

	// The status of the legal hold.
	Status LegalHoldStatus

	// The title of a legal hold.
	Title *string

	noSmithyDocumentSerde
}

// Specifies the time period, in days, before a recovery point transitions to cold
// storage or is deleted.
//
// Backups transitioned to cold storage must be stored in cold storage for a
// minimum of 90 days. Therefore, on the console, the retention setting must be 90
// days greater than the transition to cold after days setting. The transition to
// cold after days setting can't be changed after a backup has been transitioned to
// cold.
//
// Resource types that can transition to cold storage are listed in the [Feature availability by resource] table.
// Backup ignores this expression for other resource types.
//
// To remove the existing lifecycle and retention periods and keep your recovery
// points indefinitely, specify -1 for MoveToColdStorageAfterDays and
// DeleteAfterDays .
//
// [Feature availability by resource]: https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource
type Lifecycle struct {

	// The number of days after creation that a recovery point is deleted. This value
	// must be at least 90 days after the number of days specified in
	// MoveToColdStorageAfterDays .
	DeleteAfterDays *int64

	// The number of days after creation that a recovery point is moved to cold
	// storage.
	MoveToColdStorageAfterDays *int64

	// If the value is true, your backup plan transitions supported resources to
	// archive (cold) storage tier in accordance with your lifecycle settings.
	OptInToArchiveForSupportedResources *bool

	noSmithyDocumentSerde
}

// A structure that contains information about a backed-up resource.
type ProtectedResource struct {

	// The date and time a resource was last backed up, in Unix format and Coordinated
	// Universal Time (UTC). The value of LastBackupTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	LastBackupTime *time.Time

	// The ARN (Amazon Resource Name) of the backup vault that contains the most
	// recent backup recovery point.
	LastBackupVaultArn *string

	// The ARN (Amazon Resource Name) of the most recent recovery point.
	LastRecoveryPointArn *string

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	ResourceArn *string

	// The non-unique name of the resource that belongs to the specified backup.
	ResourceName *string

	// The type of Amazon Web Services resource; for example, an Amazon Elastic Block
	// Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS)
	// database. For Windows Volume Shadow Copy Service (VSS) backups, the only
	// supported resource type is Amazon EC2.
	ResourceType *string

	noSmithyDocumentSerde
}

// The conditions that you define for resources in your restore testing plan using
// tags.
type ProtectedResourceConditions struct {

	// Filters the values of your tagged resources for only those resources that you
	// tagged with the same value. Also called "exact matching."
	StringEquals []KeyValue

	// Filters the values of your tagged resources for only those resources that you
	// tagged that do not have the same value. Also called "negated matching."
	StringNotEquals []KeyValue

	noSmithyDocumentSerde
}

// Contains detailed information about the recovery points stored in a backup
// vault.
type RecoveryPointByBackupVault struct {

	// The size, in bytes, of a backup.
	BackupSizeInBytes *int64

	// An ARN that uniquely identifies a backup vault; for example,
	// arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault .
	BackupVaultArn *string

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created.
	BackupVaultName *string

	// A CalculatedLifecycle object containing DeleteAt and MoveToColdStorageAt
	// timestamps.
	CalculatedLifecycle *CalculatedLifecycle

	// The date and time a job to restore a recovery point is completed, in Unix
	// format and Coordinated Universal Time (UTC). The value of CompletionDate is
	// accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time

	// The identifier of a resource within a composite group, such as nested (child)
	// recovery point belonging to a composite (parent) stack. The ID is transferred
	// from the [logical ID]within a stack.
	//
	// [logical ID]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax
	CompositeMemberIdentifier *string

	// Contains identifying information about the creation of a recovery point,
	// including the BackupPlanArn , BackupPlanId , BackupPlanVersion , and
	// BackupRuleId of the backup plan that is used to create it.
	CreatedBy *RecoveryPointCreator

	// The date and time a recovery point is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// The server-side encryption key that is used to protect your backups; for
	// example,
	// arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab .
	EncryptionKeyArn *string

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access .
	IamRoleArn *string

	// This is the current status for the backup index associated with the specified
	// recovery point.
	//
	// Statuses are: PENDING | ACTIVE | FAILED | DELETING
	//
	// A recovery point with an index that has the status of ACTIVE can be included in
	// a search.
	IndexStatus IndexStatus

	// A string in the form of a detailed message explaining the status of a backup
	// index associated with the recovery point.
	IndexStatusMessage *string

	// The date and time when the backup job that created this recovery point was
	// initiated, in Unix format and Coordinated Universal Time (UTC).
	InitiationDate *time.Time

	// A Boolean value that is returned as TRUE if the specified recovery point is
	// encrypted, or FALSE if the recovery point is not encrypted.
	IsEncrypted bool

	// This is a boolean value indicating this is a parent (composite) recovery point.
	IsParent bool

	// The date and time a recovery point was last restored, in Unix format and
	// Coordinated Universal Time (UTC). The value of LastRestoreTime is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	LastRestoreTime *time.Time

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. Backup transitions and expires backups automatically
	// according to the lifecycle that you define.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, the “retention” setting must be 90 days greater
	// than the “transition to cold after days” setting. The “transition to cold after
	// days” setting cannot be changed after a backup has been transitioned to cold.
	//
	// Resource types that can transition to cold storage are listed in the [Feature availability by resource] table.
	// Backup ignores this expression for other resource types.
	//
	// [Feature availability by resource]: https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource
	Lifecycle *Lifecycle

	// The Amazon Resource Name (ARN) of the parent (composite) recovery point.
	ParentRecoveryPointArn *string

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for
	// example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45
	// .
	RecoveryPointArn *string

	// An ARN that uniquely identifies a resource. The format of the ARN depends on
	// the resource type.
	ResourceArn *string

	// The non-unique name of the resource that belongs to the specified backup.
	ResourceName *string

	// The type of Amazon Web Services resource saved as a recovery point; for
	// example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon
	// Relational Database Service (Amazon RDS) database. For Windows Volume Shadow
	// Copy Service (VSS) backups, the only supported resource type is Amazon EC2.
	ResourceType *string

	// The backup vault where the recovery point was originally copied from. If the
	// recovery point is restored to the same account this value will be null .
	SourceBackupVaultArn *string

	// A status code specifying the state of the recovery point.
	Status RecoveryPointStatus

	// A message explaining the current status of the recovery point.
	StatusMessage *string

	// The type of vault in which the described recovery point is stored.
	VaultType VaultType

	noSmithyDocumentSerde
}

// Contains detailed information about a saved recovery point.
type RecoveryPointByResource struct {

	// The size, in bytes, of a backup.
	BackupSizeBytes *int64

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created.
	BackupVaultName *string

	// The date and time a recovery point is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// The server-side encryption key that is used to protect your backups; for
	// example,
	// arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab .
	EncryptionKeyArn *string

	// This is the current status for the backup index associated with the specified
	// recovery point.
	//
	// Statuses are: PENDING | ACTIVE | FAILED | DELETING
	//
	// A recovery point with an index that has the status of ACTIVE can be included in
	// a search.
	IndexStatus IndexStatus

	// A string in the form of a detailed message explaining the status of a backup
	// index associated with the recovery point.
	IndexStatusMessage *string

	// This is a boolean value indicating this is a parent (composite) recovery point.
	IsParent bool

	// The Amazon Resource Name (ARN) of the parent (composite) recovery point.
	ParentRecoveryPointArn *string

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for
	// example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45
	// .
	RecoveryPointArn *string

	// The non-unique name of the resource that belongs to the specified backup.
	ResourceName *string

	// A status code specifying the state of the recovery point.
	Status RecoveryPointStatus

	// A message explaining the current status of the recovery point.
	StatusMessage *string

	// The type of vault in which the described recovery point is stored.
	VaultType VaultType

	noSmithyDocumentSerde
}

// Contains information about the backup plan and rule that Backup used to
// initiate the recovery point backup.
type RecoveryPointCreator struct {

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for
	// example,
	// arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50 .
	BackupPlanArn *string

	// Uniquely identifies a backup plan.
	BackupPlanId *string

	// Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that
	// are at most 1,024 bytes long. They cannot be edited.
	BackupPlanVersion *string

	// Uniquely identifies a rule used to schedule the backup of a selection of
	// resources.
	BackupRuleId *string

	noSmithyDocumentSerde
}

// This is a recovery point which is a child (nested) recovery point of a parent
// (composite) recovery point. These recovery points can be disassociated from
// their parent (composite) recovery point, in which case they will no longer be a
// member.
type RecoveryPointMember struct {

	// The name of the backup vault (the logical container in which backups are
	// stored).
	BackupVaultName *string

	// The Amazon Resource Name (ARN) of the parent (composite) recovery point.
	RecoveryPointArn *string

	// The Amazon Resource Name (ARN) that uniquely identifies a saved resource.
	ResourceArn *string

	// The Amazon Web Services resource type that is saved as a recovery point.
	ResourceType *string

	noSmithyDocumentSerde
}

// This specifies criteria to assign a set of resources, such as resource types or
// backup vaults.
type RecoveryPointSelection struct {

	// This is a resource filter containing FromDate: DateTime and ToDate: DateTime.
	// Both values are required. Future DateTime values are not permitted.
	//
	// The date and time are in Unix format and Coordinated Universal Time (UTC), and
	// it is accurate to milliseconds ((milliseconds are optional). For example, the
	// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	DateRange *DateRange

	// These are the resources included in the resource selection (including type of
	// resources and vaults).
	ResourceIdentifiers []string

	// These are the names of the vaults in which the selected recovery points are
	// contained.
	VaultNames []string

	noSmithyDocumentSerde
}

// Contains information from your report plan about where to deliver your reports,
// specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your
// reports.
type ReportDeliveryChannel struct {

	// The unique name of the S3 bucket that receives your reports.
	//
	// This member is required.
	S3BucketName *string

	// The format of your reports: CSV , JSON , or both. If not specified, the default
	// format is CSV .
	Formats []string

	// The prefix for where Backup Audit Manager delivers your reports to Amazon S3.
	// The prefix is this part of the following path: s3://your-bucket-name/ prefix
	// /Backup/us-west-2/year/month/day/report-name. If not specified, there is no
	// prefix.
	S3KeyPrefix *string

	noSmithyDocumentSerde
}

// Contains information from your report job about your report destination.
type ReportDestination struct {

	// The unique name of the Amazon S3 bucket that receives your reports.
	S3BucketName *string

	// The object key that uniquely identifies your reports in your S3 bucket.
	S3Keys []string

	noSmithyDocumentSerde
}

// Contains detailed information about a report job. A report job compiles a
// report based on a report plan and publishes it to Amazon S3.
type ReportJob struct {

	// The date and time that a report job is completed, in Unix format and
	// Coordinated Universal Time (UTC). The value of CompletionTime is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	CompletionTime *time.Time

	// The date and time that a report job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationTime *time.Time

	// The S3 bucket name and S3 keys for the destination where the report job
	// publishes the report.
	ReportDestination *ReportDestination

	// The identifier for a report job. A unique, randomly generated, Unicode, UTF-8
	// encoded string that is at most 1,024 bytes long. Report job IDs cannot be
	// edited.
	ReportJobId *string

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	ReportPlanArn *string

	// Identifies the report template for the report. Reports are built using a report
	// template. The report templates are:
	//
	//     RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
	//     COPY_JOB_REPORT | RESTORE_JOB_REPORT
	ReportTemplate *string

	// The status of a report job. The statuses are:
	//
	//     CREATED | RUNNING | COMPLETED | FAILED
	//
	// COMPLETED means that the report is available for your review at your designated
	// destination. If the status is FAILED , review the StatusMessage for the reason.
	Status *string

	// A message explaining the status of the report job.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Contains detailed information about a report plan.
type ReportPlan struct {

	// The date and time that a report plan is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationTime *time.Time

	// The deployment status of a report plan. The statuses are:
	//
	//     CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED
	DeploymentStatus *string

	// The date and time that a report job associated with this report plan last
	// attempted to run, in Unix format and Coordinated Universal Time (UTC). The value
	// of LastAttemptedExecutionTime is accurate to milliseconds. For example, the
	// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	LastAttemptedExecutionTime *time.Time

	// The date and time that a report job associated with this report plan last
	// successfully ran, in Unix format and Coordinated Universal Time (UTC). The value
	// of LastSuccessfulExecutionTime is accurate to milliseconds. For example, the
	// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	LastSuccessfulExecutionTime *time.Time

	// Contains information about where and how to deliver your reports, specifically
	// your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
	ReportDeliveryChannel *ReportDeliveryChannel

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	ReportPlanArn *string

	// An optional description of the report plan with a maximum 1,024 characters.
	ReportPlanDescription *string

	// The unique name of the report plan. This name is between 1 and 256 characters
	// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
	// underscores (_).
	ReportPlanName *string

	// Identifies the report template for the report. Reports are built using a report
	// template. The report templates are:
	//
	//     RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
	//     COPY_JOB_REPORT | RESTORE_JOB_REPORT
	//
	// If the report template is RESOURCE_COMPLIANCE_REPORT or
	// CONTROL_COMPLIANCE_REPORT , this API resource also describes the report coverage
	// by Amazon Web Services Regions and frameworks.
	ReportSetting *ReportSetting

	noSmithyDocumentSerde
}

// Contains detailed information about a report setting.
type ReportSetting struct {

	// Identifies the report template for the report. Reports are built using a report
	// template. The report templates are:
	//
	//     RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT |
	//     COPY_JOB_REPORT | RESTORE_JOB_REPORT
	//
	// This member is required.
	ReportTemplate *string

	// These are the accounts to be included in the report.
	//
	// Use string value of ROOT to include all organizational units.
	Accounts []string

	// The Amazon Resource Names (ARNs) of the frameworks a report covers.
	FrameworkArns []string

	// The number of frameworks a report covers.
	NumberOfFrameworks int32

	// These are the Organizational Units to be included in the report.
	OrganizationUnits []string

	// These are the Regions to be included in the report.
	//
	// Use the wildcard as the string value to include all Regions.
	Regions []string

	noSmithyDocumentSerde
}

// Contains information about a restore access backup vault.
type RestoreAccessBackupVaultListMember struct {

	// The date and time when the restore access backup vault was approved.
	ApprovalDate *time.Time

	// The date and time when the restore access backup vault was created.
	CreationDate *time.Time

	// Information about the latest request to revoke access to this backup vault.
	LatestRevokeRequest *LatestRevokeRequest

	// The ARN of the restore access backup vault.
	RestoreAccessBackupVaultArn *string

	// The current state of the restore access backup vault.
	VaultState VaultState

	noSmithyDocumentSerde
}

// Contains information about the restore testing plan that Backup used to
// initiate the restore job.
type RestoreJobCreator struct {

	// An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.
	RestoreTestingPlanArn *string

	noSmithyDocumentSerde
}

// Contains metadata about a restore job.
type RestoreJobsListMember struct {

	// The account ID that owns the restore job.
	AccountId *string

	// The size, in bytes, of the restored resource.
	BackupSizeInBytes *int64

	// The date and time a job to restore a recovery point is completed, in Unix
	// format and Coordinated Universal Time (UTC). The value of CompletionDate is
	// accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time

	// Contains identifying information about the creation of a restore job.
	CreatedBy *RestoreJobCreator

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	CreatedResourceArn *string

	// The date and time a restore job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// This notes the status of the data generated by the restore test. The status may
	// be Deleting , Failed , or Successful .
	DeletionStatus RestoreDeletionStatus

	// This describes the restore job deletion status.
	DeletionStatusMessage *string

	// The amount of time in minutes that a job restoring a recovery point is expected
	// to take.
	ExpectedCompletionTimeMinutes *int64

	// The IAM role ARN used to create the target recovery point; for example,
	// arn:aws:iam::123456789012:role/S3Access .
	IamRoleArn *string

	// Contains an estimated percentage complete of a job at the time the job status
	// was queried.
	PercentDone *string

	// An ARN that uniquely identifies a recovery point; for example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45
	// .
	RecoveryPointArn *string

	// The date on which a recovery point was created.
	RecoveryPointCreationDate *time.Time

	// The resource type of the listed restore jobs; for example, an Amazon Elastic
	// Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon
	// RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only
	// supported resource type is Amazon EC2.
	ResourceType *string

	// Uniquely identifies the job that restores a recovery point.
	RestoreJobId *string

	// A status code specifying the state of the job initiated by Backup to restore a
	// recovery point.
	Status RestoreJobStatus

	// A detailed message explaining the status of the job to restore a recovery point.
	StatusMessage *string

	// The status of validation run on the indicated restore job.
	ValidationStatus RestoreValidationStatus

	// This describes the status of validation run on the indicated restore job.
	ValidationStatusMessage *string

	noSmithyDocumentSerde
}

// This is a summary of restore jobs created or running within the most recent 30
// days.
//
// The returned summary may contain the following: Region, Account, State,
// ResourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
type RestoreJobSummary struct {

	// The account ID that owns the jobs within the summary.
	AccountId *string

	// The value as a number of jobs in a job summary.
	Count int32

	// The value of time in number format of a job end time.
	//
	// This value is the time in Unix format, Coordinated Universal Time (UTC), and
	// accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	EndTime *time.Time

	// The Amazon Web Services Regions within the job summary.
	Region *string

	// This value is the job count for the specified resource type. The request
	// GetSupportedResourceTypes returns strings for supported resource types.
	ResourceType *string

	// The value of time in number format of a job start time.
	//
	// This value is the time in Unix format, Coordinated Universal Time (UTC), and
	// accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	StartTime *time.Time

	// This value is job count for jobs with the specified state.
	State RestoreJobState

	noSmithyDocumentSerde
}

// This contains metadata about a restore testing plan.
type RestoreTestingPlanForCreate struct {

	// RecoveryPointSelection has five parameters (three required and two optional).
	// The values you specify determine which recovery point is included in the restore
	// test. You must indicate with Algorithm if you want the latest recovery point
	// within your SelectionWindowDays or if you want a random recovery point, and you
	// must indicate through IncludeVaults from which vaults the recovery points can
	// be chosen.
	//
	// Algorithm (required) Valid values: " LATEST_WITHIN_WINDOW " or "
	// RANDOM_WITHIN_WINDOW ".
	//
	// Recovery point types (required) Valid values: " SNAPSHOT " and/or " CONTINUOUS
	// ". Include SNAPSHOT to restore only snapshot recovery points; include CONTINUOUS
	// to restore continuous recovery points (point in time restore / PITR); use both
	// to restore either a snapshot or a continuous recovery point. The recovery point
	// will be determined by the value for Algorithm .
	//
	// IncludeVaults (required). You must include one or more backup vaults. Use the
	// wildcard ["*"] or specific ARNs.
	//
	// SelectionWindowDays (optional) Value must be an integer (in days) from 1 to
	// 365. If not included, the value defaults to 30 .
	//
	// ExcludeVaults (optional). You can choose to input one or more specific backup
	// vault ARNs to exclude those vaults' contents from restore eligibility. Or, you
	// can include a list of selectors. If this parameter and its value are not
	// included, it defaults to empty list.
	//
	// This member is required.
	RecoveryPointSelection *RestoreTestingRecoveryPointSelection

	// The RestoreTestingPlanName is a unique string that is the name of the restore
	// testing plan. This cannot be changed after creation, and it must consist of only
	// alphanumeric characters and underscores.
	//
	// This member is required.
	RestoreTestingPlanName *string

	// A CRON expression in specified timezone when a restore testing plan is
	// executed. When no CRON expression is provided, Backup will use the default
	// expression cron(0 5 ? * * *) .
	//
	// This member is required.
	ScheduleExpression *string

	// Optional. This is the timezone in which the schedule expression is set. By
	// default, ScheduleExpressions are in UTC. You can modify this to a specified
	// timezone.
	ScheduleExpressionTimezone *string

	// Defaults to 24 hours.
	//
	// A value in hours after a restore test is scheduled before a job will be
	// canceled if it doesn't start successfully. This value is optional. If this value
	// is included, this parameter has a maximum value of 168 hours (one week).
	StartWindowHours int32

	noSmithyDocumentSerde
}

// This contains metadata about a restore testing plan.
type RestoreTestingPlanForGet struct {

	// The date and time that a restore testing plan was created, in Unix format and
	// Coordinated Universal Time (UTC). The value of CreationTime is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	//
	// This member is required.
	CreationTime *time.Time

	// The specified criteria to assign a set of resources, such as recovery point
	// types or backup vaults.
	//
	// This member is required.
	RecoveryPointSelection *RestoreTestingRecoveryPointSelection

	// An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.
	//
	// This member is required.
	RestoreTestingPlanArn *string

	// The restore testing plan name.
	//
	// This member is required.
	RestoreTestingPlanName *string

	// A CRON expression in specified timezone when a restore testing plan is
	// executed. When no CRON expression is provided, Backup will use the default
	// expression cron(0 5 ? * * *) .
	//
	// This member is required.
	ScheduleExpression *string

	// This identifies the request and allows failed requests to be retried without
	// the risk of running the operation twice. If the request includes a
	// CreatorRequestId that matches an existing backup plan, that plan is returned.
	// This parameter is optional.
	//
	// If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
	CreatorRequestId *string

	// The last time a restore test was run with the specified restore testing plan. A
	// date and time, in Unix format and Coordinated Universal Time (UTC). The value of
	// LastExecutionDate is accurate to milliseconds. For example, the value
	// 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	LastExecutionTime *time.Time

	// The date and time that the restore testing plan was updated. This update is in
	// Unix format and Coordinated Universal Time (UTC). The value of LastUpdateTime
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	LastUpdateTime *time.Time

	// Optional. This is the timezone in which the schedule expression is set. By
	// default, ScheduleExpressions are in UTC. You can modify this to a specified
	// timezone.
	ScheduleExpressionTimezone *string

	// Defaults to 24 hours.
	//
	// A value in hours after a restore test is scheduled before a job will be
	// canceled if it doesn't start successfully. This value is optional. If this value
	// is included, this parameter has a maximum value of 168 hours (one week).
	StartWindowHours int32

	noSmithyDocumentSerde
}

// This contains metadata about a restore testing plan.
type RestoreTestingPlanForList struct {

	// The date and time that a restore testing plan was created, in Unix format and
	// Coordinated Universal Time (UTC). The value of CreationTime is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	//
	// This member is required.
	CreationTime *time.Time

	// An Amazon Resource Name (ARN) that uniquely identifiesa restore testing plan.
	//
	// This member is required.
	RestoreTestingPlanArn *string

	// The restore testing plan name.
	//
	// This member is required.
	RestoreTestingPlanName *string

	// A CRON expression in specified timezone when a restore testing plan is
	// executed. When no CRON expression is provided, Backup will use the default
	// expression cron(0 5 ? * * *) .
	//
	// This member is required.
	ScheduleExpression *string

	// The last time a restore test was run with the specified restore testing plan. A
	// date and time, in Unix format and Coordinated Universal Time (UTC). The value of
	// LastExecutionDate is accurate to milliseconds. For example, the value
	// 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	LastExecutionTime *time.Time

	// The date and time that the restore testing plan was updated. This update is in
	// Unix format and Coordinated Universal Time (UTC). The value of LastUpdateTime
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	LastUpdateTime *time.Time

	// Optional. This is the timezone in which the schedule expression is set. By
	// default, ScheduleExpressions are in UTC. You can modify this to a specified
	// timezone.
	ScheduleExpressionTimezone *string

	// Defaults to 24 hours.
	//
	// A value in hours after a restore test is scheduled before a job will be
	// canceled if it doesn't start successfully. This value is optional. If this value
	// is included, this parameter has a maximum value of 168 hours (one week).
	StartWindowHours int32

	noSmithyDocumentSerde
}

// This contains metadata about a restore testing plan.
type RestoreTestingPlanForUpdate struct {

	// Required: Algorithm ; RecoveryPointTypes ; IncludeVaults (one or more).
	//
	// Optional: SelectionWindowDays ('30' if not specified); ExcludeVaults (defaults
	// to empty list if not listed).
	RecoveryPointSelection *RestoreTestingRecoveryPointSelection

	// A CRON expression in specified timezone when a restore testing plan is
	// executed. When no CRON expression is provided, Backup will use the default
	// expression cron(0 5 ? * * *) .
	ScheduleExpression *string

	// Optional. This is the timezone in which the schedule expression is set. By
	// default, ScheduleExpressions are in UTC. You can modify this to a specified
	// timezone.
	ScheduleExpressionTimezone *string

	// Defaults to 24 hours.
	//
	// A value in hours after a restore test is scheduled before a job will be
	// canceled if it doesn't start successfully. This value is optional. If this value
	// is included, this parameter has a maximum value of 168 hours (one week).
	StartWindowHours int32

	noSmithyDocumentSerde
}

// RecoveryPointSelection has five parameters (three required and two optional).
// The values you specify determine which recovery point is included in the restore
// test. You must indicate with Algorithm if you want the latest recovery point
// within your SelectionWindowDays or if you want a random recovery point, and you
// must indicate through IncludeVaults from which vaults the recovery points can
// be chosen.
//
// Algorithm (required) Valid values: " LATEST_WITHIN_WINDOW " or "
// RANDOM_WITHIN_WINDOW ".
//
// Recovery point types (required) Valid values: " SNAPSHOT " and/or " CONTINUOUS
// ". Include SNAPSHOT to restore only snapshot recovery points; include CONTINUOUS
// to restore continuous recovery points (point in time restore / PITR); use both
// to restore either a snapshot or a continuous recovery point. The recovery point
// will be determined by the value for Algorithm .
//
// IncludeVaults (required). You must include one or more backup vaults. Use the
// wildcard ["*"] or specific ARNs.
//
// SelectionWindowDays (optional) Value must be an integer (in days) from 1 to
// 365. If not included, the value defaults to 30 .
//
// ExcludeVaults (optional). You can choose to input one or more specific backup
// vault ARNs to exclude those vaults' contents from restore eligibility. Or, you
// can include a list of selectors. If this parameter and its value are not
// included, it defaults to empty list.
type RestoreTestingRecoveryPointSelection struct {

	// Acceptable values include "LATEST_WITHIN_WINDOW" or "RANDOM_WITHIN_WINDOW"
	Algorithm RestoreTestingRecoveryPointSelectionAlgorithm

	// Accepted values include specific ARNs or list of selectors. Defaults to empty
	// list if not listed.
	ExcludeVaults []string

	// Accepted values include wildcard ["*"] or by specific ARNs or ARN wilcard
	// replacement ["arn:aws:backup:us-west-2:123456789012:backup-vault:asdf", ...]
	// ["arn:aws:backup:*:*:backup-vault:asdf-*", ...]
	IncludeVaults []string

	// These are the types of recovery points.
	//
	// Include SNAPSHOT to restore only snapshot recovery points; include CONTINUOUS
	// to restore continuous recovery points (point in time restore / PITR); use both
	// to restore either a snapshot or a continuous recovery point. The recovery point
	// will be determined by the value for Algorithm .
	RecoveryPointTypes []RestoreTestingRecoveryPointType

	// Accepted values are integers from 1 to 365.
	SelectionWindowDays int32

	noSmithyDocumentSerde
}

// This contains metadata about a specific restore testing selection.
//
// ProtectedResourceType is required, such as Amazon EBS or Amazon EC2.
//
// This consists of RestoreTestingSelectionName , ProtectedResourceType , and one
// of the following:
//
//   - ProtectedResourceArns
//
//   - ProtectedResourceConditions
//
// Each protected resource type can have one single value.
//
// A restore testing selection can include a wildcard value ("*") for
// ProtectedResourceArns along with ProtectedResourceConditions . Alternatively,
// you can include up to 30 specific protected resource ARNs in
// ProtectedResourceArns .
//
// ProtectedResourceConditions examples include as StringEquals and StringNotEquals
// .
type RestoreTestingSelectionForCreate struct {

	// The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the
	// target resource; for example: arn:aws:iam::123456789012:role/S3Access .
	//
	// This member is required.
	IamRoleArn *string

	// The type of Amazon Web Services resource included in a restore testing
	// selection; for example, an Amazon EBS volume or an Amazon RDS database.
	//
	// Supported resource types accepted include:
	//
	//   - Aurora for Amazon Aurora
	//
	//   - DocumentDB for Amazon DocumentDB (with MongoDB compatibility)
	//
	//   - DynamoDB for Amazon DynamoDB
	//
	//   - EBS for Amazon Elastic Block Store
	//
	//   - EC2 for Amazon Elastic Compute Cloud
	//
	//   - EFS for Amazon Elastic File System
	//
	//   - FSx for Amazon FSx
	//
	//   - Neptune for Amazon Neptune
	//
	//   - RDS for Amazon Relational Database Service
	//
	//   - S3 for Amazon S3
	//
	// This member is required.
	ProtectedResourceType *string

	// The unique name of the restore testing selection that belongs to the related
	// restore testing plan.
	//
	// This member is required.
	RestoreTestingSelectionName *string

	// Each protected resource can be filtered by its specific ARNs, such as
	// ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."] or by a wildcard:
	// ProtectedResourceArns: ["*"] , but not both.
	ProtectedResourceArns []string

	// If you have included the wildcard in ProtectedResourceArns, you can include
	// resource conditions, such as ProtectedResourceConditions: { StringEquals: [{
	// key: "XXXX", value: "YYYY" }] .
	ProtectedResourceConditions *ProtectedResourceConditions

	// You can override certain restore metadata keys by including the parameter
	// RestoreMetadataOverrides in the body of RestoreTestingSelection . Key values are
	// not case sensitive.
	//
	// See the complete list of [restore testing inferred metadata].
	//
	// [restore testing inferred metadata]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html
	RestoreMetadataOverrides map[string]string

	// This is amount of hours (0 to 168) available to run a validation script on the
	// data. The data will be deleted upon the completion of the validation script or
	// the end of the specified retention period, whichever comes first.
	ValidationWindowHours int32

	noSmithyDocumentSerde
}

// This contains metadata about a restore testing selection.
type RestoreTestingSelectionForGet struct {

	// The date and time that a restore testing selection was created, in Unix format
	// and Coordinated Universal Time (UTC). The value of CreationTime is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 201812:11:30.087 AM.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the
	// target resource; for example: arn:aws:iam::123456789012:role/S3Access .
	//
	// This member is required.
	IamRoleArn *string

	// The type of Amazon Web Services resource included in a resource testing
	// selection; for example, an Amazon EBS volume or an Amazon RDS database.
	//
	// This member is required.
	ProtectedResourceType *string

	// The RestoreTestingPlanName is a unique string that is the name of the restore
	// testing plan.
	//
	// This member is required.
	RestoreTestingPlanName *string

	// The unique name of the restore testing selection that belongs to the related
	// restore testing plan.
	//
	// This member is required.
	RestoreTestingSelectionName *string

	// This identifies the request and allows failed requests to be retried without
	// the risk of running the operation twice. If the request includes a
	// CreatorRequestId that matches an existing backup plan, that plan is returned.
	// This parameter is optional.
	//
	// If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
	CreatorRequestId *string

	// You can include specific ARNs, such as ProtectedResourceArns: ["arn:aws:...",
	// "arn:aws:..."] or you can include a wildcard: ProtectedResourceArns: ["*"] , but
	// not both.
	ProtectedResourceArns []string

	// In a resource testing selection, this parameter filters by specific conditions
	// such as StringEquals or StringNotEquals .
	ProtectedResourceConditions *ProtectedResourceConditions

	// You can override certain restore metadata keys by including the parameter
	// RestoreMetadataOverrides in the body of RestoreTestingSelection . Key values are
	// not case sensitive.
	//
	// See the complete list of [restore testing inferred metadata].
	//
	// [restore testing inferred metadata]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html
	RestoreMetadataOverrides map[string]string

	// This is amount of hours (1 to 168) available to run a validation script on the
	// data. The data will be deleted upon the completion of the validation script or
	// the end of the specified retention period, whichever comes first.
	ValidationWindowHours int32

	noSmithyDocumentSerde
}

// This contains metadata about a restore testing selection.
type RestoreTestingSelectionForList struct {

	// The date and time that a restore testing selection was created, in Unix format
	// and Coordinated Universal Time (UTC). The value of CreationTime is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26,2018 12:11:30.087 AM.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the
	// target resource; for example: arn:aws:iam::123456789012:role/S3Access .
	//
	// This member is required.
	IamRoleArn *string

	// The type of Amazon Web Services resource included in a restore testing
	// selection; for example, an Amazon EBS volume or an Amazon RDS database.
	//
	// This member is required.
	ProtectedResourceType *string

	// Unique string that is the name of the restore testing plan.
	//
	// The name cannot be changed after creation. The name must consist of only
	// alphanumeric characters and underscores. Maximum length is 50.
	//
	// This member is required.
	RestoreTestingPlanName *string

	// Unique name of a restore testing selection.
	//
	// This member is required.
	RestoreTestingSelectionName *string

	// This value represents the time, in hours, data is retained after a restore test
	// so that optional validation can be completed.
	//
	// Accepted value is an integer between 0 and 168 (the hourly equivalent of seven
	// days).
	ValidationWindowHours int32

	noSmithyDocumentSerde
}

// This contains metadata about a restore testing selection.
type RestoreTestingSelectionForUpdate struct {

	// The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the
	// target resource; for example: arn:aws:iam::123456789012:role/S3Access .
	IamRoleArn *string

	// You can include a list of specific ARNs, such as ProtectedResourceArns:
	// ["arn:aws:...", "arn:aws:..."] or you can include a wildcard:
	// ProtectedResourceArns: ["*"] , but not both.
	ProtectedResourceArns []string

	// The conditions that you define for resources in your restore testing plan using
	// tags.
	ProtectedResourceConditions *ProtectedResourceConditions

	// You can override certain restore metadata keys by including the parameter
	// RestoreMetadataOverrides in the body of RestoreTestingSelection . Key values are
	// not case sensitive.
	//
	// See the complete list of [restore testing inferred metadata].
	//
	// [restore testing inferred metadata]: https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html
	RestoreMetadataOverrides map[string]string

	// This value represents the time, in hours, data is retained after a restore test
	// so that optional validation can be completed.
	//
	// Accepted value is an integer between 0 and 168 (the hourly equivalent of seven
	// days).
	ValidationWindowHours int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
