// Code generated by smithy-go-codegen DO NOT EDIT.

package batch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/batch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Submits a service job to a specified job queue to run on SageMaker AI. A
// service job is a unit of work that you submit to Batch for execution on
// SageMaker AI.
func (c *Client) SubmitServiceJob(ctx context.Context, params *SubmitServiceJobInput, optFns ...func(*Options)) (*SubmitServiceJobOutput, error) {
	if params == nil {
		params = &SubmitServiceJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SubmitServiceJob", params, optFns, c.addOperationSubmitServiceJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SubmitServiceJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SubmitServiceJobInput struct {

	// The name of the service job. It can be up to 128 characters long. It can
	// contain uppercase and lowercase letters, numbers, hyphens (-), and underscores
	// (_).
	//
	// This member is required.
	JobName *string

	// The job queue into which the service job is submitted. You can specify either
	// the name or the ARN of the queue. The job queue must have the type
	// SAGEMAKER_TRAINING .
	//
	// This member is required.
	JobQueue *string

	// The type of service job. For SageMaker Training jobs, specify SAGEMAKER_TRAINING
	// .
	//
	// This member is required.
	ServiceJobType types.ServiceJobType

	// The request, in JSON, for the service that the SubmitServiceJob operation is
	// queueing.
	//
	// This member is required.
	ServiceRequestPayload *string

	// A unique identifier for the request. This token is used to ensure idempotency
	// of requests. If this parameter is specified and two submit requests with
	// identical payloads and clientToken s are received, these requests are considered
	// the same request and the second request is rejected.
	ClientToken *string

	// The retry strategy to use for failed service jobs that are submitted with this
	// service job request.
	RetryStrategy *types.ServiceJobRetryStrategy

	// The scheduling priority of the service job. Valid values are integers between 0
	// and 9999.
	SchedulingPriority *int32

	// The share identifier for the service job. Don't specify this parameter if the
	// job queue doesn't have a fair- share scheduling policy. If the job queue has a
	// fair-share scheduling policy, then this parameter must be specified.
	ShareIdentifier *string

	// The tags that you apply to the service job request. Each tag consists of a key
	// and an optional value. For more information, see [Tagging your Batch resources].
	//
	// [Tagging your Batch resources]: https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html
	Tags map[string]string

	// The timeout configuration for the service job. If none is specified, Batch
	// defers to the default timeout of the underlying service handling the job.
	TimeoutConfig *types.ServiceJobTimeout

	noSmithyDocumentSerde
}

type SubmitServiceJobOutput struct {

	// The unique identifier for the service job.
	//
	// This member is required.
	JobId *string

	// The name of the service job.
	//
	// This member is required.
	JobName *string

	// The Amazon Resource Name (ARN) for the service job.
	JobArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSubmitServiceJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSubmitServiceJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSubmitServiceJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SubmitServiceJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opSubmitServiceJobMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpSubmitServiceJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSubmitServiceJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpSubmitServiceJob struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpSubmitServiceJob) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpSubmitServiceJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*SubmitServiceJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *SubmitServiceJobInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opSubmitServiceJobMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpSubmitServiceJob{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opSubmitServiceJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SubmitServiceJob",
	}
}
