// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List all of the over-the-air (OTA) task executions.
func (c *Client) ListOtaTaskExecutions(ctx context.Context, params *ListOtaTaskExecutionsInput, optFns ...func(*Options)) (*ListOtaTaskExecutionsOutput, error) {
	if params == nil {
		params = &ListOtaTaskExecutionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListOtaTaskExecutions", params, optFns, c.addOperationListOtaTaskExecutionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListOtaTaskExecutionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListOtaTaskExecutionsInput struct {

	// The over-the-air (OTA) task id.
	//
	// This member is required.
	Identifier *string

	// The maximum number of results to return at one time.
	MaxResults *int32

	// A token that can be used to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListOtaTaskExecutionsOutput struct {

	// A list of all of the over-the-air (OTA) task executions.
	ExecutionSummaries []types.OtaTaskExecutionSummaries

	// A token that can be used to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListOtaTaskExecutionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListOtaTaskExecutions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListOtaTaskExecutions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListOtaTaskExecutions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListOtaTaskExecutionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListOtaTaskExecutions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListOtaTaskExecutionsPaginatorOptions is the paginator options for
// ListOtaTaskExecutions
type ListOtaTaskExecutionsPaginatorOptions struct {
	// The maximum number of results to return at one time.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListOtaTaskExecutionsPaginator is a paginator for ListOtaTaskExecutions
type ListOtaTaskExecutionsPaginator struct {
	options   ListOtaTaskExecutionsPaginatorOptions
	client    ListOtaTaskExecutionsAPIClient
	params    *ListOtaTaskExecutionsInput
	nextToken *string
	firstPage bool
}

// NewListOtaTaskExecutionsPaginator returns a new ListOtaTaskExecutionsPaginator
func NewListOtaTaskExecutionsPaginator(client ListOtaTaskExecutionsAPIClient, params *ListOtaTaskExecutionsInput, optFns ...func(*ListOtaTaskExecutionsPaginatorOptions)) *ListOtaTaskExecutionsPaginator {
	if params == nil {
		params = &ListOtaTaskExecutionsInput{}
	}

	options := ListOtaTaskExecutionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListOtaTaskExecutionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListOtaTaskExecutionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListOtaTaskExecutions page.
func (p *ListOtaTaskExecutionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListOtaTaskExecutionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListOtaTaskExecutions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListOtaTaskExecutionsAPIClient is a client that implements the
// ListOtaTaskExecutions operation.
type ListOtaTaskExecutionsAPIClient interface {
	ListOtaTaskExecutions(context.Context, *ListOtaTaskExecutionsInput, ...func(*Options)) (*ListOtaTaskExecutionsOutput, error)
}

var _ ListOtaTaskExecutionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListOtaTaskExecutions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListOtaTaskExecutions",
	}
}
