// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Structure representing one abort config criteria.
type AbortConfigCriteria struct {

	// The action taken by the abort configuration.
	Action AbortCriteriaAction

	// Over-the-air (OTA) task abort criteria failure type.
	FailureType AbortCriteriaFailureType

	// The minimum number of things that must receive task execution notifications
	// before the task can be aborted.
	MinNumberOfExecutedThings *int32

	// The minimum percentage of over-the-air (OTA) task execution failures that must
	// occur to initiate the last abort.
	ThresholdPercentage *float64

	noSmithyDocumentSerde
}

// Structure containing information about an account association, including its
// identifier, state, and related metadata.
type AccountAssociationItem struct {

	// The unique identifier of the account association.
	//
	// This member is required.
	AccountAssociationId *string

	// The current state of the account association, indicating its status in the
	// association lifecycle.
	//
	// This member is required.
	AssociationState AssociationState

	// The Amazon Resource Name (ARN) of the account association.
	Arn *string

	// The identifier of the connector destination associated with this account
	// association.
	ConnectorDestinationId *string

	// A description of the account association.
	Description *string

	// The error message explaining any issues with the account association, if
	// applicable.
	ErrorMessage *string

	// The name of the account association.
	Name *string

	noSmithyDocumentSerde
}

// The authentication configuration details for a connector destination, including
// OAuth settings and other authentication parameters.
type AuthConfig struct {

	// The OAuth configuration settings used for authentication with the third-party
	// service.
	OAuth *OAuthConfig

	noSmithyDocumentSerde
}

// The updated authentication configuration details for a connector destination.
type AuthConfigUpdate struct {

	// The updated OAuth configuration settings for the authentication configuration.
	OAuthUpdate *OAuthUpdate

	noSmithyDocumentSerde
}

// Action for an Amazon Web Services capability, containing the action parameters
// for control.
type CapabilityAction struct {

	// Describe a capability action with a name.
	//
	// This member is required.
	Name *string

	// Describe a capability action with an actionTraceId for a response command.
	ActionTraceId *string

	// Describe a capability action with a capability property.
	Parameters document.Interface

	// Describe a capability action with an reference.
	Ref *string

	noSmithyDocumentSerde
}

// Report of all capabilities supported by the device.
type CapabilityReport struct {

	// The endpoints used in the capability report.
	//
	// This member is required.
	Endpoints []CapabilityReportEndpoint

	// The version of the capability report.
	//
	// This member is required.
	Version *string

	// The numeric identifier of the node.
	NodeId *string

	noSmithyDocumentSerde
}

// The capability used in capability report.
type CapabilityReportCapability struct {

	// The capability actions used in the capability report.
	//
	// This member is required.
	Actions []string

	// The capability events used in the capability report.
	//
	// This member is required.
	Events []string

	// The id of the schema version.
	//
	// This member is required.
	Id *string

	// The name of the capability.
	//
	// This member is required.
	Name *string

	// The capability properties used in the capability report.
	//
	// This member is required.
	Properties []string

	// The version of the capability.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// The endpoint used in the capability report.
type CapabilityReportEndpoint struct {

	// The capabilities used in the capability report.
	//
	// This member is required.
	Capabilities []CapabilityReportCapability

	// The type of device.
	//
	// This member is required.
	DeviceTypes []string

	// The id of the endpoint used in the capability report.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Structure representing a capability schema item that defines the functionality
// and features supported by a managed thing.
type CapabilitySchemaItem struct {

	// The unique identifier of the capability defined in the schema.
	//
	// This member is required.
	CapabilityId *string

	// The external identifier for the capability, used when referencing the
	// capability outside of the AWS ecosystem.
	//
	// This member is required.
	ExtrinsicId *string

	// The version of the external capability definition, used to track compatibility
	// with external systems.
	//
	// This member is required.
	ExtrinsicVersion *int32

	// The format of the capability schema, which defines how the schema is structured
	// and interpreted.
	//
	// This member is required.
	Format SchemaVersionFormat

	// The actual schema definition that describes the capability's properties,
	// actions, and events.
	//
	// This member is required.
	Schema document.Interface

	noSmithyDocumentSerde
}

// The command capabilities added for the managed thing
type CommandCapability struct {

	// Describe the command capability with the actions it supports.
	//
	// This member is required.
	Actions []CapabilityAction

	// Describe the capability with an id.
	//
	// This member is required.
	Id *string

	// Describe the capability with an name.
	//
	// This member is required.
	Name *string

	// Describe the capability with a version.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// The endpoint for a managed thing when sending a command.
type CommandEndpoint struct {

	// Describe the endpoint with an id, a name, and the relevant capabilities for
	// sending commands.
	//
	// This member is required.
	Capabilities []CommandCapability

	// The id of the endpoint for a managed thing.
	//
	// This member is required.
	EndpointId *string

	noSmithyDocumentSerde
}

// Provides the default encryption configuration error update details.
type ConfigurationError struct {

	// The error code returned when the default encryption configuration update fails.
	Code *string

	// The error message returned when the default encryption configuration update
	// fails.
	Message *string

	noSmithyDocumentSerde
}

// Provides the status of the default encryption configuration for an Amazon Web
// Services account.
type ConfigurationStatus struct {

	// The status state describing the default encryption configuration update.
	//
	// This member is required.
	State ConfigurationState

	// The error details describing a failed default encryption configuration update.
	Error *ConfigurationError

	noSmithyDocumentSerde
}

// Structure containing summary information about a connector destination, which
// defines how a cloud-to-cloud connector connects to a customer's AWS account.
type ConnectorDestinationSummary struct {

	// The identifier of the cloud connector associated with this connector
	// destination.
	CloudConnectorId *string

	// A description of the connector destination.
	Description *string

	// The unique identifier of the connector destination.
	Id *string

	// The display name of the connector destination.
	Name *string

	noSmithyDocumentSerde
}

// Structure describing a connector.
type ConnectorItem struct {

	// The configuration details for the cloud connector endpoint, including
	// connection parameters and authentication requirements.
	//
	// This member is required.
	EndpointConfig *EndpointConfig

	// The display name of the C2C connector.
	//
	// This member is required.
	Name *string

	// A description of the C2C connector.
	Description *string

	// The type of endpoint used for the C2C connector.
	EndpointType EndpointType

	// The identifier of the C2C connector.
	Id *string

	// The type of cloud connector created.
	Type CloudConnectorType

	noSmithyDocumentSerde
}

// Structure describing one Credential Locker.
type CredentialLockerSummary struct {

	// The Amazon Resource Name (ARN) of the credential locker.
	Arn *string

	// The timestampe value of when the credential locker was created at.
	CreatedAt *time.Time

	// The id of the credential locker.
	Id *string

	// The name of the credential locker.
	Name *string

	noSmithyDocumentSerde
}

// Structure describing a destination for IoT managed integrations to deliver
// notifications for a device.
type DestinationSummary struct {

	// The Amazon Resource Name (ARN) of the customer-managed destination.
	DeliveryDestinationArn *string

	// The destination type for the customer-managed destination.
	DeliveryDestinationType DeliveryDestinationType

	// The description of the customer-managed destination.
	Description *string

	// The name of the customer-managed destination.
	Name *string

	// The Amazon Resource Name (ARN) of the delivery destination.
	RoleArn *string

	noSmithyDocumentSerde
}

// Describe the device using the relevant metadata and supported clusters for
// device discovery.
type Device struct {

	// The capability report for the device.
	//
	// This member is required.
	CapabilityReport *MatterCapabilityReport

	// The device id as defined by the connector.
	//
	// This parameter is used for cloud-to-cloud devices only.
	//
	// This member is required.
	ConnectorDeviceId *string

	// Report of all capabilities supported by the device.
	CapabilitySchemas []CapabilitySchemaItem

	// The name of the device as defined by the connector.
	ConnectorDeviceName *string

	// The metadata attributes for a device.
	DeviceMetadata document.Interface

	noSmithyDocumentSerde
}

// Structure containing summary information about a device discovery job,
// including its identifier, type, and status.
type DeviceDiscoverySummary struct {

	// The type of discovery process used to find devices.
	DiscoveryType DiscoveryType

	// The unique identifier of the device discovery job.
	Id *string

	// The current status of the device discovery job.
	Status DeviceDiscoveryStatus

	noSmithyDocumentSerde
}

// Structure containing summary information about a device discovered during a
// device discovery job.
type DiscoveredDeviceSummary struct {

	// The authentication material required for connecting to the discovered device,
	// such as credentials or tokens.
	AuthenticationMaterial *string

	// The brand of the discovered device.
	Brand *string

	// The third-party device identifier as defined by the connector. This identifier
	// must not contain personal identifiable information (PII).
	ConnectorDeviceId *string

	// The name of the device as defined by the connector or third-party system.
	ConnectorDeviceName *string

	// The list of device types or categories that the discovered device belongs to.
	DeviceTypes []string

	// The timestamp indicating when the device was discovered.
	DiscoveredAt *time.Time

	// The identifier of the managed thing created for this discovered device, if one
	// exists.
	ManagedThingId *string

	// The model of the discovered device.
	Model *string

	// The status of the discovered device, indicating whether it has been added,
	// removed, or modified since the last discovery.
	Modification DiscoveryModification

	noSmithyDocumentSerde
}

// The configuration details for an endpoint, which defines how to connect to and
// communicate with external services.
type EndpointConfig struct {

	// The Lambda function configuration for the endpoint, used when the endpoint
	// communicates through an AWS Lambda function.
	Lambda *LambdaConfig

	noSmithyDocumentSerde
}

// List of event log configurations.
type EventLogConfigurationSummary struct {

	// The logging level for the event log configuration.
	EventLogLevel LogLevel

	// The identifier of the event log configuration.
	Id *string

	// The identifier of the resource for the event log configuration.
	ResourceId *string

	// The type of resource for the event log configuration.
	ResourceType *string

	noSmithyDocumentSerde
}

// Structure representing exponential rate of rollout for an over-the-air (OTA)
// task.
type ExponentialRolloutRate struct {

	// The base rate per minute for the rollout of an over-the-air (OTA) task.
	BaseRatePerMinute *int32

	// The incremental factor for increasing the rollout rate of an over-the-air (OTA)
	// task.
	IncrementFactor *float64

	// The criteria for increasing the rollout rate of an over-the-air (OTA) task.
	RateIncreaseCriteria *RolloutRateIncreaseCriteria

	noSmithyDocumentSerde
}

// Configuration details for an AWS Lambda function used as an endpoint for a
// cloud connector.
type LambdaConfig struct {

	// The Amazon Resource Name (ARN) of the Lambda function used as an endpoint.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// Structure representing an association between a managed thing and an account
// association, which connects a device to a third-party account.
type ManagedThingAssociation struct {

	// The identifier of the account association in the association.
	AccountAssociationId *string

	// The identifier of the managed thing in the association.
	ManagedThingId *string

	noSmithyDocumentSerde
}

// Structure representing one schema item associated with a managed thing.
type ManagedThingSchemaListItem struct {

	// The id of the capability for a managed thing.
	CapabilityId *string

	// The id of the endpoint for a managed thing.
	EndpointId *string

	// The validation schema for one schema item associated with a managed thing.
	Schema document.Interface

	noSmithyDocumentSerde
}

// Structure representing one managed thing.
type ManagedThingSummary struct {

	// The timestampe value of when the managed thing was activated at.
	ActivatedAt *time.Time

	// The id of the advertised product.
	AdvertisedProductId *string

	// The Amazon Resource Name (ARN) of the managed thing.
	Arn *string

	// The brand of the device.
	Brand *string

	// The classification of the managed thing such as light bulb or thermostat.
	Classification *string

	// The identifier of the connector destination associated with this managed thing,
	// if applicable.
	ConnectorDestinationId *string

	// The third-party device id as defined by the connector. This device id must not
	// contain personal identifiable information (PII).
	//
	// This parameter is used for cloud-to-cloud devices only.
	ConnectorDeviceId *string

	// The id of the connector policy.
	//
	// This parameter is used for cloud-to-cloud devices only.
	//
	// Deprecated: ConnectorPolicyId has been deprecated
	ConnectorPolicyId *string

	// The timestamp value of when the device creation request occurred.
	CreatedAt *time.Time

	// The identifier of the credential locker for the managed thing.
	CredentialLockerId *string

	// The id of the device.
	Id *string

	// The model of the device.
	Model *string

	// The name of the managed thing representing the physical device.
	Name *string

	// Owner of the device, usually an indication of whom the device belongs to. This
	// value should not contain personal identifiable information.
	Owner *string

	// Id of the controller device used for the discovery job.
	ParentControllerId *string

	// The provisioning status of the device in the provisioning workflow for
	// onboarding to IoT managed integrations.
	ProvisioningStatus ProvisioningStatus

	// The type of device used. This will be the Amazon Web Services hub controller,
	// cloud device, or IoT device.
	Role Role

	// The serial number of the device.
	SerialNumber *string

	// The timestamp value of when the managed thing was last updated at.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Matter based capability report.
type MatterCapabilityReport struct {

	// The endpoints used in the capability report.
	//
	// This member is required.
	Endpoints []MatterCapabilityReportEndpoint

	// The version of the capability report.
	//
	// This member is required.
	Version *string

	// The numeric identifier of the node.
	NodeId *string

	noSmithyDocumentSerde
}

// Matter attribute used in capability report.
type MatterCapabilityReportAttribute struct {

	// The id of the Matter attribute.
	Id *string

	// Name for the Amazon Web Services Matter capability report attribute.
	Name *string

	// Value for the Amazon Web Services Matter capability report attribute.
	Value document.Interface

	noSmithyDocumentSerde
}

// Capability used in Matter capability report.
type MatterCapabilityReportCluster struct {

	// The id of the Amazon Web Services Matter capability report cluster.
	//
	// This member is required.
	Id *string

	// The id of the revision for the Amazon Web Services Matter capability report.
	//
	// This member is required.
	Revision *int32

	// The attributes of the Amazon Web Services Matter capability report.
	Attributes []MatterCapabilityReportAttribute

	// The commands used with the Amazon Web Services Matter capability report.
	Commands []string

	// The events used with the Amazon Web Services Matter capability report.
	Events []string

	// The fabric index for the Amazon Web Services Matter capability report.
	FabricIndex *int32

	// 32 bit-map used to indicate which features a cluster supports.
	FeatureMap *int64

	// Matter clusters used in capability report.
	GeneratedCommands []string

	// The capability name used in the Amazon Web Services Matter capability report.
	Name *string

	// The id of the schema version.
	PublicId *string

	// The spec version used in the Amazon Web Services Matter capability report.
	SpecVersion *string

	noSmithyDocumentSerde
}

// Matter endpoint used in capability report.
type MatterCapabilityReportEndpoint struct {

	// Matter clusters used in capability report.
	//
	// This member is required.
	Clusters []MatterCapabilityReportCluster

	// The type of device.
	//
	// This member is required.
	DeviceTypes []string

	// The id of the Amazon Web Services Matter capability report endpoint.
	//
	// This member is required.
	Id *string

	// Semantic information related to endpoint.
	ClientClusters []string

	// Heirachy of child endpoints contained in the given endpoint.
	Parts []string

	// Semantic information related to endpoint.
	SemanticTags []string

	noSmithyDocumentSerde
}

// Describe a Matter cluster with an id, and the relevant attributes, commands,
// and events.
type MatterCluster struct {

	// The Matter attributes.
	Attributes document.Interface

	// Describe the Matter commands with the Matter command identifier mapped to the
	// command fields.
	Commands map[string]document.Interface

	// Describe the Matter events with the Matter event identifier mapped to the event
	// fields.
	Events map[string]document.Interface

	// The cluster id.
	Id *string

	noSmithyDocumentSerde
}

// Structure describing a managed thing.
type MatterEndpoint struct {

	// A list of Matter clusters for a managed thing.
	Clusters []MatterCluster

	// The Matter endpoint id.
	Id *string

	noSmithyDocumentSerde
}

// Structure describing a notification configuration.
type NotificationConfigurationSummary struct {

	// The name of the destination for the notification configuration.
	DestinationName *string

	// The type of event triggering a device notification to the customer-managed
	// destination.
	EventType EventType

	noSmithyDocumentSerde
}

// Configuration details for OAuth authentication with a third-party service.
type OAuthConfig struct {

	// The authorization URL for the OAuth service, where users are directed to
	// authenticate and authorize access.
	//
	// This member is required.
	AuthUrl *string

	// The authentication scheme used when requesting tokens from the token endpoint.
	//
	// This member is required.
	TokenEndpointAuthenticationScheme TokenEndpointAuthenticationScheme

	// The token URL for the OAuth service, where authorization codes are exchanged
	// for access tokens.
	//
	// This member is required.
	TokenUrl *string

	// The URL where users are redirected after completing the OAuth authorization
	// process.
	OAuthCompleteRedirectUrl *string

	// Configuration for proactively refreshing OAuth tokens before they expire.
	ProactiveRefreshTokenRenewal *ProactiveRefreshTokenRenewal

	// The OAuth scopes requested during authorization, which define the permissions
	// granted to the application.
	Scope *string

	noSmithyDocumentSerde
}

// Structure containing updated OAuth configuration settings.
type OAuthUpdate struct {

	// The updated URL where users are redirected after completing the OAuth
	// authorization process.
	OAuthCompleteRedirectUrl *string

	// Updated configuration for proactively refreshing OAuth tokens before they
	// expire.
	ProactiveRefreshTokenRenewal *ProactiveRefreshTokenRenewal

	noSmithyDocumentSerde
}

// Over-the-air (OTA) task abort config.
type OtaTaskAbortConfig struct {

	// The list of criteria for the abort config.
	AbortConfigCriteriaList []AbortConfigCriteria

	noSmithyDocumentSerde
}

// Structure representing one over-the-air (OTA) task configuration.
type OtaTaskConfigurationSummary struct {

	// The timestamp value of when the over-the-air (OTA) task configuration was
	// created at.
	CreatedAt *time.Time

	// The name of the over-the-air (OTA) task configuration.
	Name *string

	// The id of the over-the-air (OTA) task configuration
	TaskConfigurationId *string

	noSmithyDocumentSerde
}

// Over-the-air (OTA) task retry config.
type OtaTaskExecutionRetryConfig struct {

	// The list of retry config criteria.
	RetryConfigCriteria []RetryConfigCriteria

	noSmithyDocumentSerde
}

// Over-the-air (OTA) task rollout config.
type OtaTaskExecutionRolloutConfig struct {

	// Structure representing exponential rate of rollout for an over-the-air (OTA)
	// task.
	ExponentialRolloutRate *ExponentialRolloutRate

	// The maximum number of things that will be notified of a pending task, per
	// minute.
	MaximumPerMinute *int32

	noSmithyDocumentSerde
}

// Structure representing one execution summary.
type OtaTaskExecutionSummaries struct {

	// The id of a managed thing.
	ManagedThingId *string

	// Structure representing one over-the-air (OTA) task execution summary
	TaskExecutionSummary *OtaTaskExecutionSummary

	noSmithyDocumentSerde
}

// Structure representing one over-the-air (OTA) task execution summary.
type OtaTaskExecutionSummary struct {

	// The execution number of the over-the-air (OTA) task execution summary.
	ExecutionNumber *int64

	// The timestamp value of when the over-the-air (OTA) task execution summary was
	// last updated.
	LastUpdatedAt *time.Time

	// The timestamp value of when the over-the-air (OTA) task execution summary is
	// targeted to start.
	QueuedAt *time.Time

	// The number of retry attempts for starting the over-the-air (OTA) task execution
	// summary after a failed attempt.
	RetryAttempt *int32

	// The timestamp value of when the over-the-air (OTA) task execution summary
	// started.
	StartedAt *time.Time

	// The status of the over-the-air (OTA) task execution summary.
	Status OtaTaskExecutionStatus

	noSmithyDocumentSerde
}

// Over-the-air (OTA) task scheduling config.
type OtaTaskSchedulingConfig struct {

	// Specifies the end behavior for all task executions after a task reaches the
	// selected endTime . If endTime is not selected when creating the task, then
	// endBehavior does not apply.
	EndBehavior SchedulingConfigEndBehavior

	// The time an over-the-air (OTA) task will stop.
	EndTime *string

	// Maintenance window list for over-the-air (OTA) task scheduling config.
	MaintenanceWindows []ScheduleMaintenanceWindow

	// The time an over-the-air (OTA) task will start.
	StartTime *string

	noSmithyDocumentSerde
}

// Structure representing one over-the-air (OTA) task.
type OtaTaskSummary struct {

	// The timestamp value of when the over-the-air (OTA) task was created at.
	CreatedAt *time.Time

	// The timestamp value of when the over-the-air (OTA) task was last updated at.
	LastUpdatedAt *time.Time

	// The status of the over-the-air (OTA) task summary.
	Status OtaStatus

	// The Amazon Resource Name (ARN) of the over-the-air (OTA) task.
	TaskArn *string

	// The identifier for the over-the-air (OTA) task configuration.
	TaskConfigurationId *string

	// The id of the over-the-air (OTA) task.
	TaskId *string

	noSmithyDocumentSerde
}

// Over-the-air (OTA) task timeout config.
type OtaTaskTimeoutConfig struct {

	// Specifies the amount of time the device has to finish execution of this task.
	// The timeout interval can be anywhere between 1 minute and 7 days.
	InProgressTimeoutInMinutes *int64

	noSmithyDocumentSerde
}

// Configuration settings for proactively refreshing OAuth tokens before they
// expire.
type ProactiveRefreshTokenRenewal struct {

	// The days before token expiration when the system should attempt to renew the
	// token, specified in days.
	DaysBeforeRenewal *int32

	// Indicates whether proactive refresh token renewal is enabled.
	Enabled *bool

	noSmithyDocumentSerde
}

// Structure describing a provisioning profile.
type ProvisioningProfileSummary struct {

	// The Amazon Resource Name (ARN) of the provisioning template used in the
	// provisioning profile.
	Arn *string

	// The identifier of the provisioning profile.
	Id *string

	// The name of the provisioning template.
	Name *string

	// The type of provisioning workflow the device uses for onboarding to IoT managed
	// integrations.
	ProvisioningType ProvisioningType

	noSmithyDocumentSerde
}

// Structure representing a push config.
type PushConfig struct {

	// Structure representing one abort config.
	AbortConfig *OtaTaskAbortConfig

	// Structure representing one rollout config.
	RolloutConfig *OtaTaskExecutionRolloutConfig

	// Structure representing one timeout config.
	TimeoutConfig *OtaTaskTimeoutConfig

	noSmithyDocumentSerde
}

// Structure representing one retry config criteria.
type RetryConfigCriteria struct {

	// Over-the-air (OTA) retry criteria failure type.
	FailureType RetryCriteriaFailureType

	// The number of retries allowed for a failure type for the over-the-air (OTA)
	// task.
	MinNumberOfRetries *int32

	noSmithyDocumentSerde
}

// Structure representing rollout config criteria.
type RolloutRateIncreaseCriteria struct {

	// The threshold for number of notified things that will initiate the increase in
	// rate of rollout.
	NumberOfNotifiedThings *int32

	// The threshold for number of succeeded things that will initiate the increase in
	// rate of rollout.
	NumberOfSucceededThings *int32

	noSmithyDocumentSerde
}

// The different configurations for runtime logs.
type RuntimeLogConfigurations struct {

	// Configuration to enable or disable deleting of runtime logs in the device once
	// uploaded to the cloud.
	DeleteLocalStoreAfterUpload *bool

	// Configuration to set the maximum bytes of runtime logs that can be stored on
	// the device before the oldest logs are deleted or overwritten.
	LocalStoreFileRotationMaxBytes *int32

	// Configuration to set the maximum number of runtime log files that can be stored
	// on the device before the oldest files are deleted or overwritten.
	LocalStoreFileRotationMaxFiles *int32

	// Configuration of where to store runtime logs in the device.
	LocalStoreLocation *string

	// The different log levels available for configuration.
	LogFlushLevel LogLevel

	// The different log levels available for configuration.
	LogLevel LogLevel

	// Configuration to enable or disable uploading of runtime logs to the cloud.
	UploadLog *bool

	// Configuration to set the time interval in minutes between each batch of runtime
	// logs that the device uploads to the cloud.
	UploadPeriodMinutes *int32

	noSmithyDocumentSerde
}

// Structure representing scheduling maintenance window.
type ScheduleMaintenanceWindow struct {

	// Displays the duration of the next maintenance window.
	DurationInMinutes *int32

	// Displays the start time of the next maintenance window.
	StartTime *string

	noSmithyDocumentSerde
}

// List item describing a schema version.
type SchemaVersionListItem struct {

	// A description of the schema version.
	Description *string

	// The name of the schema version.
	Namespace *string

	// The identifier of the schema version.
	SchemaId *string

	// The schema version. If this is left blank, it defaults to the latest version.
	SemanticVersion *string

	// The type of schema version.
	Type SchemaVersionType

	// The visibility of the schema version.
	Visibility SchemaVersionVisibility

	noSmithyDocumentSerde
}

// Configuration for AWS Secrets Manager, used to securely store and manage
// sensitive information for connector destinations.
type SecretsManager struct {

	// The Amazon Resource Name (ARN) of the AWS Secrets Manager secret.
	//
	// This member is required.
	Arn *string

	// The version ID of the AWS Secrets Manager secret.
	//
	// This member is required.
	VersionId *string

	noSmithyDocumentSerde
}

// State capabilities added for the managed thing.
type StateCapability struct {

	// The id of the managed thing in the capability report.
	//
	// This member is required.
	Id *string

	// Name for the Amazon Web Services capability.
	//
	// This member is required.
	Name *string

	// Version for the Amazon Web Services capability.
	//
	// This member is required.
	Version *string

	// Describe the command capability with the properties it supports.
	Properties document.Interface

	noSmithyDocumentSerde
}

// Describe the endpoint with an Id, a name, and the relevant capabilities for
// reporting state
type StateEndpoint struct {

	// Describe the endpoint with an id, a name, and the relevant capabilities for the
	// reporting state.
	//
	// This member is required.
	Capabilities []StateCapability

	// Numeric identifier of the endpoint
	//
	// This member is required.
	EndpointId *string

	noSmithyDocumentSerde
}

// Details about the over-the-air (OTA) task process.
type TaskProcessingDetails struct {

	// The number of canceled things in an over-the-air (OTA) task.
	NumberOfCanceledThings *int32

	// The number of failed things in an over-the-air (OTA) task.
	NumberOfFailedThings *int32

	// The number of in progress things in an over-the-air (OTA) task.
	NumberOfInProgressThings *int32

	// The number of queued things in an over-the-air (OTA) task.
	NumberOfQueuedThings *int32

	// The number of rejected things in an over-the-air (OTA) task.
	NumberOfRejectedThings *int32

	// The number of removed things in an over-the-air (OTA) task.
	NumberOfRemovedThings *int32

	// The number of succeeded things in an over-the-air (OTA) task.
	NumberOfSucceededThings *int32

	// The number of timed out things in an over-the-air (OTA) task.
	NumberOfTimedOutThings *int32

	// The targets of the over-the-air (OTA) task.
	ProcessingTargets []string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
