// Code generated by smithy-go-codegen DO NOT EDIT.

package kendra

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kendra/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches an index given an input query.
//
// If you are working with large language models (LLMs) or implementing retrieval
// augmented generation (RAG) systems, you can use Amazon Kendra's [Retrieve]API, which can
// return longer semantically relevant passages. We recommend using the Retrieve
// API instead of filing a service limit increase to increase the Query API
// document excerpt length.
//
// You can configure boosting or relevance tuning at the query level to override
// boosting at the index level, filter based on document fields/attributes and
// faceted search, and filter based on the user or their group access to documents.
// You can also include certain fields in the response that might provide useful
// additional information.
//
// A query response contains three types of results.
//
//   - Relevant suggested answers. The answers can be either a text excerpt or
//     table excerpt. The answer can be highlighted in the excerpt.
//
//   - Matching FAQs or questions-answer from your FAQ file.
//
//   - Relevant documents. This result type includes an excerpt of the document
//     with the document title. The searched terms can be highlighted in the excerpt.
//
// You can specify that the query return only one type of result using the
// QueryResultTypeFilter parameter. Each query returns the 100 most relevant
// results. If you filter result type to only question-answers, a maximum of four
// results are returned. If you filter result type to only answers, a maximum of
// three results are returned.
//
// If you're using an Amazon Kendra Gen AI Enterprise Edition index, you can only
// use ATTRIBUTE_FILTER to filter search results by user context. If you're using
// an Amazon Kendra Gen AI Enterprise Edition index and you try to use USER_TOKEN
// to configure user context policy, Amazon Kendra returns a ValidationException
// error.
//
// [Retrieve]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_Retrieve.html
func (c *Client) Query(ctx context.Context, params *QueryInput, optFns ...func(*Options)) (*QueryOutput, error) {
	if params == nil {
		params = &QueryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "Query", params, optFns, c.addOperationQueryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*QueryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type QueryInput struct {

	// The identifier of the index for the search.
	//
	// This member is required.
	IndexId *string

	// Filters search results by document fields/attributes. You can only provide one
	// attribute filter; however, the AndAllFilters , NotFilter , and OrAllFilters
	// parameters contain a list of other filters.
	//
	// The AttributeFilter parameter means you can create a set of filtering rules
	// that a document must satisfy to be included in the query results.
	//
	// For Amazon Kendra Gen AI Enterprise Edition indices use AttributeFilter to
	// enable document filtering for end users using _email_id or include public
	// documents ( _email_id=null ).
	AttributeFilter *types.AttributeFilter

	// Provides configuration to determine how to group results by document attribute
	// value, and how to display them (collapsed or expanded) under a designated
	// primary document for each group.
	CollapseConfiguration *types.CollapseConfiguration

	// Overrides relevance tuning configurations of fields/attributes set at the index
	// level.
	//
	// If you use this API to override the relevance tuning configured at the index
	// level, but there is no relevance tuning configured at the index level, then
	// Amazon Kendra does not apply any relevance tuning.
	//
	// If there is relevance tuning configured for fields at the index level, and you
	// use this API to override only some of these fields, then for the fields you did
	// not override, the importance is set to 1.
	DocumentRelevanceOverrideConfigurations []types.DocumentRelevanceConfiguration

	// An array of documents fields/attributes for faceted search. Amazon Kendra
	// returns a count for each field key specified. This helps your users narrow their
	// search.
	Facets []types.Facet

	// Query results are returned in pages the size of the PageSize parameter. By
	// default, Amazon Kendra returns the first page of results. Use this parameter to
	// get result pages after the first one.
	PageNumber *int32

	// Sets the number of results that are returned in each page of results. The
	// default page size is 10. The maximum number of results returned is 100. If you
	// ask for more than 100 results, only 100 are returned.
	PageSize *int32

	// Sets the type of query result or response. Only results for the specified type
	// are returned.
	QueryResultTypeFilter types.QueryResultType

	// The input query text for the search. Amazon Kendra truncates queries at 30
	// token words, which excludes punctuation and stop words. Truncation still applies
	// if you use Boolean or more advanced, complex queries. For example, Timeoff AND
	// October AND Category:HR is counted as 3 tokens: timeoff , october , hr . For
	// more information, see [Searching with advanced query syntax]in the Amazon Kendra Developer Guide.
	//
	// [Searching with advanced query syntax]: https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax
	QueryText *string

	// An array of document fields/attributes to include in the response. You can
	// limit the response to include certain document fields. By default, all document
	// attributes are included in the response.
	RequestedDocumentAttributes []string

	// Provides information that determines how the results of the query are sorted.
	// You can set the field that Amazon Kendra should sort the results on, and specify
	// whether the results should be sorted in ascending or descending order. In the
	// case of ties in sorting the results, the results are sorted by relevance.
	//
	// If you don't provide sorting configuration, the results are sorted by the
	// relevance that Amazon Kendra determines for the result.
	SortingConfiguration *types.SortingConfiguration

	// Provides configuration information to determine how the results of a query are
	// sorted.
	//
	// You can set upto 3 fields that Amazon Kendra should sort the results on, and
	// specify whether the results should be sorted in ascending or descending order.
	// The sort field quota can be increased.
	//
	// If you don't provide a sorting configuration, the results are sorted by the
	// relevance that Amazon Kendra determines for the result. In the case of ties in
	// sorting the results, the results are sorted by relevance.
	SortingConfigurations []types.SortingConfiguration

	// Enables suggested spell corrections for queries.
	SpellCorrectionConfiguration *types.SpellCorrectionConfiguration

	// The user context token or user and group information.
	UserContext *types.UserContext

	// Provides an identifier for a specific user. The VisitorId should be a unique
	// identifier, such as a GUID. Don't use personally identifiable information, such
	// as the user's email address, as the VisitorId .
	VisitorId *string

	noSmithyDocumentSerde
}

type QueryOutput struct {

	// Contains the facet results. A FacetResult contains the counts for each
	// field/attribute key that was specified in the Facets input parameter.
	FacetResults []types.FacetResult

	// The list of featured result items. Featured results are displayed at the top of
	// the search results page, placed above all other results for certain queries. If
	// there's an exact match of a query, then certain documents are featured in the
	// search results.
	FeaturedResultsItems []types.FeaturedResultsItem

	// The identifier for the search. You also use QueryId to identify the search when
	// using the [SubmitFeedback]API.
	//
	// [SubmitFeedback]: https://docs.aws.amazon.com/kendra/latest/APIReference/API_SubmitFeedback.html
	QueryId *string

	// The results of the search.
	ResultItems []types.QueryResultItem

	// A list of information related to suggested spell corrections for a query.
	SpellCorrectedQueries []types.SpellCorrectedQuery

	// The total number of items found by the search. However, you can only retrieve
	// up to 100 items. For example, if the search found 192 items, you can only
	// retrieve the first 100 of the items.
	TotalNumberOfResults *int32

	// A list of warning codes and their messages on problems with your query.
	//
	// Amazon Kendra currently only supports one type of warning, which is a warning
	// on invalid syntax used in the query. For examples of invalid query syntax, see [Searching with advanced query syntax].
	//
	// [Searching with advanced query syntax]: https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax
	Warnings []types.Warning

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationQueryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpQuery{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpQuery{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "Query"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpQueryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opQuery(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opQuery(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "Query",
	}
}
