// Code generated by smithy-go-codegen DO NOT EDIT.

package macie2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/macie2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the status of automated sensitive data discovery for one or more
// accounts.
func (c *Client) ListAutomatedDiscoveryAccounts(ctx context.Context, params *ListAutomatedDiscoveryAccountsInput, optFns ...func(*Options)) (*ListAutomatedDiscoveryAccountsOutput, error) {
	if params == nil {
		params = &ListAutomatedDiscoveryAccountsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAutomatedDiscoveryAccounts", params, optFns, c.addOperationListAutomatedDiscoveryAccountsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAutomatedDiscoveryAccountsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAutomatedDiscoveryAccountsInput struct {

	// The Amazon Web Services account ID for each account, for as many as 50
	// accounts. To retrieve the status for multiple accounts, append the accountIds
	// parameter and argument for each account, separated by an ampersand (&). To
	// retrieve the status for all the accounts in an organization, omit this
	// parameter.
	AccountIds []string

	// The maximum number of items to include in each page of a paginated response.
	MaxResults *int32

	// The nextToken string that specifies which page of results to return in a
	// paginated response.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAutomatedDiscoveryAccountsOutput struct {

	// An array of objects, one for each account specified in the request. Each object
	// specifies the Amazon Web Services account ID for an account and the current
	// status of automated sensitive data discovery for that account.
	Items []types.AutomatedDiscoveryAccount

	// The string to use in a subsequent request to get the next page of results in a
	// paginated response. This value is null if there are no additional pages.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAutomatedDiscoveryAccountsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAutomatedDiscoveryAccounts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAutomatedDiscoveryAccounts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAutomatedDiscoveryAccounts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAutomatedDiscoveryAccounts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAutomatedDiscoveryAccountsPaginatorOptions is the paginator options for
// ListAutomatedDiscoveryAccounts
type ListAutomatedDiscoveryAccountsPaginatorOptions struct {
	// The maximum number of items to include in each page of a paginated response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAutomatedDiscoveryAccountsPaginator is a paginator for
// ListAutomatedDiscoveryAccounts
type ListAutomatedDiscoveryAccountsPaginator struct {
	options   ListAutomatedDiscoveryAccountsPaginatorOptions
	client    ListAutomatedDiscoveryAccountsAPIClient
	params    *ListAutomatedDiscoveryAccountsInput
	nextToken *string
	firstPage bool
}

// NewListAutomatedDiscoveryAccountsPaginator returns a new
// ListAutomatedDiscoveryAccountsPaginator
func NewListAutomatedDiscoveryAccountsPaginator(client ListAutomatedDiscoveryAccountsAPIClient, params *ListAutomatedDiscoveryAccountsInput, optFns ...func(*ListAutomatedDiscoveryAccountsPaginatorOptions)) *ListAutomatedDiscoveryAccountsPaginator {
	if params == nil {
		params = &ListAutomatedDiscoveryAccountsInput{}
	}

	options := ListAutomatedDiscoveryAccountsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAutomatedDiscoveryAccountsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAutomatedDiscoveryAccountsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAutomatedDiscoveryAccounts page.
func (p *ListAutomatedDiscoveryAccountsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAutomatedDiscoveryAccountsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAutomatedDiscoveryAccounts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAutomatedDiscoveryAccountsAPIClient is a client that implements the
// ListAutomatedDiscoveryAccounts operation.
type ListAutomatedDiscoveryAccountsAPIClient interface {
	ListAutomatedDiscoveryAccounts(context.Context, *ListAutomatedDiscoveryAccountsInput, ...func(*Options)) (*ListAutomatedDiscoveryAccountsOutput, error)
}

var _ ListAutomatedDiscoveryAccountsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAutomatedDiscoveryAccounts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAutomatedDiscoveryAccounts",
	}
}
