// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Meta data about Kubernetes resources.
type KubernetesMetadata struct {

	// The name of the pod for a local resource.
	LocalPodName *string

	// The namespace of the pod for a local resource.
	LocalPodNamespace *string

	// The service name for a local resource.
	LocalServiceName *string

	// The name of the pod for a remote resource.
	RemotePodName *string

	// The namespace of the pod for a remote resource.
	RemotePodNamespace *string

	// The service name for a remote resource.
	RemoteServiceName *string

	noSmithyDocumentSerde
}

// A local resource is the host where the agent is installed. Local resources can
// be a a subnet, a VPC, or an Availability Zone.
type MonitorLocalResource struct {

	// The identifier of the local resource, such as an ARN.
	//
	// This member is required.
	Identifier *string

	// The type of the local resource. Valid values are AWS::EC2::VPC
	// AWS::AvailabilityZone or AWS::EC2::Subnet .
	//
	// This member is required.
	Type MonitorLocalResourceType

	noSmithyDocumentSerde
}

// A remote resource is the other endpoint in a network flow. That is, one
// endpoint is the local resource and the other is the remote resource. Remote
// resources can be a a subnet, a VPC, an Availability Zone, or an Amazon Web
// Services service.
type MonitorRemoteResource struct {

	// The identifier of the remote resource, such as an ARN.
	//
	// This member is required.
	Identifier *string

	// The type of the remote resource. Valid values are AWS::EC2::VPC
	// AWS::AvailabilityZone , AWS::EC2::Subnet , or AWS::AWSService .
	//
	// This member is required.
	Type MonitorRemoteResourceType

	noSmithyDocumentSerde
}

// A summary of information about a monitor, includ the ARN, the name, and the
// status.
type MonitorSummary struct {

	// The Amazon Resource Name (ARN) of the monitor.
	//
	// This member is required.
	MonitorArn *string

	// The name of the monitor.
	//
	// This member is required.
	MonitorName *string

	// The status of a monitor. The status can be one of the following
	//
	//   - PENDING : The monitor is in the process of being created.
	//
	//   - ACTIVE : The monitor is active.
	//
	//   - INACTIVE : The monitor is inactive.
	//
	//   - ERROR : Monitor creation failed due to an error.
	//
	//   - DELETING : The monitor is in the process of being deleted.
	//
	// This member is required.
	MonitorStatus MonitorStatus

	noSmithyDocumentSerde
}

// A set of information for a top contributor network flow in a monitor. In a
// monitor, Network Flow Monitor returns information about the network flows for
// top contributors for each metric. Top contributors are network flows with the
// top values for each metric type.
type MonitorTopContributorsRow struct {

	// The destination category for a top contributors row. Destination categories can
	// be one of the following:
	//
	//   - INTRA_AZ : Top contributor network flows within a single Availability Zone
	//
	//   - INTER_AZ : Top contributor network flows between Availability Zones
	//
	//   - INTER_VPC : Top contributor network flows between VPCs
	//
	//   - AWS_SERVICES : Top contributor network flows to or from Amazon Web Services
	//   services
	//
	//   - UNCLASSIFIED : Top contributor network flows that do not have a bucket
	//   classification
	DestinationCategory DestinationCategory

	// The destination network address translation (DNAT) IP address for a top
	// contributor network flow.
	DnatIp *string

	// Meta data about Kubernetes resources.
	KubernetesMetadata *KubernetesMetadata

	// The Availability Zone for the local resource for a top contributor network flow.
	LocalAz *string

	// The Amazon Resource Name (ARN) of a local resource.
	LocalInstanceArn *string

	// The instance identifier for the local resource for a top contributor network
	// flow.
	LocalInstanceId *string

	// The IP address of the local resource for a top contributor network flow.
	LocalIp *string

	// The Amazon Web Services Region for the local resource for a top contributor
	// network flow.
	LocalRegion *string

	// The Amazon Resource Name (ARN) of a local subnet.
	LocalSubnetArn *string

	// The subnet ID for the local resource for a top contributor network flow.
	LocalSubnetId *string

	// The Amazon Resource Name (ARN) of a local VPC.
	LocalVpcArn *string

	// The VPC ID for a top contributor network flow for the local resource.
	LocalVpcId *string

	// The Availability Zone for the remote resource for a top contributor network
	// flow.
	RemoteAz *string

	// The Amazon Resource Name (ARN) of a remote resource.
	RemoteInstanceArn *string

	// The instance identifier for the remote resource for a top contributor network
	// flow.
	RemoteInstanceId *string

	// The IP address of the remote resource for a top contributor network flow.
	RemoteIp *string

	// The Amazon Web Services Region for the remote resource for a top contributor
	// network flow.
	RemoteRegion *string

	// The Amazon Resource Name (ARN) of a remote subnet.
	RemoteSubnetArn *string

	// The subnet ID for the remote resource for a top contributor network flow.
	RemoteSubnetId *string

	// The Amazon Resource Name (ARN) of a remote VPC.
	RemoteVpcArn *string

	// The VPC ID for a top contributor network flow for the remote resource.
	RemoteVpcId *string

	// The secure network address translation (SNAT) IP address for a top contributor
	// network flow.
	SnatIp *string

	// The target port.
	TargetPort *int32

	// The constructs traversed by a network flow.
	TraversedConstructs []TraversedComponent

	// The value of the metric for a top contributor network flow.
	Value *int64

	noSmithyDocumentSerde
}

// A summary of information about a scope, including the ARN, target ID, and
// Amazon Web Services Region.
type ScopeSummary struct {

	// The Amazon Resource Name (ARN) of the scope.
	//
	// This member is required.
	ScopeArn *string

	// The identifier for the scope that includes the resources you want to get data
	// results for. A scope ID is an internally-generated identifier that includes all
	// the resources for a specific root account.
	//
	// This member is required.
	ScopeId *string

	// The status for a scope. The status can be one of the following: SUCCEEDED ,
	// IN_PROGRESS , FAILED , DEACTIVATING , or DEACTIVATED .
	//
	// A status of DEACTIVATING means that you've requested a scope to be deactivated
	// and Network Flow Monitor is in the process of deactivating the scope. A status
	// of DEACTIVATED means that the deactivating process is complete.
	//
	// This member is required.
	Status ScopeStatus

	noSmithyDocumentSerde
}

// A target ID is an internally-generated identifier for a target. A target allows
// you to identify all the resources in a Network Flow Monitor scope. Currently, a
// target is always an Amazon Web Services account.
//
// The following types satisfy this interface:
//
//	TargetIdMemberAccountId
type TargetId interface {
	isTargetId()
}

// The identifier for the account for a target.
type TargetIdMemberAccountId struct {
	Value string

	noSmithyDocumentSerde
}

func (*TargetIdMemberAccountId) isTargetId() {}

// A target identifier is a pair of identifying information for a resource that is
// included in a target. A target identifier includes the target ID and the target
// type.
type TargetIdentifier struct {

	// The identifier for a target.
	//
	// This member is required.
	TargetId TargetId

	// The type of a target. A target type is currently always ACCOUNT because a
	// target is currently a single Amazon Web Services account.
	//
	// This member is required.
	TargetType TargetType

	noSmithyDocumentSerde
}

// A target resource in a scope. The resource is identified by a Region and a
// target identifier, which includes a target ID and a target type.
type TargetResource struct {

	// The Amazon Web Services Region where the target resource is located.
	//
	// This member is required.
	Region *string

	// A target identifier is a pair of identifying information for a resource that is
	// included in a target. A target identifier includes the target ID and the target
	// type.
	//
	// This member is required.
	TargetIdentifier *TargetIdentifier

	noSmithyDocumentSerde
}

// A section of the network that a network flow has traveled through.
type TraversedComponent struct {

	// The Amazon Resource Name (ARN) of a tranversed component.
	ComponentArn *string

	// The identifier for the traversed component.
	ComponentId *string

	// The type of component that was traversed.
	ComponentType *string

	// The service name for the traversed component.
	ServiceName *string

	noSmithyDocumentSerde
}

// A data point for a top contributor network flow in a scope. Network Flow
// Monitor returns information about the network flows with the top values for each
// metric type, which are called top contributors.
type WorkloadInsightsTopContributorsDataPoint struct {

	// The label identifying the data point.
	//
	// This member is required.
	Label *string

	// An array of the timestamps for the data point.
	//
	// This member is required.
	Timestamps []time.Time

	// The values for the data point.
	//
	// This member is required.
	Values []float64

	noSmithyDocumentSerde
}

// A row for a top contributor for a scope.
type WorkloadInsightsTopContributorsRow struct {

	// The account ID for a specific row of data.
	AccountId *string

	// The identifier for the Availability Zone where the local resource is located.
	LocalAz *string

	// The Amazon Web Services Region where the local resource is located.
	LocalRegion *string

	// The Amazon Resource Name (ARN) of a local subnet.
	LocalSubnetArn *string

	// The subnet identifier for the local resource.
	LocalSubnetId *string

	// The Amazon Resource Name (ARN) of a local VPC.
	LocalVpcArn *string

	// The identifier for the VPC for the local resource.
	LocalVpcId *string

	// The identifier of a remote resource.
	RemoteIdentifier *string

	// The value for a metric.
	Value *int64

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isTargetId() {}
