// Code generated by smithy-go-codegen DO NOT EDIT.

package rbin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/rbin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing Recycle Bin retention rule. You can update a retention
// rule's description, resource tags, and retention period at any time after
// creation. You can't update a retention rule's resource type after creation. For
// more information, see [Update Recycle Bin retention rules]in the Amazon Elastic Compute Cloud User Guide.
//
// [Update Recycle Bin retention rules]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-update-rule
func (c *Client) UpdateRule(ctx context.Context, params *UpdateRuleInput, optFns ...func(*Options)) (*UpdateRuleOutput, error) {
	if params == nil {
		params = &UpdateRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateRule", params, optFns, c.addOperationUpdateRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateRuleInput struct {

	// The unique ID of the retention rule.
	//
	// This member is required.
	Identifier *string

	// The retention rule description.
	Description *string

	// [Region-level retention rules only] Specifies the exclusion tags to use to
	// identify resources that are to be excluded, or ignored, by a Region-level
	// retention rule. Resources that have any of these tags are not retained by the
	// retention rule upon deletion.
	//
	// You can't specify exclusion tags for tag-level retention rules.
	ExcludeResourceTags []types.ResourceTag

	// [Tag-level retention rules only] Specifies the resource tags to use to identify
	// resources that are to be retained by a tag-level retention rule. For tag-level
	// retention rules, only deleted resources, of the specified resource type, that
	// have one or more of the specified tag key and value pairs are retained. If a
	// resource is deleted, but it does not have any of the specified tag key and value
	// pairs, it is immediately deleted without being retained by the retention rule.
	//
	// You can add the same tag key and value pair to a maximum or five retention
	// rules.
	//
	// To create a Region-level retention rule, omit this parameter. A Region-level
	// retention rule does not have any resource tags specified. It retains all deleted
	// resources of the specified resource type in the Region in which the rule is
	// created, even if the resources are not tagged.
	ResourceTags []types.ResourceTag

	// This parameter is currently not supported. You can't update a retention rule's
	// resource type after creation.
	ResourceType types.ResourceType

	// Information about the retention period for which the retention rule is to
	// retain resources.
	RetentionPeriod *types.RetentionPeriod

	noSmithyDocumentSerde
}

type UpdateRuleOutput struct {

	// The retention rule description.
	Description *string

	// [Region-level retention rules only] Information about the exclusion tags used
	// to identify resources that are to be excluded, or ignored, by the retention
	// rule.
	ExcludeResourceTags []types.ResourceTag

	// The unique ID of the retention rule.
	Identifier *string

	// The date and time at which the unlock delay is set to expire. Only returned for
	// retention rules that have been unlocked and that are still within the unlock
	// delay period.
	LockEndTime *time.Time

	// [Region-level retention rules only] The lock state for the retention rule.
	//
	//   - locked - The retention rule is locked and can't be modified or deleted.
	//
	//   - pending_unlock - The retention rule has been unlocked but it is still within
	//   the unlock delay period. The retention rule can be modified or deleted only
	//   after the unlock delay period has expired.
	//
	//   - unlocked - The retention rule is unlocked and it can be modified or deleted
	//   by any user with the required permissions.
	//
	//   - null - The retention rule has never been locked. Once a retention rule has
	//   been locked, it can transition between the locked and unlocked states only; it
	//   can never transition back to null .
	LockState types.LockState

	// [Tag-level retention rules only] Information about the resource tags used to
	// identify resources that are retained by the retention rule.
	ResourceTags []types.ResourceTag

	// The resource type retained by the retention rule.
	ResourceType types.ResourceType

	// Information about the retention period for which the retention rule is to
	// retain resources.
	RetentionPeriod *types.RetentionPeriod

	// The Amazon Resource Name (ARN) of the retention rule.
	RuleArn *string

	// The state of the retention rule. Only retention rules that are in the available
	// state retain resources.
	Status types.RuleStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateRule",
	}
}
