// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves a list of event summaries for a specified HyperPod cluster. The
// operation supports filtering, sorting, and pagination of results. This
// functionality is only supported when the NodeProvisioningMode is set to
// Continuous .
func (c *Client) ListClusterEvents(ctx context.Context, params *ListClusterEventsInput, optFns ...func(*Options)) (*ListClusterEventsOutput, error) {
	if params == nil {
		params = &ListClusterEventsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListClusterEvents", params, optFns, c.addOperationListClusterEventsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListClusterEventsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListClusterEventsInput struct {

	// The name or Amazon Resource Name (ARN) of the HyperPod cluster for which to
	// list events.
	//
	// This member is required.
	ClusterName *string

	// The start of the time range for filtering events. Only events that occurred
	// after this time are included in the results.
	EventTimeAfter *time.Time

	// The end of the time range for filtering events. Only events that occurred
	// before this time are included in the results.
	EventTimeBefore *time.Time

	// The name of the instance group to filter events. If specified, only events
	// related to this instance group are returned.
	InstanceGroupName *string

	// The maximum number of events to return in the response. Valid range is 1 to 100.
	MaxResults *int32

	// A token to retrieve the next set of results. This token is obtained from the
	// output of a previous ListClusterEvents call.
	NextToken *string

	// The EC2 instance ID to filter events. If specified, only events related to this
	// instance are returned.
	NodeId *string

	// The type of resource for which to filter events. Valid values are Cluster ,
	// InstanceGroup , or Instance .
	ResourceType types.ClusterEventResourceType

	// The field to use for sorting the event list. Currently, the only supported
	// value is EventTime .
	SortBy types.EventSortBy

	// The order in which to sort the results. Valid values are Ascending or Descending
	// (the default is Descending ).
	SortOrder types.SortOrder

	noSmithyDocumentSerde
}

type ListClusterEventsOutput struct {

	// A list of event summaries matching the specified criteria.
	Events []types.ClusterEventSummary

	// A token to retrieve the next set of results. Include this token in subsequent
	// ListClusterEvents calls to fetch more events.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListClusterEventsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListClusterEvents{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListClusterEvents{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListClusterEvents"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListClusterEventsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListClusterEvents(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListClusterEventsPaginatorOptions is the paginator options for ListClusterEvents
type ListClusterEventsPaginatorOptions struct {
	// The maximum number of events to return in the response. Valid range is 1 to 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListClusterEventsPaginator is a paginator for ListClusterEvents
type ListClusterEventsPaginator struct {
	options   ListClusterEventsPaginatorOptions
	client    ListClusterEventsAPIClient
	params    *ListClusterEventsInput
	nextToken *string
	firstPage bool
}

// NewListClusterEventsPaginator returns a new ListClusterEventsPaginator
func NewListClusterEventsPaginator(client ListClusterEventsAPIClient, params *ListClusterEventsInput, optFns ...func(*ListClusterEventsPaginatorOptions)) *ListClusterEventsPaginator {
	if params == nil {
		params = &ListClusterEventsInput{}
	}

	options := ListClusterEventsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListClusterEventsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListClusterEventsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListClusterEvents page.
func (p *ListClusterEventsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListClusterEventsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListClusterEvents(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListClusterEventsAPIClient is a client that implements the ListClusterEvents
// operation.
type ListClusterEventsAPIClient interface {
	ListClusterEvents(context.Context, *ListClusterEventsInput, ...func(*Options)) (*ListClusterEventsOutput, error)
}

var _ ListClusterEventsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListClusterEvents(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListClusterEvents",
	}
}
