// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the platform software of a SageMaker HyperPod cluster for security
// patching. To learn how to use this API, see [Update the SageMaker HyperPod platform software of a cluster].
//
// The UpgradeClusterSoftware API call may impact your SageMaker HyperPod cluster
// uptime and availability. Plan accordingly to mitigate potential disruptions to
// your workloads.
//
// [Update the SageMaker HyperPod platform software of a cluster]: https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software
func (c *Client) UpdateClusterSoftware(ctx context.Context, params *UpdateClusterSoftwareInput, optFns ...func(*Options)) (*UpdateClusterSoftwareOutput, error) {
	if params == nil {
		params = &UpdateClusterSoftwareInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateClusterSoftware", params, optFns, c.addOperationUpdateClusterSoftwareMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateClusterSoftwareOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateClusterSoftwareInput struct {

	// Specify the name or the Amazon Resource Name (ARN) of the SageMaker HyperPod
	// cluster you want to update for security patching.
	//
	// This member is required.
	ClusterName *string

	// The configuration to use when updating the AMI versions.
	DeploymentConfig *types.DeploymentConfiguration

	// When configuring your HyperPod cluster, you can specify an image ID using one
	// of the following options:
	//
	//   - HyperPodPublicAmiId : Use a HyperPod public AMI
	//
	//   - CustomAmiId : Use your custom AMI
	//
	//   - default : Use the default latest system image
	//
	// If you choose to use a custom AMI ( CustomAmiId ), ensure it meets the following
	// requirements:
	//
	//   - Encryption: The custom AMI must be unencrypted.
	//
	//   - Ownership: The custom AMI must be owned by the same Amazon Web Services
	//   account that is creating the HyperPod cluster.
	//
	//   - Volume support: Only the primary AMI snapshot volume is supported;
	//   additional AMI volumes are not supported.
	//
	// When updating the instance group's AMI through the UpdateClusterSoftware
	// operation, if an instance group uses a custom AMI, you must provide an ImageId
	// or use the default as input. Note that if you don't specify an instance group in
	// your UpdateClusterSoftware request, then all of the instance groups are patched
	// with the specified image.
	ImageId *string

	// The array of instance groups for which to update AMI versions.
	InstanceGroups []types.UpdateClusterSoftwareInstanceGroupSpecification

	noSmithyDocumentSerde
}

type UpdateClusterSoftwareOutput struct {

	// The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster being updated
	// for security patching.
	//
	// This member is required.
	ClusterArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateClusterSoftwareMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateClusterSoftware{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateClusterSoftware{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateClusterSoftware"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateClusterSoftwareValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateClusterSoftware(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateClusterSoftware(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateClusterSoftware",
	}
}
