// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains information about actions and resources that define permissions to
// check against a policy.
type Access struct {

	// A list of actions for the access permissions. Any strings that can be used as
	// an action in an IAM policy can be used in the list of actions to check.
	Actions []string

	// A list of resources for the access permissions. Any strings that can be used as
	// an Amazon Resource Name (ARN) in an IAM policy can be used in the list of
	// resources to check. You can only use a wildcard in the portion of the ARN that
	// specifies the resource ID.
	Resources []string

	noSmithyDocumentSerde
}

// Contains information about an access preview.
type AccessPreview struct {

	// The ARN of the analyzer used to generate the access preview.
	//
	// This member is required.
	AnalyzerArn *string

	// A map of resource ARNs for the proposed resource configuration.
	//
	// This member is required.
	Configurations map[string]Configuration

	// The time at which the access preview was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique ID for the access preview.
	//
	// This member is required.
	Id *string

	// The status of the access preview.
	//
	//   - Creating - The access preview creation is in progress.
	//
	//   - Completed - The access preview is complete. You can preview findings for
	//   external access to the resource.
	//
	//   - Failed - The access preview creation has failed.
	//
	// This member is required.
	Status AccessPreviewStatus

	// Provides more details about the current status of the access preview.
	//
	// For example, if the creation of the access preview fails, a Failed status is
	// returned. This failure can be due to an internal issue with the analysis or due
	// to an invalid resource configuration.
	StatusReason *AccessPreviewStatusReason

	noSmithyDocumentSerde
}

// An access preview finding generated by the access preview.
type AccessPreviewFinding struct {

	// Provides context on how the access preview finding compares to existing access
	// identified in IAM Access Analyzer.
	//
	//   - New - The finding is for newly-introduced access.
	//
	//   - Unchanged - The preview finding is an existing finding that would remain
	//   unchanged.
	//
	//   - Changed - The preview finding is an existing finding with a change in status.
	//
	// For example, a Changed finding with preview status Resolved and existing status
	// Active indicates the existing Active finding would become Resolved as a result
	// of the proposed permissions change.
	//
	// This member is required.
	ChangeType FindingChangeType

	// The time at which the access preview finding was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the access preview finding. This ID uniquely identifies the element
	// in the list of access preview findings and is not related to the finding ID in
	// Access Analyzer.
	//
	// This member is required.
	Id *string

	// The Amazon Web Services account ID that owns the resource. For most Amazon Web
	// Services resources, the owning account is the account in which the resource was
	// created.
	//
	// This member is required.
	ResourceOwnerAccount *string

	// The type of the resource that can be accessed in the finding.
	//
	// This member is required.
	ResourceType ResourceType

	// The preview status of the finding. This is what the status of the finding would
	// be after permissions deployment. For example, a Changed finding with preview
	// status Resolved and existing status Active indicates the existing Active
	// finding would become Resolved as a result of the proposed permissions change.
	//
	// This member is required.
	Status FindingStatus

	// The action in the analyzed policy statement that an external principal has
	// permission to perform.
	Action []string

	// The condition in the analyzed policy statement that resulted in a finding.
	Condition map[string]string

	// An error.
	Error *string

	// The existing ID of the finding in IAM Access Analyzer, provided only for
	// existing findings.
	ExistingFindingId *string

	// The existing status of the finding, provided only for existing findings.
	ExistingFindingStatus FindingStatus

	// Indicates whether the policy that generated the finding allows public access to
	// the resource.
	IsPublic *bool

	// The external principal that has access to a resource within the zone of trust.
	Principal map[string]string

	// The resource that an external principal has access to. This is the resource
	// associated with the access preview.
	Resource *string

	// The type of restriction applied to the finding by the resource owner with an
	// Organizations resource control policy (RCP).
	ResourceControlPolicyRestriction ResourceControlPolicyRestriction

	// The sources of the finding. This indicates how the access that generated the
	// finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []FindingSource

	noSmithyDocumentSerde
}

// Provides more details about the current status of the access preview. For
// example, if the creation of the access preview fails, a Failed status is
// returned. This failure can be due to an internal issue with the analysis or due
// to an invalid proposed resource configuration.
type AccessPreviewStatusReason struct {

	// The reason code for the current status of the access preview.
	//
	// This member is required.
	Code AccessPreviewStatusReasonCode

	noSmithyDocumentSerde
}

// Contains a summary of information about an access preview.
type AccessPreviewSummary struct {

	// The ARN of the analyzer used to generate the access preview.
	//
	// This member is required.
	AnalyzerArn *string

	// The time at which the access preview was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique ID for the access preview.
	//
	// This member is required.
	Id *string

	// The status of the access preview.
	//
	//   - Creating - The access preview creation is in progress.
	//
	//   - Completed - The access preview is complete and previews the findings for
	//   external access to the resource.
	//
	//   - Failed - The access preview creation has failed.
	//
	// This member is required.
	Status AccessPreviewStatus

	// Provides more details about the current status of the access preview. For
	// example, if the creation of the access preview fails, a Failed status is
	// returned. This failure can be due to an internal issue with the analysis or due
	// to an invalid proposed resource configuration.
	StatusReason *AccessPreviewStatusReason

	noSmithyDocumentSerde
}

// You specify each grantee as a type-value pair using one of these types. You can
// specify only one type of grantee. For more information, see [PutBucketAcl].
//
// The following types satisfy this interface:
//
//	AclGranteeMemberId
//	AclGranteeMemberUri
//
// [PutBucketAcl]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAcl.html
type AclGrantee interface {
	isAclGrantee()
}

// The value specified is the canonical user ID of an Amazon Web Services account.
type AclGranteeMemberId struct {
	Value string

	noSmithyDocumentSerde
}

func (*AclGranteeMemberId) isAclGrantee() {}

// Used for granting permissions to a predefined group.
type AclGranteeMemberUri struct {
	Value string

	noSmithyDocumentSerde
}

func (*AclGranteeMemberUri) isAclGrantee() {}

// Contains information about analysis rules for the analyzer. Analysis rules
// determine which entities will generate findings based on the criteria you define
// when you create the rule.
type AnalysisRule struct {

	// A list of rules for the analyzer containing criteria to exclude from analysis.
	// Entities that meet the rule criteria will not generate findings.
	Exclusions []AnalysisRuleCriteria

	noSmithyDocumentSerde
}

// The criteria for an analysis rule for an analyzer. The criteria determine which
// entities will generate findings.
type AnalysisRuleCriteria struct {

	// A list of Amazon Web Services account IDs to apply to the analysis rule
	// criteria. The accounts cannot include the organization analyzer owner account.
	// Account IDs can only be applied to the analysis rule criteria for
	// organization-level analyzers. The list cannot include more than 2,000 account
	// IDs.
	AccountIds []string

	// An array of key-value pairs to match for your resources. You can use the set of
	// Unicode letters, digits, whitespace, _ , . , / , = , + , and - .
	//
	// For the tag key, you can specify a value that is 1 to 128 characters in length
	// and cannot be prefixed with aws: .
	//
	// For the tag value, you can specify a value that is 0 to 256 characters in
	// length. If the specified tag value is 0 characters, the rule is applied to all
	// principals with the specified tag key.
	ResourceTags []map[string]string

	noSmithyDocumentSerde
}

// Contains details about the analyzed resource.
type AnalyzedResource struct {

	// The time at which the resource was analyzed.
	//
	// This member is required.
	AnalyzedAt *time.Time

	// The time at which the finding was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Indicates whether the policy that generated the finding grants public access to
	// the resource.
	//
	// This member is required.
	IsPublic *bool

	// The ARN of the resource that was analyzed.
	//
	// This member is required.
	ResourceArn *string

	// The Amazon Web Services account ID that owns the resource.
	//
	// This member is required.
	ResourceOwnerAccount *string

	// The type of the resource that was analyzed.
	//
	// This member is required.
	ResourceType ResourceType

	// The time at which the finding was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The actions that an external principal is granted permission to use by the
	// policy that generated the finding.
	Actions []string

	// An error message.
	Error *string

	// Indicates how the access that generated the finding is granted. This is
	// populated for Amazon S3 bucket findings.
	SharedVia []string

	// The current status of the finding generated from the analyzed resource.
	Status FindingStatus

	noSmithyDocumentSerde
}

// Contains the ARN of the analyzed resource.
type AnalyzedResourceSummary struct {

	// The ARN of the analyzed resource.
	//
	// This member is required.
	ResourceArn *string

	// The Amazon Web Services account ID that owns the resource.
	//
	// This member is required.
	ResourceOwnerAccount *string

	// The type of resource that was analyzed.
	//
	// This member is required.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// Contains information about the configuration of an analyzer for an Amazon Web
// Services organization or account.
//
// The following types satisfy this interface:
//
//	AnalyzerConfigurationMemberInternalAccess
//	AnalyzerConfigurationMemberUnusedAccess
type AnalyzerConfiguration interface {
	isAnalyzerConfiguration()
}

// Specifies the configuration of an internal access analyzer for an Amazon Web
// Services organization or account. This configuration determines how the analyzer
// evaluates access within your Amazon Web Services environment.
type AnalyzerConfigurationMemberInternalAccess struct {
	Value InternalAccessConfiguration

	noSmithyDocumentSerde
}

func (*AnalyzerConfigurationMemberInternalAccess) isAnalyzerConfiguration() {}

// Specifies the configuration of an unused access analyzer for an Amazon Web
// Services organization or account.
type AnalyzerConfigurationMemberUnusedAccess struct {
	Value UnusedAccessConfiguration

	noSmithyDocumentSerde
}

func (*AnalyzerConfigurationMemberUnusedAccess) isAnalyzerConfiguration() {}

// Contains information about the analyzer.
type AnalyzerSummary struct {

	// The ARN of the analyzer.
	//
	// This member is required.
	Arn *string

	// A timestamp for the time at which the analyzer was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The name of the analyzer.
	//
	// This member is required.
	Name *string

	// The status of the analyzer. An Active analyzer successfully monitors supported
	// resources and generates new findings. The analyzer is Disabled when a user
	// action, such as removing trusted access for Identity and Access Management
	// Access Analyzer from Organizations, causes the analyzer to stop generating new
	// findings. The status is Creating when the analyzer creation is in progress and
	// Failed when the analyzer creation has failed.
	//
	// This member is required.
	Status AnalyzerStatus

	// The type represents the zone of trust or scope for the analyzer.
	//
	// This member is required.
	Type Type

	// Specifies if the analyzer is an external access, unused access, or internal
	// access analyzer. The [GetAnalyzer]action includes this property in its response if a
	// configuration is specified, while the [ListAnalyzers]action omits it.
	//
	// [GetAnalyzer]: https://docs.aws.amazon.com/access-analyzer/latest/APIReference/API_GetAnalyzer.html
	// [ListAnalyzers]: https://docs.aws.amazon.com/access-analyzer/latest/APIReference/API_ListAnalyzers.html
	Configuration AnalyzerConfiguration

	// The resource that was most recently analyzed by the analyzer.
	LastResourceAnalyzed *string

	// The time at which the most recently analyzed resource was analyzed.
	LastResourceAnalyzedAt *time.Time

	// The statusReason provides more details about the current status of the
	// analyzer. For example, if the creation for the analyzer fails, a Failed status
	// is returned. For an analyzer with organization as the type, this failure can be
	// due to an issue with creating the service-linked roles required in the member
	// accounts of the Amazon Web Services organization.
	StatusReason *StatusReason

	// An array of key-value pairs applied to the analyzer. The key-value pairs
	// consist of the set of Unicode letters, digits, whitespace, _ , . , / , = , + ,
	// and - .
	//
	// The tag key is a value that is 1 to 128 characters in length and cannot be
	// prefixed with aws: .
	//
	// The tag value is a value that is 0 to 256 characters in length.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains information about an archive rule. Archive rules automatically archive
// new findings that meet the criteria you define when you create the rule.
type ArchiveRuleSummary struct {

	// The time at which the archive rule was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// A filter used to define the archive rule.
	//
	// This member is required.
	Filter map[string]Criterion

	// The name of the archive rule.
	//
	// This member is required.
	RuleName *string

	// The time at which the archive rule was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains information about CloudTrail access.
type CloudTrailDetails struct {

	// The ARN of the service role that IAM Access Analyzer uses to access your
	// CloudTrail trail and service last accessed information.
	//
	// This member is required.
	AccessRole *string

	// The start of the time range for which IAM Access Analyzer reviews your
	// CloudTrail events. Events with a timestamp before this time are not considered
	// to generate a policy.
	//
	// This member is required.
	StartTime *time.Time

	// A Trail object that contains settings for a trail.
	//
	// This member is required.
	Trails []Trail

	// The end of the time range for which IAM Access Analyzer reviews your CloudTrail
	// events. Events with a timestamp after this time are not considered to generate a
	// policy. If this is not included in the request, the default value is the current
	// time.
	EndTime *time.Time

	noSmithyDocumentSerde
}

// Contains information about CloudTrail access.
type CloudTrailProperties struct {

	// The end of the time range for which IAM Access Analyzer reviews your CloudTrail
	// events. Events with a timestamp after this time are not considered to generate a
	// policy. If this is not included in the request, the default value is the current
	// time.
	//
	// This member is required.
	EndTime *time.Time

	// The start of the time range for which IAM Access Analyzer reviews your
	// CloudTrail events. Events with a timestamp before this time are not considered
	// to generate a policy.
	//
	// This member is required.
	StartTime *time.Time

	// A TrailProperties object that contains settings for trail properties.
	//
	// This member is required.
	TrailProperties []TrailProperties

	noSmithyDocumentSerde
}

// Access control configuration structures for your resource. You specify the
// configuration as a type-value pair. You can specify only one type of access
// control configuration.
//
// The following types satisfy this interface:
//
//	ConfigurationMemberDynamodbStream
//	ConfigurationMemberDynamodbTable
//	ConfigurationMemberEbsSnapshot
//	ConfigurationMemberEcrRepository
//	ConfigurationMemberEfsFileSystem
//	ConfigurationMemberIamRole
//	ConfigurationMemberKmsKey
//	ConfigurationMemberRdsDbClusterSnapshot
//	ConfigurationMemberRdsDbSnapshot
//	ConfigurationMemberS3Bucket
//	ConfigurationMemberS3ExpressDirectoryBucket
//	ConfigurationMemberSecretsManagerSecret
//	ConfigurationMemberSnsTopic
//	ConfigurationMemberSqsQueue
type Configuration interface {
	isConfiguration()
}

// The access control configuration is for a DynamoDB stream.
type ConfigurationMemberDynamodbStream struct {
	Value DynamodbStreamConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberDynamodbStream) isConfiguration() {}

// The access control configuration is for a DynamoDB table or index.
type ConfigurationMemberDynamodbTable struct {
	Value DynamodbTableConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberDynamodbTable) isConfiguration() {}

// The access control configuration is for an Amazon EBS volume snapshot.
type ConfigurationMemberEbsSnapshot struct {
	Value EbsSnapshotConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberEbsSnapshot) isConfiguration() {}

// The access control configuration is for an Amazon ECR repository.
type ConfigurationMemberEcrRepository struct {
	Value EcrRepositoryConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberEcrRepository) isConfiguration() {}

// The access control configuration is for an Amazon EFS file system.
type ConfigurationMemberEfsFileSystem struct {
	Value EfsFileSystemConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberEfsFileSystem) isConfiguration() {}

// The access control configuration is for an IAM role.
type ConfigurationMemberIamRole struct {
	Value IamRoleConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberIamRole) isConfiguration() {}

// The access control configuration is for a KMS key.
type ConfigurationMemberKmsKey struct {
	Value KmsKeyConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberKmsKey) isConfiguration() {}

// The access control configuration is for an Amazon RDS DB cluster snapshot.
type ConfigurationMemberRdsDbClusterSnapshot struct {
	Value RdsDbClusterSnapshotConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberRdsDbClusterSnapshot) isConfiguration() {}

// The access control configuration is for an Amazon RDS DB snapshot.
type ConfigurationMemberRdsDbSnapshot struct {
	Value RdsDbSnapshotConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberRdsDbSnapshot) isConfiguration() {}

// The access control configuration is for an Amazon S3 bucket.
type ConfigurationMemberS3Bucket struct {
	Value S3BucketConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberS3Bucket) isConfiguration() {}

// The access control configuration is for an Amazon S3 directory bucket.
type ConfigurationMemberS3ExpressDirectoryBucket struct {
	Value S3ExpressDirectoryBucketConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberS3ExpressDirectoryBucket) isConfiguration() {}

// The access control configuration is for a Secrets Manager secret.
type ConfigurationMemberSecretsManagerSecret struct {
	Value SecretsManagerSecretConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberSecretsManagerSecret) isConfiguration() {}

// The access control configuration is for an Amazon SNS topic
type ConfigurationMemberSnsTopic struct {
	Value SnsTopicConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberSnsTopic) isConfiguration() {}

// The access control configuration is for an Amazon SQS queue.
type ConfigurationMemberSqsQueue struct {
	Value SqsQueueConfiguration

	noSmithyDocumentSerde
}

func (*ConfigurationMemberSqsQueue) isConfiguration() {}

// The criteria to use in the filter that defines the archive rule. For more
// information on available filter keys, see [IAM Access Analyzer filter keys].
//
// [IAM Access Analyzer filter keys]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html
type Criterion struct {

	// A "contains" operator to match for the filter used to create the rule.
	Contains []string

	// An "equals" operator to match for the filter used to create the rule.
	Eq []string

	// An "exists" operator to match for the filter used to create the rule.
	Exists *bool

	// A "not equals" operator to match for the filter used to create the rule.
	Neq []string

	noSmithyDocumentSerde
}

// The proposed access control configuration for a DynamoDB stream. You can
// propose a configuration for a new DynamoDB stream or an existing DynamoDB stream
// that you own by specifying the policy for the DynamoDB stream. For more
// information, see [PutResourcePolicy].
//
//   - If the configuration is for an existing DynamoDB stream and you do not
//     specify the DynamoDB policy, then the access preview uses the existing DynamoDB
//     policy for the stream.
//
//   - If the access preview is for a new resource and you do not specify the
//     policy, then the access preview assumes a DynamoDB stream without a policy.
//
//   - To propose deletion of an existing DynamoDB stream policy, you can specify
//     an empty string for the DynamoDB policy.
//
// [PutResourcePolicy]: https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutResourcePolicy.html
type DynamodbStreamConfiguration struct {

	// The proposed resource policy defining who can access or manage the DynamoDB
	// stream.
	StreamPolicy *string

	noSmithyDocumentSerde
}

// The proposed access control configuration for a DynamoDB table or index. You
// can propose a configuration for a new DynamoDB table or index or an existing
// DynamoDB table or index that you own by specifying the policy for the DynamoDB
// table or index. For more information, see [PutResourcePolicy].
//
//   - If the configuration is for an existing DynamoDB table or index and you do
//     not specify the DynamoDB policy, then the access preview uses the existing
//     DynamoDB policy for the table or index.
//
//   - If the access preview is for a new resource and you do not specify the
//     policy, then the access preview assumes a DynamoDB table without a policy.
//
//   - To propose deletion of an existing DynamoDB table or index policy, you can
//     specify an empty string for the DynamoDB policy.
//
// [PutResourcePolicy]: https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutResourcePolicy.html
type DynamodbTableConfiguration struct {

	// The proposed resource policy defining who can access or manage the DynamoDB
	// table.
	TablePolicy *string

	noSmithyDocumentSerde
}

// The proposed access control configuration for an Amazon EBS volume snapshot.
// You can propose a configuration for a new Amazon EBS volume snapshot or an
// Amazon EBS volume snapshot that you own by specifying the user IDs, groups, and
// optional KMS encryption key. For more information, see [ModifySnapshotAttribute].
//
// [ModifySnapshotAttribute]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySnapshotAttribute.html
type EbsSnapshotConfiguration struct {

	// The groups that have access to the Amazon EBS volume snapshot. If the value all
	// is specified, then the Amazon EBS volume snapshot is public.
	//
	//   - If the configuration is for an existing Amazon EBS volume snapshot and you
	//   do not specify the groups , then the access preview uses the existing shared
	//   groups for the snapshot.
	//
	//   - If the access preview is for a new resource and you do not specify the
	//   groups , then the access preview considers the snapshot without any groups .
	//
	//   - To propose deletion of existing shared groups , you can specify an empty
	//   list for groups .
	Groups []string

	// The KMS key identifier for an encrypted Amazon EBS volume snapshot. The KMS key
	// identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
	//
	//   - If the configuration is for an existing Amazon EBS volume snapshot and you
	//   do not specify the kmsKeyId , or you specify an empty string, then the access
	//   preview uses the existing kmsKeyId of the snapshot.
	//
	//   - If the access preview is for a new resource and you do not specify the
	//   kmsKeyId , the access preview considers the snapshot as unencrypted.
	KmsKeyId *string

	// The IDs of the Amazon Web Services accounts that have access to the Amazon EBS
	// volume snapshot.
	//
	//   - If the configuration is for an existing Amazon EBS volume snapshot and you
	//   do not specify the userIds , then the access preview uses the existing shared
	//   userIds for the snapshot.
	//
	//   - If the access preview is for a new resource and you do not specify the
	//   userIds , then the access preview considers the snapshot without any userIds .
	//
	//   - To propose deletion of existing shared accountIds , you can specify an empty
	//   list for userIds .
	UserIds []string

	noSmithyDocumentSerde
}

// The proposed access control configuration for an Amazon ECR repository. You can
// propose a configuration for a new Amazon ECR repository or an existing Amazon
// ECR repository that you own by specifying the Amazon ECR policy. For more
// information, see [Repository].
//
//   - If the configuration is for an existing Amazon ECR repository and you do
//     not specify the Amazon ECR policy, then the access preview uses the existing
//     Amazon ECR policy for the repository.
//
//   - If the access preview is for a new resource and you do not specify the
//     policy, then the access preview assumes an Amazon ECR repository without a
//     policy.
//
//   - To propose deletion of an existing Amazon ECR repository policy, you can
//     specify an empty string for the Amazon ECR policy.
//
// [Repository]: https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_Repository.html
type EcrRepositoryConfiguration struct {

	// The JSON repository policy text to apply to the Amazon ECR repository. For more
	// information, see [Private repository policy examples]in the Amazon ECR User Guide.
	//
	// [Private repository policy examples]: https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html
	RepositoryPolicy *string

	noSmithyDocumentSerde
}

// The proposed access control configuration for an Amazon EFS file system. You
// can propose a configuration for a new Amazon EFS file system or an existing
// Amazon EFS file system that you own by specifying the Amazon EFS policy. For
// more information, see [Using file systems in Amazon EFS].
//
//   - If the configuration is for an existing Amazon EFS file system and you do
//     not specify the Amazon EFS policy, then the access preview uses the existing
//     Amazon EFS policy for the file system.
//
//   - If the access preview is for a new resource and you do not specify the
//     policy, then the access preview assumes an Amazon EFS file system without a
//     policy.
//
//   - To propose deletion of an existing Amazon EFS file system policy, you can
//     specify an empty string for the Amazon EFS policy.
//
// [Using file systems in Amazon EFS]: https://docs.aws.amazon.com/efs/latest/ug/using-fs.html
type EfsFileSystemConfiguration struct {

	// The JSON policy definition to apply to the Amazon EFS file system. For more
	// information on the elements that make up a file system policy, see [Amazon EFS Resource-based policies].
	//
	// [Amazon EFS Resource-based policies]: https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies
	FileSystemPolicy *string

	noSmithyDocumentSerde
}

// Contains information about an external access finding.
type ExternalAccessDetails struct {

	// The condition in the analyzed policy statement that resulted in an external
	// access finding.
	//
	// This member is required.
	Condition map[string]string

	// The action in the analyzed policy statement that an external principal has
	// permission to use.
	Action []string

	// Specifies whether the external access finding is public.
	IsPublic *bool

	// The external principal that has access to a resource within the zone of trust.
	Principal map[string]string

	// The type of restriction applied to the finding by the resource owner with an
	// Organizations resource control policy (RCP).
	//
	//   - APPLICABLE : There is an RCP present in the organization but IAM Access
	//   Analyzer does not include it in the evaluation of effective permissions. For
	//   example, if s3:DeleteObject is blocked by the RCP and the restriction is
	//   APPLICABLE , then s3:DeleteObject would still be included in the list of
	//   actions for the finding.
	//
	//   - FAILED_TO_EVALUATE_RCP : There was an error evaluating the RCP.
	//
	//   - NOT_APPLICABLE : There was no RCP present in the organization, or there was
	//   no RCP applicable to the resource. For example, the resource being analyzed is
	//   an Amazon RDS snapshot and there is an RCP in the organization, but the RCP only
	//   impacts Amazon S3 buckets.
	//
	//   - APPLIED : This restriction is not currently available for external access
	//   findings.
	ResourceControlPolicyRestriction ResourceControlPolicyRestriction

	// The sources of the external access finding. This indicates how the access that
	// generated the finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []FindingSource

	noSmithyDocumentSerde
}

// Provides aggregate statistics about the findings for the specified external
// access analyzer.
type ExternalAccessFindingsStatistics struct {

	// The total number of active cross-account and public findings for each resource
	// type of the specified external access analyzer.
	ResourceTypeStatistics map[string]ResourceTypeDetails

	// The number of active findings for the specified external access analyzer.
	TotalActiveFindings *int32

	// The number of archived findings for the specified external access analyzer.
	TotalArchivedFindings *int32

	// The number of resolved findings for the specified external access analyzer.
	TotalResolvedFindings *int32

	noSmithyDocumentSerde
}

// Contains information about a finding.
type Finding struct {

	// The time at which the resource was analyzed.
	//
	// This member is required.
	AnalyzedAt *time.Time

	// The condition in the analyzed policy statement that resulted in a finding.
	//
	// This member is required.
	Condition map[string]string

	// The time at which the finding was generated.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the finding.
	//
	// This member is required.
	Id *string

	// The Amazon Web Services account ID that owns the resource.
	//
	// This member is required.
	ResourceOwnerAccount *string

	// The type of the resource identified in the finding.
	//
	// This member is required.
	ResourceType ResourceType

	// The current status of the finding.
	//
	// This member is required.
	Status FindingStatus

	// The time at which the finding was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The action in the analyzed policy statement that an external principal has
	// permission to use.
	Action []string

	// An error.
	Error *string

	// Indicates whether the policy that generated the finding allows public access to
	// the resource.
	IsPublic *bool

	// The external principal that has access to a resource within the zone of trust.
	Principal map[string]string

	// The resource that an external principal has access to.
	Resource *string

	// The type of restriction applied to the finding by the resource owner with an
	// Organizations resource control policy (RCP).
	ResourceControlPolicyRestriction ResourceControlPolicyRestriction

	// The sources of the finding. This indicates how the access that generated the
	// finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []FindingSource

	noSmithyDocumentSerde
}

// Contains information about the findings for an Amazon Web Services account in
// an organization unused access analyzer.
type FindingAggregationAccountDetails struct {

	// The ID of the Amazon Web Services account for which unused access finding
	// details are provided.
	Account *string

	// Provides the number of active findings for each type of unused access for the
	// specified Amazon Web Services account.
	Details map[string]int32

	// The number of active unused access findings for the specified Amazon Web
	// Services account.
	NumberOfActiveFindings *int32

	noSmithyDocumentSerde
}

// Contains information about an external access or unused access finding. Only
// one parameter can be used in a FindingDetails object.
//
// The following types satisfy this interface:
//
//	FindingDetailsMemberExternalAccessDetails
//	FindingDetailsMemberInternalAccessDetails
//	FindingDetailsMemberUnusedIamRoleDetails
//	FindingDetailsMemberUnusedIamUserAccessKeyDetails
//	FindingDetailsMemberUnusedIamUserPasswordDetails
//	FindingDetailsMemberUnusedPermissionDetails
type FindingDetails interface {
	isFindingDetails()
}

// The details for an external access analyzer finding.
type FindingDetailsMemberExternalAccessDetails struct {
	Value ExternalAccessDetails

	noSmithyDocumentSerde
}

func (*FindingDetailsMemberExternalAccessDetails) isFindingDetails() {}

// The details for an internal access analyzer finding. This contains information
// about access patterns identified within your Amazon Web Services organization or
// account.
type FindingDetailsMemberInternalAccessDetails struct {
	Value InternalAccessDetails

	noSmithyDocumentSerde
}

func (*FindingDetailsMemberInternalAccessDetails) isFindingDetails() {}

// The details for an unused access analyzer finding with an unused IAM role
// finding type.
type FindingDetailsMemberUnusedIamRoleDetails struct {
	Value UnusedIamRoleDetails

	noSmithyDocumentSerde
}

func (*FindingDetailsMemberUnusedIamRoleDetails) isFindingDetails() {}

// The details for an unused access analyzer finding with an unused IAM user
// access key finding type.
type FindingDetailsMemberUnusedIamUserAccessKeyDetails struct {
	Value UnusedIamUserAccessKeyDetails

	noSmithyDocumentSerde
}

func (*FindingDetailsMemberUnusedIamUserAccessKeyDetails) isFindingDetails() {}

// The details for an unused access analyzer finding with an unused IAM user
// password finding type.
type FindingDetailsMemberUnusedIamUserPasswordDetails struct {
	Value UnusedIamUserPasswordDetails

	noSmithyDocumentSerde
}

func (*FindingDetailsMemberUnusedIamUserPasswordDetails) isFindingDetails() {}

// The details for an unused access analyzer finding with an unused permission
// finding type.
type FindingDetailsMemberUnusedPermissionDetails struct {
	Value UnusedPermissionDetails

	noSmithyDocumentSerde
}

func (*FindingDetailsMemberUnusedPermissionDetails) isFindingDetails() {}

// The source of the finding. This indicates how the access that generated the
// finding is granted. It is populated for Amazon S3 bucket findings.
type FindingSource struct {

	// Indicates the type of access that generated the finding.
	//
	// This member is required.
	Type FindingSourceType

	// Includes details about how the access that generated the finding is granted.
	// This is populated for Amazon S3 bucket findings.
	Detail *FindingSourceDetail

	noSmithyDocumentSerde
}

// Includes details about how the access that generated the finding is granted.
// This is populated for Amazon S3 bucket findings.
type FindingSourceDetail struct {

	// The account of the cross-account access point that generated the finding.
	AccessPointAccount *string

	// The ARN of the access point that generated the finding. The ARN format depends
	// on whether the ARN represents an access point or a multi-region access point.
	AccessPointArn *string

	noSmithyDocumentSerde
}

// Contains information about the aggregate statistics for an external or unused
// access analyzer. Only one parameter can be used in a FindingsStatistics object.
//
// The following types satisfy this interface:
//
//	FindingsStatisticsMemberExternalAccessFindingsStatistics
//	FindingsStatisticsMemberInternalAccessFindingsStatistics
//	FindingsStatisticsMemberUnusedAccessFindingsStatistics
type FindingsStatistics interface {
	isFindingsStatistics()
}

// The aggregate statistics for an external access analyzer.
type FindingsStatisticsMemberExternalAccessFindingsStatistics struct {
	Value ExternalAccessFindingsStatistics

	noSmithyDocumentSerde
}

func (*FindingsStatisticsMemberExternalAccessFindingsStatistics) isFindingsStatistics() {}

// The aggregate statistics for an internal access analyzer. This includes
// information about active, archived, and resolved findings related to internal
// access within your Amazon Web Services organization or account.
type FindingsStatisticsMemberInternalAccessFindingsStatistics struct {
	Value InternalAccessFindingsStatistics

	noSmithyDocumentSerde
}

func (*FindingsStatisticsMemberInternalAccessFindingsStatistics) isFindingsStatistics() {}

// The aggregate statistics for an unused access analyzer.
type FindingsStatisticsMemberUnusedAccessFindingsStatistics struct {
	Value UnusedAccessFindingsStatistics

	noSmithyDocumentSerde
}

func (*FindingsStatisticsMemberUnusedAccessFindingsStatistics) isFindingsStatistics() {}

// Contains information about a finding.
type FindingSummary struct {

	// The time at which the resource-based policy that generated the finding was
	// analyzed.
	//
	// This member is required.
	AnalyzedAt *time.Time

	// The condition in the analyzed policy statement that resulted in a finding.
	//
	// This member is required.
	Condition map[string]string

	// The time at which the finding was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the finding.
	//
	// This member is required.
	Id *string

	// The Amazon Web Services account ID that owns the resource.
	//
	// This member is required.
	ResourceOwnerAccount *string

	// The type of the resource that the external principal has access to.
	//
	// This member is required.
	ResourceType ResourceType

	// The status of the finding.
	//
	// This member is required.
	Status FindingStatus

	// The time at which the finding was most recently updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The action in the analyzed policy statement that an external principal has
	// permission to use.
	Action []string

	// The error that resulted in an Error finding.
	Error *string

	// Indicates whether the finding reports a resource that has a policy that allows
	// public access.
	IsPublic *bool

	// The external principal that has access to a resource within the zone of trust.
	Principal map[string]string

	// The resource that the external principal has access to.
	Resource *string

	// The type of restriction applied to the finding by the resource owner with an
	// Organizations resource control policy (RCP).
	ResourceControlPolicyRestriction ResourceControlPolicyRestriction

	// The sources of the finding. This indicates how the access that generated the
	// finding is granted. It is populated for Amazon S3 bucket findings.
	Sources []FindingSource

	noSmithyDocumentSerde
}

// Contains information about a finding.
type FindingSummaryV2 struct {

	// The time at which the resource-based policy or IAM entity that generated the
	// finding was analyzed.
	//
	// This member is required.
	AnalyzedAt *time.Time

	// The time at which the finding was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the finding.
	//
	// This member is required.
	Id *string

	// The Amazon Web Services account ID that owns the resource.
	//
	// This member is required.
	ResourceOwnerAccount *string

	// The type of the resource that the external principal has access to.
	//
	// This member is required.
	ResourceType ResourceType

	// The status of the finding.
	//
	// This member is required.
	Status FindingStatus

	// The time at which the finding was most recently updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The error that resulted in an Error finding.
	Error *string

	// The type of the access finding. For external access analyzers, the type is
	// ExternalAccess . For unused access analyzers, the type can be UnusedIAMRole ,
	// UnusedIAMUserAccessKey , UnusedIAMUserPassword , or UnusedPermission . For
	// internal access analyzers, the type is InternalAccess .
	FindingType FindingType

	// The resource that the external principal has access to.
	Resource *string

	noSmithyDocumentSerde
}

// Contains the text for the generated policy.
type GeneratedPolicy struct {

	// The text to use as the content for the new policy. The policy is created using
	// the [CreatePolicy]action.
	//
	// [CreatePolicy]: https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html
	//
	// This member is required.
	Policy *string

	noSmithyDocumentSerde
}

// Contains the generated policy details.
type GeneratedPolicyProperties struct {

	// The ARN of the IAM entity (user or role) for which you are generating a policy.
	//
	// This member is required.
	PrincipalArn *string

	// Lists details about the Trail used to generated policy.
	CloudTrailProperties *CloudTrailProperties

	// This value is set to true if the generated policy contains all possible actions
	// for a service that IAM Access Analyzer identified from the CloudTrail trail that
	// you specified, and false otherwise.
	IsComplete *bool

	noSmithyDocumentSerde
}

// Contains the text for the generated policy and its details.
type GeneratedPolicyResult struct {

	// A GeneratedPolicyProperties object that contains properties of the generated
	// policy.
	//
	// This member is required.
	Properties *GeneratedPolicyProperties

	// The text to use as the content for the new policy. The policy is created using
	// the [CreatePolicy]action.
	//
	// [CreatePolicy]: https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html
	GeneratedPolicies []GeneratedPolicy

	noSmithyDocumentSerde
}

// The proposed access control configuration for an IAM role. You can propose a
// configuration for a new IAM role or an existing IAM role that you own by
// specifying the trust policy. If the configuration is for a new IAM role, you
// must specify the trust policy. If the configuration is for an existing IAM role
// that you own and you do not propose the trust policy, the access preview uses
// the existing trust policy for the role. The proposed trust policy cannot be an
// empty string. For more information about role trust policy limits, see [IAM and STS quotas].
//
// [IAM and STS quotas]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html
type IamRoleConfiguration struct {

	// The proposed trust policy for the IAM role.
	TrustPolicy *string

	noSmithyDocumentSerde
}

// An criterion statement in an archive rule. Each archive rule may have multiple
// criteria.
type InlineArchiveRule struct {

	// The condition and values for a criterion.
	//
	// This member is required.
	Filter map[string]Criterion

	// The name of the rule.
	//
	// This member is required.
	RuleName *string

	noSmithyDocumentSerde
}

// Contains information about analysis rules for the internal access analyzer.
// Analysis rules determine which entities will generate findings based on the
// criteria you define when you create the rule.
type InternalAccessAnalysisRule struct {

	// A list of rules for the internal access analyzer containing criteria to include
	// in analysis. Only resources that meet the rule criteria will generate findings.
	Inclusions []InternalAccessAnalysisRuleCriteria

	noSmithyDocumentSerde
}

// The criteria for an analysis rule for an internal access analyzer.
type InternalAccessAnalysisRuleCriteria struct {

	// A list of Amazon Web Services account IDs to apply to the internal access
	// analysis rule criteria. Account IDs can only be applied to the analysis rule
	// criteria for organization-level analyzers.
	AccountIds []string

	// A list of resource ARNs to apply to the internal access analysis rule criteria.
	// The analyzer will only generate findings for resources that match these ARNs.
	ResourceArns []string

	// A list of resource types to apply to the internal access analysis rule
	// criteria. The analyzer will only generate findings for resources of these types.
	// These resource types are currently supported for internal access analyzers:
	//
	//   - AWS::S3::Bucket
	//
	//   - AWS::RDS::DBSnapshot
	//
	//   - AWS::RDS::DBClusterSnapshot
	//
	//   - AWS::S3Express::DirectoryBucket
	//
	//   - AWS::DynamoDB::Table
	//
	//   - AWS::DynamoDB::Stream
	ResourceTypes []ResourceType

	noSmithyDocumentSerde
}

// Specifies the configuration of an internal access analyzer for an Amazon Web
// Services organization or account. This configuration determines how the analyzer
// evaluates internal access within your Amazon Web Services environment.
type InternalAccessConfiguration struct {

	// Contains information about analysis rules for the internal access analyzer.
	// These rules determine which resources and access patterns will be analyzed.
	AnalysisRule *InternalAccessAnalysisRule

	noSmithyDocumentSerde
}

// Contains information about an internal access finding. This includes details
// about the access that was identified within your Amazon Web Services
// organization or account.
type InternalAccessDetails struct {

	// The type of internal access identified in the finding. This indicates how the
	// access is granted within your Amazon Web Services environment.
	AccessType InternalAccessType

	// The action in the analyzed policy statement that has internal access permission
	// to use.
	Action []string

	// The condition in the analyzed policy statement that resulted in an internal
	// access finding.
	Condition map[string]string

	// The principal that has access to a resource within the internal environment.
	Principal map[string]string

	// The Amazon Web Services account ID that owns the principal identified in the
	// internal access finding.
	PrincipalOwnerAccount *string

	// The type of principal identified in the internal access finding, such as IAM
	// role or IAM user.
	PrincipalType PrincipalType

	// The type of restriction applied to the finding by the resource owner with an
	// Organizations resource control policy (RCP).
	//
	//   - APPLICABLE : There is an RCP present in the organization but IAM Access
	//   Analyzer does not include it in the evaluation of effective permissions. For
	//   example, if s3:DeleteObject is blocked by the RCP and the restriction is
	//   APPLICABLE , then s3:DeleteObject would still be included in the list of
	//   actions for the finding. Only applicable to internal access findings with the
	//   account as the zone of trust.
	//
	//   - FAILED_TO_EVALUATE_RCP : There was an error evaluating the RCP.
	//
	//   - NOT_APPLICABLE : There was no RCP present in the organization. For internal
	//   access findings with the account as the zone of trust, NOT_APPLICABLE could
	//   also indicate that there was no RCP applicable to the resource.
	//
	//   - APPLIED : An RCP is present in the organization and IAM Access Analyzer
	//   included it in the evaluation of effective permissions. For example, if
	//   s3:DeleteObject is blocked by the RCP and the restriction is APPLIED , then
	//   s3:DeleteObject would not be included in the list of actions for the finding.
	//   Only applicable to internal access findings with the organization as the zone of
	//   trust.
	ResourceControlPolicyRestriction ResourceControlPolicyRestriction

	// The type of restriction applied to the finding by an Organizations service
	// control policy (SCP).
	//
	//   - APPLICABLE : There is an SCP present in the organization but IAM Access
	//   Analyzer does not include it in the evaluation of effective permissions. Only
	//   applicable to internal access findings with the account as the zone of trust.
	//
	//   - FAILED_TO_EVALUATE_SCP : There was an error evaluating the SCP.
	//
	//   - NOT_APPLICABLE : There was no SCP present in the organization. For internal
	//   access findings with the account as the zone of trust, NOT_APPLICABLE could
	//   also indicate that there was no SCP applicable to the principal.
	//
	//   - APPLIED : An SCP is present in the organization and IAM Access Analyzer
	//   included it in the evaluation of effective permissions. Only applicable to
	//   internal access findings with the organization as the zone of trust.
	ServiceControlPolicyRestriction ServiceControlPolicyRestriction

	// The sources of the internal access finding. This indicates how the access that
	// generated the finding is granted within your Amazon Web Services environment.
	Sources []FindingSource

	noSmithyDocumentSerde
}

// Provides aggregate statistics about the findings for the specified internal
// access analyzer. This includes counts of active, archived, and resolved
// findings.
type InternalAccessFindingsStatistics struct {

	// The total number of active findings for each resource type of the specified
	// internal access analyzer.
	ResourceTypeStatistics map[string]InternalAccessResourceTypeDetails

	// The number of active findings for the specified internal access analyzer.
	TotalActiveFindings *int32

	// The number of archived findings for the specified internal access analyzer.
	TotalArchivedFindings *int32

	// The number of resolved findings for the specified internal access analyzer.
	TotalResolvedFindings *int32

	noSmithyDocumentSerde
}

// Contains information about the total number of active, archived, and resolved
// findings for a resource type of an internal access analyzer.
type InternalAccessResourceTypeDetails struct {

	// The total number of active findings for the resource type in the internal
	// access analyzer.
	TotalActiveFindings *int32

	// The total number of archived findings for the resource type in the internal
	// access analyzer.
	TotalArchivedFindings *int32

	// The total number of resolved findings for the resource type in the internal
	// access analyzer.
	TotalResolvedFindings *int32

	noSmithyDocumentSerde
}

// This configuration sets the network origin for the Amazon S3 access point or
// multi-region access point to Internet .
type InternetConfiguration struct {
	noSmithyDocumentSerde
}

// Contains details about the policy generation request.
type JobDetails struct {

	// The JobId that is returned by the StartPolicyGeneration operation. The JobId
	// can be used with GetGeneratedPolicy to retrieve the generated policies or used
	// with CancelPolicyGeneration to cancel the policy generation request.
	//
	// This member is required.
	JobId *string

	// A timestamp of when the job was started.
	//
	// This member is required.
	StartedOn *time.Time

	// The status of the job request.
	//
	// This member is required.
	Status JobStatus

	// A timestamp of when the job was completed.
	CompletedOn *time.Time

	// The job error for the policy generation request.
	JobError *JobError

	noSmithyDocumentSerde
}

// Contains the details about the policy generation error.
type JobError struct {

	// The job error code.
	//
	// This member is required.
	Code JobErrorCode

	// Specific information about the error. For example, which service quota was
	// exceeded or which resource was not found.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// A proposed grant configuration for a KMS key. For more information, see [CreateGrant].
//
// [CreateGrant]: https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html
type KmsGrantConfiguration struct {

	// The principal that is given permission to perform the operations that the grant
	// permits.
	//
	// This member is required.
	GranteePrincipal *string

	//  The Amazon Web Services account under which the grant was issued. The account
	// is used to propose KMS grants issued by accounts other than the owner of the
	// key.
	//
	// This member is required.
	IssuingAccount *string

	// A list of operations that the grant permits.
	//
	// This member is required.
	Operations []KmsGrantOperation

	// Use this structure to propose allowing [cryptographic operations] in the grant only when the operation
	// request includes the specified [encryption context].
	//
	// [cryptographic operations]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations
	// [encryption context]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context
	Constraints *KmsGrantConstraints

	// The principal that is given permission to retire the grant by using [RetireGrant] operation.
	//
	// [RetireGrant]: https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html
	RetiringPrincipal *string

	noSmithyDocumentSerde
}

// Use this structure to propose allowing [cryptographic operations] in the grant only when the operation
// request includes the specified [encryption context]. You can specify only one type of encryption
// context. An empty map is treated as not specified. For more information, see [GrantConstraints].
//
// [cryptographic operations]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations
// [encryption context]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context
// [GrantConstraints]: https://docs.aws.amazon.com/kms/latest/APIReference/API_GrantConstraints.html
type KmsGrantConstraints struct {

	// A list of key-value pairs that must match the encryption context in the [cryptographic operation]
	// request. The grant allows the operation only when the encryption context in the
	// request is the same as the encryption context specified in this constraint.
	//
	// [cryptographic operation]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations
	EncryptionContextEquals map[string]string

	// A list of key-value pairs that must be included in the encryption context of
	// the [cryptographic operation]request. The grant allows the cryptographic operation only when the
	// encryption context in the request includes the key-value pairs specified in this
	// constraint, although it can include additional key-value pairs.
	//
	// [cryptographic operation]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations
	EncryptionContextSubset map[string]string

	noSmithyDocumentSerde
}

// Proposed access control configuration for a KMS key. You can propose a
// configuration for a new KMS key or an existing KMS key that you own by
// specifying the key policy and KMS grant configuration. If the configuration is
// for an existing key and you do not specify the key policy, the access preview
// uses the existing policy for the key. If the access preview is for a new
// resource and you do not specify the key policy, then the access preview uses the
// default key policy. The proposed key policy cannot be an empty string. For more
// information, see [Default key policy]. For more information about key policy limits, see [Resource quotas].
//
// [Default key policy]: https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default
// [Resource quotas]: https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html
type KmsKeyConfiguration struct {

	// A list of proposed grant configurations for the KMS key. If the proposed grant
	// configuration is for an existing key, the access preview uses the proposed list
	// of grant configurations in place of the existing grants. Otherwise, the access
	// preview uses the existing grants for the key.
	Grants []KmsGrantConfiguration

	// Resource policy configuration for the KMS key. The only valid value for the
	// name of the key policy is default . For more information, see [Default key policy].
	//
	// [Default key policy]: https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default
	KeyPolicies map[string]string

	noSmithyDocumentSerde
}

// A location in a policy that is represented as a path through the JSON
// representation and a corresponding span.
type Location struct {

	// A path in a policy, represented as a sequence of path elements.
	//
	// This member is required.
	Path []PathElement

	// A span in a policy.
	//
	// This member is required.
	Span *Span

	noSmithyDocumentSerde
}

// The proposed InternetConfiguration or VpcConfiguration to apply to the Amazon
// S3 access point. You can make the access point accessible from the internet, or
// you can specify that all requests made through that access point must originate
// from a specific virtual private cloud (VPC). You can specify only one type of
// network configuration. For more information, see [Creating access points].
//
// The following types satisfy this interface:
//
//	NetworkOriginConfigurationMemberInternetConfiguration
//	NetworkOriginConfigurationMemberVpcConfiguration
//
// [Creating access points]: https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html
type NetworkOriginConfiguration interface {
	isNetworkOriginConfiguration()
}

// The configuration for the Amazon S3 access point or multi-region access point
// with an Internet origin.
type NetworkOriginConfigurationMemberInternetConfiguration struct {
	Value InternetConfiguration

	noSmithyDocumentSerde
}

func (*NetworkOriginConfigurationMemberInternetConfiguration) isNetworkOriginConfiguration() {}

// The proposed virtual private cloud (VPC) configuration for the Amazon S3 access
// point. VPC configuration does not apply to multi-region access points. For more
// information, see [VpcConfiguration].
//
// [VpcConfiguration]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_VpcConfiguration.html
type NetworkOriginConfigurationMemberVpcConfiguration struct {
	Value VpcConfiguration

	noSmithyDocumentSerde
}

func (*NetworkOriginConfigurationMemberVpcConfiguration) isNetworkOriginConfiguration() {}

// A single element in a path through the JSON representation of a policy.
//
// The following types satisfy this interface:
//
//	PathElementMemberIndex
//	PathElementMemberKey
//	PathElementMemberSubstring
//	PathElementMemberValue
type PathElement interface {
	isPathElement()
}

// Refers to an index in a JSON array.
type PathElementMemberIndex struct {
	Value int32

	noSmithyDocumentSerde
}

func (*PathElementMemberIndex) isPathElement() {}

// Refers to a key in a JSON object.
type PathElementMemberKey struct {
	Value string

	noSmithyDocumentSerde
}

func (*PathElementMemberKey) isPathElement() {}

// Refers to a substring of a literal string in a JSON object.
type PathElementMemberSubstring struct {
	Value Substring

	noSmithyDocumentSerde
}

func (*PathElementMemberSubstring) isPathElement() {}

// Refers to the value associated with a given key in a JSON object.
type PathElementMemberValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*PathElementMemberValue) isPathElement() {}

// Contains details about the policy generation status and properties.
type PolicyGeneration struct {

	// The JobId that is returned by the StartPolicyGeneration operation. The JobId
	// can be used with GetGeneratedPolicy to retrieve the generated policies or used
	// with CancelPolicyGeneration to cancel the policy generation request.
	//
	// This member is required.
	JobId *string

	// The ARN of the IAM entity (user or role) for which you are generating a policy.
	//
	// This member is required.
	PrincipalArn *string

	// A timestamp of when the policy generation started.
	//
	// This member is required.
	StartedOn *time.Time

	// The status of the policy generation request.
	//
	// This member is required.
	Status JobStatus

	// A timestamp of when the policy generation was completed.
	CompletedOn *time.Time

	noSmithyDocumentSerde
}

// Contains the ARN details about the IAM entity for which the policy is generated.
type PolicyGenerationDetails struct {

	// The ARN of the IAM entity (user or role) for which you are generating a policy.
	//
	// This member is required.
	PrincipalArn *string

	noSmithyDocumentSerde
}

// A position in a policy.
type Position struct {

	// The column of the position, starting from 0.
	//
	// This member is required.
	Column *int32

	// The line of the position, starting from 1.
	//
	// This member is required.
	Line *int32

	// The offset within the policy that corresponds to the position, starting from 0.
	//
	// This member is required.
	Offset *int32

	noSmithyDocumentSerde
}

// The values for a manual Amazon RDS DB cluster snapshot attribute.
//
// The following types satisfy this interface:
//
//	RdsDbClusterSnapshotAttributeValueMemberAccountIds
type RdsDbClusterSnapshotAttributeValue interface {
	isRdsDbClusterSnapshotAttributeValue()
}

// The Amazon Web Services account IDs that have access to the manual Amazon RDS
// DB cluster snapshot. If the value all is specified, then the Amazon RDS DB
// cluster snapshot is public and can be copied or restored by all Amazon Web
// Services accounts.
//
//   - If the configuration is for an existing Amazon RDS DB cluster snapshot and
//     you do not specify the accountIds in RdsDbClusterSnapshotAttributeValue , then
//     the access preview uses the existing shared accountIds for the snapshot.
//
//   - If the access preview is for a new resource and you do not specify the
//     specify the accountIds in RdsDbClusterSnapshotAttributeValue , then the access
//     preview considers the snapshot without any attributes.
//
//   - To propose deletion of existing shared accountIds , you can specify an empty
//     list for accountIds in the RdsDbClusterSnapshotAttributeValue .
type RdsDbClusterSnapshotAttributeValueMemberAccountIds struct {
	Value []string

	noSmithyDocumentSerde
}

func (*RdsDbClusterSnapshotAttributeValueMemberAccountIds) isRdsDbClusterSnapshotAttributeValue() {}

// The proposed access control configuration for an Amazon RDS DB cluster
// snapshot. You can propose a configuration for a new Amazon RDS DB cluster
// snapshot or an Amazon RDS DB cluster snapshot that you own by specifying the
// RdsDbClusterSnapshotAttributeValue and optional KMS encryption key. For more
// information, see [ModifyDBClusterSnapshotAttribute].
//
// [ModifyDBClusterSnapshotAttribute]: https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBClusterSnapshotAttribute.html
type RdsDbClusterSnapshotConfiguration struct {

	// The names and values of manual DB cluster snapshot attributes. Manual DB
	// cluster snapshot attributes are used to authorize other Amazon Web Services
	// accounts to restore a manual DB cluster snapshot. The only valid value for
	// AttributeName for the attribute map is restore
	Attributes map[string]RdsDbClusterSnapshotAttributeValue

	// The KMS key identifier for an encrypted Amazon RDS DB cluster snapshot. The KMS
	// key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
	//
	//   - If the configuration is for an existing Amazon RDS DB cluster snapshot and
	//   you do not specify the kmsKeyId , or you specify an empty string, then the
	//   access preview uses the existing kmsKeyId of the snapshot.
	//
	//   - If the access preview is for a new resource and you do not specify the
	//   specify the kmsKeyId , then the access preview considers the snapshot as
	//   unencrypted.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// The name and values of a manual Amazon RDS DB snapshot attribute. Manual DB
// snapshot attributes are used to authorize other Amazon Web Services accounts to
// restore a manual DB snapshot.
//
// The following types satisfy this interface:
//
//	RdsDbSnapshotAttributeValueMemberAccountIds
type RdsDbSnapshotAttributeValue interface {
	isRdsDbSnapshotAttributeValue()
}

// The Amazon Web Services account IDs that have access to the manual Amazon RDS
// DB snapshot. If the value all is specified, then the Amazon RDS DB snapshot is
// public and can be copied or restored by all Amazon Web Services accounts.
//
//   - If the configuration is for an existing Amazon RDS DB snapshot and you do
//     not specify the accountIds in RdsDbSnapshotAttributeValue , then the access
//     preview uses the existing shared accountIds for the snapshot.
//
//   - If the access preview is for a new resource and you do not specify the
//     specify the accountIds in RdsDbSnapshotAttributeValue , then the access
//     preview considers the snapshot without any attributes.
//
//   - To propose deletion of an existing shared accountIds , you can specify an
//     empty list for accountIds in the RdsDbSnapshotAttributeValue .
type RdsDbSnapshotAttributeValueMemberAccountIds struct {
	Value []string

	noSmithyDocumentSerde
}

func (*RdsDbSnapshotAttributeValueMemberAccountIds) isRdsDbSnapshotAttributeValue() {}

// The proposed access control configuration for an Amazon RDS DB snapshot. You
// can propose a configuration for a new Amazon RDS DB snapshot or an Amazon RDS DB
// snapshot that you own by specifying the RdsDbSnapshotAttributeValue and
// optional KMS encryption key. For more information, see [ModifyDBSnapshotAttribute].
//
// [ModifyDBSnapshotAttribute]: https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_ModifyDBSnapshotAttribute.html
type RdsDbSnapshotConfiguration struct {

	// The names and values of manual DB snapshot attributes. Manual DB snapshot
	// attributes are used to authorize other Amazon Web Services accounts to restore a
	// manual DB snapshot. The only valid value for attributeName for the attribute
	// map is restore.
	Attributes map[string]RdsDbSnapshotAttributeValue

	// The KMS key identifier for an encrypted Amazon RDS DB snapshot. The KMS key
	// identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
	//
	//   - If the configuration is for an existing Amazon RDS DB snapshot and you do
	//   not specify the kmsKeyId , or you specify an empty string, then the access
	//   preview uses the existing kmsKeyId of the snapshot.
	//
	//   - If the access preview is for a new resource and you do not specify the
	//   specify the kmsKeyId , then the access preview considers the snapshot as
	//   unencrypted.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Contains information about the reasoning why a check for access passed or
// failed.
type ReasonSummary struct {

	// A description of the reasoning of a result of checking for access.
	Description *string

	// The identifier for the reason statement.
	StatementId *string

	// The index number of the reason statement.
	StatementIndex *int32

	noSmithyDocumentSerde
}

// Contains information about the reason that the retrieval of a recommendation
// for a finding failed.
type RecommendationError struct {

	// The error code for a failed retrieval of a recommendation for a finding.
	//
	// This member is required.
	Code *string

	// The error message for a failed retrieval of a recommendation for a finding.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Contains information about a recommended step for an unused access analyzer
// finding.
//
// The following types satisfy this interface:
//
//	RecommendedStepMemberUnusedPermissionsRecommendedStep
type RecommendedStep interface {
	isRecommendedStep()
}

// A recommended step for an unused permissions finding.
type RecommendedStepMemberUnusedPermissionsRecommendedStep struct {
	Value UnusedPermissionsRecommendedStep

	noSmithyDocumentSerde
}

func (*RecommendedStepMemberUnusedPermissionsRecommendedStep) isRecommendedStep() {}

// Contains information about the total number of active cross-account and public
// findings for a resource type of an external access analyzer.
type ResourceTypeDetails struct {

	// The total number of active cross-account findings for the resource type.
	TotalActiveCrossAccount *int32

	// The total number of active errors for the resource type.
	TotalActiveErrors *int32

	// The total number of active public findings for the resource type.
	TotalActivePublic *int32

	noSmithyDocumentSerde
}

// The configuration for an Amazon S3 access point or multi-region access point
// for the bucket. You can propose up to 10 access points or multi-region access
// points per bucket. If the proposed Amazon S3 access point configuration is for
// an existing bucket, the access preview uses the proposed access point
// configuration in place of the existing access points. To propose an access point
// without a policy, you can provide an empty string as the access point policy.
// For more information, see [Creating access points]. For more information about access point policy
// limits, see [Access points restrictions and limitations].
//
// [Access points restrictions and limitations]: https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points-restrictions-limitations.html
// [Creating access points]: https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html
type S3AccessPointConfiguration struct {

	// The access point or multi-region access point policy.
	AccessPointPolicy *string

	// The proposed Internet and VpcConfiguration to apply to this Amazon S3 access
	// point. VpcConfiguration does not apply to multi-region access points. If the
	// access preview is for a new resource and neither is specified, the access
	// preview uses Internet for the network origin. If the access preview is for an
	// existing resource and neither is specified, the access preview uses the existing
	// network origin.
	NetworkOrigin NetworkOriginConfiguration

	// The proposed S3PublicAccessBlock configuration to apply to this Amazon S3
	// access point or multi-region access point.
	PublicAccessBlock *S3PublicAccessBlockConfiguration

	noSmithyDocumentSerde
}

// A proposed access control list grant configuration for an Amazon S3 bucket. For
// more information, see [How to Specify an ACL].
//
// [How to Specify an ACL]: https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#setting-acls
type S3BucketAclGrantConfiguration struct {

	// The grantee to whom you’re assigning access rights.
	//
	// This member is required.
	Grantee AclGrantee

	// The permissions being granted.
	//
	// This member is required.
	Permission AclPermission

	noSmithyDocumentSerde
}

// Proposed access control configuration for an Amazon S3 bucket. You can propose
// a configuration for a new Amazon S3 bucket or an existing Amazon S3 bucket that
// you own by specifying the Amazon S3 bucket policy, bucket ACLs, bucket BPA
// settings, Amazon S3 access points, and multi-region access points attached to
// the bucket. If the configuration is for an existing Amazon S3 bucket and you do
// not specify the Amazon S3 bucket policy, the access preview uses the existing
// policy attached to the bucket. If the access preview is for a new resource and
// you do not specify the Amazon S3 bucket policy, the access preview assumes a
// bucket without a policy. To propose deletion of an existing bucket policy, you
// can specify an empty string. For more information about bucket policy limits,
// see [Bucket Policy Examples].
//
// [Bucket Policy Examples]: https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html
type S3BucketConfiguration struct {

	// The configuration of Amazon S3 access points or multi-region access points for
	// the bucket. You can propose up to 10 new access points per bucket.
	AccessPoints map[string]S3AccessPointConfiguration

	// The proposed list of ACL grants for the Amazon S3 bucket. You can propose up to
	// 100 ACL grants per bucket. If the proposed grant configuration is for an
	// existing bucket, the access preview uses the proposed list of grant
	// configurations in place of the existing grants. Otherwise, the access preview
	// uses the existing grants for the bucket.
	BucketAclGrants []S3BucketAclGrantConfiguration

	// The proposed bucket policy for the Amazon S3 bucket.
	BucketPolicy *string

	// The proposed block public access configuration for the Amazon S3 bucket.
	BucketPublicAccessBlock *S3PublicAccessBlockConfiguration

	noSmithyDocumentSerde
}

// Proposed configuration for an access point attached to an Amazon S3 directory
// bucket. You can propose up to 10 access points per bucket. If the proposed
// access point configuration is for an existing Amazon S3 directory bucket, the
// access preview uses the proposed access point configuration in place of the
// existing access points. To propose an access point without a policy, you can
// provide an empty string as the access point policy. For more information about
// access points for Amazon S3 directory buckets, see [Managing access to directory buckets with access points]in the Amazon Simple Storage
// Service User Guide.
//
// [Managing access to directory buckets with access points]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-directory-buckets.html
type S3ExpressDirectoryAccessPointConfiguration struct {

	// The proposed access point policy for an Amazon S3 directory bucket access point.
	AccessPointPolicy *string

	// The proposed InternetConfiguration or VpcConfiguration to apply to the Amazon
	// S3 access point. You can make the access point accessible from the internet, or
	// you can specify that all requests made through that access point must originate
	// from a specific virtual private cloud (VPC). You can specify only one type of
	// network configuration. For more information, see [Creating access points].
	//
	// [Creating access points]: https://docs.aws.amazon.com/AmazonS3/latest/dev/creating-access-points.html
	NetworkOrigin NetworkOriginConfiguration

	noSmithyDocumentSerde
}

// Proposed access control configuration for an Amazon S3 directory bucket. You
// can propose a configuration for a new Amazon S3 directory bucket or an existing
// Amazon S3 directory bucket that you own by specifying the Amazon S3 bucket
// policy. If the configuration is for an existing Amazon S3 directory bucket and
// you do not specify the Amazon S3 bucket policy, the access preview uses the
// existing policy attached to the directory bucket. If the access preview is for a
// new resource and you do not specify the Amazon S3 bucket policy, the access
// preview assumes an directory bucket without a policy. To propose deletion of an
// existing bucket policy, you can specify an empty string. For more information
// about Amazon S3 directory bucket policies, see [Example bucket policies for directory buckets]in the Amazon Simple Storage
// Service User Guide.
//
// [Example bucket policies for directory buckets]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-security-iam-example-bucket-policies.html
type S3ExpressDirectoryBucketConfiguration struct {

	// The proposed access points for the Amazon S3 directory bucket.
	AccessPoints map[string]S3ExpressDirectoryAccessPointConfiguration

	// The proposed bucket policy for the Amazon S3 directory bucket.
	BucketPolicy *string

	noSmithyDocumentSerde
}

// The PublicAccessBlock configuration to apply to this Amazon S3 bucket. If the
// proposed configuration is for an existing Amazon S3 bucket and the configuration
// is not specified, the access preview uses the existing setting. If the proposed
// configuration is for a new bucket and the configuration is not specified, the
// access preview uses false . If the proposed configuration is for a new access
// point or multi-region access point and the access point BPA configuration is not
// specified, the access preview uses true . For more information, see [PublicAccessBlockConfiguration].
//
// [PublicAccessBlockConfiguration]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-bucket-publicaccessblockconfiguration.html
type S3PublicAccessBlockConfiguration struct {

	//  Specifies whether Amazon S3 should ignore public ACLs for this bucket and
	// objects in this bucket.
	//
	// This member is required.
	IgnorePublicAcls *bool

	//  Specifies whether Amazon S3 should restrict public bucket policies for this
	// bucket.
	//
	// This member is required.
	RestrictPublicBuckets *bool

	noSmithyDocumentSerde
}

// The configuration for a Secrets Manager secret. For more information, see [CreateSecret].
//
// You can propose a configuration for a new secret or an existing secret that you
// own by specifying the secret policy and optional KMS encryption key. If the
// configuration is for an existing secret and you do not specify the secret
// policy, the access preview uses the existing policy for the secret. If the
// access preview is for a new resource and you do not specify the policy, the
// access preview assumes a secret without a policy. To propose deletion of an
// existing policy, you can specify an empty string. If the proposed configuration
// is for a new secret and you do not specify the KMS key ID, the access preview
// uses the Amazon Web Services managed key aws/secretsmanager . If you specify an
// empty string for the KMS key ID, the access preview uses the Amazon Web Services
// managed key of the Amazon Web Services account. For more information about
// secret policy limits, see [Quotas for Secrets Manager.].
//
// [Quotas for Secrets Manager.]: https://docs.aws.amazon.com/secretsmanager/latest/userguide/reference_limits.html
// [CreateSecret]: https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_CreateSecret.html
type SecretsManagerSecretConfiguration struct {

	// The proposed ARN, key ID, or alias of the KMS key.
	KmsKeyId *string

	// The proposed resource policy defining who can access or manage the secret.
	SecretPolicy *string

	noSmithyDocumentSerde
}

// The proposed access control configuration for an Amazon SNS topic. You can
// propose a configuration for a new Amazon SNS topic or an existing Amazon SNS
// topic that you own by specifying the policy. If the configuration is for an
// existing Amazon SNS topic and you do not specify the Amazon SNS policy, then the
// access preview uses the existing Amazon SNS policy for the topic. If the access
// preview is for a new resource and you do not specify the policy, then the access
// preview assumes an Amazon SNS topic without a policy. To propose deletion of an
// existing Amazon SNS topic policy, you can specify an empty string for the Amazon
// SNS policy. For more information, see [Topic].
//
// [Topic]: https://docs.aws.amazon.com/sns/latest/api/API_Topic.html
type SnsTopicConfiguration struct {

	// The JSON policy text that defines who can access an Amazon SNS topic. For more
	// information, see [Example cases for Amazon SNS access control]in the Amazon SNS Developer Guide.
	//
	// [Example cases for Amazon SNS access control]: https://docs.aws.amazon.com/sns/latest/dg/sns-access-policy-use-cases.html
	TopicPolicy *string

	noSmithyDocumentSerde
}

// The criteria used to sort.
type SortCriteria struct {

	// The name of the attribute to sort on.
	AttributeName *string

	// The sort order, ascending or descending.
	OrderBy OrderBy

	noSmithyDocumentSerde
}

// A span in a policy. The span consists of a start position (inclusive) and end
// position (exclusive).
type Span struct {

	// The end position of the span (exclusive).
	//
	// This member is required.
	End *Position

	// The start position of the span (inclusive).
	//
	// This member is required.
	Start *Position

	noSmithyDocumentSerde
}

// The proposed access control configuration for an Amazon SQS queue. You can
// propose a configuration for a new Amazon SQS queue or an existing Amazon SQS
// queue that you own by specifying the Amazon SQS policy. If the configuration is
// for an existing Amazon SQS queue and you do not specify the Amazon SQS policy,
// the access preview uses the existing Amazon SQS policy for the queue. If the
// access preview is for a new resource and you do not specify the policy, the
// access preview assumes an Amazon SQS queue without a policy. To propose deletion
// of an existing Amazon SQS queue policy, you can specify an empty string for the
// Amazon SQS policy. For more information about Amazon SQS policy limits, see [Quotas related to policies].
//
// [Quotas related to policies]: https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-policies.html
type SqsQueueConfiguration struct {

	//  The proposed resource policy for the Amazon SQS queue.
	QueuePolicy *string

	noSmithyDocumentSerde
}

// Provides more details about the current status of the analyzer. For example, if
// the creation for the analyzer fails, a Failed status is returned. For an
// analyzer with organization as the type, this failure can be due to an issue with
// creating the service-linked roles required in the member accounts of the Amazon
// Web Services organization.
type StatusReason struct {

	// The reason code for the current status of the analyzer.
	//
	// This member is required.
	Code ReasonCode

	noSmithyDocumentSerde
}

// A reference to a substring of a literal string in a JSON document.
type Substring struct {

	// The length of the substring.
	//
	// This member is required.
	Length *int32

	// The start index of the substring, starting from 0.
	//
	// This member is required.
	Start *int32

	noSmithyDocumentSerde
}

// Contains details about the CloudTrail trail being analyzed to generate a policy.
type Trail struct {

	// Specifies the ARN of the trail. The format of a trail ARN is
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail .
	//
	// This member is required.
	CloudTrailArn *string

	// Possible values are true or false . If set to true , IAM Access Analyzer
	// retrieves CloudTrail data from all regions to analyze and generate a policy.
	AllRegions *bool

	// A list of regions to get CloudTrail data from and analyze to generate a policy.
	Regions []string

	noSmithyDocumentSerde
}

// Contains details about the CloudTrail trail being analyzed to generate a policy.
type TrailProperties struct {

	// Specifies the ARN of the trail. The format of a trail ARN is
	// arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail .
	//
	// This member is required.
	CloudTrailArn *string

	// Possible values are true or false . If set to true , IAM Access Analyzer
	// retrieves CloudTrail data from all regions to analyze and generate a policy.
	AllRegions *bool

	// A list of regions to get CloudTrail data from and analyze to generate a policy.
	Regions []string

	noSmithyDocumentSerde
}

// Contains information about an unused access analyzer.
type UnusedAccessConfiguration struct {

	// Contains information about analysis rules for the analyzer. Analysis rules
	// determine which entities will generate findings based on the criteria you define
	// when you create the rule.
	AnalysisRule *AnalysisRule

	// The specified access age in days for which to generate findings for unused
	// access. For example, if you specify 90 days, the analyzer will generate findings
	// for IAM entities within the accounts of the selected organization for any access
	// that hasn't been used in 90 or more days since the analyzer's last scan. You can
	// choose a value between 1 and 365 days.
	UnusedAccessAge *int32

	noSmithyDocumentSerde
}

// Provides aggregate statistics about the findings for the specified unused
// access analyzer.
type UnusedAccessFindingsStatistics struct {

	// A list of one to ten Amazon Web Services accounts that have the most active
	// findings for the unused access analyzer.
	TopAccounts []FindingAggregationAccountDetails

	// The total number of active findings for the unused access analyzer.
	TotalActiveFindings *int32

	// The total number of archived findings for the unused access analyzer.
	TotalArchivedFindings *int32

	// The total number of resolved findings for the unused access analyzer.
	TotalResolvedFindings *int32

	// A list of details about the total number of findings for each type of unused
	// access for the analyzer.
	UnusedAccessTypeStatistics []UnusedAccessTypeStatistics

	noSmithyDocumentSerde
}

// Contains information about the total number of findings for a type of unused
// access.
type UnusedAccessTypeStatistics struct {

	// The total number of findings for the specified unused access type.
	Total *int32

	// The type of unused access.
	UnusedAccessType *string

	noSmithyDocumentSerde
}

// Contains information about an unused access finding for an action. IAM Access
// Analyzer charges for unused access analysis based on the number of IAM roles and
// users analyzed per month. For more details on pricing, see [IAM Access Analyzer pricing].
//
// [IAM Access Analyzer pricing]: https://aws.amazon.com/iam/access-analyzer/pricing
type UnusedAction struct {

	// The action for which the unused access finding was generated.
	//
	// This member is required.
	Action *string

	// The time at which the action was last accessed.
	LastAccessed *time.Time

	noSmithyDocumentSerde
}

// Contains information about an unused access finding for an IAM role. IAM Access
// Analyzer charges for unused access analysis based on the number of IAM roles and
// users analyzed per month. For more details on pricing, see [IAM Access Analyzer pricing].
//
// [IAM Access Analyzer pricing]: https://aws.amazon.com/iam/access-analyzer/pricing
type UnusedIamRoleDetails struct {

	// The time at which the role was last accessed.
	LastAccessed *time.Time

	noSmithyDocumentSerde
}

// Contains information about an unused access finding for an IAM user access key.
// IAM Access Analyzer charges for unused access analysis based on the number of
// IAM roles and users analyzed per month. For more details on pricing, see [IAM Access Analyzer pricing].
//
// [IAM Access Analyzer pricing]: https://aws.amazon.com/iam/access-analyzer/pricing
type UnusedIamUserAccessKeyDetails struct {

	// The ID of the access key for which the unused access finding was generated.
	//
	// This member is required.
	AccessKeyId *string

	// The time at which the access key was last accessed.
	LastAccessed *time.Time

	noSmithyDocumentSerde
}

// Contains information about an unused access finding for an IAM user password.
// IAM Access Analyzer charges for unused access analysis based on the number of
// IAM roles and users analyzed per month. For more details on pricing, see [IAM Access Analyzer pricing].
//
// [IAM Access Analyzer pricing]: https://aws.amazon.com/iam/access-analyzer/pricing
type UnusedIamUserPasswordDetails struct {

	// The time at which the password was last accessed.
	LastAccessed *time.Time

	noSmithyDocumentSerde
}

// Contains information about an unused access finding for a permission. IAM
// Access Analyzer charges for unused access analysis based on the number of IAM
// roles and users analyzed per month. For more details on pricing, see [IAM Access Analyzer pricing].
//
// [IAM Access Analyzer pricing]: https://aws.amazon.com/iam/access-analyzer/pricing
type UnusedPermissionDetails struct {

	// The namespace of the Amazon Web Services service that contains the unused
	// actions.
	//
	// This member is required.
	ServiceNamespace *string

	// A list of unused actions for which the unused access finding was generated.
	Actions []UnusedAction

	// The time at which the permission was last accessed.
	LastAccessed *time.Time

	noSmithyDocumentSerde
}

// Contains information about the action to take for a policy in an unused
// permissions finding.
type UnusedPermissionsRecommendedStep struct {

	// A recommendation of whether to create or detach a policy for an unused
	// permissions finding.
	//
	// This member is required.
	RecommendedAction RecommendedRemediationAction

	// If the recommended action for the unused permissions finding is to detach a
	// policy, the ID of an existing policy to be detached.
	ExistingPolicyId *string

	// The time at which the existing policy for the unused permissions finding was
	// last updated.
	PolicyUpdatedAt *time.Time

	// If the recommended action for the unused permissions finding is to replace the
	// existing policy, the contents of the recommended policy to replace the policy
	// specified in the existingPolicyId field.
	RecommendedPolicy *string

	noSmithyDocumentSerde
}

// A finding in a policy. Each finding is an actionable recommendation that can be
// used to improve the policy.
type ValidatePolicyFinding struct {

	// A localized message that explains the finding and provides guidance on how to
	// address it.
	//
	// This member is required.
	FindingDetails *string

	// The impact of the finding.
	//
	// Security warnings report when the policy allows access that we consider overly
	// permissive.
	//
	// Errors report when a part of the policy is not functional.
	//
	// Warnings report non-security issues when a policy does not conform to policy
	// writing best practices.
	//
	// Suggestions recommend stylistic improvements in the policy that do not impact
	// access.
	//
	// This member is required.
	FindingType ValidatePolicyFindingType

	// The issue code provides an identifier of the issue associated with this finding.
	//
	// This member is required.
	IssueCode *string

	// A link to additional documentation about the type of finding.
	//
	// This member is required.
	LearnMoreLink *string

	// The list of locations in the policy document that are related to the finding.
	// The issue code provides a summary of an issue identified by the finding.
	//
	// This member is required.
	Locations []Location

	noSmithyDocumentSerde
}

// Contains information about a validation exception.
type ValidationExceptionField struct {

	// A message about the validation exception.
	//
	// This member is required.
	Message *string

	// The name of the validation exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The proposed virtual private cloud (VPC) configuration for the Amazon S3 access
// point. VPC configuration does not apply to multi-region access points. For more
// information, see [VpcConfiguration].
//
// [VpcConfiguration]: https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_VpcConfiguration.html
type VpcConfiguration struct {

	//  If this field is specified, this access point will only allow connections from
	// the specified VPC ID.
	//
	// This member is required.
	VpcId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAclGrantee()                         {}
func (*UnknownUnionMember) isAnalyzerConfiguration()              {}
func (*UnknownUnionMember) isConfiguration()                      {}
func (*UnknownUnionMember) isFindingDetails()                     {}
func (*UnknownUnionMember) isFindingsStatistics()                 {}
func (*UnknownUnionMember) isNetworkOriginConfiguration()         {}
func (*UnknownUnionMember) isPathElement()                        {}
func (*UnknownUnionMember) isRdsDbClusterSnapshotAttributeValue() {}
func (*UnknownUnionMember) isRdsDbSnapshotAttributeValue()        {}
func (*UnknownUnionMember) isRecommendedStep()                    {}
