// Code generated by smithy-go-codegen DO NOT EDIT.

package amp

import (
	"context"
	"errors"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/amp/types"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"time"
)

// Retrieves detailed information about a specific anomaly detector, including its
// status and configuration.
func (c *Client) DescribeAnomalyDetector(ctx context.Context, params *DescribeAnomalyDetectorInput, optFns ...func(*Options)) (*DescribeAnomalyDetectorOutput, error) {
	if params == nil {
		params = &DescribeAnomalyDetectorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeAnomalyDetector", params, optFns, c.addOperationDescribeAnomalyDetectorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeAnomalyDetectorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeAnomalyDetectorInput struct {

	// The identifier of the anomaly detector to describe.
	//
	// This member is required.
	AnomalyDetectorId *string

	// The identifier of the workspace containing the anomaly detector.
	//
	// This member is required.
	WorkspaceId *string

	noSmithyDocumentSerde
}

type DescribeAnomalyDetectorOutput struct {

	// The detailed information about the anomaly detector.
	//
	// This member is required.
	AnomalyDetector *types.AnomalyDetectorDescription

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeAnomalyDetectorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeAnomalyDetector{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeAnomalyDetector{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeAnomalyDetector"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeAnomalyDetectorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeAnomalyDetector(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// AnomalyDetectorActiveWaiterOptions are waiter options for
// AnomalyDetectorActiveWaiter
type AnomalyDetectorActiveWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// AnomalyDetectorActiveWaiter will use default minimum delay of 2 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, AnomalyDetectorActiveWaiter will use default max delay of 120
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeAnomalyDetectorInput, *DescribeAnomalyDetectorOutput, error) (bool, error)
}

// AnomalyDetectorActiveWaiter defines the waiters for AnomalyDetectorActive
type AnomalyDetectorActiveWaiter struct {
	client DescribeAnomalyDetectorAPIClient

	options AnomalyDetectorActiveWaiterOptions
}

// NewAnomalyDetectorActiveWaiter constructs a AnomalyDetectorActiveWaiter.
func NewAnomalyDetectorActiveWaiter(client DescribeAnomalyDetectorAPIClient, optFns ...func(*AnomalyDetectorActiveWaiterOptions)) *AnomalyDetectorActiveWaiter {
	options := AnomalyDetectorActiveWaiterOptions{}
	options.MinDelay = 2 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = anomalyDetectorActiveStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &AnomalyDetectorActiveWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for AnomalyDetectorActive waiter. The maxWaitDur
// is the maximum wait duration the waiter will wait. The maxWaitDur is required
// and must be greater than zero.
func (w *AnomalyDetectorActiveWaiter) Wait(ctx context.Context, params *DescribeAnomalyDetectorInput, maxWaitDur time.Duration, optFns ...func(*AnomalyDetectorActiveWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for AnomalyDetectorActive waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *AnomalyDetectorActiveWaiter) WaitForOutput(ctx context.Context, params *DescribeAnomalyDetectorInput, maxWaitDur time.Duration, optFns ...func(*AnomalyDetectorActiveWaiterOptions)) (*DescribeAnomalyDetectorOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeAnomalyDetector(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for AnomalyDetectorActive waiter")
}

func anomalyDetectorActiveStateRetryable(ctx context.Context, input *DescribeAnomalyDetectorInput, output *DescribeAnomalyDetectorOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.AnomalyDetector
		var v2 *types.AnomalyDetectorStatus
		if v1 != nil {
			v3 := v1.Status
			v2 = v3
		}
		var v4 types.AnomalyDetectorStatusCode
		if v2 != nil {
			v5 := v2.StatusCode
			v4 = v5
		}
		expectedValue := "ACTIVE"
		var pathValue string
		pathValue = string(v4)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.AnomalyDetector
		var v2 *types.AnomalyDetectorStatus
		if v1 != nil {
			v3 := v1.Status
			v2 = v3
		}
		var v4 types.AnomalyDetectorStatusCode
		if v2 != nil {
			v5 := v2.StatusCode
			v4 = v5
		}
		expectedValue := "CREATING"
		var pathValue string
		pathValue = string(v4)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err == nil {
		v1 := output.AnomalyDetector
		var v2 *types.AnomalyDetectorStatus
		if v1 != nil {
			v3 := v1.Status
			v2 = v3
		}
		var v4 types.AnomalyDetectorStatusCode
		if v2 != nil {
			v5 := v2.StatusCode
			v4 = v5
		}
		expectedValue := "UPDATING"
		var pathValue string
		pathValue = string(v4)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// AnomalyDetectorDeletedWaiterOptions are waiter options for
// AnomalyDetectorDeletedWaiter
type AnomalyDetectorDeletedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// AnomalyDetectorDeletedWaiter will use default minimum delay of 2 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, AnomalyDetectorDeletedWaiter will use default max delay of 120
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *DescribeAnomalyDetectorInput, *DescribeAnomalyDetectorOutput, error) (bool, error)
}

// AnomalyDetectorDeletedWaiter defines the waiters for AnomalyDetectorDeleted
type AnomalyDetectorDeletedWaiter struct {
	client DescribeAnomalyDetectorAPIClient

	options AnomalyDetectorDeletedWaiterOptions
}

// NewAnomalyDetectorDeletedWaiter constructs a AnomalyDetectorDeletedWaiter.
func NewAnomalyDetectorDeletedWaiter(client DescribeAnomalyDetectorAPIClient, optFns ...func(*AnomalyDetectorDeletedWaiterOptions)) *AnomalyDetectorDeletedWaiter {
	options := AnomalyDetectorDeletedWaiterOptions{}
	options.MinDelay = 2 * time.Second
	options.MaxDelay = 120 * time.Second
	options.Retryable = anomalyDetectorDeletedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &AnomalyDetectorDeletedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for AnomalyDetectorDeleted waiter. The
// maxWaitDur is the maximum wait duration the waiter will wait. The maxWaitDur is
// required and must be greater than zero.
func (w *AnomalyDetectorDeletedWaiter) Wait(ctx context.Context, params *DescribeAnomalyDetectorInput, maxWaitDur time.Duration, optFns ...func(*AnomalyDetectorDeletedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for AnomalyDetectorDeleted waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *AnomalyDetectorDeletedWaiter) WaitForOutput(ctx context.Context, params *DescribeAnomalyDetectorInput, maxWaitDur time.Duration, optFns ...func(*AnomalyDetectorDeletedWaiterOptions)) (*DescribeAnomalyDetectorOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 120 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.DescribeAnomalyDetector(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for AnomalyDetectorDeleted waiter")
}

func anomalyDetectorDeletedStateRetryable(ctx context.Context, input *DescribeAnomalyDetectorInput, output *DescribeAnomalyDetectorOutput, err error) (bool, error) {

	if err != nil {
		var errorType *types.ResourceNotFoundException
		if errors.As(err, &errorType) {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.AnomalyDetector
		var v2 *types.AnomalyDetectorStatus
		if v1 != nil {
			v3 := v1.Status
			v2 = v3
		}
		var v4 types.AnomalyDetectorStatusCode
		if v2 != nil {
			v5 := v2.StatusCode
			v4 = v5
		}
		expectedValue := "DELETING"
		var pathValue string
		pathValue = string(v4)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// DescribeAnomalyDetectorAPIClient is a client that implements the
// DescribeAnomalyDetector operation.
type DescribeAnomalyDetectorAPIClient interface {
	DescribeAnomalyDetector(context.Context, *DescribeAnomalyDetectorInput, ...func(*Options)) (*DescribeAnomalyDetectorOutput, error)
}

var _ DescribeAnomalyDetectorAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeAnomalyDetector(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeAnomalyDetector",
	}
}
