// Code generated by smithy-go-codegen DO NOT EDIT.

package apigatewayv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/apigatewayv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates a portal.
func (c *Client) UpdatePortal(ctx context.Context, params *UpdatePortalInput, optFns ...func(*Options)) (*UpdatePortalOutput, error) {
	if params == nil {
		params = &UpdatePortalInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdatePortal", params, optFns, c.addOperationUpdatePortalMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdatePortalOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request body for the patch operation.
type UpdatePortalInput struct {

	// The portal identifier.
	//
	// This member is required.
	PortalId *string

	// The authorization of the portal.
	Authorization *types.Authorization

	// Represents an endpoint configuration.
	EndpointConfiguration *types.EndpointConfigurationRequest

	// The ARNs of the portal products included in the portal.
	IncludedPortalProductArns []string

	// The logo URI.
	LogoUri *string

	// Contains the content that is visible to portal consumers including the themes,
	// display names, and description.
	PortalContent *types.PortalContent

	// The CloudWatch RUM app monitor name.
	RumAppMonitorName *string

	noSmithyDocumentSerde
}

type UpdatePortalOutput struct {

	// The authorization for the portal.
	Authorization *types.Authorization

	// The endpoint configuration.
	EndpointConfiguration *types.EndpointConfigurationResponse

	// The ARNs of the portal products included in the portal.
	IncludedPortalProductArns []string

	// The timestamp when the portal was last modified.
	LastModified *time.Time

	// The timestamp when the portal was last published.
	LastPublished *time.Time

	// The description associated with the last time the portal was published.
	LastPublishedDescription *string

	// The ARN of the portal.
	PortalArn *string

	// Contains the content that is visible to portal consumers including the themes,
	// display names, and description.
	PortalContent *types.PortalContent

	// The portal identifier.
	PortalId *string

	// Represents the preview endpoint and the any possible error messages during
	// preview generation.
	Preview *types.Preview

	// The publishStatus.
	PublishStatus types.PublishStatus

	// The CloudWatch RUM app monitor name.
	RumAppMonitorName *string

	// The status exception information.
	StatusException *types.StatusException

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdatePortalMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdatePortal{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdatePortal{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdatePortal"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdatePortalValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdatePortal(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdatePortal(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdatePortal",
	}
}
