// Code generated by smithy-go-codegen DO NOT EDIT.

package appconfigdata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the latest deployed configuration. This API may return empty
// configuration data if the client already has the latest version. For more
// information about this API action and to view example CLI commands that show how
// to use it with the StartConfigurationSessionAPI action, see [Retrieving the configuration] in the AppConfig User Guide.
//
// Note the following important information.
//
//   - Each configuration token is only valid for one call to
//     GetLatestConfiguration . The GetLatestConfiguration response includes a
//     NextPollConfigurationToken that should always replace the token used for the
//     just-completed call in preparation for the next one.
//
//   - GetLatestConfiguration is a priced call. For more information, see [Pricing].
//
// [Pricing]: https://aws.amazon.com/systems-manager/pricing/
// [Retrieving the configuration]: http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration
func (c *Client) GetLatestConfiguration(ctx context.Context, params *GetLatestConfigurationInput, optFns ...func(*Options)) (*GetLatestConfigurationOutput, error) {
	if params == nil {
		params = &GetLatestConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetLatestConfiguration", params, optFns, c.addOperationGetLatestConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetLatestConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetLatestConfigurationInput struct {

	// Token describing the current state of the configuration session. To obtain a
	// token, first call the StartConfigurationSessionAPI. Note that every call to GetLatestConfiguration will
	// return a new ConfigurationToken ( NextPollConfigurationToken in the response)
	// and must be provided to subsequent GetLatestConfiguration API calls.
	//
	// This token should only be used once. To support long poll use cases, the token
	// is valid for up to 24 hours. If a GetLatestConfiguration call uses an expired
	// token, the system returns BadRequestException .
	//
	// This member is required.
	ConfigurationToken *string

	noSmithyDocumentSerde
}

type GetLatestConfigurationOutput struct {

	// The data of the configuration. This may be empty if the client already has the
	// latest version of configuration.
	Configuration []byte

	// A standard MIME type describing the format of the configuration content.
	ContentType *string

	// The latest token describing the current state of the configuration session.
	// This must be provided to the next call to GetLatestConfiguration.
	//
	// This token should only be used once. To support long poll use cases, the token
	// is valid for up to 24 hours. If a GetLatestConfiguration call uses an expired
	// token, the system returns BadRequestException .
	NextPollConfigurationToken *string

	// The amount of time the client should wait before polling for configuration
	// updates again. Use RequiredMinimumPollIntervalInSeconds to set the desired poll
	// interval.
	NextPollIntervalInSeconds int32

	// The user-defined label for the AppConfig hosted configuration version. This
	// attribute doesn't apply if the configuration is not from an AppConfig hosted
	// configuration version. If the client already has the latest version of the
	// configuration data, this value is empty.
	VersionLabel *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetLatestConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetLatestConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetLatestConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetLatestConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetLatestConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetLatestConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetLatestConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetLatestConfiguration",
	}
}
