// Code generated by smithy-go-codegen DO NOT EDIT.

package appstream

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/appstream/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a custom WorkSpaces Applications image by importing an EC2 AMI. This
// allows you to use your own customized AMI to create WorkSpaces Applications
// images that support additional instance types beyond the standard stream.*
// instances.
func (c *Client) CreateImportedImage(ctx context.Context, params *CreateImportedImageInput, optFns ...func(*Options)) (*CreateImportedImageOutput, error) {
	if params == nil {
		params = &CreateImportedImageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateImportedImage", params, optFns, c.addOperationCreateImportedImageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateImportedImageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateImportedImageInput struct {

	// The ARN of the IAM role that allows WorkSpaces Applications to access your AMI.
	// The role must have permissions to modify image attributes and describe images,
	// with a trust relationship allowing appstream.amazonaws.com to assume the role.
	//
	// This member is required.
	IamRoleArn *string

	// A unique name for the imported image. The name must be between 1 and 100
	// characters and can contain letters, numbers, underscores, periods, and hyphens.
	//
	// This member is required.
	Name *string

	// The ID of the EC2 AMI to import. The AMI must meet specific requirements
	// including Windows Server 2022 Full Base, UEFI boot mode, TPM 2.0 support, and
	// proper drivers.
	//
	// This member is required.
	SourceAmiId *string

	// The version of the WorkSpaces Applications agent to use for the imported image.
	// Choose CURRENT_LATEST to use the agent version available at the time of import,
	// or ALWAYS_LATEST to automatically update to the latest agent version when new
	// versions are released.
	AgentSoftwareVersion types.AgentSoftwareVersion

	// Configuration for the application catalog of the imported image. This allows
	// you to specify applications available for streaming, including their paths,
	// icons, and launch parameters. This field contains sensitive data.
	AppCatalogConfig []types.ApplicationConfig

	// An optional description for the imported image. The description must match
	// approved regex patterns and can be up to 256 characters.
	Description *string

	// An optional display name for the imported image. The display name must match
	// approved regex patterns and can be up to 100 characters.
	DisplayName *string

	// When set to true, performs validation checks without actually creating the
	// imported image. Use this to verify your configuration before executing the
	// actual import operation.
	DryRun *bool

	// Configuration for runtime validation of the imported image. When specified,
	// WorkSpaces Applications provisions an instance to test streaming functionality,
	// which helps ensure the image is suitable for use.
	RuntimeValidationConfig *types.RuntimeValidationConfig

	// The tags to apply to the imported image. Tags help you organize and manage your
	// WorkSpaces Applications resources.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateImportedImageOutput struct {

	// Describes an image.
	Image *types.Image

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateImportedImageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateImportedImage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateImportedImage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateImportedImage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateImportedImageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateImportedImage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateImportedImage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateImportedImage",
	}
}
