// Code generated by smithy-go-codegen DO NOT EDIT.

package appstream

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Removes license included application(s) association(s) from an image builder
// instance.
func (c *Client) DisassociateSoftwareFromImageBuilder(ctx context.Context, params *DisassociateSoftwareFromImageBuilderInput, optFns ...func(*Options)) (*DisassociateSoftwareFromImageBuilderOutput, error) {
	if params == nil {
		params = &DisassociateSoftwareFromImageBuilderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DisassociateSoftwareFromImageBuilder", params, optFns, c.addOperationDisassociateSoftwareFromImageBuilderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DisassociateSoftwareFromImageBuilderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DisassociateSoftwareFromImageBuilderInput struct {

	// The name of the target image builder instance.
	//
	// This member is required.
	ImageBuilderName *string

	// The list of license included applications to disassociate from the image
	// builder.
	//
	// Possible values include the following:
	//
	//   - Microsoft_Office_2021_LTSC_Professional_Plus_32Bit
	//
	//   - Microsoft_Office_2021_LTSC_Professional_Plus_64Bit
	//
	//   - Microsoft_Office_2024_LTSC_Professional_Plus_32Bit
	//
	//   - Microsoft_Office_2024_LTSC_Professional_Plus_64Bit
	//
	//   - Microsoft_Visio_2021_LTSC_Professional_32Bit
	//
	//   - Microsoft_Visio_2021_LTSC_Professional_64Bit
	//
	//   - Microsoft_Visio_2024_LTSC_Professional_32Bit
	//
	//   - Microsoft_Visio_2024_LTSC_Professional_64Bit
	//
	//   - Microsoft_Project_2021_Professional_32Bit
	//
	//   - Microsoft_Project_2021_Professional_64Bit
	//
	//   - Microsoft_Project_2024_Professional_32Bit
	//
	//   - Microsoft_Project_2024_Professional_64Bit
	//
	//   - Microsoft_Office_2021_LTSC_Standard_32Bit
	//
	//   - Microsoft_Office_2021_LTSC_Standard_64Bit
	//
	//   - Microsoft_Office_2024_LTSC_Standard_32Bit
	//
	//   - Microsoft_Office_2024_LTSC_Standard_64Bit
	//
	//   - Microsoft_Visio_2021_LTSC_Standard_32Bit
	//
	//   - Microsoft_Visio_2021_LTSC_Standard_64Bit
	//
	//   - Microsoft_Visio_2024_LTSC_Standard_32Bit
	//
	//   - Microsoft_Visio_2024_LTSC_Standard_64Bit
	//
	//   - Microsoft_Project_2021_Standard_32Bit
	//
	//   - Microsoft_Project_2021_Standard_64Bit
	//
	//   - Microsoft_Project_2024_Standard_32Bit
	//
	//   - Microsoft_Project_2024_Standard_64Bit
	//
	// This member is required.
	SoftwareNames []string

	noSmithyDocumentSerde
}

type DisassociateSoftwareFromImageBuilderOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDisassociateSoftwareFromImageBuilderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDisassociateSoftwareFromImageBuilder{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDisassociateSoftwareFromImageBuilder{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DisassociateSoftwareFromImageBuilder"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDisassociateSoftwareFromImageBuilderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDisassociateSoftwareFromImageBuilder(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDisassociateSoftwareFromImageBuilder(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DisassociateSoftwareFromImageBuilder",
	}
}
