// Code generated by smithy-go-codegen DO NOT EDIT.

package arcregionswitch

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/arcregionswitch/types"
	smithy "github.com/aws/smithy-go"
	smithycbor "github.com/aws/smithy-go/encoding/cbor"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"net/http"
)

type smithyRpcv2cbor_serializeOpApprovePlanExecutionStep struct {
}

func (*smithyRpcv2cbor_serializeOpApprovePlanExecutionStep) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpApprovePlanExecutionStep) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*ApprovePlanExecutionStepInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/ApprovePlanExecutionStep"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_ApprovePlanExecutionStepInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpCancelPlanExecution struct {
}

func (*smithyRpcv2cbor_serializeOpCancelPlanExecution) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpCancelPlanExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*CancelPlanExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/CancelPlanExecution"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_CancelPlanExecutionInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpCreatePlan struct {
}

func (*smithyRpcv2cbor_serializeOpCreatePlan) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpCreatePlan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*CreatePlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/CreatePlan"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_CreatePlanInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpDeletePlan struct {
}

func (*smithyRpcv2cbor_serializeOpDeletePlan) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpDeletePlan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*DeletePlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/DeletePlan"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_DeletePlanInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpGetPlan struct {
}

func (*smithyRpcv2cbor_serializeOpGetPlan) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpGetPlan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*GetPlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/GetPlan"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_GetPlanInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpGetPlanEvaluationStatus struct {
}

func (*smithyRpcv2cbor_serializeOpGetPlanEvaluationStatus) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpGetPlanEvaluationStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*GetPlanEvaluationStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/GetPlanEvaluationStatus"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_GetPlanEvaluationStatusInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpGetPlanExecution struct {
}

func (*smithyRpcv2cbor_serializeOpGetPlanExecution) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpGetPlanExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*GetPlanExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/GetPlanExecution"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_GetPlanExecutionInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpGetPlanInRegion struct {
}

func (*smithyRpcv2cbor_serializeOpGetPlanInRegion) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpGetPlanInRegion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*GetPlanInRegionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/GetPlanInRegion"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_GetPlanInRegionInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpListPlanExecutionEvents struct {
}

func (*smithyRpcv2cbor_serializeOpListPlanExecutionEvents) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpListPlanExecutionEvents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*ListPlanExecutionEventsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/ListPlanExecutionEvents"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_ListPlanExecutionEventsInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpListPlanExecutions struct {
}

func (*smithyRpcv2cbor_serializeOpListPlanExecutions) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpListPlanExecutions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*ListPlanExecutionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/ListPlanExecutions"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_ListPlanExecutionsInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpListPlans struct {
}

func (*smithyRpcv2cbor_serializeOpListPlans) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpListPlans) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*ListPlansInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/ListPlans"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_ListPlansInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpListPlansInRegion struct {
}

func (*smithyRpcv2cbor_serializeOpListPlansInRegion) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpListPlansInRegion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*ListPlansInRegionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/ListPlansInRegion"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_ListPlansInRegionInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpListRoute53HealthChecks struct {
}

func (*smithyRpcv2cbor_serializeOpListRoute53HealthChecks) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpListRoute53HealthChecks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*ListRoute53HealthChecksInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/ListRoute53HealthChecks"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_ListRoute53HealthChecksInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpListTagsForResource struct {
}

func (*smithyRpcv2cbor_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/ListTagsForResource"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_ListTagsForResourceInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpStartPlanExecution struct {
}

func (*smithyRpcv2cbor_serializeOpStartPlanExecution) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpStartPlanExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*StartPlanExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/StartPlanExecution"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_StartPlanExecutionInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpTagResource struct {
}

func (*smithyRpcv2cbor_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/TagResource"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_TagResourceInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpUntagResource struct {
}

func (*smithyRpcv2cbor_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/UntagResource"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_UntagResourceInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpUpdatePlan struct {
}

func (*smithyRpcv2cbor_serializeOpUpdatePlan) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpUpdatePlan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*UpdatePlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/UpdatePlan"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_UpdatePlanInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpUpdatePlanExecution struct {
}

func (*smithyRpcv2cbor_serializeOpUpdatePlanExecution) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpUpdatePlanExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*UpdatePlanExecutionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/UpdatePlanExecution"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_UpdatePlanExecutionInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}

type smithyRpcv2cbor_serializeOpUpdatePlanExecutionStep struct {
}

func (*smithyRpcv2cbor_serializeOpUpdatePlanExecutionStep) ID() string {
	return "OperationSerializer"
}

func (m *smithyRpcv2cbor_serializeOpUpdatePlanExecutionStep) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	input, ok := in.Parameters.(*UpdatePlanExecutionStepInput)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected input type %T", in.Parameters)
	}
	_ = input

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", in.Request)
	}

	req.Method = http.MethodPost
	req.URL.Path = "/service/ArcRegionSwitch/operation/UpdatePlanExecutionStep"
	req.Header.Set("smithy-protocol", "rpc-v2-cbor")

	req.Header.Set("Content-Type", "application/cbor")
	req.Header.Set("Accept", "application/cbor")

	cv, err := serializeCBOR_UpdatePlanExecutionStepInput(input)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	payload := bytes.NewReader(smithycbor.Encode(cv))
	if req, err = req.SetStream(payload); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	in.Request = req

	endTimer()
	span.End()

	return next.HandleSerialize(ctx, in)
}
func serializeCBOR_AlarmCondition(v types.AlarmCondition) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_AlarmType(v types.AlarmType) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_Approval(v types.Approval) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_ArcRoutingControlConfiguration(v *types.ArcRoutingControlConfiguration) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.TimeoutMinutes != nil {
		ser, err := serializeCBOR_Int32(*v.TimeoutMinutes)
		if err != nil {
			return nil, err
		}
		vm["timeoutMinutes"] = ser
	}
	if v.CrossAccountRole != nil {
		ser, err := serializeCBOR_String(*v.CrossAccountRole)
		if err != nil {
			return nil, err
		}
		vm["crossAccountRole"] = ser
	}
	if v.ExternalId != nil {
		ser, err := serializeCBOR_String(*v.ExternalId)
		if err != nil {
			return nil, err
		}
		vm["externalId"] = ser
	}
	if v.RegionAndRoutingControls != nil {
		ser, err := serializeCBOR_RegionAndRoutingControls(v.RegionAndRoutingControls)
		if err != nil {
			return nil, err
		}
		vm["regionAndRoutingControls"] = ser
	}
	return vm, nil
}

func serializeCBOR_ArcRoutingControlState(v *types.ArcRoutingControlState) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.RoutingControlArn != nil {
		ser, err := serializeCBOR_String(*v.RoutingControlArn)
		if err != nil {
			return nil, err
		}
		vm["routingControlArn"] = ser
	}
	if len(v.State) > 0 {
		ser, err := serializeCBOR_RoutingControlStateChange(v.State)
		if err != nil {
			return nil, err
		}
		vm["state"] = ser
	}
	return vm, nil
}

func serializeCBOR_ArcRoutingControlStates(v []types.ArcRoutingControlState) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {

		ser, err := serializeCBOR_ArcRoutingControlState(&v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_Asg(v *types.Asg) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.CrossAccountRole != nil {
		ser, err := serializeCBOR_String(*v.CrossAccountRole)
		if err != nil {
			return nil, err
		}
		vm["crossAccountRole"] = ser
	}
	if v.ExternalId != nil {
		ser, err := serializeCBOR_String(*v.ExternalId)
		if err != nil {
			return nil, err
		}
		vm["externalId"] = ser
	}
	if v.Arn != nil {
		ser, err := serializeCBOR_String(*v.Arn)
		if err != nil {
			return nil, err
		}
		vm["arn"] = ser
	}
	return vm, nil
}

func serializeCBOR_AsgList(v []types.Asg) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {

		ser, err := serializeCBOR_Asg(&v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_AssociatedAlarm(v *types.AssociatedAlarm) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.CrossAccountRole != nil {
		ser, err := serializeCBOR_String(*v.CrossAccountRole)
		if err != nil {
			return nil, err
		}
		vm["crossAccountRole"] = ser
	}
	if v.ExternalId != nil {
		ser, err := serializeCBOR_String(*v.ExternalId)
		if err != nil {
			return nil, err
		}
		vm["externalId"] = ser
	}
	if v.ResourceIdentifier != nil {
		ser, err := serializeCBOR_String(*v.ResourceIdentifier)
		if err != nil {
			return nil, err
		}
		vm["resourceIdentifier"] = ser
	}
	if len(v.AlarmType) > 0 {
		ser, err := serializeCBOR_AlarmType(v.AlarmType)
		if err != nil {
			return nil, err
		}
		vm["alarmType"] = ser
	}
	return vm, nil
}

func serializeCBOR_AssociatedAlarmMap(v map[string]types.AssociatedAlarm) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	for k, vv := range v {

		ser, err := serializeCBOR_AssociatedAlarm(&vv)
		if err != nil {
			return nil, err
		}
		vm[k] = ser
	}
	return vm, nil
}

func serializeCBOR_AuroraClusterArns(v []string) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {

		ser, err := serializeCBOR_String(v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_CustomActionLambdaConfiguration(v *types.CustomActionLambdaConfiguration) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.TimeoutMinutes != nil {
		ser, err := serializeCBOR_Int32(*v.TimeoutMinutes)
		if err != nil {
			return nil, err
		}
		vm["timeoutMinutes"] = ser
	}
	if v.Lambdas != nil {
		ser, err := serializeCBOR_LambdaList(v.Lambdas)
		if err != nil {
			return nil, err
		}
		vm["lambdas"] = ser
	}
	if v.RetryIntervalMinutes != nil {
		ser, err := serializeCBOR_Float32(*v.RetryIntervalMinutes)
		if err != nil {
			return nil, err
		}
		vm["retryIntervalMinutes"] = ser
	}
	if len(v.RegionToRun) > 0 {
		ser, err := serializeCBOR_RegionToRunIn(v.RegionToRun)
		if err != nil {
			return nil, err
		}
		vm["regionToRun"] = ser
	}
	if v.Ungraceful != nil {
		ser, err := serializeCBOR_LambdaUngraceful(v.Ungraceful)
		if err != nil {
			return nil, err
		}
		vm["ungraceful"] = ser
	}
	return vm, nil
}

func serializeCBOR_Ec2AsgCapacityIncreaseConfiguration(v *types.Ec2AsgCapacityIncreaseConfiguration) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.TimeoutMinutes != nil {
		ser, err := serializeCBOR_Int32(*v.TimeoutMinutes)
		if err != nil {
			return nil, err
		}
		vm["timeoutMinutes"] = ser
	}
	if v.Asgs != nil {
		ser, err := serializeCBOR_AsgList(v.Asgs)
		if err != nil {
			return nil, err
		}
		vm["asgs"] = ser
	}
	if v.Ungraceful != nil {
		ser, err := serializeCBOR_Ec2Ungraceful(v.Ungraceful)
		if err != nil {
			return nil, err
		}
		vm["ungraceful"] = ser
	}
	if v.TargetPercent != nil {
		ser, err := serializeCBOR_Int32(*v.TargetPercent)
		if err != nil {
			return nil, err
		}
		vm["targetPercent"] = ser
	}
	if len(v.CapacityMonitoringApproach) > 0 {
		ser, err := serializeCBOR_Ec2AsgCapacityMonitoringApproach(v.CapacityMonitoringApproach)
		if err != nil {
			return nil, err
		}
		vm["capacityMonitoringApproach"] = ser
	}
	return vm, nil
}

func serializeCBOR_Ec2AsgCapacityMonitoringApproach(v types.Ec2AsgCapacityMonitoringApproach) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_Ec2Ungraceful(v *types.Ec2Ungraceful) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.MinimumSuccessPercentage != nil {
		ser, err := serializeCBOR_Int32(*v.MinimumSuccessPercentage)
		if err != nil {
			return nil, err
		}
		vm["minimumSuccessPercentage"] = ser
	}
	return vm, nil
}

func serializeCBOR_EcsCapacityIncreaseConfiguration(v *types.EcsCapacityIncreaseConfiguration) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.TimeoutMinutes != nil {
		ser, err := serializeCBOR_Int32(*v.TimeoutMinutes)
		if err != nil {
			return nil, err
		}
		vm["timeoutMinutes"] = ser
	}
	if v.Services != nil {
		ser, err := serializeCBOR_ServiceList(v.Services)
		if err != nil {
			return nil, err
		}
		vm["services"] = ser
	}
	if v.Ungraceful != nil {
		ser, err := serializeCBOR_EcsUngraceful(v.Ungraceful)
		if err != nil {
			return nil, err
		}
		vm["ungraceful"] = ser
	}
	if v.TargetPercent != nil {
		ser, err := serializeCBOR_Int32(*v.TargetPercent)
		if err != nil {
			return nil, err
		}
		vm["targetPercent"] = ser
	}
	if len(v.CapacityMonitoringApproach) > 0 {
		ser, err := serializeCBOR_EcsCapacityMonitoringApproach(v.CapacityMonitoringApproach)
		if err != nil {
			return nil, err
		}
		vm["capacityMonitoringApproach"] = ser
	}
	return vm, nil
}

func serializeCBOR_EcsCapacityMonitoringApproach(v types.EcsCapacityMonitoringApproach) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_EcsUngraceful(v *types.EcsUngraceful) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.MinimumSuccessPercentage != nil {
		ser, err := serializeCBOR_Int32(*v.MinimumSuccessPercentage)
		if err != nil {
			return nil, err
		}
		vm["minimumSuccessPercentage"] = ser
	}
	return vm, nil
}

func serializeCBOR_EksCapacityMonitoringApproach(v types.EksCapacityMonitoringApproach) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_EksCluster(v *types.EksCluster) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.CrossAccountRole != nil {
		ser, err := serializeCBOR_String(*v.CrossAccountRole)
		if err != nil {
			return nil, err
		}
		vm["crossAccountRole"] = ser
	}
	if v.ExternalId != nil {
		ser, err := serializeCBOR_String(*v.ExternalId)
		if err != nil {
			return nil, err
		}
		vm["externalId"] = ser
	}
	if v.ClusterArn != nil {
		ser, err := serializeCBOR_String(*v.ClusterArn)
		if err != nil {
			return nil, err
		}
		vm["clusterArn"] = ser
	}
	return vm, nil
}

func serializeCBOR_EksClusters(v []types.EksCluster) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {

		ser, err := serializeCBOR_EksCluster(&v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_EksResourceScalingConfiguration(v *types.EksResourceScalingConfiguration) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.TimeoutMinutes != nil {
		ser, err := serializeCBOR_Int32(*v.TimeoutMinutes)
		if err != nil {
			return nil, err
		}
		vm["timeoutMinutes"] = ser
	}
	if v.KubernetesResourceType != nil {
		ser, err := serializeCBOR_KubernetesResourceType(v.KubernetesResourceType)
		if err != nil {
			return nil, err
		}
		vm["kubernetesResourceType"] = ser
	}
	if v.ScalingResources != nil {
		ser, err := serializeCBOR_KubernetesScalingApps(v.ScalingResources)
		if err != nil {
			return nil, err
		}
		vm["scalingResources"] = ser
	}
	if v.EksClusters != nil {
		ser, err := serializeCBOR_EksClusters(v.EksClusters)
		if err != nil {
			return nil, err
		}
		vm["eksClusters"] = ser
	}
	if v.Ungraceful != nil {
		ser, err := serializeCBOR_EksResourceScalingUngraceful(v.Ungraceful)
		if err != nil {
			return nil, err
		}
		vm["ungraceful"] = ser
	}
	if v.TargetPercent != nil {
		ser, err := serializeCBOR_Int32(*v.TargetPercent)
		if err != nil {
			return nil, err
		}
		vm["targetPercent"] = ser
	}
	if len(v.CapacityMonitoringApproach) > 0 {
		ser, err := serializeCBOR_EksCapacityMonitoringApproach(v.CapacityMonitoringApproach)
		if err != nil {
			return nil, err
		}
		vm["capacityMonitoringApproach"] = ser
	}
	return vm, nil
}

func serializeCBOR_EksResourceScalingUngraceful(v *types.EksResourceScalingUngraceful) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.MinimumSuccessPercentage != nil {
		ser, err := serializeCBOR_Int32(*v.MinimumSuccessPercentage)
		if err != nil {
			return nil, err
		}
		vm["minimumSuccessPercentage"] = ser
	}
	return vm, nil
}

func serializeCBOR_ExecutionAction(v types.ExecutionAction) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_ExecutionApprovalConfiguration(v *types.ExecutionApprovalConfiguration) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.TimeoutMinutes != nil {
		ser, err := serializeCBOR_Int32(*v.TimeoutMinutes)
		if err != nil {
			return nil, err
		}
		vm["timeoutMinutes"] = ser
	}
	if v.ApprovalRole != nil {
		ser, err := serializeCBOR_String(*v.ApprovalRole)
		if err != nil {
			return nil, err
		}
		vm["approvalRole"] = ser
	}
	return vm, nil
}

func serializeCBOR_ExecutionBlockConfiguration(v types.ExecutionBlockConfiguration) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	switch uv := v.(type) {
	case *types.ExecutionBlockConfigurationMemberCustomActionLambdaConfig:
		ser, err := serializeCBOR_CustomActionLambdaConfiguration(&uv.Value)
		if err != nil {
			return nil, err
		}
		vm["customActionLambdaConfig"] = ser
	case *types.ExecutionBlockConfigurationMemberEc2AsgCapacityIncreaseConfig:
		ser, err := serializeCBOR_Ec2AsgCapacityIncreaseConfiguration(&uv.Value)
		if err != nil {
			return nil, err
		}
		vm["ec2AsgCapacityIncreaseConfig"] = ser
	case *types.ExecutionBlockConfigurationMemberExecutionApprovalConfig:
		ser, err := serializeCBOR_ExecutionApprovalConfiguration(&uv.Value)
		if err != nil {
			return nil, err
		}
		vm["executionApprovalConfig"] = ser
	case *types.ExecutionBlockConfigurationMemberArcRoutingControlConfig:
		ser, err := serializeCBOR_ArcRoutingControlConfiguration(&uv.Value)
		if err != nil {
			return nil, err
		}
		vm["arcRoutingControlConfig"] = ser
	case *types.ExecutionBlockConfigurationMemberGlobalAuroraConfig:
		ser, err := serializeCBOR_GlobalAuroraConfiguration(&uv.Value)
		if err != nil {
			return nil, err
		}
		vm["globalAuroraConfig"] = ser
	case *types.ExecutionBlockConfigurationMemberParallelConfig:
		ser, err := serializeCBOR_ParallelExecutionBlockConfiguration(&uv.Value)
		if err != nil {
			return nil, err
		}
		vm["parallelConfig"] = ser
	case *types.ExecutionBlockConfigurationMemberRegionSwitchPlanConfig:
		ser, err := serializeCBOR_RegionSwitchPlanConfiguration(&uv.Value)
		if err != nil {
			return nil, err
		}
		vm["regionSwitchPlanConfig"] = ser
	case *types.ExecutionBlockConfigurationMemberEcsCapacityIncreaseConfig:
		ser, err := serializeCBOR_EcsCapacityIncreaseConfiguration(&uv.Value)
		if err != nil {
			return nil, err
		}
		vm["ecsCapacityIncreaseConfig"] = ser
	case *types.ExecutionBlockConfigurationMemberEksResourceScalingConfig:
		ser, err := serializeCBOR_EksResourceScalingConfiguration(&uv.Value)
		if err != nil {
			return nil, err
		}
		vm["eksResourceScalingConfig"] = ser
	case *types.ExecutionBlockConfigurationMemberRoute53HealthCheckConfig:
		ser, err := serializeCBOR_Route53HealthCheckConfiguration(&uv.Value)
		if err != nil {
			return nil, err
		}
		vm["route53HealthCheckConfig"] = ser
	default:
		return nil, fmt.Errorf("unknown variant type %T", v)
	}
	return vm, nil
}

func serializeCBOR_ExecutionBlockType(v types.ExecutionBlockType) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_ExecutionMode(v types.ExecutionMode) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_ExecutionState(v types.ExecutionState) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_GlobalAuroraConfiguration(v *types.GlobalAuroraConfiguration) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.TimeoutMinutes != nil {
		ser, err := serializeCBOR_Int32(*v.TimeoutMinutes)
		if err != nil {
			return nil, err
		}
		vm["timeoutMinutes"] = ser
	}
	if v.CrossAccountRole != nil {
		ser, err := serializeCBOR_String(*v.CrossAccountRole)
		if err != nil {
			return nil, err
		}
		vm["crossAccountRole"] = ser
	}
	if v.ExternalId != nil {
		ser, err := serializeCBOR_String(*v.ExternalId)
		if err != nil {
			return nil, err
		}
		vm["externalId"] = ser
	}
	if len(v.Behavior) > 0 {
		ser, err := serializeCBOR_GlobalAuroraDefaultBehavior(v.Behavior)
		if err != nil {
			return nil, err
		}
		vm["behavior"] = ser
	}
	if v.Ungraceful != nil {
		ser, err := serializeCBOR_GlobalAuroraUngraceful(v.Ungraceful)
		if err != nil {
			return nil, err
		}
		vm["ungraceful"] = ser
	}
	if v.GlobalClusterIdentifier != nil {
		ser, err := serializeCBOR_String(*v.GlobalClusterIdentifier)
		if err != nil {
			return nil, err
		}
		vm["globalClusterIdentifier"] = ser
	}
	if v.DatabaseClusterArns != nil {
		ser, err := serializeCBOR_AuroraClusterArns(v.DatabaseClusterArns)
		if err != nil {
			return nil, err
		}
		vm["databaseClusterArns"] = ser
	}
	return vm, nil
}

func serializeCBOR_GlobalAuroraDefaultBehavior(v types.GlobalAuroraDefaultBehavior) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_GlobalAuroraUngraceful(v *types.GlobalAuroraUngraceful) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if len(v.Ungraceful) > 0 {
		ser, err := serializeCBOR_GlobalAuroraUngracefulBehavior(v.Ungraceful)
		if err != nil {
			return nil, err
		}
		vm["ungraceful"] = ser
	}
	return vm, nil
}

func serializeCBOR_GlobalAuroraUngracefulBehavior(v types.GlobalAuroraUngracefulBehavior) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_KubernetesResourceType(v *types.KubernetesResourceType) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.ApiVersion != nil {
		ser, err := serializeCBOR_String(*v.ApiVersion)
		if err != nil {
			return nil, err
		}
		vm["apiVersion"] = ser
	}
	if v.Kind != nil {
		ser, err := serializeCBOR_String(*v.Kind)
		if err != nil {
			return nil, err
		}
		vm["kind"] = ser
	}
	return vm, nil
}

func serializeCBOR_KubernetesScalingApplication(v map[string]map[string]types.KubernetesScalingResource) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	for k, vv := range v {
		if vv == nil {
			vm[k] = &smithycbor.Nil{}
			continue
		}
		ser, err := serializeCBOR_RegionalScalingResource(vv)
		if err != nil {
			return nil, err
		}
		vm[k] = ser
	}
	return vm, nil
}

func serializeCBOR_KubernetesScalingApps(v []map[string]map[string]types.KubernetesScalingResource) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {
		if v[i] == nil {
			vl = append(vl, &smithycbor.Nil{})
			continue
		}
		ser, err := serializeCBOR_KubernetesScalingApplication(v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_KubernetesScalingResource(v *types.KubernetesScalingResource) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Namespace != nil {
		ser, err := serializeCBOR_String(*v.Namespace)
		if err != nil {
			return nil, err
		}
		vm["namespace"] = ser
	}
	if v.Name != nil {
		ser, err := serializeCBOR_String(*v.Name)
		if err != nil {
			return nil, err
		}
		vm["name"] = ser
	}
	if v.HpaName != nil {
		ser, err := serializeCBOR_String(*v.HpaName)
		if err != nil {
			return nil, err
		}
		vm["hpaName"] = ser
	}
	return vm, nil
}

func serializeCBOR_LambdaList(v []types.Lambdas) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {

		ser, err := serializeCBOR_Lambdas(&v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_Lambdas(v *types.Lambdas) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.CrossAccountRole != nil {
		ser, err := serializeCBOR_String(*v.CrossAccountRole)
		if err != nil {
			return nil, err
		}
		vm["crossAccountRole"] = ser
	}
	if v.ExternalId != nil {
		ser, err := serializeCBOR_String(*v.ExternalId)
		if err != nil {
			return nil, err
		}
		vm["externalId"] = ser
	}
	if v.Arn != nil {
		ser, err := serializeCBOR_String(*v.Arn)
		if err != nil {
			return nil, err
		}
		vm["arn"] = ser
	}
	return vm, nil
}

func serializeCBOR_LambdaUngraceful(v *types.LambdaUngraceful) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if len(v.Behavior) > 0 {
		ser, err := serializeCBOR_LambdaUngracefulBehavior(v.Behavior)
		if err != nil {
			return nil, err
		}
		vm["behavior"] = ser
	}
	return vm, nil
}

func serializeCBOR_LambdaUngracefulBehavior(v types.LambdaUngracefulBehavior) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_ParallelExecutionBlockConfiguration(v *types.ParallelExecutionBlockConfiguration) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Steps != nil {
		ser, err := serializeCBOR_Steps(v.Steps)
		if err != nil {
			return nil, err
		}
		vm["steps"] = ser
	}
	return vm, nil
}

func serializeCBOR_RecoveryApproach(v types.RecoveryApproach) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_RegionalScalingResource(v map[string]types.KubernetesScalingResource) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	for k, vv := range v {

		ser, err := serializeCBOR_KubernetesScalingResource(&vv)
		if err != nil {
			return nil, err
		}
		vm[k] = ser
	}
	return vm, nil
}

func serializeCBOR_RegionAndRoutingControls(v map[string][]types.ArcRoutingControlState) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	for k, vv := range v {
		if vv == nil {
			vm[k] = &smithycbor.Nil{}
			continue
		}
		ser, err := serializeCBOR_ArcRoutingControlStates(vv)
		if err != nil {
			return nil, err
		}
		vm[k] = ser
	}
	return vm, nil
}

func serializeCBOR_RegionList(v []string) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {

		ser, err := serializeCBOR_String(v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_RegionSwitchPlanConfiguration(v *types.RegionSwitchPlanConfiguration) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.CrossAccountRole != nil {
		ser, err := serializeCBOR_String(*v.CrossAccountRole)
		if err != nil {
			return nil, err
		}
		vm["crossAccountRole"] = ser
	}
	if v.ExternalId != nil {
		ser, err := serializeCBOR_String(*v.ExternalId)
		if err != nil {
			return nil, err
		}
		vm["externalId"] = ser
	}
	if v.Arn != nil {
		ser, err := serializeCBOR_String(*v.Arn)
		if err != nil {
			return nil, err
		}
		vm["arn"] = ser
	}
	return vm, nil
}

func serializeCBOR_RegionToRunIn(v types.RegionToRunIn) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_Route53HealthCheckConfiguration(v *types.Route53HealthCheckConfiguration) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.TimeoutMinutes != nil {
		ser, err := serializeCBOR_Int32(*v.TimeoutMinutes)
		if err != nil {
			return nil, err
		}
		vm["timeoutMinutes"] = ser
	}
	if v.CrossAccountRole != nil {
		ser, err := serializeCBOR_String(*v.CrossAccountRole)
		if err != nil {
			return nil, err
		}
		vm["crossAccountRole"] = ser
	}
	if v.ExternalId != nil {
		ser, err := serializeCBOR_String(*v.ExternalId)
		if err != nil {
			return nil, err
		}
		vm["externalId"] = ser
	}
	if v.HostedZoneId != nil {
		ser, err := serializeCBOR_String(*v.HostedZoneId)
		if err != nil {
			return nil, err
		}
		vm["hostedZoneId"] = ser
	}
	if v.RecordName != nil {
		ser, err := serializeCBOR_String(*v.RecordName)
		if err != nil {
			return nil, err
		}
		vm["recordName"] = ser
	}
	if v.RecordSets != nil {
		ser, err := serializeCBOR_Route53ResourceRecordSetList(v.RecordSets)
		if err != nil {
			return nil, err
		}
		vm["recordSets"] = ser
	}
	return vm, nil
}

func serializeCBOR_Route53ResourceRecordSet(v *types.Route53ResourceRecordSet) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.RecordSetIdentifier != nil {
		ser, err := serializeCBOR_String(*v.RecordSetIdentifier)
		if err != nil {
			return nil, err
		}
		vm["recordSetIdentifier"] = ser
	}
	if v.Region != nil {
		ser, err := serializeCBOR_String(*v.Region)
		if err != nil {
			return nil, err
		}
		vm["region"] = ser
	}
	return vm, nil
}

func serializeCBOR_Route53ResourceRecordSetList(v []types.Route53ResourceRecordSet) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {

		ser, err := serializeCBOR_Route53ResourceRecordSet(&v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_RoutingControlStateChange(v types.RoutingControlStateChange) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_Service(v *types.Service) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.CrossAccountRole != nil {
		ser, err := serializeCBOR_String(*v.CrossAccountRole)
		if err != nil {
			return nil, err
		}
		vm["crossAccountRole"] = ser
	}
	if v.ExternalId != nil {
		ser, err := serializeCBOR_String(*v.ExternalId)
		if err != nil {
			return nil, err
		}
		vm["externalId"] = ser
	}
	if v.ClusterArn != nil {
		ser, err := serializeCBOR_String(*v.ClusterArn)
		if err != nil {
			return nil, err
		}
		vm["clusterArn"] = ser
	}
	if v.ServiceArn != nil {
		ser, err := serializeCBOR_String(*v.ServiceArn)
		if err != nil {
			return nil, err
		}
		vm["serviceArn"] = ser
	}
	return vm, nil
}

func serializeCBOR_ServiceList(v []types.Service) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {

		ser, err := serializeCBOR_Service(&v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_Step(v *types.Step) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Name != nil {
		ser, err := serializeCBOR_String(*v.Name)
		if err != nil {
			return nil, err
		}
		vm["name"] = ser
	}
	if v.Description != nil {
		ser, err := serializeCBOR_String(*v.Description)
		if err != nil {
			return nil, err
		}
		vm["description"] = ser
	}
	if v.ExecutionBlockConfiguration != nil {
		ser, err := serializeCBOR_ExecutionBlockConfiguration(v.ExecutionBlockConfiguration)
		if err != nil {
			return nil, err
		}
		vm["executionBlockConfiguration"] = ser
	}
	if len(v.ExecutionBlockType) > 0 {
		ser, err := serializeCBOR_ExecutionBlockType(v.ExecutionBlockType)
		if err != nil {
			return nil, err
		}
		vm["executionBlockType"] = ser
	}
	return vm, nil
}

func serializeCBOR_Steps(v []types.Step) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {

		ser, err := serializeCBOR_Step(&v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_TagKeys(v []string) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {

		ser, err := serializeCBOR_String(v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_Tags(v map[string]string) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	for k, vv := range v {

		ser, err := serializeCBOR_String(vv)
		if err != nil {
			return nil, err
		}
		vm[k] = ser
	}
	return vm, nil
}

func serializeCBOR_Trigger(v *types.Trigger) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Description != nil {
		ser, err := serializeCBOR_String(*v.Description)
		if err != nil {
			return nil, err
		}
		vm["description"] = ser
	}
	if v.TargetRegion != nil {
		ser, err := serializeCBOR_String(*v.TargetRegion)
		if err != nil {
			return nil, err
		}
		vm["targetRegion"] = ser
	}
	if len(v.Action) > 0 {
		ser, err := serializeCBOR_WorkflowTargetAction(v.Action)
		if err != nil {
			return nil, err
		}
		vm["action"] = ser
	}
	if v.Conditions != nil {
		ser, err := serializeCBOR_TriggerConditionList(v.Conditions)
		if err != nil {
			return nil, err
		}
		vm["conditions"] = ser
	}
	if v.MinDelayMinutesBetweenExecutions != nil {
		ser, err := serializeCBOR_Int32(*v.MinDelayMinutesBetweenExecutions)
		if err != nil {
			return nil, err
		}
		vm["minDelayMinutesBetweenExecutions"] = ser
	}
	return vm, nil
}

func serializeCBOR_TriggerCondition(v *types.TriggerCondition) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.AssociatedAlarmName != nil {
		ser, err := serializeCBOR_String(*v.AssociatedAlarmName)
		if err != nil {
			return nil, err
		}
		vm["associatedAlarmName"] = ser
	}
	if len(v.Condition) > 0 {
		ser, err := serializeCBOR_AlarmCondition(v.Condition)
		if err != nil {
			return nil, err
		}
		vm["condition"] = ser
	}
	return vm, nil
}

func serializeCBOR_TriggerConditionList(v []types.TriggerCondition) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {

		ser, err := serializeCBOR_TriggerCondition(&v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_TriggerList(v []types.Trigger) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {

		ser, err := serializeCBOR_Trigger(&v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_UpdatePlanExecutionAction(v types.UpdatePlanExecutionAction) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_UpdatePlanExecutionStepAction(v types.UpdatePlanExecutionStepAction) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_Workflow(v *types.Workflow) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Steps != nil {
		ser, err := serializeCBOR_Steps(v.Steps)
		if err != nil {
			return nil, err
		}
		vm["steps"] = ser
	}
	if len(v.WorkflowTargetAction) > 0 {
		ser, err := serializeCBOR_WorkflowTargetAction(v.WorkflowTargetAction)
		if err != nil {
			return nil, err
		}
		vm["workflowTargetAction"] = ser
	}
	if v.WorkflowTargetRegion != nil {
		ser, err := serializeCBOR_String(*v.WorkflowTargetRegion)
		if err != nil {
			return nil, err
		}
		vm["workflowTargetRegion"] = ser
	}
	if v.WorkflowDescription != nil {
		ser, err := serializeCBOR_String(*v.WorkflowDescription)
		if err != nil {
			return nil, err
		}
		vm["workflowDescription"] = ser
	}
	return vm, nil
}

func serializeCBOR_WorkflowList(v []types.Workflow) (smithycbor.Value, error) {
	vl := smithycbor.List{}
	for i := range v {

		ser, err := serializeCBOR_Workflow(&v[i])
		if err != nil {
			return nil, err
		}
		vl = append(vl, ser)
	}
	return vl, nil
}

func serializeCBOR_WorkflowTargetAction(v types.WorkflowTargetAction) (smithycbor.Value, error) {
	return smithycbor.String(string(v)), nil
}

func serializeCBOR_Float32(v float32) (smithycbor.Value, error) {
	return smithycbor.Float32(v), nil
}

func serializeCBOR_Int32(v int32) (smithycbor.Value, error) {
	if v < 0 {
		return smithycbor.NegInt(uint64(-v)), nil
	}
	return smithycbor.Uint(uint64(v)), nil
}

func serializeCBOR_String(v string) (smithycbor.Value, error) {
	return smithycbor.String(v), nil
}

func serializeCBOR_ApprovePlanExecutionStepInput(v *ApprovePlanExecutionStepInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.PlanArn != nil {
		ser, err := serializeCBOR_String(*v.PlanArn)
		if err != nil {
			return nil, err
		}
		vm["planArn"] = ser
	}
	if v.ExecutionId != nil {
		ser, err := serializeCBOR_String(*v.ExecutionId)
		if err != nil {
			return nil, err
		}
		vm["executionId"] = ser
	}
	if v.StepName != nil {
		ser, err := serializeCBOR_String(*v.StepName)
		if err != nil {
			return nil, err
		}
		vm["stepName"] = ser
	}
	if len(v.Approval) > 0 {
		ser, err := serializeCBOR_Approval(v.Approval)
		if err != nil {
			return nil, err
		}
		vm["approval"] = ser
	}
	if v.Comment != nil {
		ser, err := serializeCBOR_String(*v.Comment)
		if err != nil {
			return nil, err
		}
		vm["comment"] = ser
	}
	return vm, nil
}

func serializeCBOR_CancelPlanExecutionInput(v *CancelPlanExecutionInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.PlanArn != nil {
		ser, err := serializeCBOR_String(*v.PlanArn)
		if err != nil {
			return nil, err
		}
		vm["planArn"] = ser
	}
	if v.ExecutionId != nil {
		ser, err := serializeCBOR_String(*v.ExecutionId)
		if err != nil {
			return nil, err
		}
		vm["executionId"] = ser
	}
	if v.Comment != nil {
		ser, err := serializeCBOR_String(*v.Comment)
		if err != nil {
			return nil, err
		}
		vm["comment"] = ser
	}
	return vm, nil
}

func serializeCBOR_CreatePlanInput(v *CreatePlanInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Description != nil {
		ser, err := serializeCBOR_String(*v.Description)
		if err != nil {
			return nil, err
		}
		vm["description"] = ser
	}
	if v.Workflows != nil {
		ser, err := serializeCBOR_WorkflowList(v.Workflows)
		if err != nil {
			return nil, err
		}
		vm["workflows"] = ser
	}
	if v.ExecutionRole != nil {
		ser, err := serializeCBOR_String(*v.ExecutionRole)
		if err != nil {
			return nil, err
		}
		vm["executionRole"] = ser
	}
	if v.RecoveryTimeObjectiveMinutes != nil {
		ser, err := serializeCBOR_Int32(*v.RecoveryTimeObjectiveMinutes)
		if err != nil {
			return nil, err
		}
		vm["recoveryTimeObjectiveMinutes"] = ser
	}
	if v.AssociatedAlarms != nil {
		ser, err := serializeCBOR_AssociatedAlarmMap(v.AssociatedAlarms)
		if err != nil {
			return nil, err
		}
		vm["associatedAlarms"] = ser
	}
	if v.Triggers != nil {
		ser, err := serializeCBOR_TriggerList(v.Triggers)
		if err != nil {
			return nil, err
		}
		vm["triggers"] = ser
	}
	if v.Name != nil {
		ser, err := serializeCBOR_String(*v.Name)
		if err != nil {
			return nil, err
		}
		vm["name"] = ser
	}
	if v.Regions != nil {
		ser, err := serializeCBOR_RegionList(v.Regions)
		if err != nil {
			return nil, err
		}
		vm["regions"] = ser
	}
	if len(v.RecoveryApproach) > 0 {
		ser, err := serializeCBOR_RecoveryApproach(v.RecoveryApproach)
		if err != nil {
			return nil, err
		}
		vm["recoveryApproach"] = ser
	}
	if v.PrimaryRegion != nil {
		ser, err := serializeCBOR_String(*v.PrimaryRegion)
		if err != nil {
			return nil, err
		}
		vm["primaryRegion"] = ser
	}
	if v.Tags != nil {
		ser, err := serializeCBOR_Tags(v.Tags)
		if err != nil {
			return nil, err
		}
		vm["tags"] = ser
	}
	return vm, nil
}

func serializeCBOR_DeletePlanInput(v *DeletePlanInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Arn != nil {
		ser, err := serializeCBOR_String(*v.Arn)
		if err != nil {
			return nil, err
		}
		vm["arn"] = ser
	}
	return vm, nil
}

func serializeCBOR_GetPlanEvaluationStatusInput(v *GetPlanEvaluationStatusInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.PlanArn != nil {
		ser, err := serializeCBOR_String(*v.PlanArn)
		if err != nil {
			return nil, err
		}
		vm["planArn"] = ser
	}
	if v.MaxResults != nil {
		ser, err := serializeCBOR_Int32(*v.MaxResults)
		if err != nil {
			return nil, err
		}
		vm["maxResults"] = ser
	}
	if v.NextToken != nil {
		ser, err := serializeCBOR_String(*v.NextToken)
		if err != nil {
			return nil, err
		}
		vm["nextToken"] = ser
	}
	return vm, nil
}

func serializeCBOR_GetPlanExecutionInput(v *GetPlanExecutionInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.PlanArn != nil {
		ser, err := serializeCBOR_String(*v.PlanArn)
		if err != nil {
			return nil, err
		}
		vm["planArn"] = ser
	}
	if v.ExecutionId != nil {
		ser, err := serializeCBOR_String(*v.ExecutionId)
		if err != nil {
			return nil, err
		}
		vm["executionId"] = ser
	}
	if v.MaxResults != nil {
		ser, err := serializeCBOR_Int32(*v.MaxResults)
		if err != nil {
			return nil, err
		}
		vm["maxResults"] = ser
	}
	if v.NextToken != nil {
		ser, err := serializeCBOR_String(*v.NextToken)
		if err != nil {
			return nil, err
		}
		vm["nextToken"] = ser
	}
	return vm, nil
}

func serializeCBOR_GetPlanInput(v *GetPlanInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Arn != nil {
		ser, err := serializeCBOR_String(*v.Arn)
		if err != nil {
			return nil, err
		}
		vm["arn"] = ser
	}
	return vm, nil
}

func serializeCBOR_GetPlanInRegionInput(v *GetPlanInRegionInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Arn != nil {
		ser, err := serializeCBOR_String(*v.Arn)
		if err != nil {
			return nil, err
		}
		vm["arn"] = ser
	}
	return vm, nil
}

func serializeCBOR_ListPlanExecutionEventsInput(v *ListPlanExecutionEventsInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.PlanArn != nil {
		ser, err := serializeCBOR_String(*v.PlanArn)
		if err != nil {
			return nil, err
		}
		vm["planArn"] = ser
	}
	if v.ExecutionId != nil {
		ser, err := serializeCBOR_String(*v.ExecutionId)
		if err != nil {
			return nil, err
		}
		vm["executionId"] = ser
	}
	if v.MaxResults != nil {
		ser, err := serializeCBOR_Int32(*v.MaxResults)
		if err != nil {
			return nil, err
		}
		vm["maxResults"] = ser
	}
	if v.NextToken != nil {
		ser, err := serializeCBOR_String(*v.NextToken)
		if err != nil {
			return nil, err
		}
		vm["nextToken"] = ser
	}
	if v.Name != nil {
		ser, err := serializeCBOR_String(*v.Name)
		if err != nil {
			return nil, err
		}
		vm["name"] = ser
	}
	return vm, nil
}

func serializeCBOR_ListPlanExecutionsInput(v *ListPlanExecutionsInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.PlanArn != nil {
		ser, err := serializeCBOR_String(*v.PlanArn)
		if err != nil {
			return nil, err
		}
		vm["planArn"] = ser
	}
	if v.MaxResults != nil {
		ser, err := serializeCBOR_Int32(*v.MaxResults)
		if err != nil {
			return nil, err
		}
		vm["maxResults"] = ser
	}
	if v.NextToken != nil {
		ser, err := serializeCBOR_String(*v.NextToken)
		if err != nil {
			return nil, err
		}
		vm["nextToken"] = ser
	}
	if len(v.State) > 0 {
		ser, err := serializeCBOR_ExecutionState(v.State)
		if err != nil {
			return nil, err
		}
		vm["state"] = ser
	}
	return vm, nil
}

func serializeCBOR_ListPlansInput(v *ListPlansInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.MaxResults != nil {
		ser, err := serializeCBOR_Int32(*v.MaxResults)
		if err != nil {
			return nil, err
		}
		vm["maxResults"] = ser
	}
	if v.NextToken != nil {
		ser, err := serializeCBOR_String(*v.NextToken)
		if err != nil {
			return nil, err
		}
		vm["nextToken"] = ser
	}
	return vm, nil
}

func serializeCBOR_ListPlansInRegionInput(v *ListPlansInRegionInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.MaxResults != nil {
		ser, err := serializeCBOR_Int32(*v.MaxResults)
		if err != nil {
			return nil, err
		}
		vm["maxResults"] = ser
	}
	if v.NextToken != nil {
		ser, err := serializeCBOR_String(*v.NextToken)
		if err != nil {
			return nil, err
		}
		vm["nextToken"] = ser
	}
	return vm, nil
}

func serializeCBOR_ListRoute53HealthChecksInput(v *ListRoute53HealthChecksInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Arn != nil {
		ser, err := serializeCBOR_String(*v.Arn)
		if err != nil {
			return nil, err
		}
		vm["arn"] = ser
	}
	if v.HostedZoneId != nil {
		ser, err := serializeCBOR_String(*v.HostedZoneId)
		if err != nil {
			return nil, err
		}
		vm["hostedZoneId"] = ser
	}
	if v.RecordName != nil {
		ser, err := serializeCBOR_String(*v.RecordName)
		if err != nil {
			return nil, err
		}
		vm["recordName"] = ser
	}
	if v.MaxResults != nil {
		ser, err := serializeCBOR_Int32(*v.MaxResults)
		if err != nil {
			return nil, err
		}
		vm["maxResults"] = ser
	}
	if v.NextToken != nil {
		ser, err := serializeCBOR_String(*v.NextToken)
		if err != nil {
			return nil, err
		}
		vm["nextToken"] = ser
	}
	return vm, nil
}

func serializeCBOR_ListTagsForResourceInput(v *ListTagsForResourceInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Arn != nil {
		ser, err := serializeCBOR_String(*v.Arn)
		if err != nil {
			return nil, err
		}
		vm["arn"] = ser
	}
	return vm, nil
}

func serializeCBOR_StartPlanExecutionInput(v *StartPlanExecutionInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.PlanArn != nil {
		ser, err := serializeCBOR_String(*v.PlanArn)
		if err != nil {
			return nil, err
		}
		vm["planArn"] = ser
	}
	if v.TargetRegion != nil {
		ser, err := serializeCBOR_String(*v.TargetRegion)
		if err != nil {
			return nil, err
		}
		vm["targetRegion"] = ser
	}
	if len(v.Action) > 0 {
		ser, err := serializeCBOR_ExecutionAction(v.Action)
		if err != nil {
			return nil, err
		}
		vm["action"] = ser
	}
	if len(v.Mode) > 0 {
		ser, err := serializeCBOR_ExecutionMode(v.Mode)
		if err != nil {
			return nil, err
		}
		vm["mode"] = ser
	}
	if v.Comment != nil {
		ser, err := serializeCBOR_String(*v.Comment)
		if err != nil {
			return nil, err
		}
		vm["comment"] = ser
	}
	if v.LatestVersion != nil {
		ser, err := serializeCBOR_String(*v.LatestVersion)
		if err != nil {
			return nil, err
		}
		vm["latestVersion"] = ser
	}
	return vm, nil
}

func serializeCBOR_TagResourceInput(v *TagResourceInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Arn != nil {
		ser, err := serializeCBOR_String(*v.Arn)
		if err != nil {
			return nil, err
		}
		vm["arn"] = ser
	}
	if v.Tags != nil {
		ser, err := serializeCBOR_Tags(v.Tags)
		if err != nil {
			return nil, err
		}
		vm["tags"] = ser
	}
	return vm, nil
}

func serializeCBOR_UntagResourceInput(v *UntagResourceInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Arn != nil {
		ser, err := serializeCBOR_String(*v.Arn)
		if err != nil {
			return nil, err
		}
		vm["arn"] = ser
	}
	if v.ResourceTagKeys != nil {
		ser, err := serializeCBOR_TagKeys(v.ResourceTagKeys)
		if err != nil {
			return nil, err
		}
		vm["resourceTagKeys"] = ser
	}
	return vm, nil
}

func serializeCBOR_UpdatePlanExecutionInput(v *UpdatePlanExecutionInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.PlanArn != nil {
		ser, err := serializeCBOR_String(*v.PlanArn)
		if err != nil {
			return nil, err
		}
		vm["planArn"] = ser
	}
	if v.ExecutionId != nil {
		ser, err := serializeCBOR_String(*v.ExecutionId)
		if err != nil {
			return nil, err
		}
		vm["executionId"] = ser
	}
	if len(v.Action) > 0 {
		ser, err := serializeCBOR_UpdatePlanExecutionAction(v.Action)
		if err != nil {
			return nil, err
		}
		vm["action"] = ser
	}
	if v.Comment != nil {
		ser, err := serializeCBOR_String(*v.Comment)
		if err != nil {
			return nil, err
		}
		vm["comment"] = ser
	}
	return vm, nil
}

func serializeCBOR_UpdatePlanExecutionStepInput(v *UpdatePlanExecutionStepInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.PlanArn != nil {
		ser, err := serializeCBOR_String(*v.PlanArn)
		if err != nil {
			return nil, err
		}
		vm["planArn"] = ser
	}
	if v.ExecutionId != nil {
		ser, err := serializeCBOR_String(*v.ExecutionId)
		if err != nil {
			return nil, err
		}
		vm["executionId"] = ser
	}
	if v.Comment != nil {
		ser, err := serializeCBOR_String(*v.Comment)
		if err != nil {
			return nil, err
		}
		vm["comment"] = ser
	}
	if v.StepName != nil {
		ser, err := serializeCBOR_String(*v.StepName)
		if err != nil {
			return nil, err
		}
		vm["stepName"] = ser
	}
	if len(v.ActionToTake) > 0 {
		ser, err := serializeCBOR_UpdatePlanExecutionStepAction(v.ActionToTake)
		if err != nil {
			return nil, err
		}
		vm["actionToTake"] = ser
	}
	return vm, nil
}

func serializeCBOR_UpdatePlanInput(v *UpdatePlanInput) (smithycbor.Value, error) {
	vm := smithycbor.Map{}
	if v.Arn != nil {
		ser, err := serializeCBOR_String(*v.Arn)
		if err != nil {
			return nil, err
		}
		vm["arn"] = ser
	}
	if v.Description != nil {
		ser, err := serializeCBOR_String(*v.Description)
		if err != nil {
			return nil, err
		}
		vm["description"] = ser
	}
	if v.Workflows != nil {
		ser, err := serializeCBOR_WorkflowList(v.Workflows)
		if err != nil {
			return nil, err
		}
		vm["workflows"] = ser
	}
	if v.ExecutionRole != nil {
		ser, err := serializeCBOR_String(*v.ExecutionRole)
		if err != nil {
			return nil, err
		}
		vm["executionRole"] = ser
	}
	if v.RecoveryTimeObjectiveMinutes != nil {
		ser, err := serializeCBOR_Int32(*v.RecoveryTimeObjectiveMinutes)
		if err != nil {
			return nil, err
		}
		vm["recoveryTimeObjectiveMinutes"] = ser
	}
	if v.AssociatedAlarms != nil {
		ser, err := serializeCBOR_AssociatedAlarmMap(v.AssociatedAlarms)
		if err != nil {
			return nil, err
		}
		vm["associatedAlarms"] = ser
	}
	if v.Triggers != nil {
		ser, err := serializeCBOR_TriggerList(v.Triggers)
		if err != nil {
			return nil, err
		}
		vm["triggers"] = ser
	}
	return vm, nil
}
