// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backup/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a logical container to where backups may be copied.
//
// This request includes a name, the Region, the maximum number of retention days,
// the minimum number of retention days, and optionally can include tags and a
// creator request ID.
//
// Do not include sensitive data, such as passport numbers, in the name of a
// backup vault.
func (c *Client) CreateLogicallyAirGappedBackupVault(ctx context.Context, params *CreateLogicallyAirGappedBackupVaultInput, optFns ...func(*Options)) (*CreateLogicallyAirGappedBackupVaultOutput, error) {
	if params == nil {
		params = &CreateLogicallyAirGappedBackupVaultInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLogicallyAirGappedBackupVault", params, optFns, c.addOperationCreateLogicallyAirGappedBackupVaultMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLogicallyAirGappedBackupVaultOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateLogicallyAirGappedBackupVaultInput struct {

	// The name of a logical container where backups are stored. Logically air-gapped
	// backup vaults are identified by names that are unique to the account used to
	// create them and the Region where they are created.
	//
	// This member is required.
	BackupVaultName *string

	// The maximum retention period that the vault retains its recovery points.
	//
	// This member is required.
	MaxRetentionDays *int64

	// This setting specifies the minimum retention period that the vault retains its
	// recovery points.
	//
	// The minimum value accepted is 7 days.
	//
	// This member is required.
	MinRetentionDays *int64

	// The tags to assign to the vault.
	BackupVaultTags map[string]string

	// The ID of the creation request.
	//
	// This parameter is optional. If used, this parameter must contain 1 to 50
	// alphanumeric or '-_.' characters.
	CreatorRequestId *string

	// The ARN of the customer-managed KMS key to use for encrypting the logically
	// air-gapped backup vault. If not specified, the vault will be encrypted with an
	// Amazon Web Services-owned key managed by Amazon Web Services Backup.
	EncryptionKeyArn *string

	noSmithyDocumentSerde
}

type CreateLogicallyAirGappedBackupVaultOutput struct {

	// The ARN (Amazon Resource Name) of the vault.
	BackupVaultArn *string

	// The name of a logical container where backups are stored. Logically air-gapped
	// backup vaults are identified by names that are unique to the account used to
	// create them and the Region where they are created.
	BackupVaultName *string

	// The date and time when the vault was created.
	//
	// This value is in Unix format, Coordinated Universal Time (UTC), and accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	CreationDate *time.Time

	// The current state of the vault.
	VaultState types.VaultState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLogicallyAirGappedBackupVaultMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateLogicallyAirGappedBackupVault{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateLogicallyAirGappedBackupVault{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateLogicallyAirGappedBackupVault"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateLogicallyAirGappedBackupVaultMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateLogicallyAirGappedBackupVaultValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLogicallyAirGappedBackupVault(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateLogicallyAirGappedBackupVault struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateLogicallyAirGappedBackupVault) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateLogicallyAirGappedBackupVault) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateLogicallyAirGappedBackupVaultInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateLogicallyAirGappedBackupVaultInput ")
	}

	if input.CreatorRequestId == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.CreatorRequestId = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateLogicallyAirGappedBackupVaultMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateLogicallyAirGappedBackupVault{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateLogicallyAirGappedBackupVault(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateLogicallyAirGappedBackupVault",
	}
}
