// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// An object that represents an Batch array job.
type ArrayProperties struct {

	// The size of the array job.
	Size *int32

	noSmithyDocumentSerde
}

// An object that represents the array properties of a job.
type ArrayPropertiesDetail struct {

	// The job index within the array that's associated with this job. This parameter
	// is returned for array job children.
	Index *int32

	// The size of the array job. This parameter is returned for parent array jobs.
	Size *int32

	// A summary of the number of array job children in each available job status.
	// This parameter is returned for parent array jobs.
	StatusSummary map[string]int32

	noSmithyDocumentSerde
}

// An object that represents the array properties of a job.
type ArrayPropertiesSummary struct {

	// The job index within the array that's associated with this job. This parameter
	// is returned for children of array jobs.
	Index *int32

	// The size of the array job. This parameter is returned for parent array jobs.
	Size *int32

	noSmithyDocumentSerde
}

// An object that represents the details of a container that's part of a job
// attempt.
type AttemptContainerDetail struct {

	// The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts
	// the job attempt.
	ContainerInstanceArn *string

	// The exit code for the job attempt. A non-zero exit code is considered failed.
	ExitCode *int32

	// The name of the CloudWatch Logs log stream that's associated with the
	// container. The log group for Batch jobs is /aws/batch/job . Each container
	// attempt receives a log stream name when they reach the RUNNING status.
	LogStreamName *string

	// The network interfaces that are associated with the job attempt.
	NetworkInterfaces []NetworkInterface

	// A short (255 max characters) human-readable string to provide additional
	// details for a running or stopped container.
	Reason *string

	// The Amazon Resource Name (ARN) of the Amazon ECS task that's associated with
	// the job attempt. Each container attempt receives a task ARN when they reach the
	// STARTING status.
	TaskArn *string

	noSmithyDocumentSerde
}

// An object that represents a job attempt.
type AttemptDetail struct {

	// The details for the container in this job attempt.
	Container *AttemptContainerDetail

	// The Unix timestamp (in milliseconds) for when the attempt was started (when the
	// attempt transitioned from the STARTING state to the RUNNING state).
	StartedAt *int64

	// A short, human-readable string to provide additional details for the current
	// status of the job attempt.
	StatusReason *string

	// The Unix timestamp (in milliseconds) for when the attempt was stopped (when the
	// attempt transitioned from the RUNNING state to a terminal state, such as
	// SUCCEEDED or FAILED ).
	StoppedAt *int64

	// The properties for a task definition that describes the container and volume
	// definitions of an Amazon ECS task.
	TaskProperties []AttemptEcsTaskDetails

	noSmithyDocumentSerde
}

// An object that represents the details of a task.
type AttemptEcsTaskDetails struct {

	// The Amazon Resource Name (ARN) of the container instance that hosts the task.
	ContainerInstanceArn *string

	// A list of containers that are included in the taskProperties list.
	Containers []AttemptTaskContainerDetails

	// The ARN of the Amazon ECS task.
	TaskArn *string

	noSmithyDocumentSerde
}

// An object that represents the details of a container that's part of a job
// attempt.
type AttemptTaskContainerDetails struct {

	// The exit code for the container’s attempt. A non-zero exit code is considered
	// failed.
	ExitCode *int32

	// The name of the Amazon CloudWatch Logs log stream that's associated with the
	// container. The log group for Batch jobs is /aws/batch/job . Each container
	// attempt receives a log stream name when they reach the RUNNING status.
	LogStreamName *string

	// The name of a container.
	Name *string

	// The network interfaces that are associated with the job attempt.
	NetworkInterfaces []NetworkInterface

	// A short (255 max characters) string that's easy to understand and provides
	// additional details for a running or stopped container.
	Reason *string

	noSmithyDocumentSerde
}

// Defines the capacity limit for a service environment. This structure specifies
// the maximum amount of resources that can be used by service jobs in the
// environment.
type CapacityLimit struct {

	// The unit of measure for the capacity limit. This defines how the maxCapacity
	// value should be interpreted. For SAGEMAKER_TRAINING jobs, use NUM_INSTANCES .
	CapacityUnit *string

	// The maximum capacity available for the service environment. This value
	// represents the maximum amount of resources that can be allocated to service
	// jobs.
	//
	// For example, maxCapacity=50 , capacityUnit=NUM_INSTANCES . This indicates that
	// the maximum number of instances that can be run on this service environment is
	// 50. You could then run 5 SageMaker Training jobs that each use 10 instances.
	// However, if you submit another job that requires 10 instances, it will wait in
	// the queue.
	MaxCapacity *int32

	noSmithyDocumentSerde
}

// An object that represents an Batch compute environment.
type ComputeEnvironmentDetail struct {

	// The Amazon Resource Name (ARN) of the compute environment.
	//
	// This member is required.
	ComputeEnvironmentArn *string

	// The name of the compute environment. It can be up to 128 characters long. It
	// can contain uppercase and lowercase letters, numbers, hyphens (-), and
	// underscores (_).
	//
	// This member is required.
	ComputeEnvironmentName *string

	// The compute resources defined for the compute environment. For more
	// information, see [Compute environments]in the Batch User Guide.
	//
	// [Compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html
	ComputeResources *ComputeResource

	// The orchestration type of the compute environment. The valid values are ECS
	// (default) or EKS .
	ContainerOrchestrationType OrchestrationType

	// Reserved.
	Context *string

	// The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster that the
	// compute environment uses.
	EcsClusterArn *string

	// The configuration for the Amazon EKS cluster that supports the Batch compute
	// environment. Only specify this parameter if the containerOrchestrationType is
	// EKS .
	EksConfiguration *EksConfiguration

	// The service role that's associated with the compute environment that allows
	// Batch to make calls to Amazon Web Services API operations on your behalf. For
	// more information, see [Batch service IAM role]in the Batch User Guide.
	//
	// [Batch service IAM role]: https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html
	ServiceRole *string

	// The state of the compute environment. The valid values are ENABLED or DISABLED .
	//
	// If the state is ENABLED , then the Batch scheduler can attempt to place jobs
	// from an associated job queue on the compute resources within the environment. If
	// the compute environment is managed, then it can scale its instances out or in
	// automatically based on the job queue demand.
	//
	// If the state is DISABLED , then the Batch scheduler doesn't attempt to place
	// jobs within the environment. Jobs in a STARTING or RUNNING state continue to
	// progress normally. Managed compute environments in the DISABLED state don't
	// scale out.
	//
	// Compute environments in a DISABLED state may continue to incur billing charges.
	// To prevent additional charges, turn off and then delete the compute environment.
	// For more information, see [State]in the Batch User Guide.
	//
	// When an instance is idle, the instance scales down to the minvCpus value.
	// However, the instance size doesn't change. For example, consider a c5.8xlarge
	// instance with a minvCpus value of 4 and a desiredvCpus value of 36 . This
	// instance doesn't scale down to a c5.large instance.
	//
	// [State]: https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state
	State CEState

	// The current status of the compute environment (for example, CREATING or VALID ).
	Status CEStatus

	// A short, human-readable string to provide additional details for the current
	// status of the compute environment.
	StatusReason *string

	// The tags applied to the compute environment.
	Tags map[string]string

	// The type of the compute environment: MANAGED or UNMANAGED . For more
	// information, see [Compute environments]in the Batch User Guide.
	//
	// [Compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html
	Type CEType

	// The maximum number of VCPUs expected to be used for an unmanaged compute
	// environment.
	UnmanagedvCpus *int32

	// Specifies the infrastructure update policy for the compute environment. For
	// more information about infrastructure updates, see [Updating compute environments]in the Batch User Guide.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	UpdatePolicy *UpdatePolicy

	// Unique identifier for the compute environment.
	Uuid *string

	noSmithyDocumentSerde
}

// The order that compute environments are tried in for job placement within a
// queue. Compute environments are tried in ascending order. For example, if two
// compute environments are associated with a job queue, the compute environment
// with a lower order integer value is tried for job placement first. Compute
// environments must be in the VALID state before you can associate them with a
// job queue. All of the compute environments must be either EC2 ( EC2 or SPOT ) or
// Fargate ( FARGATE or FARGATE_SPOT ); Amazon EC2 and Fargate compute environments
// can't be mixed.
//
// All compute environments that are associated with a job queue must share the
// same architecture. Batch doesn't support mixing compute environment architecture
// types in a single job queue.
type ComputeEnvironmentOrder struct {

	// The Amazon Resource Name (ARN) of the compute environment.
	//
	// This member is required.
	ComputeEnvironment *string

	// The order of the compute environment. Compute environments are tried in
	// ascending order. For example, if two compute environments are associated with a
	// job queue, the compute environment with a lower order integer value is tried
	// for job placement first.
	//
	// This member is required.
	Order *int32

	noSmithyDocumentSerde
}

// An object that represents an Batch compute resource. For more information, see [Compute environments]
// in the Batch User Guide.
//
// [Compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html
type ComputeResource struct {

	// The maximum number of vCPUs that a compute environment can support.
	//
	// With BEST_FIT_PROGRESSIVE , SPOT_CAPACITY_OPTIMIZED and
	// SPOT_PRICE_CAPACITY_OPTIMIZED (recommended) strategies using On-Demand or Spot
	// Instances, and the BEST_FIT strategy using Spot Instances, Batch might need to
	// exceed maxvCpus to meet your capacity requirements. In this event, Batch never
	// exceeds maxvCpus by more than a single instance.
	//
	// This member is required.
	MaxvCpus *int32

	// The VPC subnets where the compute resources are launched. These subnets must be
	// within the same VPC. Fargate compute resources can contain up to 16 subnets. For
	// more information, see [VPCs and subnets]in the Amazon VPC User Guide.
	//
	// Batch on Amazon EC2 and Batch on Amazon EKS support Local Zones. For more
	// information, see [Local Zones]in the Amazon EC2 User Guide for Linux Instances, [Amazon EKS and Amazon Web Services Local Zones] in the
	// Amazon EKS User Guide and [Amazon ECS clusters in Local Zones, Wavelength Zones, and Amazon Web Services Outposts]in the Amazon ECS Developer Guide.
	//
	// Batch on Fargate doesn't currently support Local Zones.
	//
	// [VPCs and subnets]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
	// [Amazon ECS clusters in Local Zones, Wavelength Zones, and Amazon Web Services Outposts]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones
	// [Local Zones]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones
	// [Amazon EKS and Amazon Web Services Local Zones]: https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html
	//
	// This member is required.
	Subnets []string

	// The type of compute environment: EC2 , SPOT , FARGATE , or FARGATE_SPOT . For
	// more information, see [Compute environments]in the Batch User Guide.
	//
	// If you choose SPOT , you must also specify an Amazon EC2 Spot Fleet role with
	// the spotIamFleetRole parameter. For more information, see [Amazon EC2 spot fleet role] in the Batch User
	// Guide.
	//
	// Multi-node parallel jobs aren't supported on Spot Instances.
	//
	// [Amazon EC2 spot fleet role]: https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html
	// [Compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html
	//
	// This member is required.
	Type CRType

	// The allocation strategy to use for the compute resource if not enough instances
	// of the best fitting instance type can be allocated. This might be because of
	// availability of the instance type in the Region or [Amazon EC2 service limits]. For more information, see [Allocation strategies]
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// BEST_FIT (default) Batch selects an instance type that best fits the needs of
	// the jobs with a preference for the lowest-cost instance type. If additional
	// instances of the selected instance type aren't available, Batch waits for the
	// additional instances to be available. If there aren't enough instances available
	// or the user is reaching [Amazon EC2 service limits], additional jobs aren't run until the currently
	// running jobs are completed. This allocation strategy keeps costs lower but can
	// limit scaling. If you're using Spot Fleets with BEST_FIT , the Spot Fleet IAM
	// Role must be specified. Compute resources that use a BEST_FIT allocation
	// strategy don't support infrastructure updates and can't update some parameters.
	// For more information, see [Updating compute environments]in the Batch User Guide.
	//
	// BEST_FIT_PROGRESSIVE Batch selects additional instance types that are large
	// enough to meet the requirements of the jobs in the queue. Its preference is for
	// instance types with lower cost vCPUs. If additional instances of the previously
	// selected instance types aren't available, Batch selects new instance types.
	//
	// SPOT_CAPACITY_OPTIMIZED Batch selects one or more instance types that are large
	// enough to meet the requirements of the jobs in the queue. Its preference is for
	// instance types that are less likely to be interrupted. This allocation strategy
	// is only available for Spot Instance compute resources.
	//
	// SPOT_PRICE_CAPACITY_OPTIMIZED The price and capacity optimized allocation
	// strategy looks at both price and capacity to select the Spot Instance pools that
	// are the least likely to be interrupted and have the lowest possible price. This
	// allocation strategy is only available for Spot Instance compute resources.
	//
	// With BEST_FIT_PROGRESSIVE , SPOT_CAPACITY_OPTIMIZED and
	// SPOT_PRICE_CAPACITY_OPTIMIZED (recommended) strategies using On-Demand or Spot
	// Instances, and the BEST_FIT strategy using Spot Instances, Batch might need to
	// exceed maxvCpus to meet your capacity requirements. In this event, Batch never
	// exceeds maxvCpus by more than a single instance.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	// [Allocation strategies]: https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html
	// [Amazon EC2 service limits]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html
	AllocationStrategy CRAllocationStrategy

	// The maximum percentage that a Spot Instance price can be when compared with the
	// On-Demand price for that instance type before instances are launched. For
	// example, if your maximum percentage is 20%, then the Spot price must be less
	// than 20% of the current On-Demand price for that Amazon EC2 instance. You always
	// pay the lowest (market) price and never more than your maximum percentage. If
	// you leave this field empty, the default value is 100% of the On-Demand price.
	// For most use cases, we recommend leaving this field empty.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	BidPercentage *int32

	// The desired number of vCPUS in the compute environment. Batch modifies this
	// value between the minimum and maximum values based on job queue demand.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	DesiredvCpus *int32

	// Provides information that's used to select Amazon Machine Images (AMIs) for
	// Amazon EC2 instances in the compute environment. If Ec2Configuration isn't
	// specified, the default is ECS_AL2 .
	//
	// One or two values can be provided.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	Ec2Configuration []Ec2Configuration

	// The Amazon EC2 key pair that's used for instances launched in the compute
	// environment. You can use this key pair to log in to your instances with SSH.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	Ec2KeyPair *string

	// The Amazon Machine Image (AMI) ID used for instances launched in the compute
	// environment. This parameter is overridden by the imageIdOverride member of the
	// Ec2Configuration structure.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// The AMI that you choose for a compute environment must match the architecture
	// of the instance types that you intend to use for that compute environment. For
	// example, if your compute environment uses A1 instance types, the compute
	// resource AMI that you choose must support ARM instances. Amazon ECS vends both
	// x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more
	// information, see [Amazon ECS-optimized Amazon Linux 2 AMI]in the Amazon Elastic Container Service Developer Guide.
	//
	// [Amazon ECS-optimized Amazon Linux 2 AMI]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html
	//
	// Deprecated: This field is deprecated, use ec2Configuration[].imageIdOverride
	// instead.
	ImageId *string

	// The Amazon ECS instance profile applied to Amazon EC2 instances in a compute
	// environment. This parameter is required for Amazon EC2 instances types. You can
	// specify the short name or full Amazon Resource Name (ARN) of an instance
	// profile. For example, ecsInstanceRole  or
	// arn:aws:iam:::instance-profile/ecsInstanceRole . For more information, see [Amazon ECS instance role] in
	// the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// [Amazon ECS instance role]: https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html
	InstanceRole *string

	// The instances types that can be launched. You can specify instance families to
	// launch any instance type within those families (for example, c5 or p3 ), or you
	// can specify specific sizes within a family (such as c5.8xlarge ).
	//
	// Batch can select the instance type for you if you choose one of the following:
	//
	//   - optimal to select instance types (from the c4 , m4 , r4 , c5 , m5 , and r5
	//   instance families) that match the demand of your job queues.
	//
	//   - default_x86_64 to choose x86 based instance types (from the m6i , c6i , r6i
	//   , and c7i instance families) that matches the resource demands of the job
	//   queue.
	//
	//   - default_arm64 to choose ARM based instance types (from the m6g , c6g , r6g ,
	//   and c7g instance families) that matches the resource demands of the job queue.
	//
	// Starting on 11/01/2025 the behavior of optimal is going to be changed to match
	// default_x86_64 . During the change your instance families could be updated to a
	// newer generation. You do not need to perform any actions for the upgrade to
	// happen. For more information about change, see [Optimal instance type configuration to receive automatic instance family updates].
	//
	// Instance family availability varies by Amazon Web Services Region. For example,
	// some Amazon Web Services Regions may not have any fourth generation instance
	// families but have fifth and sixth generation instance families.
	//
	// When using default_x86_64 or default_arm64 instance bundles, Batch selects
	// instance families based on a balance of cost-effectiveness and performance.
	// While newer generation instances often provide better price-performance, Batch
	// may choose an earlier generation instance family if it provides the optimal
	// combination of availability, cost, and performance for your workload. For
	// example, in an Amazon Web Services Region where both c6i and c7i instances are
	// available, Batch might select c6i instances if they offer better
	// cost-effectiveness for your specific job requirements. For more information on
	// Batch instance types and Amazon Web Services Region availability, see [Instance type compute table]in the
	// Batch User Guide.
	//
	// Batch periodically updates your instances in default bundles to newer, more
	// cost-effective options. Updates happen automatically without requiring any
	// action from you. Your workloads continue running during updates with no
	// interruption
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// When you create a compute environment, the instance types that you select for
	// the compute environment must share the same architecture. For example, you can't
	// mix x86 and ARM instances in the same compute environment.
	//
	// [Instance type compute table]: https://docs.aws.amazon.com/batch/latest/userguide/instance-type-compute-table.html
	// [Optimal instance type configuration to receive automatic instance family updates]: https://docs.aws.amazon.com/batch/latest/userguide/optimal-default-instance-troubleshooting.html
	InstanceTypes []string

	// The launch template to use for your compute resources. Any other compute
	// resource parameters that you specify in a [CreateComputeEnvironment]API operation override the same
	// parameters in the launch template. You must specify either the launch template
	// ID or launch template name in the request, but not both. For more information,
	// see [Launch template support]in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// [CreateComputeEnvironment]: https://docs.aws.amazon.com/batch/latest/APIReference/API_CreateComputeEnvironment.html
	// [Launch template support]: https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html
	LaunchTemplate *LaunchTemplateSpecification

	// The minimum number of vCPUs that a compute environment should maintain (even if
	// the compute environment is DISABLED ).
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	MinvCpus *int32

	// The Amazon EC2 placement group to associate with your compute resources. If you
	// intend to submit multi-node parallel jobs to your compute environment, you
	// should consider creating a cluster placement group and associate it with your
	// compute resources. This keeps your multi-node parallel job on a logical grouping
	// of instances within a single Availability Zone with high network flow potential.
	// For more information, see [Placement groups]in the Amazon EC2 User Guide for Linux Instances.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// [Placement groups]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html
	PlacementGroup *string

	// The Amazon EC2 security groups that are associated with instances launched in
	// the compute environment. One or more security groups must be specified, either
	// in securityGroupIds or using a launch template referenced in launchTemplate .
	// This parameter is required for jobs that are running on Fargate resources and
	// must contain at least one security group. Fargate doesn't support launch
	// templates. If security groups are specified using both securityGroupIds and
	// launchTemplate , the values in securityGroupIds are used.
	SecurityGroupIds []string

	// The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to
	// a SPOT compute environment. This role is required if the allocation strategy
	// set to BEST_FIT or if the allocation strategy isn't specified. For more
	// information, see [Amazon EC2 spot fleet role]in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// To tag your Spot Instances on creation, the Spot Fleet IAM role specified here
	// must use the newer AmazonEC2SpotFleetTaggingRole managed policy. The previously
	// recommended AmazonEC2SpotFleetRole managed policy doesn't have the required
	// permissions to tag Spot Instances. For more information, see [Spot instances not tagged on creation]in the Batch User
	// Guide.
	//
	// [Spot instances not tagged on creation]: https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#spot-instance-no-tag
	// [Amazon EC2 spot fleet role]: https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html
	SpotIamFleetRole *string

	// Key-value pair tags to be applied to Amazon EC2 resources that are launched in
	// the compute environment. For Batch, these take the form of "String1": "String2"
	// , where String1 is the tag key and String2 is the tag value (for example, {
	// "Name": "Batch Instance - C4OnDemand" } ). This is helpful for recognizing your
	// Batch instances in the Amazon EC2 console. Updating these tags requires an
	// infrastructure update to the compute environment. For more information, see [Updating compute environments]in
	// the Batch User Guide. These tags aren't seen when using the Batch
	// ListTagsForResource API operation.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	Tags map[string]string

	noSmithyDocumentSerde
}

// An object that represents the attributes of a compute environment that can be
// updated. For more information, see [Updating compute environments]in the Batch User Guide.
//
// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
type ComputeResourceUpdate struct {

	// The allocation strategy to use for the compute resource if there's not enough
	// instances of the best fitting instance type that can be allocated. This might be
	// because of availability of the instance type in the Region or [Amazon EC2 service limits]. For more
	// information, see [Allocation strategies]in the Batch User Guide.
	//
	// When updating a compute environment, changing the allocation strategy requires
	// an infrastructure update of the compute environment. For more information, see [Updating compute environments]
	// in the Batch User Guide. BEST_FIT isn't supported when updating a compute
	// environment.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// BEST_FIT_PROGRESSIVE Batch selects additional instance types that are large
	// enough to meet the requirements of the jobs in the queue. Its preference is for
	// instance types with lower cost vCPUs. If additional instances of the previously
	// selected instance types aren't available, Batch selects new instance types.
	//
	// SPOT_CAPACITY_OPTIMIZED Batch selects one or more instance types that are large
	// enough to meet the requirements of the jobs in the queue. Its preference is for
	// instance types that are less likely to be interrupted. This allocation strategy
	// is only available for Spot Instance compute resources.
	//
	// SPOT_PRICE_CAPACITY_OPTIMIZED The price and capacity optimized allocation
	// strategy looks at both price and capacity to select the Spot Instance pools that
	// are the least likely to be interrupted and have the lowest possible price. This
	// allocation strategy is only available for Spot Instance compute resources.
	//
	// With BEST_FIT_PROGRESSIVE , SPOT_CAPACITY_OPTIMIZED and
	// SPOT_PRICE_CAPACITY_OPTIMIZED (recommended) strategies using On-Demand or Spot
	// Instances, and the BEST_FIT strategy using Spot Instances, Batch might need to
	// exceed maxvCpus to meet your capacity requirements. In this event, Batch never
	// exceeds maxvCpus by more than a single instance.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	// [Allocation strategies]: https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html
	// [Amazon EC2 service limits]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html
	AllocationStrategy CRUpdateAllocationStrategy

	// The maximum percentage that a Spot Instance price can be when compared with the
	// On-Demand price for that instance type before instances are launched. For
	// example, if your maximum percentage is 20%, the Spot price must be less than 20%
	// of the current On-Demand price for that Amazon EC2 instance. You always pay the
	// lowest (market) price and never more than your maximum percentage. For most use
	// cases, we recommend leaving this field empty.
	//
	// When updating a compute environment, changing the bid percentage requires an
	// infrastructure update of the compute environment. For more information, see [Updating compute environments]in
	// the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	BidPercentage *int32

	// The desired number of vCPUS in the compute environment. Batch modifies this
	// value between the minimum and maximum values based on job queue demand.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// Batch doesn't support changing the desired number of vCPUs of an existing
	// compute environment. Don't specify this parameter for compute environments using
	// Amazon EKS clusters.
	//
	// When you update the desiredvCpus setting, the value must be between the minvCpus
	// and maxvCpus values.
	//
	// Additionally, the updated desiredvCpus value must be greater than or equal to
	// the current desiredvCpus value. For more information, see [Troubleshooting Batch] in the Batch User
	// Guide.
	//
	// [Troubleshooting Batch]: https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#error-desired-vcpus-update
	DesiredvCpus *int32

	// Provides information used to select Amazon Machine Images (AMIs) for Amazon EC2
	// instances in the compute environment. If Ec2Configuration isn't specified, the
	// default is ECS_AL2 .
	//
	// When updating a compute environment, changing this setting requires an
	// infrastructure update of the compute environment. For more information, see [Updating compute environments]in
	// the Batch User Guide. To remove the Amazon EC2 configuration and any custom AMI
	// ID specified in imageIdOverride , set this value to an empty string.
	//
	// One or two values can be provided.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	Ec2Configuration []Ec2Configuration

	// The Amazon EC2 key pair that's used for instances launched in the compute
	// environment. You can use this key pair to log in to your instances with SSH. To
	// remove the Amazon EC2 key pair, set this value to an empty string.
	//
	// When updating a compute environment, changing the Amazon EC2 key pair requires
	// an infrastructure update of the compute environment. For more information, see [Updating compute environments]
	// in the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	Ec2KeyPair *string

	// The Amazon Machine Image (AMI) ID used for instances launched in the compute
	// environment. This parameter is overridden by the imageIdOverride member of the
	// Ec2Configuration structure. To remove the custom AMI ID and use the default AMI
	// ID, set this value to an empty string.
	//
	// When updating a compute environment, changing the AMI ID requires an
	// infrastructure update of the compute environment. For more information, see [Updating compute environments]in
	// the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// The AMI that you choose for a compute environment must match the architecture
	// of the instance types that you intend to use for that compute environment. For
	// example, if your compute environment uses A1 instance types, the compute
	// resource AMI that you choose must support ARM instances. Amazon ECS vends both
	// x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more
	// information, see [Amazon ECS-optimized Amazon Linux 2 AMI]in the Amazon Elastic Container Service Developer Guide.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	// [Amazon ECS-optimized Amazon Linux 2 AMI]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html
	ImageId *string

	// The Amazon ECS instance profile applied to Amazon EC2 instances in a compute
	// environment. Required for Amazon EC2 instances. You can specify the short name
	// or full Amazon Resource Name (ARN) of an instance profile. For example,
	// ecsInstanceRole or arn:aws:iam:::instance-profile/ecsInstanceRole . For more
	// information, see [Amazon ECS instance role]in the Batch User Guide.
	//
	// When updating a compute environment, changing this setting requires an
	// infrastructure update of the compute environment. For more information, see [Updating compute environments]in
	// the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	// [Amazon ECS instance role]: https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html
	InstanceRole *string

	// The instances types that can be launched. You can specify instance families to
	// launch any instance type within those families (for example, c5 or p3 ), or you
	// can specify specific sizes within a family (such as c5.8xlarge ).
	//
	// Batch can select the instance type for you if you choose one of the following:
	//
	//   - optimal to select instance types (from the c4 , m4 , r4 , c5 , m5 , and r5
	//   instance families) that match the demand of your job queues.
	//
	//   - default_x86_64 to choose x86 based instance types (from the m6i , c6i , r6i
	//   , and c7i instance families) that matches the resource demands of the job
	//   queue.
	//
	//   - default_arm64 to choose x86 based instance types (from the m6g , c6g , r6g ,
	//   and c7g instance families) that matches the resource demands of the job queue.
	//
	// Starting on 11/01/2025 the behavior of optimal is going to be changed to match
	// default_x86_64 . During the change your instance families could be updated to a
	// newer generation. You do not need to perform any actions for the upgrade to
	// happen. For more information about change, see [Optimal instance type configuration to receive automatic instance family updates].
	//
	// Instance family availability varies by Amazon Web Services Region. For example,
	// some Amazon Web Services Regions may not have any fourth generation instance
	// families but have fifth and sixth generation instance families.
	//
	// When using default_x86_64 or default_arm64 instance bundles, Batch selects
	// instance families based on a balance of cost-effectiveness and performance.
	// While newer generation instances often provide better price-performance, Batch
	// may choose an earlier generation instance family if it provides the optimal
	// combination of availability, cost, and performance for your workload. For
	// example, in an Amazon Web Services Region where both c6i and c7i instances are
	// available, Batch might select c6i instances if they offer better
	// cost-effectiveness for your specific job requirements. For more information on
	// Batch instance types and Amazon Web Services Region availability, see [Instance type compute table]in the
	// Batch User Guide.
	//
	// Batch periodically updates your instances in default bundles to newer, more
	// cost-effective options. Updates happen automatically without requiring any
	// action from you. Your workloads continue running during updates with no
	// interruption
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// When you create a compute environment, the instance types that you select for
	// the compute environment must share the same architecture. For example, you can't
	// mix x86 and ARM instances in the same compute environment.
	//
	// [Instance type compute table]: https://docs.aws.amazon.com/batch/latest/userguide/instance-type-compute-table.html
	// [Optimal instance type configuration to receive automatic instance family updates]: https://docs.aws.amazon.com/batch/latest/userguide/optimal-default-instance-troubleshooting.html
	InstanceTypes []string

	// The updated launch template to use for your compute resources. You must specify
	// either the launch template ID or launch template name in the request, but not
	// both. For more information, see [Launch template support]in the Batch User Guide. To remove the custom
	// launch template and use the default launch template, set launchTemplateId or
	// launchTemplateName member of the launch template specification to an empty
	// string. Removing the launch template from a compute environment will not remove
	// the AMI specified in the launch template. In order to update the AMI specified
	// in a launch template, the updateToLatestImageVersion parameter must be set to
	// true .
	//
	// When updating a compute environment, changing the launch template requires an
	// infrastructure update of the compute environment. For more information, see [Updating compute environments]in
	// the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	// [Launch template support]: https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html
	LaunchTemplate *LaunchTemplateSpecification

	// The maximum number of Amazon EC2 vCPUs that an environment can reach.
	//
	// With BEST_FIT_PROGRESSIVE , SPOT_CAPACITY_OPTIMIZED and
	// SPOT_PRICE_CAPACITY_OPTIMIZED (recommended) strategies using On-Demand or Spot
	// Instances, and the BEST_FIT strategy using Spot Instances, Batch might need to
	// exceed maxvCpus to meet your capacity requirements. In this event, Batch never
	// exceeds maxvCpus by more than a single instance.
	MaxvCpus *int32

	// The minimum number of vCPUs that an environment should maintain (even if the
	// compute environment is DISABLED ).
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	MinvCpus *int32

	// The Amazon EC2 placement group to associate with your compute resources. If you
	// intend to submit multi-node parallel jobs to your compute environment, you
	// should consider creating a cluster placement group and associate it with your
	// compute resources. This keeps your multi-node parallel job on a logical grouping
	// of instances within a single Availability Zone with high network flow potential.
	// For more information, see [Placement groups]in the Amazon EC2 User Guide for Linux Instances.
	//
	// When updating a compute environment, changing the placement group requires an
	// infrastructure update of the compute environment. For more information, see [Updating compute environments]in
	// the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	// [Placement groups]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html
	PlacementGroup *string

	// The Amazon EC2 security groups that are associated with instances launched in
	// the compute environment. This parameter is required for Fargate compute
	// resources, where it can contain up to 5 security groups. For Fargate compute
	// resources, providing an empty list is handled as if this parameter wasn't
	// specified and no change is made. For Amazon EC2 compute resources, providing an
	// empty list removes the security groups from the compute resource.
	//
	// When updating a compute environment, changing the Amazon EC2 security groups
	// requires an infrastructure update of the compute environment. For more
	// information, see [Updating compute environments]in the Batch User Guide.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	SecurityGroupIds []string

	// The VPC subnets where the compute resources are launched. Fargate compute
	// resources can contain up to 16 subnets. For Fargate compute resources, providing
	// an empty list will be handled as if this parameter wasn't specified and no
	// change is made. For Amazon EC2 compute resources, providing an empty list
	// removes the VPC subnets from the compute resource. For more information, see [VPCs and subnets]in
	// the Amazon VPC User Guide.
	//
	// When updating a compute environment, changing the VPC subnets requires an
	// infrastructure update of the compute environment. For more information, see [Updating compute environments]in
	// the Batch User Guide.
	//
	// Batch on Amazon EC2 and Batch on Amazon EKS support Local Zones. For more
	// information, see [Local Zones]in the Amazon EC2 User Guide for Linux Instances, [Amazon EKS and Amazon Web Services Local Zones] in the
	// Amazon EKS User Guide and [Amazon ECS clusters in Local Zones, Wavelength Zones, and Amazon Web Services Outposts]in the Amazon ECS Developer Guide.
	//
	// Batch on Fargate doesn't currently support Local Zones.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	// [VPCs and subnets]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
	// [Amazon ECS clusters in Local Zones, Wavelength Zones, and Amazon Web Services Outposts]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones
	// [Local Zones]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones
	// [Amazon EKS and Amazon Web Services Local Zones]: https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html
	Subnets []string

	// Key-value pair tags to be applied to Amazon EC2 resources that are launched in
	// the compute environment. For Batch, these take the form of "String1": "String2"
	// , where String1 is the tag key and String2 is the tag value (for example, {
	// "Name": "Batch Instance - C4OnDemand" } ). This is helpful for recognizing your
	// Batch instances in the Amazon EC2 console. These tags aren't seen when using the
	// Batch ListTagsForResource API operation.
	//
	// When updating a compute environment, changing this setting requires an
	// infrastructure update of the compute environment. For more information, see [Updating compute environments]in
	// the Batch User Guide.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't specify it.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	Tags map[string]string

	// The type of compute environment: EC2 , SPOT , FARGATE , or FARGATE_SPOT . For
	// more information, see [Compute environments]in the Batch User Guide.
	//
	// If you choose SPOT , you must also specify an Amazon EC2 Spot Fleet role with
	// the spotIamFleetRole parameter. For more information, see [Amazon EC2 spot fleet role] in the Batch User
	// Guide.
	//
	// When updating a compute environment, changing the type of a compute environment
	// requires an infrastructure update of the compute environment. For more
	// information, see [Updating compute environments]in the Batch User Guide.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	// [Amazon EC2 spot fleet role]: https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html
	// [Compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html
	Type CRType

	// Specifies whether the AMI ID is updated to the latest one that's supported by
	// Batch when the compute environment has an infrastructure update. The default
	// value is false .
	//
	// An AMI ID can either be specified in the imageId or imageIdOverride parameters
	// or be determined by the launch template that's specified in the launchTemplate
	// parameter. If an AMI ID is specified any of these ways, this parameter is
	// ignored. For more information about to update AMI IDs during an infrastructure
	// update, see [Updating the AMI ID]in the Batch User Guide.
	//
	// When updating a compute environment, changing this setting requires an
	// infrastructure update of the compute environment. For more information, see [Updating compute environments]in
	// the Batch User Guide.
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	// [Updating the AMI ID]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami
	UpdateToLatestImageVersion *bool

	noSmithyDocumentSerde
}

// Contains a list of consumable resources required by a job.
type ConsumableResourceProperties struct {

	// The list of consumable resources required by a job.
	ConsumableResourceList []ConsumableResourceRequirement

	noSmithyDocumentSerde
}

// Information about a consumable resource required to run a job.
type ConsumableResourceRequirement struct {

	// The name or ARN of the consumable resource.
	ConsumableResource *string

	// The quantity of the consumable resource that is needed.
	Quantity *int64

	noSmithyDocumentSerde
}

// Current information about a consumable resource.
type ConsumableResourceSummary struct {

	// The Amazon Resource Name (ARN) of the consumable resource.
	//
	// This member is required.
	ConsumableResourceArn *string

	// The name of the consumable resource.
	//
	// This member is required.
	ConsumableResourceName *string

	// The amount of the consumable resource that is currently in use.
	InUseQuantity *int64

	// Indicates whether the resource is available to be re-used after a job
	// completes. Can be one of:
	//
	//   - REPLENISHABLE
	//
	//   - NON_REPLENISHABLE
	ResourceType *string

	// The total amount of the consumable resource that is available.
	TotalQuantity *int64

	noSmithyDocumentSerde
}

// An object that represents the details of a container that's part of a job.
type ContainerDetail struct {

	// The command that's passed to the container.
	Command []string

	// The Amazon Resource Name (ARN) of the container instance that the container is
	// running on.
	ContainerInstanceArn *string

	// Determines whether execute command functionality is turned on for this task. If
	// true , execute command functionality is turned on all the containers in the task.
	EnableExecuteCommand *bool

	// The environment variables to pass to a container.
	//
	// Environment variables cannot start with " AWS_BATCH ". This naming convention is
	// reserved for variables that Batch sets.
	Environment []KeyValuePair

	// The amount of ephemeral storage allocated for the task. This parameter is used
	// to expand the total amount of ephemeral storage available, beyond the default
	// amount, for tasks hosted on Fargate.
	EphemeralStorage *EphemeralStorage

	// The Amazon Resource Name (ARN) of the execution role that Batch can assume. For
	// more information, see [Batch execution IAM role]in the Batch User Guide.
	//
	// [Batch execution IAM role]: https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html
	ExecutionRoleArn *string

	// The exit code returned upon completion.
	ExitCode *int32

	// The platform configuration for jobs that are running on Fargate resources. Jobs
	// that are running on Amazon EC2 resources must not specify this parameter.
	FargatePlatformConfiguration *FargatePlatformConfiguration

	// The image used to start the container.
	Image *string

	// The instance type of the underlying host infrastructure of a multi-node
	// parallel job.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	InstanceType *string

	// The Amazon Resource Name (ARN) that's associated with the job when run.
	JobRoleArn *string

	// Linux-specific modifications that are applied to the container, such as details
	// for device mappings.
	LinuxParameters *LinuxParameters

	// The log configuration specification for the container.
	//
	// This parameter maps to LogConfig in the [Create a container] section of the [Docker Remote API] and the --log-driver
	// option to [docker run]. By default, containers use the same logging driver that the Docker
	// daemon uses. However, the container might use a different logging driver than
	// the Docker daemon by specifying a log driver with this parameter in the
	// container definition. To use a different logging driver for a container, the log
	// system must be configured properly on the container instance. Or, alternatively,
	// it must be configured on a different log server for remote logging options. For
	// more information on the options for different supported log drivers, see [Configure logging drivers]in the
	// Docker documentation.
	//
	// Batch currently supports a subset of the logging drivers available to the
	// Docker daemon (shown in the [LogConfiguration]data type). Additional log drivers might be
	// available in future releases of the Amazon ECS container agent.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater on
	// your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version | grep "Server API version"
	//
	// The Amazon ECS container agent running on a container instance must register
	// the logging drivers available on that instance with the
	// ECS_AVAILABLE_LOGGING_DRIVERS environment variable before containers placed on
	// that instance can use these log configuration options. For more information, see
	// [Amazon ECS container agent configuration]in the Amazon Elastic Container Service Developer Guide.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Configure logging drivers]: https://docs.docker.com/engine/admin/logging/overview/
	// [Amazon ECS container agent configuration]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	// [LogConfiguration]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html
	LogConfiguration *LogConfiguration

	// The name of the Amazon CloudWatch Logs log stream that's associated with the
	// container. The log group for Batch jobs is /aws/batch/job . Each container
	// attempt receives a log stream name when they reach the RUNNING status.
	LogStreamName *string

	// For jobs running on Amazon EC2 resources that didn't specify memory
	// requirements using resourceRequirements , the number of MiB of memory reserved
	// for the job. For other jobs, including all run on Fargate resources, see
	// resourceRequirements .
	Memory *int32

	// The mount points for data volumes in your container.
	MountPoints []MountPoint

	// The network configuration for jobs that are running on Fargate resources. Jobs
	// that are running on Amazon EC2 resources must not specify this parameter.
	NetworkConfiguration *NetworkConfiguration

	// The network interfaces that are associated with the job.
	NetworkInterfaces []NetworkInterface

	// When this parameter is true, the container is given elevated permissions on the
	// host container instance (similar to the root user). The default value is false .
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources
	// and shouldn't be provided, or specified as false .
	Privileged *bool

	// When this parameter is true, the container is given read-only access to its
	// root file system. This parameter maps to ReadonlyRootfs in the [Create a container] section of the [Docker Remote API]
	// and the --read-only option to [docker run]docker run .
	//
	// [docker run]: https://docs.docker.com/engine/reference/commandline/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	ReadonlyRootFilesystem *bool

	// A short (255 max characters) human-readable string to provide additional
	// details for a running or stopped container.
	Reason *string

	// The private repository authentication credentials to use.
	RepositoryCredentials *RepositoryCredentials

	// The type and amount of resources to assign to a container. The supported
	// resources include GPU , MEMORY , and VCPU .
	ResourceRequirements []ResourceRequirement

	// An object that represents the compute environment architecture for Batch jobs
	// on Fargate.
	RuntimePlatform *RuntimePlatform

	// The secrets to pass to the container. For more information, see [Specifying sensitive data] in the Batch
	// User Guide.
	//
	// [Specifying sensitive data]: https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html
	Secrets []Secret

	// The Amazon Resource Name (ARN) of the Amazon ECS task that's associated with
	// the container job. Each container attempt receives a task ARN when they reach
	// the STARTING status.
	TaskArn *string

	// A list of ulimit values to set in the container. This parameter maps to Ulimits
	// in the [Create a container]section of the [Docker Remote API] and the --ulimit option to [docker run].
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	Ulimits []Ulimit

	// The user name to use inside the container. This parameter maps to User in the [Create a container]
	// section of the [Docker Remote API]and the --user option to [docker run].
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	User *string

	// The number of vCPUs reserved for the container. For jobs that run on Amazon EC2
	// resources, you can specify the vCPU requirement for the job using
	// resourceRequirements , but you can't specify the vCPU requirements in both the
	// vcpus and resourceRequirements object. This parameter maps to CpuShares in the [Create a container]
	// section of the [Docker Remote API]and the --cpu-shares option to [docker run]. Each vCPU is equivalent to
	// 1,024 CPU shares. You must specify at least one vCPU. This is required but can
	// be specified in several places. It must be specified for each node at least
	// once.
	//
	// This parameter isn't applicable to jobs that run on Fargate resources. For jobs
	// that run on Fargate resources, you must specify the vCPU requirement for the job
	// using resourceRequirements .
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	Vcpus *int32

	// A list of volumes that are associated with the job.
	Volumes []Volume

	noSmithyDocumentSerde
}

// The overrides that should be sent to a container.
//
// For information about using Batch overrides when you connect event sources to
// targets, see [BatchContainerOverrides].
//
// [BatchContainerOverrides]: https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_BatchContainerOverrides.html
type ContainerOverrides struct {

	// The command to send to the container that overrides the default command from
	// the Docker image or the job definition.
	//
	// This parameter can't contain an empty string.
	Command []string

	// The environment variables to send to the container. You can add new environment
	// variables, which are added to the container at launch, or you can override the
	// existing environment variables from the Docker image or the job definition.
	//
	// Environment variables cannot start with " AWS_BATCH ". This naming convention is
	// reserved for variables that Batch sets.
	Environment []KeyValuePair

	// The instance type to use for a multi-node parallel job.
	//
	// This parameter isn't applicable to single-node container jobs or jobs that run
	// on Fargate resources, and shouldn't be provided.
	InstanceType *string

	// This parameter is deprecated, use resourceRequirements to override the memory
	// requirements specified in the job definition. It's not supported for jobs
	// running on Fargate resources. For jobs that run on Amazon EC2 resources, it
	// overrides the memory parameter set in the job definition, but doesn't override
	// any memory requirement that's specified in the resourceRequirements structure
	// in the job definition. To override memory requirements that are specified in the
	// resourceRequirements structure in the job definition, resourceRequirements must
	// be specified in the SubmitJob request, with type set to MEMORY and value set to
	// the new value. For more information, see [Can't override job definition resource requirements]in the Batch User Guide.
	//
	// [Can't override job definition resource requirements]: https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#override-resource-requirements
	//
	// Deprecated: This field is deprecated, use resourceRequirements instead.
	Memory *int32

	// The type and amount of resources to assign to a container. This overrides the
	// settings in the job definition. The supported resources include GPU , MEMORY ,
	// and VCPU .
	ResourceRequirements []ResourceRequirement

	// This parameter is deprecated, use resourceRequirements to override the vcpus
	// parameter that's set in the job definition. It's not supported for jobs running
	// on Fargate resources. For jobs that run on Amazon EC2 resources, it overrides
	// the vcpus parameter set in the job definition, but doesn't override any vCPU
	// requirement specified in the resourceRequirements structure in the job
	// definition. To override vCPU requirements that are specified in the
	// resourceRequirements structure in the job definition, resourceRequirements must
	// be specified in the SubmitJob request, with type set to VCPU and value set to
	// the new value. For more information, see [Can't override job definition resource requirements]in the Batch User Guide.
	//
	// [Can't override job definition resource requirements]: https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#override-resource-requirements
	//
	// Deprecated: This field is deprecated, use resourceRequirements instead.
	Vcpus *int32

	noSmithyDocumentSerde
}

// Container properties are used for Amazon ECS based job definitions. These
// properties to describe the container that's launched as part of a job.
type ContainerProperties struct {

	// The command that's passed to the container. This parameter maps to Cmd in the [Create a container]
	// section of the [Docker Remote API]and the COMMAND parameter to [docker run]. For more information, see [https://docs.docker.com/engine/reference/builder/#cmd].
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	// [https://docs.docker.com/engine/reference/builder/#cmd]: https://docs.docker.com/engine/reference/builder/#cmd
	Command []string

	// Determines whether execute command functionality is turned on for this task. If
	// true , execute command functionality is turned on all the containers in the task.
	EnableExecuteCommand *bool

	// The environment variables to pass to a container. This parameter maps to Env in
	// the [Create a container]section of the [Docker Remote API] and the --env option to [docker run].
	//
	// We don't recommend using plaintext environment variables for sensitive
	// information, such as credential data.
	//
	// Environment variables cannot start with " AWS_BATCH ". This naming convention is
	// reserved for variables that Batch sets.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	Environment []KeyValuePair

	// The amount of ephemeral storage to allocate for the task. This parameter is
	// used to expand the total amount of ephemeral storage available, beyond the
	// default amount, for tasks hosted on Fargate.
	EphemeralStorage *EphemeralStorage

	// The Amazon Resource Name (ARN) of the execution role that Batch can assume. For
	// jobs that run on Fargate resources, you must provide an execution role. For more
	// information, see [Batch execution IAM role]in the Batch User Guide.
	//
	// [Batch execution IAM role]: https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html
	ExecutionRoleArn *string

	// The platform configuration for jobs that are running on Fargate resources. Jobs
	// that are running on Amazon EC2 resources must not specify this parameter.
	FargatePlatformConfiguration *FargatePlatformConfiguration

	// Required. The image used to start a container. This string is passed directly
	// to the Docker daemon. Images in the Docker Hub registry are available by
	// default. Other repositories are specified with repository-url/image:tag . It
	// can be 255 characters long. It can contain uppercase and lowercase letters,
	// numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes
	// (/), and number signs (#). This parameter maps to Image in the [Create a container] section of the [Docker Remote API]
	// and the IMAGE parameter of [docker run].
	//
	// Docker image architecture must match the processor architecture of the compute
	// resources that they're scheduled on. For example, ARM-based Docker images can
	// only run on ARM-based compute resources.
	//
	//   - Images in Amazon ECR Public repositories use the full
	//   registry/repository[:tag] or registry/repository[@digest] naming conventions.
	//   For example, public.ecr.aws/registry_alias/my-web-app:latest .
	//
	//   - Images in Amazon ECR repositories use the full registry and repository URI
	//   (for example, 123456789012.dkr.ecr..amazonaws.com/ ).
	//
	//   - Images in official repositories on Docker Hub use a single name (for
	//   example, ubuntu or mongo ).
	//
	//   - Images in other repositories on Docker Hub are qualified with an
	//   organization name (for example, amazon/amazon-ecs-agent ).
	//
	//   - Images in other online repositories are qualified further by a domain name
	//   (for example, quay.io/assemblyline/ubuntu ).
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	Image *string

	// The instance type to use for a multi-node parallel job. All node groups in a
	// multi-node parallel job must use the same instance type.
	//
	// This parameter isn't applicable to single-node container jobs or jobs that run
	// on Fargate resources, and shouldn't be provided.
	InstanceType *string

	// The Amazon Resource Name (ARN) of the IAM role that the container can assume
	// for Amazon Web Services permissions. For more information, see [IAM roles for tasks]in the Amazon
	// Elastic Container Service Developer Guide.
	//
	// [IAM roles for tasks]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html
	JobRoleArn *string

	// Linux-specific modifications that are applied to the container, such as details
	// for device mappings.
	LinuxParameters *LinuxParameters

	// The log configuration specification for the container.
	//
	// This parameter maps to LogConfig in the [Create a container] section of the [Docker Remote API] and the --log-driver
	// option to [docker run]. By default, containers use the same logging driver that the Docker
	// daemon uses. However the container might use a different logging driver than the
	// Docker daemon by specifying a log driver with this parameter in the container
	// definition. To use a different logging driver for a container, the log system
	// must be configured properly on the container instance (or on a different log
	// server for remote logging options). For more information on the options for
	// different supported log drivers, see [Configure logging drivers]in the Docker documentation.
	//
	// Batch currently supports a subset of the logging drivers available to the
	// Docker daemon (shown in the [LogConfiguration]data type).
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater on
	// your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version | grep "Server API version"
	//
	// The Amazon ECS container agent running on a container instance must register
	// the logging drivers available on that instance with the
	// ECS_AVAILABLE_LOGGING_DRIVERS environment variable before containers placed on
	// that instance can use these log configuration options. For more information, see
	// [Amazon ECS container agent configuration]in the Amazon Elastic Container Service Developer Guide.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Configure logging drivers]: https://docs.docker.com/engine/admin/logging/overview/
	// [Amazon ECS container agent configuration]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	// [LogConfiguration]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html
	LogConfiguration *LogConfiguration

	// This parameter is deprecated, use resourceRequirements to specify the memory
	// requirements for the job definition. It's not supported for jobs running on
	// Fargate resources. For jobs that run on Amazon EC2 resources, it specifies the
	// memory hard limit (in MiB) for a container. If your container attempts to exceed
	// the specified number, it's terminated. You must specify at least 4 MiB of memory
	// for a job using this parameter. The memory hard limit can be specified in
	// several places. It must be specified for each node at least once.
	//
	// Deprecated: This field is deprecated, use resourceRequirements instead.
	Memory *int32

	// The mount points for data volumes in your container. This parameter maps to
	// Volumes in the [Create a container] section of the [Docker Remote API] and the --volume option to [docker run].
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	MountPoints []MountPoint

	// The network configuration for jobs that are running on Fargate resources. Jobs
	// that are running on Amazon EC2 resources must not specify this parameter.
	NetworkConfiguration *NetworkConfiguration

	// When this parameter is true, the container is given elevated permissions on the
	// host container instance (similar to the root user). This parameter maps to
	// Privileged in the [Create a container] section of the [Docker Remote API] and the --privileged option to [docker run]. The default
	// value is false.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources
	// and shouldn't be provided, or specified as false.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	Privileged *bool

	// When this parameter is true, the container is given read-only access to its
	// root file system. This parameter maps to ReadonlyRootfs in the [Create a container] section of the [Docker Remote API]
	// and the --read-only option to docker run .
	//
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	ReadonlyRootFilesystem *bool

	// The private repository authentication credentials to use.
	RepositoryCredentials *RepositoryCredentials

	// The type and amount of resources to assign to a container. The supported
	// resources include GPU , MEMORY , and VCPU .
	ResourceRequirements []ResourceRequirement

	// An object that represents the compute environment architecture for Batch jobs
	// on Fargate.
	RuntimePlatform *RuntimePlatform

	// The secrets for the container. For more information, see [Specifying sensitive data] in the Batch User
	// Guide.
	//
	// [Specifying sensitive data]: https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html
	Secrets []Secret

	// A list of ulimits to set in the container. This parameter maps to Ulimits in
	// the [Create a container]section of the [Docker Remote API] and the --ulimit option to [docker run].
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources
	// and shouldn't be provided.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	Ulimits []Ulimit

	// The user name to use inside the container. This parameter maps to User in the [Create a container]
	// section of the [Docker Remote API]and the --user option to [docker run].
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	User *string

	// This parameter is deprecated, use resourceRequirements to specify the vCPU
	// requirements for the job definition. It's not supported for jobs running on
	// Fargate resources. For jobs running on Amazon EC2 resources, it specifies the
	// number of vCPUs reserved for the job.
	//
	// Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to CpuShares
	// in the [Create a container]section of the [Docker Remote API] and the --cpu-shares option to [docker run]. The number of vCPUs
	// must be specified but can be specified in several places. You must specify it at
	// least once for each node.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	//
	// Deprecated: This field is deprecated, use resourceRequirements instead.
	Vcpus *int32

	// A list of data volumes used in a job.
	Volumes []Volume

	noSmithyDocumentSerde
}

// An object that represents summary details of a container within a job.
type ContainerSummary struct {

	// The exit code to return upon completion.
	ExitCode *int32

	// A short (255 max characters) human-readable string to provide additional
	// details for a running or stopped container.
	Reason *string

	noSmithyDocumentSerde
}

// An object that represents a container instance host device.
//
// This object isn't applicable to jobs that are running on Fargate resources and
// shouldn't be provided.
type Device struct {

	// The path for the device on the host container instance.
	//
	// This member is required.
	HostPath *string

	// The path inside the container that's used to expose the host device. By
	// default, the hostPath value is used.
	ContainerPath *string

	// The explicit permissions to provide to the container for the device. By
	// default, the container has permissions for read , write , and mknod for the
	// device.
	Permissions []DeviceCgroupPermission

	noSmithyDocumentSerde
}

// Provides information used to select Amazon Machine Images (AMIs) for instances
// in the compute environment. If Ec2Configuration isn't specified, the default is
// ECS_AL2 ([Amazon Linux 2] ).
//
// This object isn't applicable to jobs that are running on Fargate resources.
//
// [Amazon Linux 2]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami
type Ec2Configuration struct {

	// The image type to match with the instance type to select an AMI. The supported
	// values are different for ECS and EKS resources.
	//
	// ECS If the imageIdOverride parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI] ( ECS_AL2 )
	// is used. If a new image type is specified in an update, but neither an imageId
	// nor a imageIdOverride parameter is specified, then the latest Amazon ECS
	// optimized AMI for that image type that's supported by Batch is used.
	//
	// Amazon Web Services will end support for Amazon ECS optimized AL2-optimized and
	// AL2-accelerated AMIs. Starting in January 2026, Batch will change the default
	// AMI for new Amazon ECS compute environments from Amazon Linux 2 to Amazon Linux
	// 2023. We recommend migrating Batch Amazon ECS compute environments to Amazon
	// Linux 2023 to maintain optimal performance and security. For more information on
	// upgrading from AL2 to AL2023, see [How to migrate from ECS AL2 to ECS AL2023]in the Batch User Guide.
	//
	// ECS_AL2 [Amazon Linux 2]: Default for all non-GPU instance families.
	//
	// ECS_AL2_NVIDIA [Amazon Linux 2 (GPU)]: Default for all GPU instance families (for example P4 and G4 )
	// and can be used for all non Amazon Web Services Graviton-based instance types.
	//
	// ECS_AL2023 [Amazon Linux 2023]: Batch supports Amazon Linux 2023.
	//
	// Amazon Linux 2023 does not support A1 instances.
	//
	// ECS_AL2023_NVIDIA [Amazon Linux 2023 (GPU)]: For all GPU instance families and can be used for all non
	// Amazon Web Services Graviton-based instance types.
	//
	// ECS_AL2023_NVIDIA doesn't support p3 and g3 instance types.
	//
	// EKS If the imageIdOverride parameter isn't specified, then a recent [Amazon EKS-optimized Amazon Linux 2023 AMI] ( EKS_AL2023
	// ) is used. If a new image type is specified in an update, but neither an imageId
	// nor a imageIdOverride parameter is specified, then the latest Amazon EKS
	// optimized AMI for that image type that Batch supports is used.
	//
	// Amazon Linux 2023 AMIs are the default on Batch for Amazon EKS.
	//
	// Amazon Web Services will end support for Amazon EKS AL2-optimized and
	// AL2-accelerated AMIs, starting 11/26/25. You can continue using Batch-provided
	// Amazon EKS optimized Amazon Linux 2 AMIs on your Amazon EKS compute environments
	// beyond the 11/26/25 end-of-support date, these compute environments will no
	// longer receive any new software updates, security patches, or bug fixes from
	// Amazon Web Services. For more information on upgrading from AL2 to AL2023, see [How to upgrade from EKS AL2 to EKS AL2023]
	// in the Batch User Guide.
	//
	// EKS_AL2 [Amazon Linux 2]: Used for non-GPU instance families.
	//
	// EKS_AL2_NVIDIA [Amazon Linux 2 (accelerated)]: Used for GPU instance families (for example, P4 and G4 ) and
	// can be used for all non Amazon Web Services Graviton-based instance types.
	//
	// EKS_AL2023 [Amazon Linux 2023]: Default for non-GPU instance families.
	//
	// Amazon Linux 2023 does not support A1 instances.
	//
	// EKS_AL2023_NVIDIA [Amazon Linux 2023 (accelerated)]: Default for GPU instance families and can be used for all
	// non Amazon Web Services Graviton-based instance types.
	//
	// [Amazon Linux 2023]: https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
	// [How to upgrade from EKS AL2 to EKS AL2023]: https://docs.aws.amazon.com/batch/latest/userguide/eks-migration-2023.html
	// [Amazon Linux 2 (GPU)]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami
	// [Amazon Linux 2023 (GPU)]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami
	// [Amazon Linux 2023 (accelerated)]: https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
	// [Amazon Linux 2 (accelerated)]: https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
	// [Amazon ECS-optimized Amazon Linux 2 AMI]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami
	// [Amazon Linux 2]: https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
	// [How to migrate from ECS AL2 to ECS AL2023]: https://docs.aws.amazon.com/batch/latest/userguide/ecs-migration-2023.html
	// [Amazon EKS-optimized Amazon Linux 2023 AMI]: https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
	//
	// This member is required.
	ImageType *string

	// The AMI ID used for instances launched in the compute environment that match
	// the image type. This setting overrides the imageId set in the computeResource
	// object.
	//
	// The AMI that you choose for a compute environment must match the architecture
	// of the instance types that you intend to use for that compute environment. For
	// example, if your compute environment uses A1 instance types, the compute
	// resource AMI that you choose must support ARM instances. Amazon ECS vends both
	// x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more
	// information, see [Amazon ECS-optimized Amazon Linux 2 AMI]in the Amazon Elastic Container Service Developer Guide.
	//
	// [Amazon ECS-optimized Amazon Linux 2 AMI]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html
	ImageIdOverride *string

	// The Kubernetes version for the compute environment. If you don't specify a
	// value, the latest version that Batch supports is used.
	ImageKubernetesVersion *string

	noSmithyDocumentSerde
}

// An object that contains the properties for the Amazon ECS resources of a job.
type EcsProperties struct {

	// An object that contains the properties for the Amazon ECS task definition of a
	// job.
	//
	// This object is currently limited to one task element. However, the task element
	// can run up to 10 containers.
	//
	// This member is required.
	TaskProperties []EcsTaskProperties

	noSmithyDocumentSerde
}

// An object that contains the details for the Amazon ECS resources of a job.
type EcsPropertiesDetail struct {

	// The properties for the Amazon ECS task definition of a job.
	TaskProperties []EcsTaskDetails

	noSmithyDocumentSerde
}

// An object that contains overrides for the Amazon ECS task definition of a job.
type EcsPropertiesOverride struct {

	// The overrides for the Amazon ECS task definition of a job.
	//
	// This object is currently limited to one element.
	TaskProperties []TaskPropertiesOverride

	noSmithyDocumentSerde
}

// The details of a task definition that describes the container and volume
// definitions of an Amazon ECS task.
type EcsTaskDetails struct {

	// The Amazon Resource Name (ARN) of the container instance that hosts the task.
	ContainerInstanceArn *string

	// A list of containers that are included in the taskProperties list.
	Containers []TaskContainerDetails

	// Determines whether execute command functionality is turned on for this task. If
	// true , execute command functionality is turned on all the containers in the task.
	EnableExecuteCommand *bool

	// The amount of ephemeral storage allocated for the task.
	EphemeralStorage *EphemeralStorage

	// The Amazon Resource Name (ARN) of the execution role that Batch can assume. For
	// more information, see [Batch execution IAM role]in the Batch User Guide.
	//
	// [Batch execution IAM role]: https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html
	ExecutionRoleArn *string

	// The IPC resource namespace to use for the containers in the task. The valid
	// values are host , task , or none . For more information see ipcMode in [EcsTaskProperties].
	//
	// [EcsTaskProperties]: https://docs.aws.amazon.com/batch/latest/APIReference/API_EcsTaskProperties.html
	IpcMode *string

	// The network configuration for jobs that are running on Fargate resources. Jobs
	// that are running on Amazon EC2 resources must not specify this parameter.
	NetworkConfiguration *NetworkConfiguration

	// The process namespace to use for the containers in the task. The valid values
	// are host , or task . For more information see pidMode in [EcsTaskProperties].
	//
	// [EcsTaskProperties]: https://docs.aws.amazon.com/batch/latest/APIReference/API_EcsTaskProperties.html
	PidMode *string

	// The Fargate platform version where the jobs are running.
	PlatformVersion *string

	// An object that represents the compute environment architecture for Batch jobs
	// on Fargate.
	RuntimePlatform *RuntimePlatform

	// The ARN of the Amazon ECS task.
	TaskArn *string

	// The Amazon Resource Name (ARN) of the IAM role that the container can assume
	// for Amazon Web Services permissions. For more information, see [IAM roles for tasks]in the Amazon
	// Elastic Container Service Developer Guide.
	//
	// This is object is comparable to [ContainerProperties:jobRoleArn].
	//
	// [ContainerProperties:jobRoleArn]: https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html
	// [IAM roles for tasks]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html
	TaskRoleArn *string

	// A list of data volumes used in a job.
	Volumes []Volume

	noSmithyDocumentSerde
}

// The properties for a task definition that describes the container and volume
// definitions of an Amazon ECS task. You can specify which Docker images to use,
// the required resources, and other configurations related to launching the task
// definition through an Amazon ECS service or task.
type EcsTaskProperties struct {

	// This object is a list of containers.
	//
	// This member is required.
	Containers []TaskContainerProperties

	// Determines whether execute command functionality is turned on for this task. If
	// true , execute command functionality is turned on all the containers in the task.
	EnableExecuteCommand *bool

	// The amount of ephemeral storage to allocate for the task. This parameter is
	// used to expand the total amount of ephemeral storage available, beyond the
	// default amount, for tasks hosted on Fargate.
	EphemeralStorage *EphemeralStorage

	// The Amazon Resource Name (ARN) of the execution role that Batch can assume. For
	// jobs that run on Fargate resources, you must provide an execution role. For more
	// information, see [Batch execution IAM role]in the Batch User Guide.
	//
	// [Batch execution IAM role]: https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html
	ExecutionRoleArn *string

	// The IPC resource namespace to use for the containers in the task. The valid
	// values are host , task , or none .
	//
	// If host is specified, all containers within the tasks that specified the host
	// IPC mode on the same container instance share the same IPC resources with the
	// host Amazon EC2 instance.
	//
	// If task is specified, all containers within the specified task share the same
	// IPC resources.
	//
	// If none is specified, the IPC resources within the containers of a task are
	// private, and are not shared with other containers in a task or on the container
	// instance.
	//
	// If no value is specified, then the IPC resource namespace sharing depends on
	// the Docker daemon setting on the container instance. For more information, see [IPC settings]
	// in the Docker run reference.
	//
	// [IPC settings]: https://docs.docker.com/engine/reference/run/#ipc-settings---ipc
	IpcMode *string

	// The network configuration for jobs that are running on Fargate resources. Jobs
	// that are running on Amazon EC2 resources must not specify this parameter.
	NetworkConfiguration *NetworkConfiguration

	// The process namespace to use for the containers in the task. The valid values
	// are host or task . For example, monitoring sidecars might need pidMode to
	// access information about other containers running in the same task.
	//
	// If host is specified, all containers within the tasks that specified the host
	// PID mode on the same container instance share the process namespace with the
	// host Amazon EC2 instance.
	//
	// If task is specified, all containers within the specified task share the same
	// process namespace.
	//
	// If no value is specified, the default is a private namespace for each
	// container. For more information, see [PID settings]in the Docker run reference.
	//
	// [PID settings]: https://docs.docker.com/engine/reference/run/#pid-settings---pid
	PidMode *string

	// The Fargate platform version where the jobs are running. A platform version is
	// specified only for jobs that are running on Fargate resources. If one isn't
	// specified, the LATEST platform version is used by default. This uses a recent,
	// approved version of the Fargate platform for compute resources. For more
	// information, see [Fargate platform versions]in the Amazon Elastic Container Service Developer Guide.
	//
	// [Fargate platform versions]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html
	PlatformVersion *string

	// An object that represents the compute environment architecture for Batch jobs
	// on Fargate.
	RuntimePlatform *RuntimePlatform

	// The Amazon Resource Name (ARN) that's associated with the Amazon ECS task.
	//
	// This is object is comparable to [ContainerProperties:jobRoleArn].
	//
	// [ContainerProperties:jobRoleArn]: https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html
	TaskRoleArn *string

	// A list of volumes that are associated with the job.
	Volumes []Volume

	noSmithyDocumentSerde
}

// The authorization configuration details for the Amazon EFS file system.
type EFSAuthorizationConfig struct {

	// The Amazon EFS access point ID to use. If an access point is specified, the
	// root directory value specified in the EFSVolumeConfiguration must either be
	// omitted or set to / which enforces the path set on the EFS access point. If an
	// access point is used, transit encryption must be enabled in the
	// EFSVolumeConfiguration . For more information, see [Working with Amazon EFS access points] in the Amazon Elastic File
	// System User Guide.
	//
	// [Working with Amazon EFS access points]: https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html
	AccessPointId *string

	// Whether or not to use the Batch job IAM role defined in a job definition when
	// mounting the Amazon EFS file system. If enabled, transit encryption must be
	// enabled in the EFSVolumeConfiguration . If this parameter is omitted, the
	// default value of DISABLED is used. For more information, see [Using Amazon EFS access points] in the Batch User
	// Guide. EFS IAM authorization requires that TransitEncryption be ENABLED and
	// that a JobRoleArn is specified.
	//
	// [Using Amazon EFS access points]: https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints
	Iam EFSAuthorizationConfigIAM

	noSmithyDocumentSerde
}

// This is used when you're using an Amazon Elastic File System file system for
// job storage. For more information, see [Amazon EFS Volumes]in the Batch User Guide.
//
// [Amazon EFS Volumes]: https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html
type EFSVolumeConfiguration struct {

	// The Amazon EFS file system ID to use.
	//
	// This member is required.
	FileSystemId *string

	// The authorization configuration details for the Amazon EFS file system.
	AuthorizationConfig *EFSAuthorizationConfig

	// The directory within the Amazon EFS file system to mount as the root directory
	// inside the host. If this parameter is omitted, the root of the Amazon EFS volume
	// is used instead. Specifying / has the same effect as omitting this parameter.
	// The maximum length is 4,096 characters.
	//
	// If an EFS access point is specified in the authorizationConfig , the root
	// directory parameter must either be omitted or set to / , which enforces the path
	// set on the Amazon EFS access point.
	RootDirectory *string

	// Determines whether to enable encryption for Amazon EFS data in transit between
	// the Amazon ECS host and the Amazon EFS server. Transit encryption must be
	// enabled if Amazon EFS IAM authorization is used. If this parameter is omitted,
	// the default value of DISABLED is used. For more information, see [Encrypting data in transit] in the Amazon
	// Elastic File System User Guide.
	//
	// [Encrypting data in transit]: https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html
	TransitEncryption EFSTransitEncryption

	// The port to use when sending encrypted data between the Amazon ECS host and the
	// Amazon EFS server. If you don't specify a transit encryption port, it uses the
	// port selection strategy that the Amazon EFS mount helper uses. The value must be
	// between 0 and 65,535. For more information, see [EFS mount helper]in the Amazon Elastic File
	// System User Guide.
	//
	// [EFS mount helper]: https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html
	TransitEncryptionPort *int32

	noSmithyDocumentSerde
}

// An object that represents the details for an attempt for a job attempt that an
// Amazon EKS container runs.
type EksAttemptContainerDetail struct {

	// The ID for the container.
	ContainerID *string

	// The exit code returned for the job attempt. A non-zero exit code is considered
	// failed.
	ExitCode *int32

	// The name of a container.
	Name *string

	// A short (255 max characters) human-readable string to provide additional
	// details for a running or stopped container.
	Reason *string

	noSmithyDocumentSerde
}

// An object that represents the details of a job attempt for a job attempt by an
// Amazon EKS container.
type EksAttemptDetail struct {

	// The details for the final status of the containers for this job attempt.
	Containers []EksAttemptContainerDetail

	// The Amazon Resource Name (ARN) of the Amazon EKS cluster.
	EksClusterArn *string

	// The details for the init containers.
	InitContainers []EksAttemptContainerDetail

	// The name of the node for this job attempt.
	NodeName *string

	// The name of the pod for this job attempt.
	PodName *string

	// The namespace of the Amazon EKS cluster that the pod exists in.
	PodNamespace *string

	// The Unix timestamp (in milliseconds) for when the attempt was started (when the
	// attempt transitioned from the STARTING state to the RUNNING state).
	StartedAt *int64

	// A short, human-readable string to provide additional details for the current
	// status of the job attempt.
	StatusReason *string

	// The Unix timestamp (in milliseconds) for when the attempt was stopped. This
	// happens when the attempt transitioned from the RUNNING state to a terminal
	// state, such as SUCCEEDED or FAILED .
	StoppedAt *int64

	noSmithyDocumentSerde
}

// Configuration for the Amazon EKS cluster that supports the Batch compute
// environment. The cluster must exist before the compute environment can be
// created.
type EksConfiguration struct {

	// The Amazon Resource Name (ARN) of the Amazon EKS cluster. An example is
	// arn:aws:eks:us-east-1:123456789012:cluster/ClusterForBatch .
	//
	// This member is required.
	EksClusterArn *string

	// The namespace of the Amazon EKS cluster. Batch manages pods in this namespace.
	// The value can't left empty or null. It must be fewer than 64 characters long,
	// can't be set to default , can't start with " kube- ," and must match this
	// regular expression: ^[a-z0-9]([-a-z0-9]*[a-z0-9])?$ . For more information, see [Namespaces]
	// in the Kubernetes documentation.
	//
	// [Namespaces]: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
	//
	// This member is required.
	KubernetesNamespace *string

	noSmithyDocumentSerde
}

// EKS container properties are used in job definitions for Amazon EKS based job
// definitions to describe the properties for a container node in the pod that's
// launched as part of a job. This can't be specified for Amazon ECS based job
// definitions.
type EksContainer struct {

	// The Docker image used to start the container.
	//
	// This member is required.
	Image *string

	// An array of arguments to the entrypoint. If this isn't specified, the CMD of
	// the container image is used. This corresponds to the args member in the [Entrypoint]
	// portion of the [Pod]in Kubernetes. Environment variable references are expanded
	// using the container's environment.
	//
	// If the referenced environment variable doesn't exist, the reference in the
	// command isn't changed. For example, if the reference is to " $(NAME1) " and the
	// NAME1 environment variable doesn't exist, the command string will remain "
	// $(NAME1) ." $$ is replaced with $ , and the resulting string isn't expanded. For
	// example, $$(VAR_NAME) is passed as $(VAR_NAME) whether or not the VAR_NAME
	// environment variable exists. For more information, see [Dockerfile reference: CMD]and [Define a command and arguments for a pod] in the Kubernetes
	// documentation.
	//
	// [Entrypoint]: https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint
	// [Pod]: https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/
	// [Dockerfile reference: CMD]: https://docs.docker.com/engine/reference/builder/#cmd
	// [Define a command and arguments for a pod]: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/
	Args []string

	// The entrypoint for the container. This isn't run within a shell. If this isn't
	// specified, the ENTRYPOINT of the container image is used. Environment variable
	// references are expanded using the container's environment.
	//
	// If the referenced environment variable doesn't exist, the reference in the
	// command isn't changed. For example, if the reference is to " $(NAME1) " and the
	// NAME1 environment variable doesn't exist, the command string will remain "
	// $(NAME1) ." $$ is replaced with $ and the resulting string isn't expanded. For
	// example, $$(VAR_NAME) will be passed as $(VAR_NAME) whether or not the VAR_NAME
	// environment variable exists. The entrypoint can't be updated. For more
	// information, see [ENTRYPOINT]in the Dockerfile reference and [Define a command and arguments for a container] and [Entrypoint] in the Kubernetes
	// documentation.
	//
	// [Define a command and arguments for a container]: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/
	// [Entrypoint]: https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint
	// [ENTRYPOINT]: https://docs.docker.com/engine/reference/builder/#entrypoint
	Command []string

	// The environment variables to pass to a container.
	//
	// Environment variables cannot start with " AWS_BATCH ". This naming convention is
	// reserved for variables that Batch sets.
	Env []EksContainerEnvironmentVariable

	// The image pull policy for the container. Supported values are Always ,
	// IfNotPresent , and Never . This parameter defaults to IfNotPresent . However, if
	// the :latest tag is specified, it defaults to Always . For more information, see [Updating images]
	// in the Kubernetes documentation.
	//
	// [Updating images]: https://kubernetes.io/docs/concepts/containers/images/#updating-images
	ImagePullPolicy *string

	// The name of the container. If the name isn't specified, the default name "
	// Default " is used. Each container in a pod must have a unique name.
	Name *string

	// The type and amount of resources to assign to a container. The supported
	// resources include memory , cpu , and nvidia.com/gpu . For more information, see [Resource management for pods and containers]
	// in the Kubernetes documentation.
	//
	// [Resource management for pods and containers]: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
	Resources *EksContainerResourceRequirements

	// The security context for a job. For more information, see [Configure a security context for a pod or container] in the Kubernetes
	// documentation.
	//
	// [Configure a security context for a pod or container]: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
	SecurityContext *EksContainerSecurityContext

	// The volume mounts for the container. Batch supports emptyDir , hostPath , and
	// secret volume types. For more information about volumes and volume mounts in
	// Kubernetes, see [Volumes]in the Kubernetes documentation.
	//
	// [Volumes]: https://kubernetes.io/docs/concepts/storage/volumes/
	VolumeMounts []EksContainerVolumeMount

	noSmithyDocumentSerde
}

// The details for container properties that are returned by DescribeJobs for jobs
// that use Amazon EKS.
type EksContainerDetail struct {

	// An array of arguments to the entrypoint. If this isn't specified, the CMD of
	// the container image is used. This corresponds to the args member in the [Entrypoint]
	// portion of the [Pod]in Kubernetes. Environment variable references are expanded
	// using the container's environment.
	//
	// If the referenced environment variable doesn't exist, the reference in the
	// command isn't changed. For example, if the reference is to " $(NAME1) " and the
	// NAME1 environment variable doesn't exist, the command string will remain "
	// $(NAME1) ". $$ is replaced with $ and the resulting string isn't expanded. For
	// example, $$(VAR_NAME) is passed as $(VAR_NAME) whether or not the VAR_NAME
	// environment variable exists. For more information, see [Dockerfile reference: CMD]and [Define a command and arguments for a pod] in the Kubernetes
	// documentation.
	//
	// [Entrypoint]: https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint
	// [Pod]: https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/
	// [Dockerfile reference: CMD]: https://docs.docker.com/engine/reference/builder/#cmd
	// [Define a command and arguments for a pod]: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/
	Args []string

	// The entrypoint for the container. For more information, see [Entrypoint] in the Kubernetes
	// documentation.
	//
	// [Entrypoint]: https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint
	Command []string

	// The environment variables to pass to a container.
	//
	// Environment variables cannot start with " AWS_BATCH ". This naming convention is
	// reserved for variables that Batch sets.
	Env []EksContainerEnvironmentVariable

	// The exit code returned for the job attempt. A non-zero exit code is considered
	// failed.
	ExitCode *int32

	// The Docker image used to start the container.
	Image *string

	// The image pull policy for the container. Supported values are Always ,
	// IfNotPresent , and Never . This parameter defaults to Always if the :latest tag
	// is specified, IfNotPresent otherwise. For more information, see [Updating images] in the
	// Kubernetes documentation.
	//
	// [Updating images]: https://kubernetes.io/docs/concepts/containers/images/#updating-images
	ImagePullPolicy *string

	// The name of the container. If the name isn't specified, the default name "
	// Default " is used. Each container in a pod must have a unique name.
	Name *string

	// A short human-readable string to provide additional details for a running or
	// stopped container. It can be up to 255 characters long.
	Reason *string

	// The type and amount of resources to assign to a container. The supported
	// resources include memory , cpu , and nvidia.com/gpu . For more information, see [Resource management for pods and containers]
	// in the Kubernetes documentation.
	//
	// [Resource management for pods and containers]: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
	Resources *EksContainerResourceRequirements

	// The security context for a job. For more information, see [Configure a security context for a pod or container] in the Kubernetes
	// documentation.
	//
	// [Configure a security context for a pod or container]: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
	SecurityContext *EksContainerSecurityContext

	// The volume mounts for the container. Batch supports emptyDir , hostPath , and
	// secret volume types. For more information about volumes and volume mounts in
	// Kubernetes, see [Volumes]in the Kubernetes documentation.
	//
	// [Volumes]: https://kubernetes.io/docs/concepts/storage/volumes/
	VolumeMounts []EksContainerVolumeMount

	noSmithyDocumentSerde
}

// An environment variable.
type EksContainerEnvironmentVariable struct {

	// The name of the environment variable.
	//
	// This member is required.
	Name *string

	// The value of the environment variable.
	Value *string

	noSmithyDocumentSerde
}

// Object representing any Kubernetes overrides to a job definition that's used in
// a [SubmitJob]API operation.
//
// [SubmitJob]: https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html
type EksContainerOverride struct {

	// The arguments to the entrypoint to send to the container that overrides the
	// default arguments from the Docker image or the job definition. For more
	// information, see [Dockerfile reference: CMD]and [Define a command an arguments for a pod] in the Kubernetes documentation.
	//
	// [Define a command an arguments for a pod]: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/
	// [Dockerfile reference: CMD]: https://docs.docker.com/engine/reference/builder/#cmd
	Args []string

	// The command to send to the container that overrides the default command from
	// the Docker image or the job definition.
	Command []string

	// The environment variables to send to the container. You can add new environment
	// variables, which are added to the container at launch. Or, you can override the
	// existing environment variables from the Docker image or the job definition.
	//
	// Environment variables cannot start with " AWS_BATCH ". This naming convention is
	// reserved for variables that Batch sets.
	Env []EksContainerEnvironmentVariable

	// The override of the Docker image that's used to start the container.
	Image *string

	// A pointer to the container that you want to override. The name must match a
	// unique container name that you wish to override.
	Name *string

	// The type and amount of resources to assign to a container. These override the
	// settings in the job definition. The supported resources include memory , cpu ,
	// and nvidia.com/gpu . For more information, see [Resource management for pods and containers] in the Kubernetes documentation.
	//
	// [Resource management for pods and containers]: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
	Resources *EksContainerResourceRequirements

	noSmithyDocumentSerde
}

// The type and amount of resources to assign to a container. The supported
// resources include memory , cpu , and nvidia.com/gpu . For more information, see [Resource management for pods and containers]
// in the Kubernetes documentation.
//
// [Resource management for pods and containers]: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
type EksContainerResourceRequirements struct {

	// The type and quantity of the resources to reserve for the container. The values
	// vary based on the name that's specified. Resources can be requested using
	// either the limits or the requests objects.
	//
	// memory The memory hard limit (in MiB) for the container, using whole integers,
	// with a "Mi" suffix. If your container attempts to exceed the memory specified,
	// the container is terminated. You must specify at least 4 MiB of memory for a
	// job. memory can be specified in limits , requests , or both. If memory is
	// specified in both places, then the value that's specified in limits must be
	// equal to the value that's specified in requests .
	//
	// To maximize your resource utilization, provide your jobs with as much memory as
	// possible for the specific instance type that you are using. To learn how, see [Memory management]
	// in the Batch User Guide.
	//
	// cpu The number of CPUs that's reserved for the container. Values must be an
	// even multiple of 0.25 . cpu can be specified in limits , requests , or both. If
	// cpu is specified in both places, then the value that's specified in limits must
	// be at least as large as the value that's specified in requests .
	//
	// nvidia.com/gpu The number of GPUs that's reserved for the container. Values
	// must be a whole integer. memory can be specified in limits , requests , or both.
	// If memory is specified in both places, then the value that's specified in limits
	// must be equal to the value that's specified in requests .
	//
	// [Memory management]: https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html
	Limits map[string]string

	// The type and quantity of the resources to request for the container. The values
	// vary based on the name that's specified. Resources can be requested by using
	// either the limits or the requests objects.
	//
	// memory The memory hard limit (in MiB) for the container, using whole integers,
	// with a "Mi" suffix. If your container attempts to exceed the memory specified,
	// the container is terminated. You must specify at least 4 MiB of memory for a
	// job. memory can be specified in limits , requests , or both. If memory is
	// specified in both, then the value that's specified in limits must be equal to
	// the value that's specified in requests .
	//
	// If you're trying to maximize your resource utilization by providing your jobs
	// as much memory as possible for a particular instance type, see [Memory management]in the Batch
	// User Guide.
	//
	// cpu The number of CPUs that are reserved for the container. Values must be an
	// even multiple of 0.25 . cpu can be specified in limits , requests , or both. If
	// cpu is specified in both, then the value that's specified in limits must be at
	// least as large as the value that's specified in requests .
	//
	// nvidia.com/gpu The number of GPUs that are reserved for the container. Values
	// must be a whole integer. nvidia.com/gpu can be specified in limits , requests ,
	// or both. If nvidia.com/gpu is specified in both, then the value that's
	// specified in limits must be equal to the value that's specified in requests .
	//
	// [Memory management]: https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html
	Requests map[string]string

	noSmithyDocumentSerde
}

// The security context for a job. For more information, see [Configure a security context for a pod or container] in the Kubernetes
// documentation.
//
// [Configure a security context for a pod or container]: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
type EksContainerSecurityContext struct {

	// Whether or not a container or a Kubernetes pod is allowed to gain more
	// privileges than its parent process. The default value is false .
	AllowPrivilegeEscalation *bool

	// When this parameter is true , the container is given elevated permissions on the
	// host container instance. The level of permissions are similar to the root user
	// permissions. The default value is false . This parameter maps to privileged
	// policy in the [Privileged pod security policies]in the Kubernetes documentation.
	//
	// [Privileged pod security policies]: https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged
	Privileged *bool

	// When this parameter is true , the container is given read-only access to its
	// root file system. The default value is false . This parameter maps to
	// ReadOnlyRootFilesystem policy in the [Volumes and file systems pod security policies] in the Kubernetes documentation.
	//
	// [Volumes and file systems pod security policies]: https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems
	ReadOnlyRootFilesystem *bool

	// When this parameter is specified, the container is run as the specified group
	// ID ( gid ). If this parameter isn't specified, the default is the group that's
	// specified in the image metadata. This parameter maps to RunAsGroup and MustRunAs
	// policy in the [Users and groups pod security policies]in the Kubernetes documentation.
	//
	// [Users and groups pod security policies]: https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups
	RunAsGroup *int64

	// When this parameter is specified, the container is run as a user with a uid
	// other than 0. If this parameter isn't specified, so such rule is enforced. This
	// parameter maps to RunAsUser and MustRunAsNonRoot policy in the [Users and groups pod security policies] in the
	// Kubernetes documentation.
	//
	// [Users and groups pod security policies]: https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups
	RunAsNonRoot *bool

	// When this parameter is specified, the container is run as the specified user ID
	// ( uid ). If this parameter isn't specified, the default is the user that's
	// specified in the image metadata. This parameter maps to RunAsUser and MustRanAs
	// policy in the [Users and groups pod security policies]in the Kubernetes documentation.
	//
	// [Users and groups pod security policies]: https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups
	RunAsUser *int64

	noSmithyDocumentSerde
}

// The volume mounts for a container for an Amazon EKS job. For more information
// about volumes and volume mounts in Kubernetes, see [Volumes]in the Kubernetes
// documentation.
//
// [Volumes]: https://kubernetes.io/docs/concepts/storage/volumes/
type EksContainerVolumeMount struct {

	// The path on the container where the volume is mounted.
	MountPath *string

	// The name the volume mount. This must match the name of one of the volumes in
	// the pod.
	Name *string

	// If this value is true , the container has read-only access to the volume.
	// Otherwise, the container can write to the volume. The default value is false .
	ReadOnly *bool

	// A sub-path inside the referenced volume instead of its root.
	SubPath *string

	noSmithyDocumentSerde
}

// Specifies the configuration of a Kubernetes emptyDir volume. An emptyDir volume
// is first created when a pod is assigned to a node. It exists as long as that pod
// is running on that node. The emptyDir volume is initially empty. All containers
// in the pod can read and write the files in the emptyDir volume. However, the
// emptyDir volume can be mounted at the same or different paths in each container.
// When a pod is removed from a node for any reason, the data in the emptyDir is
// deleted permanently. For more information, see [emptyDir]in the Kubernetes documentation.
//
// [emptyDir]: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir
type EksEmptyDir struct {

	// The medium to store the volume. The default value is an empty string, which
	// uses the storage of the node.
	//
	// ""  (Default) Use the disk storage of the node.
	//
	// "Memory" Use the tmpfs volume that's backed by the RAM of the node. Contents of
	// the volume are lost when the node reboots, and any storage on the volume counts
	// against the container's memory limit.
	Medium *string

	// The maximum size of the volume. By default, there's no maximum size defined.
	SizeLimit *string

	noSmithyDocumentSerde
}

// Specifies the configuration of a Kubernetes hostPath volume. A hostPath volume
// mounts an existing file or directory from the host node's filesystem into your
// pod. For more information, see [hostPath]in the Kubernetes documentation.
//
// [hostPath]: https://kubernetes.io/docs/concepts/storage/volumes/#hostpath
type EksHostPath struct {

	// The path of the file or directory on the host to mount into containers on the
	// pod.
	Path *string

	noSmithyDocumentSerde
}

// Describes and uniquely identifies Kubernetes resources. For example, the
// compute environment that a pod runs in or the jobID for a job running in the
// pod. For more information, see [Understanding Kubernetes Objects]in the Kubernetes documentation.
//
// [Understanding Kubernetes Objects]: https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/
type EksMetadata struct {

	// Key-value pairs used to attach arbitrary, non-identifying metadata to
	// Kubernetes objects. Valid annotation keys have two segments: an optional prefix
	// and a name, separated by a slash (/).
	//
	//   - The prefix is optional and must be 253 characters or less. If specified,
	//   the prefix must be a DNS subdomain− a series of DNS labels separated by dots
	//   (.), and it must end with a slash (/).
	//
	//   - The name segment is required and must be 63 characters or less. It can
	//   include alphanumeric characters ([a-z0-9A-Z]), dashes (-), underscores (_), and
	//   dots (.), but must begin and end with an alphanumeric character.
	//
	// Annotation values must be 255 characters or less.
	//
	// Annotations can be added or modified at any time. Each resource can have
	// multiple annotations.
	Annotations map[string]string

	// Key-value pairs used to identify, sort, and organize cube resources. Can
	// contain up to 63 uppercase letters, lowercase letters, numbers, hyphens (-), and
	// underscores (_). Labels can be added or modified at any time. Each resource can
	// have multiple labels, but each key must be unique for a given object.
	Labels map[string]string

	// The namespace of the Amazon EKS cluster. In Kubernetes, namespaces provide a
	// mechanism for isolating groups of resources within a single cluster. Names of
	// resources need to be unique within a namespace, but not across namespaces. Batch
	// places Batch Job pods in this namespace. If this field is provided, the value
	// can't be empty or null. It must meet the following requirements:
	//
	//   - 1-63 characters long
	//
	//   - Can't be set to default
	//
	//   - Can't start with kube
	//
	//   - Must match the following regular expression:
	//   ^[a-z0-9]([-a-z0-9]*[a-z0-9])?$
	//
	// For more information, see [Namespaces] in the Kubernetes documentation. This namespace can
	// be different from the kubernetesNamespace set in the compute environment's
	// EksConfiguration , but must have identical role-based access control (RBAC)
	// roles as the compute environment's kubernetesNamespace . For multi-node parallel
	// jobs, the same value must be provided across all the node ranges.
	//
	// [Namespaces]: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
	Namespace *string

	noSmithyDocumentSerde
}

// A persistentVolumeClaim volume is used to mount a [PersistentVolume] into a Pod.
// PersistentVolumeClaims are a way for users to "claim" durable storage without
// knowing the details of the particular cloud environment. See the information
// about [PersistentVolumes]in the Kubernetes documentation.
//
// [PersistentVolumes]: https://kubernetes.io/docs/concepts/storage/persistent-volumes/
// [PersistentVolume]: https://kubernetes.io/docs/concepts/storage/persistent-volumes/
type EksPersistentVolumeClaim struct {

	// The name of the persistentVolumeClaim bounded to a persistentVolume . For more
	// information, see [Persistent Volume Claims]in the Kubernetes documentation.
	//
	// [Persistent Volume Claims]: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims
	//
	// This member is required.
	ClaimName *string

	// An optional boolean value indicating if the mount is read only. Default is
	// false. For more information, see [Read Only Mounts]in the Kubernetes documentation.
	//
	// [Read Only Mounts]: https://kubernetes.io/docs/concepts/storage/volumes/#read-only-mounts
	ReadOnly *bool

	noSmithyDocumentSerde
}

// The properties for the pod.
type EksPodProperties struct {

	// The properties of the container that's used on the Amazon EKS pod.
	//
	// This object is limited to 10 elements.
	Containers []EksContainer

	// The DNS policy for the pod. The default value is ClusterFirst . If the
	// hostNetwork parameter is not specified, the default is ClusterFirstWithHostNet .
	// ClusterFirst indicates that any DNS query that does not match the configured
	// cluster domain suffix is forwarded to the upstream nameserver inherited from the
	// node. For more information, see [Pod's DNS policy]in the Kubernetes documentation.
	//
	// Valid values: Default | ClusterFirst | ClusterFirstWithHostNet
	//
	// [Pod's DNS policy]: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy
	DnsPolicy *string

	// Indicates if the pod uses the hosts' network IP address. The default value is
	// true . Setting this to false enables the Kubernetes pod networking model. Most
	// Batch workloads are egress-only and don't require the overhead of IP allocation
	// for each pod for incoming connections. For more information, see [Host namespaces]and [Pod networking] in the
	// Kubernetes documentation.
	//
	// [Pod networking]: https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking
	// [Host namespaces]: https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces
	HostNetwork *bool

	// References a Kubernetes secret resource. It holds a list of secrets. These
	// secrets help to gain access to pull an images from a private registry.
	//
	// ImagePullSecret$name is required when this object is used.
	ImagePullSecrets []ImagePullSecret

	// These containers run before application containers, always runs to completion,
	// and must complete successfully before the next container starts. These
	// containers are registered with the Amazon EKS Connector agent and persists the
	// registration information in the Kubernetes backend data store. For more
	// information, see [Init Containers]in the Kubernetes documentation.
	//
	// This object is limited to 10 elements.
	//
	// [Init Containers]: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
	InitContainers []EksContainer

	// Metadata about the Kubernetes pod. For more information, see [Understanding Kubernetes Objects] in the Kubernetes
	// documentation.
	//
	// [Understanding Kubernetes Objects]: https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/
	Metadata *EksMetadata

	// The name of the service account that's used to run the pod. For more
	// information, see [Kubernetes service accounts]and [Configure a Kubernetes service account to assume an IAM role] in the Amazon EKS User Guide and [Configure service accounts for pods] in the Kubernetes
	// documentation.
	//
	// [Kubernetes service accounts]: https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html
	// [Configure service accounts for pods]: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
	// [Configure a Kubernetes service account to assume an IAM role]: https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html
	ServiceAccountName *string

	// Indicates if the processes in a container are shared, or visible, to other
	// containers in the same pod. For more information, see [Share Process Namespace between Containers in a Pod].
	//
	// [Share Process Namespace between Containers in a Pod]: https://kubernetes.io/docs/tasks/configure-pod-container/share-process-namespace/
	ShareProcessNamespace *bool

	// Specifies the volumes for a job definition that uses Amazon EKS resources.
	Volumes []EksVolume

	noSmithyDocumentSerde
}

// The details for the pod.
type EksPodPropertiesDetail struct {

	// The properties of the container that's used on the Amazon EKS pod.
	Containers []EksContainerDetail

	// The DNS policy for the pod. The default value is ClusterFirst . If the
	// hostNetwork parameter is not specified, the default is ClusterFirstWithHostNet .
	// ClusterFirst indicates that any DNS query that does not match the configured
	// cluster domain suffix is forwarded to the upstream nameserver inherited from the
	// node. If no value was specified for dnsPolicy in the [RegisterJobDefinition] API operation, then no
	// value will be returned for dnsPolicy by either of [DescribeJobDefinitions] or [DescribeJobs] API operations. The pod
	// spec setting will contain either ClusterFirst or ClusterFirstWithHostNet ,
	// depending on the value of the hostNetwork parameter. For more information, see [Pod's DNS policy]
	// in the Kubernetes documentation.
	//
	// Valid values: Default | ClusterFirst | ClusterFirstWithHostNet
	//
	// [DescribeJobs]: https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobs.html
	// [RegisterJobDefinition]: https://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html
	// [DescribeJobDefinitions]: https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobDefinitions.html
	// [Pod's DNS policy]: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy
	DnsPolicy *string

	// Indicates if the pod uses the hosts' network IP address. The default value is
	// true . Setting this to false enables the Kubernetes pod networking model. Most
	// Batch workloads are egress-only and don't require the overhead of IP allocation
	// for each pod for incoming connections. For more information, see [Host namespaces]and [Pod networking] in the
	// Kubernetes documentation.
	//
	// [Pod networking]: https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking
	// [Host namespaces]: https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces
	HostNetwork *bool

	// Displays the reference pointer to the Kubernetes secret resource. These secrets
	// help to gain access to pull an images from a private registry.
	ImagePullSecrets []ImagePullSecret

	// The container registered with the Amazon EKS Connector agent and persists the
	// registration information in the Kubernetes backend data store.
	InitContainers []EksContainerDetail

	// Describes and uniquely identifies Kubernetes resources. For example, the
	// compute environment that a pod runs in or the jobID for a job running in the
	// pod. For more information, see [Understanding Kubernetes Objects]in the Kubernetes documentation.
	//
	// [Understanding Kubernetes Objects]: https://kubernetes.io/docs/concepts/overview/working-with-objects/kubernetes-objects/
	Metadata *EksMetadata

	// The name of the node for this job.
	NodeName *string

	// The name of the pod for this job.
	PodName *string

	// The name of the service account that's used to run the pod. For more
	// information, see [Kubernetes service accounts]and [Configure a Kubernetes service account to assume an IAM role] in the Amazon EKS User Guide and [Configure service accounts for pods] in the Kubernetes
	// documentation.
	//
	// [Kubernetes service accounts]: https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html
	// [Configure service accounts for pods]: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
	// [Configure a Kubernetes service account to assume an IAM role]: https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html
	ServiceAccountName *string

	// Indicates if the processes in a container are shared, or visible, to other
	// containers in the same pod. For more information, see [Share Process Namespace between Containers in a Pod].
	//
	// [Share Process Namespace between Containers in a Pod]: https://kubernetes.io/docs/tasks/configure-pod-container/share-process-namespace/
	ShareProcessNamespace *bool

	// Specifies the volumes for a job definition using Amazon EKS resources.
	Volumes []EksVolume

	noSmithyDocumentSerde
}

// An object that contains overrides for the Kubernetes pod properties of a job.
type EksPodPropertiesOverride struct {

	// The overrides for the container that's used on the Amazon EKS pod.
	Containers []EksContainerOverride

	// The overrides for the initContainers defined in the Amazon EKS pod. These
	// containers run before application containers, always run to completion, and must
	// complete successfully before the next container starts. These containers are
	// registered with the Amazon EKS Connector agent and persists the registration
	// information in the Kubernetes backend data store. For more information, see [Init Containers]in
	// the Kubernetes documentation.
	//
	// [Init Containers]: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
	InitContainers []EksContainerOverride

	// Metadata about the overrides for the container that's used on the Amazon EKS
	// pod.
	Metadata *EksMetadata

	noSmithyDocumentSerde
}

// An object that contains the properties for the Kubernetes resources of a job.
type EksProperties struct {

	// The properties for the Kubernetes pod resources of a job.
	PodProperties *EksPodProperties

	noSmithyDocumentSerde
}

// An object that contains the details for the Kubernetes resources of a job.
type EksPropertiesDetail struct {

	// The properties for the Kubernetes pod resources of a job.
	PodProperties *EksPodPropertiesDetail

	noSmithyDocumentSerde
}

// An object that contains overrides for the Kubernetes resources of a job.
type EksPropertiesOverride struct {

	// The overrides for the Kubernetes pod resources of a job.
	PodProperties *EksPodPropertiesOverride

	noSmithyDocumentSerde
}

// Specifies the configuration of a Kubernetes secret volume. For more
// information, see [secret]in the Kubernetes documentation.
//
// [secret]: https://kubernetes.io/docs/concepts/storage/volumes/#secret
type EksSecret struct {

	// The name of the secret. The name must be allowed as a DNS subdomain name. For
	// more information, see [DNS subdomain names]in the Kubernetes documentation.
	//
	// [DNS subdomain names]: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names
	//
	// This member is required.
	SecretName *string

	// Specifies whether the secret or the secret's keys must be defined.
	Optional *bool

	noSmithyDocumentSerde
}

// Specifies an Amazon EKS volume for a job definition.
type EksVolume struct {

	// The name of the volume. The name must be allowed as a DNS subdomain name. For
	// more information, see [DNS subdomain names]in the Kubernetes documentation.
	//
	// [DNS subdomain names]: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names
	//
	// This member is required.
	Name *string

	// Specifies the configuration of a Kubernetes emptyDir volume. For more
	// information, see [emptyDir]in the Kubernetes documentation.
	//
	// [emptyDir]: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir
	EmptyDir *EksEmptyDir

	// Specifies the configuration of a Kubernetes hostPath volume. For more
	// information, see [hostPath]in the Kubernetes documentation.
	//
	// [hostPath]: https://kubernetes.io/docs/concepts/storage/volumes/#hostpath
	HostPath *EksHostPath

	// Specifies the configuration of a Kubernetes persistentVolumeClaim bounded to a
	// persistentVolume . For more information, see [Persistent Volume Claims] in the Kubernetes documentation.
	//
	// [Persistent Volume Claims]: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#persistentvolumeclaims
	PersistentVolumeClaim *EksPersistentVolumeClaim

	// Specifies the configuration of a Kubernetes secret volume. For more
	// information, see [secret]in the Kubernetes documentation.
	//
	// [secret]: https://kubernetes.io/docs/concepts/storage/volumes/#secret
	Secret *EksSecret

	noSmithyDocumentSerde
}

// The amount of ephemeral storage to allocate for the task. This parameter is
// used to expand the total amount of ephemeral storage available, beyond the
// default amount, for tasks hosted on Fargate.
type EphemeralStorage struct {

	// The total amount, in GiB, of ephemeral storage to set for the task. The minimum
	// supported value is 21 GiB and the maximum supported value is 200 GiB.
	//
	// This member is required.
	SizeInGiB *int32

	noSmithyDocumentSerde
}

// Specifies an array of up to 5 conditions to be met, and an action to take ( RETRY
// or EXIT ) if all conditions are met. If none of the EvaluateOnExit conditions
// in a RetryStrategy match, then the job is retried.
type EvaluateOnExit struct {

	// Specifies the action to take if all of the specified conditions ( onStatusReason
	// , onReason , and onExitCode ) are met. The values aren't case sensitive.
	//
	// This member is required.
	Action RetryAction

	// Contains a glob pattern to match against the decimal representation of the
	// ExitCode returned for a job. The pattern can be up to 512 characters long. It
	// can contain only numbers, and can end with an asterisk (*) so that only the
	// start of the string needs to be an exact match.
	//
	// The string can contain up to 512 characters.
	OnExitCode *string

	// Contains a glob pattern to match against the Reason returned for a job. The
	// pattern can contain up to 512 characters. It can contain letters, numbers,
	// periods (.), colons (:), and white space (including spaces and tabs). It can
	// optionally end with an asterisk (*) so that only the start of the string needs
	// to be an exact match.
	OnReason *string

	// Contains a glob pattern to match against the StatusReason returned for a job.
	// The pattern can contain up to 512 characters. It can contain letters, numbers,
	// periods (.), colons (:), and white spaces (including spaces or tabs). It can
	// optionally end with an asterisk (*) so that only the start of the string needs
	// to be an exact match.
	OnStatusReason *string

	noSmithyDocumentSerde
}

// The fair-share scheduling policy details.
type FairsharePolicy struct {

	// A value used to reserve some of the available maximum vCPU for share
	// identifiers that aren't already used.
	//
	// The reserved ratio is (computeReservation/100)^ActiveFairShares  where
	// ActiveFairShares is the number of active share identifiers.
	//
	// For example, a computeReservation value of 50 indicates that Batch reserves 50%
	// of the maximum available vCPU if there's only one share identifier. It reserves
	// 25% if there are two share identifiers. It reserves 12.5% if there are three
	// share identifiers. A computeReservation value of 25 indicates that Batch should
	// reserve 25% of the maximum available vCPU if there's only one share identifier,
	// 6.25% if there are two fair share identifiers, and 1.56% if there are three
	// share identifiers.
	//
	// The minimum value is 0 and the maximum value is 99.
	ComputeReservation *int32

	// The amount of time (in seconds) to use to calculate a fair-share percentage for
	// each share identifier in use. A value of zero (0) indicates the default minimum
	// time window (600 seconds). The maximum supported value is 604800 (1 week).
	//
	// The decay allows for more recently run jobs to have more weight than jobs that
	// ran earlier. Consider adjusting this number if you have jobs that (on average)
	// run longer than ten minutes, or a large difference in job count or job run times
	// between share identifiers, and the allocation of resources doesn't meet your
	// needs.
	ShareDecaySeconds *int32

	// An array of SharedIdentifier objects that contain the weights for the share
	// identifiers for the fair-share policy. Share identifiers that aren't included
	// have a default weight of 1.0 .
	ShareDistribution []ShareAttributes

	noSmithyDocumentSerde
}

// The platform configuration for jobs that are running on Fargate resources. Jobs
// that run on Amazon EC2 resources must not specify this parameter.
type FargatePlatformConfiguration struct {

	// The Fargate platform version where the jobs are running. A platform version is
	// specified only for jobs that are running on Fargate resources. If one isn't
	// specified, the LATEST platform version is used by default. This uses a recent,
	// approved version of the Fargate platform for compute resources. For more
	// information, see [Fargate platform versions]in the Amazon Elastic Container Service Developer Guide.
	//
	// [Fargate platform versions]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html
	PlatformVersion *string

	noSmithyDocumentSerde
}

// The FireLens configuration for the container. This is used to specify and
// configure a log router for container logs. For more information, see [Custom log]routing in
// the Amazon Elastic Container Service Developer Guide.
//
// [Custom log]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html
type FirelensConfiguration struct {

	// The log router to use. The valid values are fluentd or fluentbit .
	//
	// This member is required.
	Type FirelensConfigurationType

	// The options to use when configuring the log router. This field is optional and
	// can be used to specify a custom configuration file or to add additional
	// metadata, such as the task, task definition, cluster, and container instance
	// details to the log event. If specified, the syntax to use is
	// "options":{"enable-ecs-log-metadata":"true|false","config-file-type:"s3|file","config-file-value":"arn:aws:s3:::mybucket/fluent.conf|filepath"}
	// . For more information, see [Creating a task definition that uses a FireLens configuration]in the Amazon Elastic Container Service Developer
	// Guide.
	//
	// [Creating a task definition that uses a FireLens configuration]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef
	Options map[string]string

	noSmithyDocumentSerde
}

// Contains a list of the first 100 RUNNABLE jobs associated to a single job queue.
type FrontOfQueueDetail struct {

	// The Amazon Resource Names (ARNs) of the first 100 RUNNABLE jobs in a named job
	// queue. For first-in-first-out (FIFO) job queues, jobs are ordered based on their
	// submission time. For fair-share scheduling (FSS) job queues, jobs are ordered
	// based on their job priority and share usage.
	Jobs []FrontOfQueueJobSummary

	// The Unix timestamp (in milliseconds) for when each of the first 100 RUNNABLE
	// jobs were last updated.
	LastUpdatedAt *int64

	noSmithyDocumentSerde
}

// An object that represents summary details for the first 100 RUNNABLE jobs in a
// job queue.
type FrontOfQueueJobSummary struct {

	// The Unix timestamp (in milliseconds) for when the job transitioned to its
	// current position in the job queue.
	EarliestTimeAtPosition *int64

	// The ARN for a job in a named job queue.
	JobArn *string

	noSmithyDocumentSerde
}

// Determine whether your data volume persists on the host container instance and
// where it's stored. If this parameter is empty, then the Docker daemon assigns a
// host path for your data volume. However, the data isn't guaranteed to persist
// after the containers that are associated with it stop running.
type Host struct {

	// The path on the host container instance that's presented to the container. If
	// this parameter is empty, then the Docker daemon has assigned a host path for
	// you. If this parameter contains a file location, then the data volume persists
	// at the specified location on the host container instance until you delete it
	// manually. If the source path location doesn't exist on the host container
	// instance, the Docker daemon creates it. If the location does exist, the contents
	// of the source path folder are exported.
	//
	// This parameter isn't applicable to jobs that run on Fargate resources. Don't
	// provide this for these jobs.
	SourcePath *string

	noSmithyDocumentSerde
}

// References a Kubernetes secret resource. This name of the secret must start and
// end with an alphanumeric character, is required to be lowercase, can include
// periods (.) and hyphens (-), and can't contain more than 253 characters.
type ImagePullSecret struct {

	// Provides a unique identifier for the ImagePullSecret . This object is required
	// when EksPodProperties$imagePullSecrets is used.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// An object that represents an Batch job definition.
type JobDefinition struct {

	// The Amazon Resource Name (ARN) for the job definition.
	//
	// This member is required.
	JobDefinitionArn *string

	// The name of the job definition.
	//
	// This member is required.
	JobDefinitionName *string

	// The revision of the job definition.
	//
	// This member is required.
	Revision *int32

	// The type of job definition. It's either container or multinode . If the job is
	// run on Fargate resources, then multinode isn't supported. For more information
	// about multi-node parallel jobs, see [Creating a multi-node parallel job definition]in the Batch User Guide.
	//
	// [Creating a multi-node parallel job definition]: https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html
	//
	// This member is required.
	Type *string

	// Contains a list of consumable resources required by the job.
	ConsumableResourceProperties *ConsumableResourceProperties

	// The orchestration type of the compute environment. The valid values are ECS
	// (default) or EKS .
	ContainerOrchestrationType OrchestrationType

	// An object with properties specific to Amazon ECS-based jobs. When
	// containerProperties is used in the job definition, it can't be used in addition
	// to eksProperties , ecsProperties , or nodeProperties .
	ContainerProperties *ContainerProperties

	// An object that contains the properties for the Amazon ECS resources of a
	// job.When ecsProperties is used in the job definition, it can't be used in
	// addition to containerProperties , eksProperties , or nodeProperties .
	EcsProperties *EcsProperties

	// An object with properties that are specific to Amazon EKS-based jobs. When
	// eksProperties is used in the job definition, it can't be used in addition to
	// containerProperties , ecsProperties , or nodeProperties .
	EksProperties *EksProperties

	// An object with properties that are specific to multi-node parallel jobs. When
	// nodeProperties is used in the job definition, it can't be used in addition to
	// containerProperties , ecsProperties , or eksProperties .
	//
	// If the job runs on Fargate resources, don't specify nodeProperties . Use
	// containerProperties instead.
	NodeProperties *NodeProperties

	// Default parameters or parameter substitution placeholders that are set in the
	// job definition. Parameters are specified as a key-value pair mapping. Parameters
	// in a SubmitJob request override any corresponding parameter defaults from the
	// job definition. For more information about specifying parameters, see [Job definition parameters]in the
	// Batch User Guide.
	//
	// [Job definition parameters]: https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html
	Parameters map[string]string

	// The platform capabilities required by the job definition. If no value is
	// specified, it defaults to EC2 . Jobs run on Fargate resources specify FARGATE .
	PlatformCapabilities []PlatformCapability

	// Specifies whether to propagate the tags from the job or job definition to the
	// corresponding Amazon ECS task. If no value is specified, the tags aren't
	// propagated. Tags can only be propagated to the tasks when the tasks are created.
	// For tags with the same name, job tags are given priority over job definitions
	// tags. If the total number of combined tags from the job and job definition is
	// over 50, the job is moved to the FAILED state.
	PropagateTags *bool

	// The retry strategy to use for failed jobs that are submitted with this job
	// definition.
	RetryStrategy *RetryStrategy

	// The scheduling priority of the job definition. This only affects jobs in job
	// queues with a fair-share policy. Jobs with a higher scheduling priority are
	// scheduled before jobs with a lower scheduling priority.
	SchedulingPriority *int32

	// The status of the job definition.
	Status *string

	// The tags that are applied to the job definition.
	Tags map[string]string

	// The timeout time for jobs that are submitted with this job definition. After
	// the amount of time you specify passes, Batch terminates your jobs if they aren't
	// finished.
	Timeout *JobTimeout

	noSmithyDocumentSerde
}

// An object that represents an Batch job dependency.
type JobDependency struct {

	// The job ID of the Batch job that's associated with this dependency.
	JobId *string

	// The type of the job dependency.
	Type ArrayJobDependency

	noSmithyDocumentSerde
}

// An object that represents an Batch job.
type JobDetail struct {

	// The Amazon Resource Name (ARN) of the job definition that this job uses.
	//
	// This member is required.
	JobDefinition *string

	// The job ID.
	//
	// This member is required.
	JobId *string

	// The job name.
	//
	// This member is required.
	JobName *string

	// The Amazon Resource Name (ARN) of the job queue that the job is associated with.
	//
	// This member is required.
	JobQueue *string

	// The Unix timestamp (in milliseconds) for when the job was started. More
	// specifically, it's when the job transitioned from the STARTING state to the
	// RUNNING state.
	//
	// This member is required.
	StartedAt *int64

	// The current status for the job.
	//
	// If your jobs don't progress to STARTING , see [Jobs stuck in RUNNABLE status] in the troubleshooting section
	// of the Batch User Guide.
	//
	// [Jobs stuck in RUNNABLE status]: https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable
	//
	// This member is required.
	Status JobStatus

	// The array properties of the job, if it's an array job.
	ArrayProperties *ArrayPropertiesDetail

	// A list of job attempts that are associated with this job.
	Attempts []AttemptDetail

	// Contains a list of consumable resources required by the job.
	ConsumableResourceProperties *ConsumableResourceProperties

	// An object that represents the details for the container that's associated with
	// the job. If the details are for a multiple-container job, this object will be
	// empty.
	Container *ContainerDetail

	// The Unix timestamp (in milliseconds) for when the job was created. For
	// non-array jobs and parent array jobs, this is when the job entered the SUBMITTED
	// state. This is specifically at the time [SubmitJob]was called. For array child jobs, this
	// is when the child job was spawned by its parent and entered the PENDING state.
	//
	// [SubmitJob]: https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html
	CreatedAt *int64

	// A list of job IDs that this job depends on.
	DependsOn []JobDependency

	// An object with properties that are specific to Amazon ECS-based jobs.
	EcsProperties *EcsPropertiesDetail

	// A list of job attempts that are associated with this job.
	EksAttempts []EksAttemptDetail

	// An object with various properties that are specific to Amazon EKS based jobs.
	EksProperties *EksPropertiesDetail

	// Indicates whether the job is canceled.
	IsCancelled *bool

	// Indicates whether the job is terminated.
	IsTerminated *bool

	// The Amazon Resource Name (ARN) of the job.
	JobArn *string

	// An object that represents the details of a node that's associated with a
	// multi-node parallel job.
	NodeDetails *NodeDetails

	// An object that represents the node properties of a multi-node parallel job.
	//
	// This isn't applicable to jobs that are running on Fargate resources.
	NodeProperties *NodeProperties

	// Additional parameters that are passed to the job that replace parameter
	// substitution placeholders or override any corresponding parameter defaults from
	// the job definition.
	Parameters map[string]string

	// The platform capabilities required by the job definition. If no value is
	// specified, it defaults to EC2 . Jobs run on Fargate resources specify FARGATE .
	PlatformCapabilities []PlatformCapability

	// Specifies whether to propagate the tags from the job or job definition to the
	// corresponding Amazon ECS task. If no value is specified, the tags aren't
	// propagated. Tags can only be propagated to the tasks when the tasks are created.
	// For tags with the same name, job tags are given priority over job definitions
	// tags. If the total number of combined tags from the job and job definition is
	// over 50, the job is moved to the FAILED state.
	PropagateTags *bool

	// The retry strategy to use for this job if an attempt fails.
	RetryStrategy *RetryStrategy

	// The scheduling policy of the job definition. This only affects jobs in job
	// queues with a fair-share policy. Jobs with a higher scheduling priority are
	// scheduled before jobs with a lower scheduling priority.
	SchedulingPriority *int32

	// The share identifier for the job.
	ShareIdentifier *string

	// A short, human-readable string to provide more details for the current status
	// of the job.
	//
	//   - CAPACITY:INSUFFICIENT_INSTANCE_CAPACITY - All compute environments have
	//   insufficient capacity to service the job.
	//
	//   - MISCONFIGURATION:COMPUTE_ENVIRONMENT_MAX_RESOURCE - All compute environments
	//   have a maxVcpu setting that is smaller than the job requirements.
	//
	//   - MISCONFIGURATION:JOB_RESOURCE_REQUIREMENT - All compute environments have no
	//   connected instances that meet the job requirements.
	//
	//   - MISCONFIGURATION:SERVICE_ROLE_PERMISSIONS - All compute environments have
	//   problems with the service role permissions.
	StatusReason *string

	// The Unix timestamp (in milliseconds) for when the job was stopped. More
	// specifically, it's when the job transitioned from the RUNNING state to a
	// terminal state, such as SUCCEEDED or FAILED .
	StoppedAt *int64

	// The tags that are applied to the job.
	Tags map[string]string

	// The timeout configuration for the job.
	Timeout *JobTimeout

	noSmithyDocumentSerde
}

// An object that represents the details for an Batch job queue.
type JobQueueDetail struct {

	// The compute environments that are attached to the job queue and the order that
	// job placement is preferred. Compute environments are selected for job placement
	// in ascending order.
	//
	// This member is required.
	ComputeEnvironmentOrder []ComputeEnvironmentOrder

	// The Amazon Resource Name (ARN) of the job queue.
	//
	// This member is required.
	JobQueueArn *string

	// The job queue name.
	//
	// This member is required.
	JobQueueName *string

	// The priority of the job queue. Job queue priority determines the order that job
	// queues are evaluated when multiple queues dispatch jobs within a shared compute
	// environment. A higher value for priority indicates a higher priority. Queues
	// are evaluated in cycles, in descending order by priority. For example, a job
	// queue with a priority value of 10 is evaluated before a queue with a priority
	// value of 1 . All of the compute environments must be either Amazon EC2 ( EC2 or
	// SPOT ) or Fargate ( FARGATE or FARGATE_SPOT ). Amazon EC2 and Fargate compute
	// environments can't be mixed.
	//
	// Job queue priority doesn't guarantee that a particular job executes before a
	// job in a lower priority queue. Jobs added to higher priority queues during the
	// queue evaluation cycle might not be evaluated until the next cycle. A job is
	// dispatched from a queue only if resources are available when the queue is
	// evaluated. If there are insufficient resources available at that time, the cycle
	// proceeds to the next queue. This means that jobs added to higher priority queues
	// might have to wait for jobs in multiple lower priority queues to complete before
	// they are dispatched. You can use job dependencies to control the order for jobs
	// from queues with different priorities. For more information, see [Job Dependencies]in the Batch
	// User Guide.
	//
	// [Job Dependencies]: https://docs.aws.amazon.com/batch/latest/userguide/job_dependencies.html
	//
	// This member is required.
	Priority *int32

	// Describes the ability of the queue to accept new jobs. If the job queue state
	// is ENABLED , it can accept jobs. If the job queue state is DISABLED , new jobs
	// can't be added to the queue, but jobs already in the queue can finish.
	//
	// This member is required.
	State JQState

	// The type of job queue. For service jobs that run on SageMaker Training, this
	// value is SAGEMAKER_TRAINING . For regular container jobs, this value is EKS ,
	// ECS , or ECS_FARGATE depending on the compute environment.
	JobQueueType JobQueueType

	// The set of actions that Batch perform on jobs that remain at the head of the
	// job queue in the specified state longer than specified times. Batch will perform
	// each action after maxTimeSeconds has passed.
	JobStateTimeLimitActions []JobStateTimeLimitAction

	// The Amazon Resource Name (ARN) of the scheduling policy. The format is
	// aws:Partition:batch:Region:Account:scheduling-policy/Name . For example,
	// aws:aws:batch:us-west-2:123456789012:scheduling-policy/MySchedulingPolicy .
	SchedulingPolicyArn *string

	// The order of the service environment associated with the job queue. Job queues
	// with a higher priority are evaluated first when associated with the same service
	// environment.
	ServiceEnvironmentOrder []ServiceEnvironmentOrder

	// The status of the job queue (for example, CREATING or VALID ).
	Status JQStatus

	// A short, human-readable string to provide additional details for the current
	// status of the job queue.
	StatusReason *string

	// The tags that are applied to the job queue. For more information, see [Tagging your Batch resources] in Batch
	// User Guide.
	//
	// [Tagging your Batch resources]: https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html
	Tags map[string]string

	noSmithyDocumentSerde
}

// Specifies an action that Batch will take after the job has remained at the head
// of the queue in the specified state for longer than the specified time.
type JobStateTimeLimitAction struct {

	// The action to take when a job is at the head of the job queue in the specified
	// state for the specified period of time. The only supported value is CANCEL ,
	// which will cancel the job.
	//
	// This member is required.
	Action JobStateTimeLimitActionsAction

	// The approximate amount of time, in seconds, that must pass with the job in the
	// specified state before the action is taken. The minimum value is 600 (10
	// minutes) and the maximum value is 86,400 (24 hours).
	//
	// This member is required.
	MaxTimeSeconds *int32

	// The reason to log for the action being taken.
	//
	// This member is required.
	Reason *string

	// The state of the job needed to trigger the action. The only supported value is
	// RUNNABLE .
	//
	// This member is required.
	State JobStateTimeLimitActionsState

	noSmithyDocumentSerde
}

// An object that represents summary details of a job.
type JobSummary struct {

	// The job ID.
	//
	// This member is required.
	JobId *string

	// The job name.
	//
	// This member is required.
	JobName *string

	// The array properties of the job, if it's an array job.
	ArrayProperties *ArrayPropertiesSummary

	// An object that represents the details of the container that's associated with
	// the job.
	Container *ContainerSummary

	// The Unix timestamp (in milliseconds) for when the job was created. For
	// non-array jobs and parent array jobs, this is when the job entered the SUBMITTED
	// state (at the time [SubmitJob]was called). For array child jobs, this is when the child
	// job was spawned by its parent and entered the PENDING state.
	//
	// [SubmitJob]: https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html
	CreatedAt *int64

	// The Amazon Resource Name (ARN) of the job.
	JobArn *string

	// The Amazon Resource Name (ARN) of the job definition.
	JobDefinition *string

	// The node properties for a single node in a job summary list.
	//
	// This isn't applicable to jobs that are running on Fargate resources.
	NodeProperties *NodePropertiesSummary

	// The Unix timestamp for when the job was started. More specifically, it's when
	// the job transitioned from the STARTING state to the RUNNING state.
	StartedAt *int64

	// The current status for the job.
	Status JobStatus

	// A short, human-readable string to provide more details for the current status
	// of the job.
	StatusReason *string

	// The Unix timestamp for when the job was stopped. More specifically, it's when
	// the job transitioned from the RUNNING state to a terminal state, such as
	// SUCCEEDED or FAILED .
	StoppedAt *int64

	noSmithyDocumentSerde
}

// An object that represents a job timeout configuration.
type JobTimeout struct {

	// The job timeout time (in seconds) that's measured from the job attempt's
	// startedAt timestamp. After this time passes, Batch terminates your jobs if they
	// aren't finished. The minimum value for the timeout is 60 seconds.
	//
	// For array jobs, the timeout applies to the child jobs, not to the parent array
	// job.
	//
	// For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not
	// to the individual nodes.
	AttemptDurationSeconds *int32

	noSmithyDocumentSerde
}

// A key-value pair object.
type KeyValuePair struct {

	// The name of the key-value pair. For environment variables, this is the name of
	// the environment variable.
	Name *string

	// The value of the key-value pair. For environment variables, this is the value
	// of the environment variable.
	Value *string

	noSmithyDocumentSerde
}

// A filter name and value pair that's used to return a more specific list of
// results from a ListJobs or ListJobsByConsumableResource API operation.
type KeyValuesPair struct {

	// The name of the filter. Filter names are case sensitive.
	Name *string

	// The filter values.
	Values []string

	noSmithyDocumentSerde
}

// Information about the latest attempt of a service job. A Service job can
// transition from SCHEDULED back to RUNNABLE state when they encounter capacity
// constraints.
type LatestServiceJobAttempt struct {

	// The service resource identifier associated with the service job attempt.
	ServiceResourceId *ServiceResourceId

	noSmithyDocumentSerde
}

// An object that represents a launch template that's associated with a compute
// resource. You must specify either the launch template ID or launch template name
// in the request, but not both.
//
// If security groups are specified using both the securityGroupIds parameter of
// CreateComputeEnvironment and the launch template, the values in the
// securityGroupIds parameter of CreateComputeEnvironment will be used.
//
// This object isn't applicable to jobs that are running on Fargate resources.
type LaunchTemplateSpecification struct {

	// The ID of the launch template.
	LaunchTemplateId *string

	// The name of the launch template.
	LaunchTemplateName *string

	// A launch template to use in place of the default launch template. You must
	// specify either the launch template ID or launch template name in the request,
	// but not both.
	//
	// You can specify up to ten (10) launch template overrides that are associated to
	// unique instance types or families for each compute environment.
	//
	// To unset all override templates for a compute environment, you can pass an
	// empty array to the [UpdateComputeEnvironment.overrides]parameter, or not include the overrides parameter when
	// submitting the UpdateComputeEnvironment API operation.
	//
	// [UpdateComputeEnvironment.overrides]: https://docs.aws.amazon.com/batch/latest/APIReference/API_UpdateComputeEnvironment.html
	Overrides []LaunchTemplateSpecificationOverride

	// The EKS node initialization process to use. You only need to specify this value
	// if you are using a custom AMI. The default value is EKS_BOOTSTRAP_SH . If
	// imageType is a custom AMI based on EKS_AL2023 or EKS_AL2023_NVIDIA then you must
	// choose EKS_NODEADM .
	UserdataType UserdataType

	// The version number of the launch template, $Default , or $Latest .
	//
	// If the value is $Default , the default version of the launch template is used.
	// If the value is $Latest , the latest version of the launch template is used.
	//
	// If the AMI ID that's used in a compute environment is from the launch template,
	// the AMI isn't changed when the compute environment is updated. It's only changed
	// if the updateToLatestImageVersion parameter for the compute environment is set
	// to true . During an infrastructure update, if either $Default or $Latest is
	// specified, Batch re-evaluates the launch template version, and it might use a
	// different version of the launch template. This is the case even if the launch
	// template isn't specified in the update. When updating a compute environment,
	// changing the launch template requires an infrastructure update of the compute
	// environment. For more information, see [Updating compute environments]in the Batch User Guide.
	//
	// Default: $Default
	//
	// Latest: $Latest
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	Version *string

	noSmithyDocumentSerde
}

// An object that represents a launch template to use in place of the default
// launch template. You must specify either the launch template ID or launch
// template name in the request, but not both.
//
// If security groups are specified using both the securityGroupIds parameter of
// CreateComputeEnvironment and the launch template, the values in the
// securityGroupIds parameter of CreateComputeEnvironment will be used.
//
// You can define up to ten (10) overrides for each compute environment.
//
// This object isn't applicable to jobs that are running on Fargate resources.
//
// To unset all override templates for a compute environment, you can pass an
// empty array to the [UpdateComputeEnvironment.overrides]parameter, or not include the overrides parameter when
// submitting the UpdateComputeEnvironment API operation.
//
// [UpdateComputeEnvironment.overrides]: https://docs.aws.amazon.com/batch/latest/APIReference/API_UpdateComputeEnvironment.html
type LaunchTemplateSpecificationOverride struct {

	// The ID of the launch template.
	//
	// Note: If you specify the launchTemplateId you can't specify the
	// launchTemplateName as well.
	LaunchTemplateId *string

	// The name of the launch template.
	//
	// Note: If you specify the launchTemplateName you can't specify the
	// launchTemplateId as well.
	LaunchTemplateName *string

	// The instance type or family that this override launch template should be
	// applied to.
	//
	// This parameter is required when defining a launch template override.
	//
	// Information included in this parameter must meet the following requirements:
	//
	//   - Must be a valid Amazon EC2 instance type or family.
	//
	//   - The following Batch InstanceTypes are not allowed: optimal , default_x86_64
	//   , and default_arm64 .
	//
	//   - targetInstanceTypes can target only instance types and families that are
	//   included within the [ComputeResource.instanceTypes]ComputeResource.instanceTypes set. targetInstanceTypes
	//   doesn't need to include all of the instances from the instanceType set, but at
	//   least a subset. For example, if ComputeResource.instanceTypes includes [m5,
	//   g5] , targetInstanceTypes can include [m5.2xlarge] and [m5.large] but not
	//   [c5.large] .
	//
	//   - targetInstanceTypes included within the same launch template override or
	//   across launch template overrides can't overlap for the same compute environment.
	//   For example, you can't define one launch template override to target an instance
	//   family and another define an instance type within this same family.
	//
	// [ComputeResource.instanceTypes]: https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-instanceTypes
	TargetInstanceTypes []string

	// The EKS node initialization process to use. You only need to specify this value
	// if you are using a custom AMI. The default value is EKS_BOOTSTRAP_SH . If
	// imageType is a custom AMI based on EKS_AL2023 or EKS_AL2023_NVIDIA then you must
	// choose EKS_NODEADM .
	UserdataType UserdataType

	// The version number of the launch template, $Default , or $Latest .
	//
	// If the value is $Default , the default version of the launch template is used.
	// If the value is $Latest , the latest version of the launch template is used.
	//
	// If the AMI ID that's used in a compute environment is from the launch template,
	// the AMI isn't changed when the compute environment is updated. It's only changed
	// if the updateToLatestImageVersion parameter for the compute environment is set
	// to true . During an infrastructure update, if either $Default or $Latest is
	// specified, Batch re-evaluates the launch template version, and it might use a
	// different version of the launch template. This is the case even if the launch
	// template isn't specified in the update. When updating a compute environment,
	// changing the launch template requires an infrastructure update of the compute
	// environment. For more information, see [Updating compute environments]in the Batch User Guide.
	//
	// Default: $Default
	//
	// Latest: $Latest
	//
	// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
	Version *string

	noSmithyDocumentSerde
}

// Linux-specific modifications that are applied to the container, such as details
// for device mappings.
type LinuxParameters struct {

	// Any of the host devices to expose to the container. This parameter maps to
	// Devices in the [Create a container] section of the [Docker Remote API] and the --device option to [docker run].
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't provide it for these jobs.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	Devices []Device

	// If true, run an init process inside the container that forwards signals and
	// reaps processes. This parameter maps to the --init option to [docker run]. This parameter
	// requires version 1.25 of the Docker Remote API or greater on your container
	// instance. To check the Docker Remote API version on your container instance, log
	// in to your container instance and run the following command: sudo docker
	// version | grep "Server API version"
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	InitProcessEnabled *bool

	// The total amount of swap memory (in MiB) a container can use. This parameter is
	// translated to the --memory-swap option to [docker run] where the value is the sum of the
	// container memory plus the maxSwap value. For more information, see [--memory-swap details]--memory-swap
	// in the Docker documentation.
	//
	// If a maxSwap value of 0 is specified, the container doesn't use swap. Accepted
	// values are 0 or any positive integer. If the maxSwap parameter is omitted, the
	// container doesn't use the swap configuration for the container instance on which
	// it runs. A maxSwap value must be set for the swappiness parameter to be used.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't provide it for these jobs.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [--memory-swap details]: https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details
	MaxSwap *int32

	// The value for the size (in MiB) of the /dev/shm volume. This parameter maps to
	// the --shm-size option to [docker run].
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't provide it for these jobs.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	SharedMemorySize *int32

	// You can use this parameter to tune a container's memory swappiness behavior. A
	// swappiness value of 0 causes swapping to not occur unless absolutely necessary.
	// A swappiness value of 100 causes pages to be swapped aggressively. Valid values
	// are whole numbers between 0 and 100 . If the swappiness parameter isn't
	// specified, a default value of 60 is used. If a value isn't specified for maxSwap
	// , then this parameter is ignored. If maxSwap is set to 0, the container doesn't
	// use swap. This parameter maps to the --memory-swappiness option to [docker run].
	//
	// Consider the following when you use a per-container swap configuration.
	//
	//   - Swap space must be enabled and allocated on the container instance for the
	//   containers to use.
	//
	// By default, the Amazon ECS optimized AMIs don't have swap enabled. You must
	//   enable swap on the instance to use this feature. For more information, see [Instance store swap volumes]in
	//   the Amazon EC2 User Guide for Linux Instances or [How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?]
	//
	//   - The swap space parameters are only supported for job definitions using EC2
	//   resources.
	//
	//   - If the maxSwap and swappiness parameters are omitted from a job definition,
	//   each container has a default swappiness value of 60. Moreover, the total swap
	//   usage is limited to two times the memory reservation of the container.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't provide it for these jobs.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Instance store swap volumes]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html
	// [How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?]: http://aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/
	Swappiness *int32

	// The container path, mount options, and size (in MiB) of the tmpfs mount. This
	// parameter maps to the --tmpfs option to [docker run].
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	// Don't provide this parameter for this resource type.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	Tmpfs []Tmpfs

	noSmithyDocumentSerde
}

// Current information about a consumable resource required by a job.
type ListJobsByConsumableResourceSummary struct {

	// Contains a list of consumable resources required by the job.
	//
	// This member is required.
	ConsumableResourceProperties *ConsumableResourceProperties

	// The Unix timestamp (in milliseconds) for when the consumable resource was
	// created.
	//
	// This member is required.
	CreatedAt *int64

	// The Amazon Resource Name (ARN) of the job.
	//
	// This member is required.
	JobArn *string

	// The name of the job.
	//
	// This member is required.
	JobName *string

	// The Amazon Resource Name (ARN) of the job queue.
	//
	// This member is required.
	JobQueueArn *string

	// The status of the job. Can be one of:
	//
	//   - SUBMITTED
	//
	//   - PENDING
	//
	//   - RUNNABLE
	//
	//   - STARTING
	//
	//   - RUNNING
	//
	//   - SUCCEEDED
	//
	//   - FAILED
	//
	// This member is required.
	JobStatus *string

	// The total amount of the consumable resource that is available.
	//
	// This member is required.
	Quantity *int64

	// The Amazon Resource Name (ARN) of the job definition.
	JobDefinitionArn *string

	// The fair-share scheduling policy identifier for the job.
	ShareIdentifier *string

	// The Unix timestamp for when the job was started. More specifically, it's when
	// the job transitioned from the STARTING state to the RUNNING state.
	StartedAt *int64

	// A short, human-readable string to provide more details for the current status
	// of the job.
	StatusReason *string

	noSmithyDocumentSerde
}

// Log configuration options to send to a custom log driver for the container.
type LogConfiguration struct {

	// The log driver to use for the container. The valid values that are listed for
	// this parameter are log drivers that the Amazon ECS container agent can
	// communicate with by default.
	//
	// The supported log drivers are awsfirelens , awslogs , fluentd , gelf , json-file
	// , journald , logentries , syslog , and splunk .
	//
	// Jobs that are running on Fargate resources are restricted to the awslogs and
	// splunk log drivers.
	//
	// awsfirelens Specifies the firelens logging driver. For more information on
	// configuring Firelens, see [Send Amazon ECS logs to an Amazon Web Services service or Amazon Web Services Partner]in the Amazon Elastic Container Service Developer
	// Guide.
	//
	// awslogs Specifies the Amazon CloudWatch Logs logging driver. For more
	// information, see [Using the awslogs log driver]in the Batch User Guide and [Amazon CloudWatch Logs logging driver] in the Docker documentation.
	//
	// fluentd Specifies the Fluentd logging driver. For more information including
	// usage and options, see [Fluentd logging driver]in the Docker documentation.
	//
	// gelf Specifies the Graylog Extended Format (GELF) logging driver. For more
	// information including usage and options, see [Graylog Extended Format logging driver]in the Docker documentation.
	//
	// journald Specifies the journald logging driver. For more information including
	// usage and options, see [Journald logging driver]in the Docker documentation.
	//
	// json-file Specifies the JSON file logging driver. For more information
	// including usage and options, see [JSON File logging driver]in the Docker documentation.
	//
	// splunk Specifies the Splunk logging driver. For more information including
	// usage and options, see [Splunk logging driver]in the Docker documentation.
	//
	// syslog Specifies the syslog logging driver. For more information including
	// usage and options, see [Syslog logging driver]in the Docker documentation.
	//
	// If you have a custom driver that's not listed earlier that you want to work
	// with the Amazon ECS container agent, you can fork the Amazon ECS container agent
	// project that's [available on GitHub]and customize it to work with that driver. We encourage you to
	// submit pull requests for changes that you want to have included. However, Amazon
	// Web Services doesn't currently support running modified copies of this software.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater on
	// your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version | grep "Server API version"
	//
	// [Journald logging driver]: https://docs.docker.com/config/containers/logging/journald/
	// [Syslog logging driver]: https://docs.docker.com/config/containers/logging/syslog/
	// [JSON File logging driver]: https://docs.docker.com/config/containers/logging/json-file/
	// [Splunk logging driver]: https://docs.docker.com/config/containers/logging/splunk/
	// [Send Amazon ECS logs to an Amazon Web Services service or Amazon Web Services Partner]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html
	// [Amazon CloudWatch Logs logging driver]: https://docs.docker.com/config/containers/logging/awslogs/
	// [available on GitHub]: https://github.com/aws/amazon-ecs-agent
	// [Using the awslogs log driver]: https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html
	// [Fluentd logging driver]: https://docs.docker.com/config/containers/logging/fluentd/
	// [Graylog Extended Format logging driver]: https://docs.docker.com/config/containers/logging/gelf/
	//
	// This member is required.
	LogDriver LogDriver

	// The configuration options to send to the log driver. This parameter requires
	// version 1.19 of the Docker Remote API or greater on your container instance. To
	// check the Docker Remote API version on your container instance, log in to your
	// container instance and run the following command: sudo docker version | grep
	// "Server API version"
	Options map[string]string

	// The secrets to pass to the log configuration. For more information, see [Specifying sensitive data] in the
	// Batch User Guide.
	//
	// [Specifying sensitive data]: https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html
	SecretOptions []Secret

	noSmithyDocumentSerde
}

// Details for a Docker volume mount point that's used in a job's container
// properties. This parameter maps to Volumes in the [Create a container] section of the Docker Remote
// API and the --volume option to docker run.
//
// [Create a container]: https://docs.docker.com/engine/api/v1.43/#tag/Container/operation/ContainerCreate
type MountPoint struct {

	// The path on the container where the host volume is mounted.
	ContainerPath *string

	// If this value is true , the container has read-only access to the volume.
	// Otherwise, the container can write to the volume. The default value is false .
	ReadOnly *bool

	// The name of the volume to mount.
	SourceVolume *string

	noSmithyDocumentSerde
}

// The network configuration for jobs that are running on Fargate resources. Jobs
// that are running on Amazon EC2 resources must not specify this parameter.
type NetworkConfiguration struct {

	// Indicates whether the job has a public IP address. For a job that's running on
	// Fargate resources in a private subnet to send outbound traffic to the internet
	// (for example, to pull container images), the private subnet requires a NAT
	// gateway be attached to route requests to the internet. For more information, see
	// [Amazon ECS task networking]in the Amazon Elastic Container Service Developer Guide. The default value is "
	// DISABLED ".
	//
	// [Amazon ECS task networking]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html
	AssignPublicIp AssignPublicIp

	noSmithyDocumentSerde
}

// An object that represents the elastic network interface for a multi-node
// parallel job node.
type NetworkInterface struct {

	// The attachment ID for the network interface.
	AttachmentId *string

	// The private IPv6 address for the network interface.
	Ipv6Address *string

	// The private IPv4 address for the network interface.
	PrivateIpv4Address *string

	noSmithyDocumentSerde
}

// An object that represents the details of a multi-node parallel job node.
type NodeDetails struct {

	// Specifies whether the current node is the main node for a multi-node parallel
	// job.
	IsMainNode *bool

	// The node index for the node. Node index numbering starts at zero. This index is
	// also available on the node with the AWS_BATCH_JOB_NODE_INDEX environment
	// variable.
	NodeIndex *int32

	noSmithyDocumentSerde
}

// An object that represents any node overrides to a job definition that's used in
// a [SubmitJob]API operation.
//
// This parameter isn't applicable to jobs that are running on Fargate resources.
// Don't provide it for these jobs. Rather, use containerOverrides instead.
//
// [SubmitJob]: https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html
type NodeOverrides struct {

	// The node property overrides for the job.
	NodePropertyOverrides []NodePropertyOverride

	// The number of nodes to use with a multi-node parallel job. This value overrides
	// the number of nodes that are specified in the job definition. To use this
	// override, you must meet the following conditions:
	//
	//   - There must be at least one node range in your job definition that has an
	//   open upper boundary, such as : or n: .
	//
	//   - The lower boundary of the node range that's specified in the job definition
	//   must be fewer than the number of nodes specified in the override.
	//
	//   - The main node index that's specified in the job definition must be fewer
	//   than the number of nodes specified in the override.
	NumNodes *int32

	noSmithyDocumentSerde
}

// An object that represents the node properties of a multi-node parallel job.
//
// Node properties can't be specified for Amazon EKS based job definitions.
type NodeProperties struct {

	// Specifies the node index for the main node of a multi-node parallel job. This
	// node index value must be fewer than the number of nodes.
	//
	// This member is required.
	MainNode *int32

	// A list of node ranges and their properties that are associated with a
	// multi-node parallel job.
	//
	// This member is required.
	NodeRangeProperties []NodeRangeProperty

	// The number of nodes that are associated with a multi-node parallel job.
	//
	// This member is required.
	NumNodes *int32

	noSmithyDocumentSerde
}

// An object that represents the properties of a node that's associated with a
// multi-node parallel job.
type NodePropertiesSummary struct {

	// Specifies whether the current node is the main node for a multi-node parallel
	// job.
	IsMainNode *bool

	// The node index for the node. Node index numbering begins at zero. This index is
	// also available on the node with the AWS_BATCH_JOB_NODE_INDEX environment
	// variable.
	NodeIndex *int32

	// The number of nodes that are associated with a multi-node parallel job.
	NumNodes *int32

	noSmithyDocumentSerde
}

// The object that represents any node overrides to a job definition that's used
// in a [SubmitJob]API operation.
//
// [SubmitJob]: https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html
type NodePropertyOverride struct {

	// The range of nodes, using node index values, that's used to override. A range
	// of 0:3 indicates nodes with index values of 0 through 3 . If the starting range
	// value is omitted ( :n ), then 0 is used to start the range. If the ending range
	// value is omitted ( n: ), then the highest possible node index is used to end the
	// range.
	//
	// This member is required.
	TargetNodes *string

	// An object that contains overrides for the consumable resources of a job.
	ConsumableResourcePropertiesOverride *ConsumableResourceProperties

	// The overrides that are sent to a node range.
	ContainerOverrides *ContainerOverrides

	// An object that contains the properties that you want to replace for the
	// existing Amazon ECS resources of a job.
	EcsPropertiesOverride *EcsPropertiesOverride

	// An object that contains the properties that you want to replace for the
	// existing Amazon EKS resources of a job.
	EksPropertiesOverride *EksPropertiesOverride

	// An object that contains the instance types that you want to replace for the
	// existing resources of a job.
	InstanceTypes []string

	noSmithyDocumentSerde
}

// This is an object that represents the properties of the node range for a
// multi-node parallel job.
type NodeRangeProperty struct {

	// The range of nodes, using node index values. A range of 0:3 indicates nodes
	// with index values of 0 through 3 . If the starting range value is omitted ( :n
	// ), then 0 is used to start the range. If the ending range value is omitted ( n:
	// ), then the highest possible node index is used to end the range. Your
	// accumulative node ranges must account for all nodes ( 0:n ). You can nest node
	// ranges (for example, 0:10 and 4:5 ). In this case, the 4:5 range properties
	// override the 0:10 properties.
	//
	// This member is required.
	TargetNodes *string

	// Contains a list of consumable resources required by a job.
	ConsumableResourceProperties *ConsumableResourceProperties

	// The container details for the node range.
	Container *ContainerProperties

	// This is an object that represents the properties of the node range for a
	// multi-node parallel job.
	EcsProperties *EcsProperties

	// This is an object that represents the properties of the node range for a
	// multi-node parallel job.
	EksProperties *EksProperties

	// The instance types of the underlying host infrastructure of a multi-node
	// parallel job.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources.
	//
	// In addition, this list object is currently limited to one element.
	InstanceTypes []string

	noSmithyDocumentSerde
}

// The repository credentials for private registry authentication.
type RepositoryCredentials struct {

	// The Amazon Resource Name (ARN) of the secret containing the private repository
	// credentials.
	//
	// This member is required.
	CredentialsParameter *string

	noSmithyDocumentSerde
}

// The type and amount of a resource to assign to a container. The supported
// resources include GPU , MEMORY , and VCPU .
type ResourceRequirement struct {

	// The type of resource to assign to a container. The supported resources include
	// GPU , MEMORY , and VCPU .
	//
	// This member is required.
	Type ResourceType

	// The quantity of the specified resource to reserve for the container. The values
	// vary based on the type specified.
	//
	// type="GPU" The number of physical GPUs to reserve for the container. Make sure
	// that the number of GPUs reserved for all containers in a job doesn't exceed the
	// number of available GPUs on the compute resource that the job is launched on.
	//
	// GPUs aren't available for jobs that are running on Fargate resources.
	//
	// type="MEMORY" The memory hard limit (in MiB) present to the container. This
	// parameter is supported for jobs that are running on Amazon EC2 resources. If
	// your container attempts to exceed the memory specified, the container is
	// terminated. This parameter maps to Memory in the [Create a container] section of the [Docker Remote API] and the
	// --memory option to [docker run]. You must specify at least 4 MiB of memory for a job. This
	// is required but can be specified in several places for multi-node parallel (MNP)
	// jobs. It must be specified for each node at least once. This parameter maps to
	// Memory in the [Create a container] section of the [Docker Remote API] and the --memory option to [docker run].
	//
	// If you're trying to maximize your resource utilization by providing your jobs
	// as much memory as possible for a particular instance type, see [Memory management]in the Batch
	// User Guide.
	//
	// For jobs that are running on Fargate resources, then value is the hard limit
	// (in MiB), and must match one of the supported values and the VCPU values must
	// be one of the values supported for that memory value.
	//
	// value = 512 VCPU = 0.25
	//
	// value = 1024 VCPU = 0.25 or 0.5
	//
	// value = 2048 VCPU = 0.25, 0.5, or 1
	//
	// value = 3072 VCPU = 0.5, or 1
	//
	// value = 4096 VCPU = 0.5, 1, or 2
	//
	// value = 5120, 6144, or 7168 VCPU = 1 or 2
	//
	// value = 8192 VCPU = 1, 2, or 4
	//
	// value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360 VCPU = 2 or 4
	//
	// value = 16384 VCPU = 2, 4, or 8
	//
	// value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696,
	// or 30720 VCPU = 4
	//
	// value = 20480, 24576, or 28672 VCPU = 4 or 8
	//
	// value = 36864, 45056, 53248, or 61440 VCPU = 8
	//
	// value = 32768, 40960, 49152, or 57344 VCPU = 8 or 16
	//
	// value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880 VCPU = 16
	//
	// type="VCPU" The number of vCPUs reserved for the container. This parameter maps
	// to CpuShares in the [Create a container] section of the [Docker Remote API] and the --cpu-shares option to [docker run]. Each vCPU
	// is equivalent to 1,024 CPU shares. For Amazon EC2 resources, you must specify at
	// least one vCPU. This is required but can be specified in several places; it must
	// be specified for each node at least once.
	//
	// The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For
	// more information about Fargate quotas, see [Fargate quotas]in the Amazon Web Services General
	// Reference.
	//
	// For jobs that are running on Fargate resources, then value must match one of
	// the supported values and the MEMORY values must be one of the values supported
	// for that VCPU value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16
	//
	// value = 0.25 MEMORY = 512, 1024, or 2048
	//
	// value = 0.5 MEMORY = 1024, 2048, 3072, or 4096
	//
	// value = 1 MEMORY = 2048, 3072, 4096, 5120, 6144, 7168, or 8192
	//
	// value = 2 MEMORY = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288,
	// 13312, 14336, 15360, or 16384
	//
	// value = 4 MEMORY = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384,
	// 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648,
	// 28672, 29696, or 30720
	//
	// value = 8 MEMORY = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056,
	// 49152, 53248, 57344, or 61440
	//
	// value = 16 MEMORY = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112,
	// 98304, 106496, 114688, or 122880
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Memory management]: https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	// [Fargate quotas]: https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The retry strategy that's associated with a job. For more information, see [Automated job retries] in
// the Batch User Guide.
//
// [Automated job retries]: https://docs.aws.amazon.com/batch/latest/userguide/job_retries.html
type RetryStrategy struct {

	// The number of times to move a job to the RUNNABLE status. You can specify
	// between 1 and 10 attempts. If the value of attempts is greater than one, the
	// job is retried on failure the same number of attempts as the value.
	Attempts *int32

	// Array of up to 5 objects that specify the conditions where jobs are retried or
	// failed. If this parameter is specified, then the attempts parameter must also
	// be specified. If none of the listed conditions match, then the job is retried.
	EvaluateOnExit []EvaluateOnExit

	noSmithyDocumentSerde
}

//	An object that represents the compute environment architecture for Batch jobs
//
// on Fargate.
type RuntimePlatform struct {

	// The vCPU architecture. The default value is X86_64 . Valid values are X86_64
	// and ARM64 .
	//
	// This parameter must be set to X86_64 for Windows containers.
	//
	// Fargate Spot is not supported on Windows-based containers on Fargate. A job
	// queue will be blocked if a Windows job is submitted to a job queue with only
	// Fargate Spot compute environments. However, you can attach both FARGATE and
	// FARGATE_SPOT compute environments to the same job queue.
	CpuArchitecture *string

	// The operating system for the compute environment. Valid values are: LINUX
	// (default), WINDOWS_SERVER_2019_CORE , WINDOWS_SERVER_2019_FULL ,
	// WINDOWS_SERVER_2022_CORE , and WINDOWS_SERVER_2022_FULL .
	//
	// The following parameters can’t be set for Windows containers: linuxParameters ,
	// privileged , user , ulimits , readonlyRootFilesystem , and
	// efsVolumeConfiguration .
	//
	// The Batch Scheduler checks the compute environments that are attached to the
	// job queue before registering a task definition with Fargate. In this scenario,
	// the job queue is where the job is submitted. If the job requires a Windows
	// container and the first compute environment is LINUX , the compute environment
	// is skipped and the next compute environment is checked until a Windows-based
	// compute environment is found.
	//
	// Fargate Spot is not supported on Windows-based containers on Fargate. A job
	// queue will be blocked if a Windows job is submitted to a job queue with only
	// Fargate Spot compute environments. However, you can attach both FARGATE and
	// FARGATE_SPOT compute environments to the same job queue.
	OperatingSystemFamily *string

	noSmithyDocumentSerde
}

// An object that represents a scheduling policy.
type SchedulingPolicyDetail struct {

	// The Amazon Resource Name (ARN) of the scheduling policy. An example is
	// arn:aws:batch:us-east-1:123456789012:scheduling-policy/HighPriority .
	//
	// This member is required.
	Arn *string

	// The name of the fair-share scheduling policy.
	//
	// This member is required.
	Name *string

	// The fair-share scheduling policy details.
	FairsharePolicy *FairsharePolicy

	// The tags that you apply to the fair-share scheduling policy to categorize and
	// organize your resources. Each tag consists of a key and an optional value. For
	// more information, see [Tagging Amazon Web Services resources]in Amazon Web Services General Reference.
	//
	// [Tagging Amazon Web Services resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	Tags map[string]string

	noSmithyDocumentSerde
}

// An object that contains the details of a scheduling policy that's returned in a
// ListSchedulingPolicy action.
type SchedulingPolicyListingDetail struct {

	// Amazon Resource Name (ARN) of the scheduling policy.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// An object that represents the secret to expose to your container. Secrets can
// be exposed to a container in the following ways:
//
//   - To inject sensitive data into your containers as environment variables, use
//     the secrets container definition parameter.
//
//   - To reference sensitive information in the log configuration of a container,
//     use the secretOptions container definition parameter.
//
// For more information, see [Specifying sensitive data] in the Batch User Guide.
//
// [Specifying sensitive data]: https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html
type Secret struct {

	// The name of the secret.
	//
	// This member is required.
	Name *string

	// The secret to expose to the container. The supported values are either the full
	// Amazon Resource Name (ARN) of the Secrets Manager secret or the full ARN of the
	// parameter in the Amazon Web Services Systems Manager Parameter Store.
	//
	// If the Amazon Web Services Systems Manager Parameter Store parameter exists in
	// the same Region as the job you're launching, then you can use either the full
	// Amazon Resource Name (ARN) or name of the parameter. If the parameter exists in
	// a different Region, then the full ARN must be specified.
	//
	// This member is required.
	ValueFrom *string

	noSmithyDocumentSerde
}

// Detailed information about a service environment, including its configuration,
// state, and capacity limits.
type ServiceEnvironmentDetail struct {

	// The capacity limits for the service environment. This defines the maximum
	// resources that can be used by service jobs in this environment.
	//
	// This member is required.
	CapacityLimits []CapacityLimit

	// The Amazon Resource Name (ARN) of the service environment.
	//
	// This member is required.
	ServiceEnvironmentArn *string

	// The name of the service environment.
	//
	// This member is required.
	ServiceEnvironmentName *string

	// The type of service environment. For SageMaker Training jobs, this value is
	// SAGEMAKER_TRAINING .
	//
	// This member is required.
	ServiceEnvironmentType ServiceEnvironmentType

	// The state of the service environment. Valid values are ENABLED and DISABLED .
	State ServiceEnvironmentState

	// The current status of the service environment.
	Status ServiceEnvironmentStatus

	// The tags associated with the service environment. Each tag consists of a key
	// and an optional value. For more information, see [Tagging your Batch resources].
	//
	// [Tagging your Batch resources]: https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html
	Tags map[string]string

	noSmithyDocumentSerde
}

// Specifies the order of a service environment for a job queue. This determines
// the priority order when multiple service environments are associated with the
// same job queue.
type ServiceEnvironmentOrder struct {

	// The order of the service environment. Job queues with a higher priority are
	// evaluated first when associated with the same service environment.
	//
	// This member is required.
	Order *int32

	// The name or ARN of the service environment.
	//
	// This member is required.
	ServiceEnvironment *string

	noSmithyDocumentSerde
}

// Detailed information about an attempt to run a service job.
type ServiceJobAttemptDetail struct {

	// The service resource identifier associated with the service job attempt.
	ServiceResourceId *ServiceResourceId

	// The Unix timestamp (in milliseconds) for when the service job attempt was
	// started.
	StartedAt *int64

	// A string that provides additional details for the current status of the service
	// job attempt.
	StatusReason *string

	// The Unix timestamp (in milliseconds) for when the service job attempt stopped
	// running.
	StoppedAt *int64

	noSmithyDocumentSerde
}

// Specifies conditions for when to exit or retry a service job based on the exit
// status or status reason.
type ServiceJobEvaluateOnExit struct {

	// The action to take if the service job exits with the specified condition. Valid
	// values are RETRY and EXIT .
	Action ServiceJobRetryAction

	// Contains a glob pattern to match against the StatusReason returned for a job.
	// The pattern can contain up to 512 characters and can contain all printable
	// characters. It can optionally end with an asterisk (*) so that only the start of
	// the string needs to be an exact match.
	OnStatusReason *string

	noSmithyDocumentSerde
}

// The retry strategy for service jobs. This defines how many times to retry a
// failed service job and under what conditions. For more information, see [Service job retry strategies]in the
// Batch User Guide.
//
// [Service job retry strategies]: https://docs.aws.amazon.com/batch/latest/userguide/service-job-retries.html
type ServiceJobRetryStrategy struct {

	// The number of times to move a service job to RUNNABLE status. You can specify
	// between 1 and 10 attempts.
	//
	// This member is required.
	Attempts *int32

	// Array of ServiceJobEvaluateOnExit objects that specify conditions under which
	// the service job should be retried or failed.
	EvaluateOnExit []ServiceJobEvaluateOnExit

	noSmithyDocumentSerde
}

// Summary information about a service job.
type ServiceJobSummary struct {

	// The job ID for the service job.
	//
	// This member is required.
	JobId *string

	// The name of the service job.
	//
	// This member is required.
	JobName *string

	// The type of service job. For SageMaker Training jobs, this value is
	// SAGEMAKER_TRAINING .
	//
	// This member is required.
	ServiceJobType ServiceJobType

	// The Unix timestamp (in milliseconds) for when the service job was created.
	CreatedAt *int64

	// The Amazon Resource Name (ARN) of the service job.
	JobArn *string

	// Information about the latest attempt for the service job.
	LatestAttempt *LatestServiceJobAttempt

	// The share identifier for the job.
	ShareIdentifier *string

	// The Unix timestamp (in milliseconds) for when the service job was started.
	StartedAt *int64

	// The current status of the service job.
	Status ServiceJobStatus

	// A short string to provide more details on the current status of the service job.
	StatusReason *string

	// The Unix timestamp (in milliseconds) for when the service job stopped running.
	StoppedAt *int64

	noSmithyDocumentSerde
}

// The timeout configuration for service jobs.
type ServiceJobTimeout struct {

	// The maximum duration in seconds that a service job attempt can run. After this
	// time is reached, Batch terminates the service job attempt.
	AttemptDurationSeconds *int32

	noSmithyDocumentSerde
}

// The Batch unique identifier.
type ServiceResourceId struct {

	// The name of the resource identifier.
	//
	// This member is required.
	Name ServiceResourceIdName

	// The value of the resource identifier.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Specifies the weights for the share identifiers for the fair-share policy.
// Share identifiers that aren't included have a default weight of 1.0 .
type ShareAttributes struct {

	// A share identifier or share identifier prefix. If the string ends with an
	// asterisk (*), this entry specifies the weight factor to use for share
	// identifiers that start with that prefix. The list of share identifiers in a
	// fair-share policy can't overlap. For example, you can't have one that specifies
	// a shareIdentifier of UserA* and another that specifies a shareIdentifier of
	// UserA1 .
	//
	// There can be no more than 500 share identifiers active in a job queue.
	//
	// The string is limited to 255 alphanumeric characters, and can be followed by an
	// asterisk (*).
	//
	// This member is required.
	ShareIdentifier *string

	// The weight factor for the share identifier. The default value is 1.0. A lower
	// value has a higher priority for compute resources. For example, jobs that use a
	// share identifier with a weight factor of 0.125 (1/8) get 8 times the compute
	// resources of jobs that use a share identifier with a weight factor of 1.
	//
	// The smallest supported value is 0.0001, and the largest supported value is
	// 999.9999.
	WeightFactor *float32

	noSmithyDocumentSerde
}

// A list of containers that this task depends on.
type TaskContainerDependency struct {

	// The dependency condition of the container. The following are the available
	// conditions and their behavior:
	//
	//   - START - This condition emulates the behavior of links and volumes today. It
	//   validates that a dependent container is started before permitting other
	//   containers to start.
	//
	//   - COMPLETE - This condition validates that a dependent container runs to
	//   completion (exits) before permitting other containers to start. This can be
	//   useful for nonessential containers that run a script and then exit. This
	//   condition can't be set on an essential container.
	//
	//   - SUCCESS - This condition is the same as COMPLETE , but it also requires that
	//   the container exits with a zero status. This condition can't be set on an
	//   essential container.
	Condition *string

	// A unique identifier for the container.
	ContainerName *string

	noSmithyDocumentSerde
}

// The details for the container in this task attempt.
type TaskContainerDetails struct {

	// The command that's passed to the container. This parameter maps to Cmd in the [Create a container]
	// section of the [Docker Remote API]and the COMMAND parameter to [docker run]. For more information, see [https://docs.docker.com/engine/reference/builder/#cmd].
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	// [https://docs.docker.com/engine/reference/builder/#cmd]: https://docs.docker.com/engine/reference/builder/#cmd
	Command []string

	// A list of containers that this container depends on.
	DependsOn []TaskContainerDependency

	// The environment variables to pass to a container. This parameter maps to Env in
	// the [Create a container]section of the [Docker Remote API] and the --env option to [docker run].
	//
	// We don't recommend using plaintext environment variables for sensitive
	// information, such as credential data.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	Environment []KeyValuePair

	// If the essential parameter of a container is marked as true , and that container
	// fails or stops for any reason, all other containers that are part of the task
	// are stopped. If the essential parameter of a container is marked as false, its
	// failure doesn't affect the rest of the containers in a task. If this parameter
	// is omitted, a container is assumed to be essential.
	//
	// All jobs must have at least one essential container. If you have an application
	// that's composed of multiple containers, group containers that are used for a
	// common purpose into components, and separate the different components into
	// multiple task definitions. For more information, see [Application Architecture]in the Amazon Elastic
	// Container Service Developer Guide.
	//
	// [Application Architecture]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html
	Essential *bool

	// The exit code returned upon completion.
	ExitCode *int32

	// The FireLens configuration for the container. This is used to specify and
	// configure a log router for container logs. For more information, see [Custom log]routing in
	// the Amazon Elastic Container Service Developer Guide.
	//
	// [Custom log]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html
	FirelensConfiguration *FirelensConfiguration

	// The image used to start a container. This string is passed directly to the
	// Docker daemon. By default, images in the Docker Hub registry are available.
	// Other repositories are specified with either repository-url/image:tag or
	// repository-url/image@digest . Up to 255 letters (uppercase and lowercase),
	// numbers, hyphens, underscores, colons, periods, forward slashes, and number
	// signs are allowed. This parameter maps to Image in the [Create a container] section of the [Docker Remote API] and the
	// IMAGE parameter of the [docker run].
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/#security-configuration
	// [Create a container]: https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.35/
	Image *string

	// Linux-specific modifications that are applied to the container, such as Linux
	// kernel capabilities. For more information, see [KernelCapabilities].
	//
	// This parameter is not supported for Windows containers.
	//
	// [KernelCapabilities]: https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html
	LinuxParameters *LinuxParameters

	// The log configuration specification for the container.
	//
	// This parameter maps to LogConfig in the [Create a container] section of the [Docker Remote API] and the --log-driver
	// option to [docker run].
	//
	// By default, containers use the same logging driver that the Docker daemon uses.
	// However the container can use a different logging driver than the Docker daemon
	// by specifying a log driver with this parameter in the container definition. To
	// use a different logging driver for a container, the log system must be
	// configured properly on the container instance (or on a different log server for
	// remote logging options). For more information about the options for different
	// supported log drivers, see [Configure logging drivers]in the Docker documentation.
	//
	// Amazon ECS currently supports a subset of the logging drivers available to the
	// Docker daemon (shown in the LogConfiguration data type). Additional log drivers
	// may be available in future releases of the Amazon ECS container agent.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater on
	// your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	//
	// The Amazon ECS container agent running on a container instance must register
	// the logging drivers available on that instance with the
	// ECS_AVAILABLE_LOGGING_DRIVERS environment variable before containers placed on
	// that instance can use these log configuration options. For more information, see
	// [Amazon ECS container agent configuration]in the Amazon Elastic Container Service Developer Guide.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/#security-configuration
	// [Create a container]: https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate
	// [Configure logging drivers]: https://docs.docker.com/engine/admin/logging/overview/
	// [Amazon ECS container agent configuration]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.35/
	LogConfiguration *LogConfiguration

	// The name of the CloudWatch Logs log stream that's associated with the
	// container. The log group for Batch jobs is /aws/batch/job. Each container
	// attempt receives a log stream name when they reach the RUNNING status.
	LogStreamName *string

	// The mount points for data volumes in your container.
	//
	// This parameter maps to Volumes in the [Create a container] section of the [Docker Remote API] and the --volume option to [docker run].
	//
	// Windows containers can mount whole directories on the same drive as
	// $env:ProgramData . Windows containers can't mount directories on a different
	// drive, and mount point can't be across drives.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/#security-configuration
	// [Create a container]: https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.35/
	MountPoints []MountPoint

	// The name of a container.
	Name *string

	// The network interfaces that are associated with the job.
	NetworkInterfaces []NetworkInterface

	// When this parameter is true , the container is given elevated privileges on the
	// host container instance (similar to the root user). This parameter maps to
	// Privileged in the [Create a container] section of the [Docker Remote API] and the --privileged option to [docker run].
	//
	// This parameter is not supported for Windows containers or tasks run on Fargate.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/#security-configuration
	// [Create a container]: https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.35/
	Privileged *bool

	// When this parameter is true, the container is given read-only access to its
	// root file system. This parameter maps to ReadonlyRootfs in the [Create a container] section of the [Docker Remote API]
	// and the --read-only option to [docker run].
	//
	// This parameter is not supported for Windows containers.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/#security-configuration
	// [Create a container]: https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.35/
	ReadonlyRootFilesystem *bool

	// A short (255 max characters) human-readable string to provide additional
	// details for a running or stopped container.
	Reason *string

	// The private repository authentication credentials to use.
	RepositoryCredentials *RepositoryCredentials

	// The type and amount of a resource to assign to a container. The only supported
	// resource is a GPU.
	ResourceRequirements []ResourceRequirement

	// The secrets to pass to the container. For more information, see [Specifying Sensitive Data] in the Amazon
	// Elastic Container Service Developer Guide.
	//
	// [Specifying Sensitive Data]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html
	Secrets []Secret

	// A list of ulimits to set in the container. If a ulimit value is specified in a
	// task definition, it overrides the default values set by Docker. This parameter
	// maps to Ulimits in the [Create a container] section of the [Docker Remote API] and the --ulimit option to [docker run].
	//
	// Amazon ECS tasks hosted on Fargate use the default resource limit values set by
	// the operating system with the exception of the nofile resource limit parameter
	// which Fargate overrides. The nofile resource limit sets a restriction on the
	// number of open files that a container can use. The default nofile soft limit is
	// 1024 and the default hard limit is 65535 .
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater on
	// your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	//
	// This parameter is not supported for Windows containers.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/#security-configuration
	// [Create a container]: https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.35/
	Ulimits []Ulimit

	// The user to use inside the container. This parameter maps to User in the Create
	// a container section of the Docker Remote API and the --user option to docker
	// run.
	//
	// When running tasks using the host network mode, don't run containers using the
	// root user (UID 0) . We recommend using a non-root user for better security.
	//
	// You can specify the user using the following formats. If specifying a UID or
	// GID, you must specify it as a positive integer.
	//
	//   - user
	//
	//   - user:group
	//
	//   - uid
	//
	//   - uid:gid
	//
	//   - user:gi
	//
	//   - uid:group
	//
	// This parameter is not supported for Windows containers.
	User *string

	noSmithyDocumentSerde
}

// The overrides that should be sent to a container.
//
// For information about using Batch overrides when you connect event sources to
// targets, see [BatchContainerOverrides].
//
// [BatchContainerOverrides]: https://docs.aws.amazon.com/eventbridge/latest/pipes-reference/API_BatchContainerOverrides.html
type TaskContainerOverrides struct {

	// The command to send to the container that overrides the default command from
	// the Docker image or the job definition.
	//
	// This parameter can't contain an empty string.
	Command []string

	// The environment variables to send to the container. You can add new environment
	// variables, which are added to the container at launch, or you can override the
	// existing environment variables from the Docker image or the job definition.
	//
	// Environment variables cannot start with AWS_BATCH . This naming convention is
	// reserved for variables that Batch sets.
	Environment []KeyValuePair

	// A pointer to the container that you want to override. The container's name
	// provides a unique identifier for the container being used.
	Name *string

	// The type and amount of resources to assign to a container. This overrides the
	// settings in the job definition. The supported resources include GPU , MEMORY ,
	// and VCPU .
	ResourceRequirements []ResourceRequirement

	noSmithyDocumentSerde
}

// Container properties are used for Amazon ECS-based job definitions. These
// properties to describe the container that's launched as part of a job.
type TaskContainerProperties struct {

	// The image used to start a container. This string is passed directly to the
	// Docker daemon. By default, images in the Docker Hub registry are available.
	// Other repositories are specified with either repository-url/image:tag or
	// repository-url/image@digest . Up to 255 letters (uppercase and lowercase),
	// numbers, hyphens, underscores, colons, periods, forward slashes, and number
	// signs are allowed. This parameter maps to Image in the [Create a container] section of the [Docker Remote API] and the
	// IMAGE parameter of the [docker run].
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/#security-configuration
	// [Create a container]: https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.35/
	//
	// This member is required.
	Image *string

	// The command that's passed to the container. This parameter maps to Cmd in the [Create a container]
	// section of the [Docker Remote API]and the COMMAND parameter to [docker run]. For more information, see [Dockerfile reference: CMD].
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Dockerfile reference: CMD]: https://docs.docker.com/engine/reference/builder/#cmd
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	Command []string

	// A list of containers that this container depends on.
	DependsOn []TaskContainerDependency

	// The environment variables to pass to a container. This parameter maps to Env in
	// the [Create a container]section of the [Docker Remote API] and the --env parameter to [docker run].
	//
	// We don't recommend using plaintext environment variables for sensitive
	// information, such as credential data.
	//
	// Environment variables cannot start with AWS_BATCH . This naming convention is
	// reserved for variables that Batch sets.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/
	// [Create a container]: https://docs.docker.com/engine/api/v1.23/#create-a-container
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.23/
	Environment []KeyValuePair

	// If the essential parameter of a container is marked as true , and that container
	// fails or stops for any reason, all other containers that are part of the task
	// are stopped. If the essential parameter of a container is marked as false, its
	// failure doesn't affect the rest of the containers in a task. If this parameter
	// is omitted, a container is assumed to be essential.
	//
	// All jobs must have at least one essential container. If you have an application
	// that's composed of multiple containers, group containers that are used for a
	// common purpose into components, and separate the different components into
	// multiple task definitions. For more information, see [Application Architecture]in the Amazon Elastic
	// Container Service Developer Guide.
	//
	// [Application Architecture]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html
	Essential *bool

	// The FireLens configuration for the container. This is used to specify and
	// configure a log router for container logs. For more information, see [Custom log]routing in
	// the Amazon Elastic Container Service Developer Guide.
	//
	// [Custom log]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html
	FirelensConfiguration *FirelensConfiguration

	// Linux-specific modifications that are applied to the container, such as Linux
	// kernel capabilities. For more information, see [KernelCapabilities].
	//
	// [KernelCapabilities]: https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html
	LinuxParameters *LinuxParameters

	// The log configuration specification for the container.
	//
	// This parameter maps to LogConfig in the [Create a container] section of the [Docker Remote API] and the --log-driver
	// option to [docker run].
	//
	// By default, containers use the same logging driver that the Docker daemon uses.
	// However the container can use a different logging driver than the Docker daemon
	// by specifying a log driver with this parameter in the container definition. To
	// use a different logging driver for a container, the log system must be
	// configured properly on the container instance (or on a different log server for
	// remote logging options). For more information about the options for different
	// supported log drivers, see [Configure logging drivers]in the Docker documentation.
	//
	// Amazon ECS currently supports a subset of the logging drivers available to the
	// Docker daemon (shown in the LogConfiguration data type). Additional log drivers
	// may be available in future releases of the Amazon ECS container agent.
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater on
	// your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	//
	// The Amazon ECS container agent running on a container instance must register
	// the logging drivers available on that instance with the
	// ECS_AVAILABLE_LOGGING_DRIVERS environment variable before containers placed on
	// that instance can use these log configuration options. For more information, see
	// [Amazon ECS container agent configuration]in the Amazon Elastic Container Service Developer Guide.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/#security-configuration
	// [Create a container]: https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate
	// [Configure logging drivers]: https://docs.docker.com/engine/admin/logging/overview/
	// [Amazon ECS container agent configuration]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.35/
	LogConfiguration *LogConfiguration

	// The mount points for data volumes in your container.
	//
	// This parameter maps to Volumes in the [Create a container] section of the [Docker Remote API] and the --volume option to [docker run].
	//
	// Windows containers can mount whole directories on the same drive as
	// $env:ProgramData . Windows containers can't mount directories on a different
	// drive, and mount point can't be across drives.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/#security-configuration
	// [Create a container]: https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.35/
	MountPoints []MountPoint

	// The name of a container. The name can be used as a unique identifier to target
	// your dependsOn and Overrides objects.
	Name *string

	// When this parameter is true , the container is given elevated privileges on the
	// host container instance (similar to the root user). This parameter maps to
	// Privileged in the [Create a container] section of the [Docker Remote API] and the --privileged option to [docker run].
	//
	// This parameter is not supported for Windows containers or tasks run on Fargate.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/#security-configuration
	// [Create a container]: https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.35/
	Privileged *bool

	// When this parameter is true, the container is given read-only access to its
	// root file system. This parameter maps to ReadonlyRootfs in the [Create a container] section of the [Docker Remote API]
	// and the --read-only option to [docker run].
	//
	// This parameter is not supported for Windows containers.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/#security-configuration
	// [Create a container]: https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.35/
	ReadonlyRootFilesystem *bool

	// The private repository authentication credentials to use.
	RepositoryCredentials *RepositoryCredentials

	// The type and amount of a resource to assign to a container. The only supported
	// resource is a GPU.
	ResourceRequirements []ResourceRequirement

	// The secrets to pass to the container. For more information, see [Specifying Sensitive Data] in the Amazon
	// Elastic Container Service Developer Guide.
	//
	// [Specifying Sensitive Data]: https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html
	Secrets []Secret

	// A list of ulimits to set in the container. If a ulimit value is specified in a
	// task definition, it overrides the default values set by Docker. This parameter
	// maps to Ulimits in the [Create a container] section of the [Docker Remote API] and the --ulimit option to [docker run].
	//
	// Amazon ECS tasks hosted on Fargate use the default resource limit values set by
	// the operating system with the exception of the nofile resource limit parameter
	// which Fargate overrides. The nofile resource limit sets a restriction on the
	// number of open files that a container can use. The default nofile soft limit is
	// 1024 and the default hard limit is 65535 .
	//
	// This parameter requires version 1.18 of the Docker Remote API or greater on
	// your container instance. To check the Docker Remote API version on your
	// container instance, log in to your container instance and run the following
	// command: sudo docker version --format '{{.Server.APIVersion}}'
	//
	// This parameter is not supported for Windows containers.
	//
	// [docker run]: https://docs.docker.com/engine/reference/run/#security-configuration
	// [Create a container]: https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate
	// [Docker Remote API]: https://docs.docker.com/engine/api/v1.35/
	Ulimits []Ulimit

	// The user to use inside the container. This parameter maps to User in the Create
	// a container section of the Docker Remote API and the --user option to docker
	// run.
	//
	// When running tasks using the host network mode, don't run containers using the
	// root user (UID 0) . We recommend using a non-root user for better security.
	//
	// You can specify the user using the following formats. If specifying a UID or
	// GID, you must specify it as a positive integer.
	//
	//   - user
	//
	//   - user:group
	//
	//   - uid
	//
	//   - uid:gid
	//
	//   - user:gi
	//
	//   - uid:group
	//
	// This parameter is not supported for Windows containers.
	User *string

	noSmithyDocumentSerde
}

// An object that contains overrides for the task definition of a job.
type TaskPropertiesOverride struct {

	// The overrides for the container definition of a job.
	Containers []TaskContainerOverrides

	noSmithyDocumentSerde
}

// The container path, mount options, and size of the tmpfs mount.
//
// This object isn't applicable to jobs that are running on Fargate resources.
type Tmpfs struct {

	// The absolute file path in the container where the tmpfs volume is mounted.
	//
	// This member is required.
	ContainerPath *string

	// The size (in MiB) of the tmpfs volume.
	//
	// This member is required.
	Size *int32

	// The list of tmpfs volume mount options.
	//
	// Valid values: " defaults " | " ro " | " rw " | " suid " | " nosuid " | " dev " |
	// " nodev " | " exec " | " noexec " | " sync " | " async " | " dirsync " | "
	// remount " | " mand " | " nomand " | " atime " | " noatime " | " diratime " | "
	// nodiratime " | " bind " | " rbind" | "unbindable" | "runbindable" | "private" |
	// "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime " | "
	// norelatime " | " strictatime " | " nostrictatime " | " mode " | " uid " | " gid
	// " | " nr_inodes " | " nr_blocks " | " mpol "
	MountOptions []string

	noSmithyDocumentSerde
}

// The ulimit settings to pass to the container. For more information, see [Ulimit].
//
// This object isn't applicable to jobs that are running on Fargate resources.
//
// [Ulimit]: https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_Ulimit.html
type Ulimit struct {

	// The hard limit for the ulimit type.
	//
	// This member is required.
	HardLimit *int32

	// The type of the ulimit . Valid values are: core | cpu | data | fsize | locks |
	// memlock | msgqueue | nice | nofile | nproc | rss | rtprio | rttime | sigpending
	// | stack .
	//
	// This member is required.
	Name *string

	// The soft limit for the ulimit type.
	//
	// This member is required.
	SoftLimit *int32

	noSmithyDocumentSerde
}

// Specifies the infrastructure update policy for the Amazon EC2 compute
// environment. For more information about infrastructure updates, see [Updating compute environments]in the
// Batch User Guide.
//
// [Updating compute environments]: https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html
type UpdatePolicy struct {

	// Specifies the job timeout (in minutes) when the compute environment
	// infrastructure is updated. The default value is 30.
	JobExecutionTimeoutMinutes *int64

	// Specifies whether jobs are automatically terminated when the compute
	// environment infrastructure is updated. The default value is false .
	TerminateJobsOnUpdate *bool

	noSmithyDocumentSerde
}

// A data volume that's used in a job's container properties.
type Volume struct {

	// This parameter is specified when you're using an Amazon Elastic File System
	// file system for job storage. Jobs that are running on Fargate resources must
	// specify a platformVersion of at least 1.4.0 .
	EfsVolumeConfiguration *EFSVolumeConfiguration

	// The contents of the host parameter determine whether your data volume persists
	// on the host container instance and where it's stored. If the host parameter is
	// empty, then the Docker daemon assigns a host path for your data volume. However,
	// the data isn't guaranteed to persist after the containers that are associated
	// with it stop running.
	//
	// This parameter isn't applicable to jobs that are running on Fargate resources
	// and shouldn't be provided.
	Host *Host

	// The name of the volume. It can be up to 255 characters long. It can contain
	// uppercase and lowercase letters, numbers, hyphens (-), and underscores (_). This
	// name is referenced in the sourceVolume parameter of container definition
	// mountPoints .
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
