// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Create Compute Savings Plans, EC2 Instance Savings Plans, or EC2 Reserved
//
// Instances commitments that you want to model in a Bill Scenario.
//
// The BatchCreateBillScenarioCommitmentModification operation doesn't have its
// own IAM permission. To authorize this operation for Amazon Web Services
// principals, include the permission
// bcm-pricing-calculator:CreateBillScenarioCommitmentModification in your policies.
func (c *Client) BatchCreateBillScenarioCommitmentModification(ctx context.Context, params *BatchCreateBillScenarioCommitmentModificationInput, optFns ...func(*Options)) (*BatchCreateBillScenarioCommitmentModificationOutput, error) {
	if params == nil {
		params = &BatchCreateBillScenarioCommitmentModificationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchCreateBillScenarioCommitmentModification", params, optFns, c.addOperationBatchCreateBillScenarioCommitmentModificationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchCreateBillScenarioCommitmentModificationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchCreateBillScenarioCommitmentModificationInput struct {

	//  The ID of the Bill Scenario for which you want to create the modeled
	// commitment.
	//
	// This member is required.
	BillScenarioId *string

	//  List of commitments that you want to model in the Bill Scenario.
	//
	// This member is required.
	CommitmentModifications []types.BatchCreateBillScenarioCommitmentModificationEntry

	//  A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string

	noSmithyDocumentSerde
}

type BatchCreateBillScenarioCommitmentModificationOutput struct {

	//  Returns the list of errors reason and the commitment item keys that cannot be
	// created in the Bill Scenario.
	Errors []types.BatchCreateBillScenarioCommitmentModificationError

	//  Returns the list of successful commitment line items that were created for the
	// Bill Scenario.
	Items []types.BatchCreateBillScenarioCommitmentModificationItem

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchCreateBillScenarioCommitmentModificationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpBatchCreateBillScenarioCommitmentModification{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpBatchCreateBillScenarioCommitmentModification{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchCreateBillScenarioCommitmentModification"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opBatchCreateBillScenarioCommitmentModificationMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpBatchCreateBillScenarioCommitmentModificationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchCreateBillScenarioCommitmentModification(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpBatchCreateBillScenarioCommitmentModification struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpBatchCreateBillScenarioCommitmentModification) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpBatchCreateBillScenarioCommitmentModification) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*BatchCreateBillScenarioCommitmentModificationInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *BatchCreateBillScenarioCommitmentModificationInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opBatchCreateBillScenarioCommitmentModificationMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpBatchCreateBillScenarioCommitmentModification{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opBatchCreateBillScenarioCommitmentModification(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchCreateBillScenarioCommitmentModification",
	}
}
