// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Create Amazon Web Services service usage that you want to model in a Workload
//
// Estimate.
//
// The BatchCreateWorkloadEstimateUsage operation doesn't have its own IAM
// permission. To authorize this operation for Amazon Web Services principals,
// include the permission bcm-pricing-calculator:CreateWorkloadEstimateUsage in
// your policies.
func (c *Client) BatchCreateWorkloadEstimateUsage(ctx context.Context, params *BatchCreateWorkloadEstimateUsageInput, optFns ...func(*Options)) (*BatchCreateWorkloadEstimateUsageOutput, error) {
	if params == nil {
		params = &BatchCreateWorkloadEstimateUsageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchCreateWorkloadEstimateUsage", params, optFns, c.addOperationBatchCreateWorkloadEstimateUsageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchCreateWorkloadEstimateUsageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchCreateWorkloadEstimateUsageInput struct {

	//  List of usage that you want to model in the Workload estimate.
	//
	// This member is required.
	Usage []types.BatchCreateWorkloadEstimateUsageEntry

	//  The ID of the Workload estimate for which you want to create the modeled
	// usage.
	//
	// This member is required.
	WorkloadEstimateId *string

	//  A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string

	noSmithyDocumentSerde
}

type BatchCreateWorkloadEstimateUsageOutput struct {

	//  Returns the list of errors reason and the usage item keys that cannot be
	// created in the Workload estimate.
	Errors []types.BatchCreateWorkloadEstimateUsageError

	//  Returns the list of successful usage line items that were created for the
	// Workload estimate.
	Items []types.BatchCreateWorkloadEstimateUsageItem

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchCreateWorkloadEstimateUsageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpBatchCreateWorkloadEstimateUsage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpBatchCreateWorkloadEstimateUsage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchCreateWorkloadEstimateUsage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opBatchCreateWorkloadEstimateUsageMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpBatchCreateWorkloadEstimateUsageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchCreateWorkloadEstimateUsage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpBatchCreateWorkloadEstimateUsage struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpBatchCreateWorkloadEstimateUsage) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpBatchCreateWorkloadEstimateUsage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*BatchCreateWorkloadEstimateUsageInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *BatchCreateWorkloadEstimateUsageInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opBatchCreateWorkloadEstimateUsageMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpBatchCreateWorkloadEstimateUsage{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opBatchCreateWorkloadEstimateUsage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchCreateWorkloadEstimateUsage",
	}
}
