// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Update a newly added or existing commitment. You can update the commitment
//
// group based on a commitment ID and a Bill scenario ID.
//
// The BatchUpdateBillScenarioCommitmentModification operation doesn't have its
// own IAM permission. To authorize this operation for Amazon Web Services
// principals, include the permission
// bcm-pricing-calculator:UpdateBillScenarioCommitmentModification in your policies.
func (c *Client) BatchUpdateBillScenarioCommitmentModification(ctx context.Context, params *BatchUpdateBillScenarioCommitmentModificationInput, optFns ...func(*Options)) (*BatchUpdateBillScenarioCommitmentModificationOutput, error) {
	if params == nil {
		params = &BatchUpdateBillScenarioCommitmentModificationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchUpdateBillScenarioCommitmentModification", params, optFns, c.addOperationBatchUpdateBillScenarioCommitmentModificationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchUpdateBillScenarioCommitmentModificationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchUpdateBillScenarioCommitmentModificationInput struct {

	//  The ID of the Bill Scenario for which you want to modify the commitment group
	// of a modeled commitment.
	//
	// This member is required.
	BillScenarioId *string

	//  List of commitments that you want to update in a Bill Scenario.
	//
	// This member is required.
	CommitmentModifications []types.BatchUpdateBillScenarioCommitmentModificationEntry

	noSmithyDocumentSerde
}

type BatchUpdateBillScenarioCommitmentModificationOutput struct {

	//  Returns the list of error reasons and commitment line item IDs that could not
	// be updated for the Bill Scenario.
	Errors []types.BatchUpdateBillScenarioCommitmentModificationError

	//  Returns the list of successful commitment line items that were updated for a
	// Bill Scenario.
	Items []types.BillScenarioCommitmentModificationItem

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchUpdateBillScenarioCommitmentModificationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpBatchUpdateBillScenarioCommitmentModification{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpBatchUpdateBillScenarioCommitmentModification{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchUpdateBillScenarioCommitmentModification"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpBatchUpdateBillScenarioCommitmentModificationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchUpdateBillScenarioCommitmentModification(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchUpdateBillScenarioCommitmentModification(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchUpdateBillScenarioCommitmentModification",
	}
}
