// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing workload estimate.
func (c *Client) UpdateWorkloadEstimate(ctx context.Context, params *UpdateWorkloadEstimateInput, optFns ...func(*Options)) (*UpdateWorkloadEstimateOutput, error) {
	if params == nil {
		params = &UpdateWorkloadEstimateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateWorkloadEstimate", params, optFns, c.addOperationUpdateWorkloadEstimateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateWorkloadEstimateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateWorkloadEstimateInput struct {

	//  The unique identifier of the workload estimate to update.
	//
	// This member is required.
	Identifier *string

	//  The new expiration date for the workload estimate.
	ExpiresAt *time.Time

	//  The new name for the workload estimate.
	Name *string

	noSmithyDocumentSerde
}

// Mixin for common fields returned by CRUD APIs
type UpdateWorkloadEstimateOutput struct {

	//  The unique identifier of the updated workload estimate.
	//
	// This member is required.
	Id *string

	//  The currency of the updated estimated cost.
	CostCurrency types.CurrencyCode

	//  The timestamp when the workload estimate was originally created.
	CreatedAt *time.Time

	//  The updated expiration timestamp for the workload estimate.
	ExpiresAt *time.Time

	//  An error message if the workload estimate update failed.
	FailureMessage *string

	//  The updated name of the workload estimate.
	Name *string

	//  The timestamp of the pricing rates used for the updated estimate.
	RateTimestamp *time.Time

	//  The type of pricing rates used for the updated estimate.
	RateType types.WorkloadEstimateRateType

	//  The current status of the updated workload estimate.
	Status types.WorkloadEstimateStatus

	//  The updated total estimated cost for the workload.
	TotalCost *float64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateWorkloadEstimateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateWorkloadEstimate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateWorkloadEstimate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateWorkloadEstimate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateWorkloadEstimateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateWorkloadEstimate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateWorkloadEstimate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateWorkloadEstimate",
	}
}
