// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new version of an existing Automated Reasoning policy. This allows
// you to iterate on your policy rules while maintaining previous versions for
// rollback or comparison purposes.
func (c *Client) CreateAutomatedReasoningPolicyVersion(ctx context.Context, params *CreateAutomatedReasoningPolicyVersionInput, optFns ...func(*Options)) (*CreateAutomatedReasoningPolicyVersionOutput, error) {
	if params == nil {
		params = &CreateAutomatedReasoningPolicyVersionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAutomatedReasoningPolicyVersion", params, optFns, c.addOperationCreateAutomatedReasoningPolicyVersionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAutomatedReasoningPolicyVersionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAutomatedReasoningPolicyVersionInput struct {

	// The hash of the current policy definition used as a concurrency token to ensure
	// the policy hasn't been modified since you last retrieved it.
	//
	// This member is required.
	LastUpdatedDefinitionHash *string

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to
	// create a version.
	//
	// This member is required.
	PolicyArn *string

	// A unique, case-sensitive identifier to ensure that the operation completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error.
	ClientRequestToken *string

	// A list of tags to associate with the policy version.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateAutomatedReasoningPolicyVersionOutput struct {

	// The timestamp when the policy version was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The hash of the policy definition for this version.
	//
	// This member is required.
	DefinitionHash *string

	// The name of the policy version.
	//
	// This member is required.
	Name *string

	// The versioned Amazon Resource Name (ARN) of the policy version.
	//
	// This member is required.
	PolicyArn *string

	// The version number of the policy version.
	//
	// This member is required.
	Version *string

	// The description of the policy version.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAutomatedReasoningPolicyVersionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateAutomatedReasoningPolicyVersion{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateAutomatedReasoningPolicyVersion{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAutomatedReasoningPolicyVersion"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateAutomatedReasoningPolicyVersionMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAutomatedReasoningPolicyVersionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAutomatedReasoningPolicyVersion(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateAutomatedReasoningPolicyVersion struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateAutomatedReasoningPolicyVersion) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateAutomatedReasoningPolicyVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateAutomatedReasoningPolicyVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateAutomatedReasoningPolicyVersionInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateAutomatedReasoningPolicyVersionMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateAutomatedReasoningPolicyVersion{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateAutomatedReasoningPolicyVersion(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAutomatedReasoningPolicyVersion",
	}
}
