// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/bedrockagent/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains details about the Lambda function containing the business logic that
// is carried out upon invoking the action or the custom control method for
// handling the information elicited from the user.
//
// The following types satisfy this interface:
//
//	ActionGroupExecutorMemberCustomControl
//	ActionGroupExecutorMemberLambda
type ActionGroupExecutor interface {
	isActionGroupExecutor()
}

// To return the action group invocation results directly in the InvokeAgent
// response, specify RETURN_CONTROL .
type ActionGroupExecutorMemberCustomControl struct {
	Value CustomControlMethod

	noSmithyDocumentSerde
}

func (*ActionGroupExecutorMemberCustomControl) isActionGroupExecutor() {}

// The Amazon Resource Name (ARN) of the Lambda function containing the business
// logic that is carried out upon invoking the action.
type ActionGroupExecutorMemberLambda struct {
	Value string

	noSmithyDocumentSerde
}

func (*ActionGroupExecutorMemberLambda) isActionGroupExecutor() {}

// Contains details about an action group.
type ActionGroupSummary struct {

	// The unique identifier of the action group.
	//
	// This member is required.
	ActionGroupId *string

	// The name of the action group.
	//
	// This member is required.
	ActionGroupName *string

	// Specifies whether the action group is available for the agent to invoke or not
	// when sending an [InvokeAgent]request.
	//
	// [InvokeAgent]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html
	//
	// This member is required.
	ActionGroupState ActionGroupState

	// The time at which the action group was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the action group.
	Description *string

	noSmithyDocumentSerde
}

// Contains details about an agent.
type Agent struct {

	// The Amazon Resource Name (ARN) of the agent.
	//
	// This member is required.
	AgentArn *string

	// The unique identifier of the agent.
	//
	// This member is required.
	AgentId *string

	// The name of the agent.
	//
	// This member is required.
	AgentName *string

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API
	// operations on the agent.
	//
	// This member is required.
	AgentResourceRoleArn *string

	// The status of the agent and whether it is ready for use. The following statuses
	// are possible:
	//
	//   - CREATING – The agent is being created.
	//
	//   - PREPARING – The agent is being prepared.
	//
	//   - PREPARED – The agent is prepared and ready to be invoked.
	//
	//   - NOT_PREPARED – The agent has been created but not yet prepared.
	//
	//   - FAILED – The agent API operation failed.
	//
	//   - UPDATING – The agent is being updated.
	//
	//   - DELETING – The agent is being deleted.
	//
	// This member is required.
	AgentStatus AgentStatus

	// The version of the agent.
	//
	// This member is required.
	AgentVersion *string

	// The time at which the agent was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The number of seconds for which Amazon Bedrock keeps information about a user's
	// conversation with the agent.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Bedrock
	// deletes any data provided before the timeout.
	//
	// This member is required.
	IdleSessionTTLInSeconds *int32

	// The time at which the agent was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The agent's collaboration settings.
	AgentCollaboration AgentCollaboration

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	//  Contains custom orchestration configurations for the agent.
	CustomOrchestration *CustomOrchestration

	// The Amazon Resource Name (ARN) of the KMS key that encrypts the agent.
	CustomerEncryptionKeyArn *string

	// The description of the agent.
	Description *string

	// Contains reasons that the agent-related API that you invoked failed.
	FailureReasons []string

	// The foundation model used for orchestration by the agent.
	FoundationModel *string

	// Details about the guardrail associated with the agent.
	GuardrailConfiguration *GuardrailConfiguration

	// Instructions that tell the agent what it should do and how it should interact
	// with users.
	Instruction *string

	// Contains memory configuration for the agent.
	MemoryConfiguration *MemoryConfiguration

	//  Specifies the orchestration strategy for the agent.
	OrchestrationType OrchestrationType

	// The time at which the agent was last prepared.
	PreparedAt *time.Time

	// Contains configurations to override prompt templates in different parts of an
	// agent sequence. For more information, see [Advanced prompts].
	//
	// [Advanced prompts]: https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html
	PromptOverrideConfiguration *PromptOverrideConfiguration

	// Contains recommended actions to take for the agent-related API that you invoked
	// to succeed.
	RecommendedActions []string

	noSmithyDocumentSerde
}

// Contains details about an action group.
type AgentActionGroup struct {

	// The unique identifier of the action group.
	//
	// This member is required.
	ActionGroupId *string

	// The name of the action group.
	//
	// This member is required.
	ActionGroupName *string

	// Specifies whether the action group is available for the agent to invoke or not
	// when sending an [InvokeAgent]request.
	//
	// [InvokeAgent]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html
	//
	// This member is required.
	ActionGroupState ActionGroupState

	// The unique identifier of the agent to which the action group belongs.
	//
	// This member is required.
	AgentId *string

	// The version of the agent to which the action group belongs.
	//
	// This member is required.
	AgentVersion *string

	// The time at which the action group was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time at which the action group was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The Amazon Resource Name (ARN) of the Lambda function containing the business
	// logic that is carried out upon invoking the action or the custom control method
	// for handling the information elicited from the user.
	ActionGroupExecutor ActionGroupExecutor

	// Contains either details about the S3 object containing the OpenAPI schema for
	// the action group or the JSON or YAML-formatted payload defining the schema. For
	// more information, see [Action group OpenAPI schemas].
	//
	// [Action group OpenAPI schemas]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html
	ApiSchema APISchema

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	// The description of the action group.
	Description *string

	// Defines functions that each define parameters that the agent needs to invoke
	// from the user. Each function represents an action in an action group.
	FunctionSchema FunctionSchema

	// The configuration settings for a computer use action.
	//
	// Computer use is a new Anthropic Claude model capability (in beta) available
	// with Claude 3.7 Sonnet and Claude 3.5 Sonnet v2 only. For more information, see [Configure an Amazon Bedrock Agent to complete tasks with computer use tools]
	// .
	//
	// [Configure an Amazon Bedrock Agent to complete tasks with computer use tools]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-computer-use.html
	ParentActionGroupSignatureParams map[string]string

	// If this field is set as AMAZON.UserInput , the agent can request the user for
	// additional information when trying to complete a task. The description ,
	// apiSchema , and actionGroupExecutor fields must be blank for this action group.
	//
	// During orchestration, if the agent determines that it needs to invoke an API in
	// an action group, but doesn't have enough information to complete the API
	// request, it will invoke this action group instead and return an [Observation]reprompting the
	// user for more information.
	//
	// [Observation]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html
	ParentActionSignature ActionGroupSignature

	noSmithyDocumentSerde
}

// Contains details about an alias of an agent.
type AgentAlias struct {

	// The Amazon Resource Name (ARN) of the alias of the agent.
	//
	// This member is required.
	AgentAliasArn *string

	// The unique identifier of the alias of the agent.
	//
	// This member is required.
	AgentAliasId *string

	// The name of the alias of the agent.
	//
	// This member is required.
	AgentAliasName *string

	// The status of the alias of the agent and whether it is ready for use. The
	// following statuses are possible:
	//
	//   - CREATING – The agent alias is being created.
	//
	//   - PREPARED – The agent alias is finished being created or updated and is
	//   ready to be invoked.
	//
	//   - FAILED – The agent alias API operation failed.
	//
	//   - UPDATING – The agent alias is being updated.
	//
	//   - DELETING – The agent alias is being deleted.
	//
	//   - DISSOCIATED - The agent alias has no version associated with it.
	//
	// This member is required.
	AgentAliasStatus AgentAliasStatus

	// The unique identifier of the agent.
	//
	// This member is required.
	AgentId *string

	// The time at which the alias of the agent was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Contains details about the routing configuration of the alias.
	//
	// This member is required.
	RoutingConfiguration []AgentAliasRoutingConfigurationListItem

	// The time at which the alias was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Contains details about the history of the alias.
	AgentAliasHistoryEvents []AgentAliasHistoryEvent

	// The invocation state for the agent alias. If the agent alias is running, the
	// value is ACCEPT_INVOCATIONS . If the agent alias is paused, the value is
	// REJECT_INVOCATIONS . Use the UpdateAgentAlias operation to change the
	// invocation state.
	AliasInvocationState AliasInvocationState

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	// The description of the alias of the agent.
	Description *string

	// Information on the failure of Provisioned Throughput assigned to an agent alias.
	FailureReasons []string

	noSmithyDocumentSerde
}

// Contains details about the history of the alias.
type AgentAliasHistoryEvent struct {

	// The date that the alias stopped being associated to the version in the
	// routingConfiguration object
	EndDate *time.Time

	// Contains details about the version of the agent with which the alias is
	// associated.
	RoutingConfiguration []AgentAliasRoutingConfigurationListItem

	// The date that the alias began being associated to the version in the
	// routingConfiguration object.
	StartDate *time.Time

	noSmithyDocumentSerde
}

// Contains details about the routing configuration of the alias.
type AgentAliasRoutingConfigurationListItem struct {

	// The version of the agent with which the alias is associated.
	AgentVersion *string

	// Information on the Provisioned Throughput assigned to an agent alias.
	ProvisionedThroughput *string

	noSmithyDocumentSerde
}

// Contains details about an alias of an agent.
type AgentAliasSummary struct {

	// Contains details about
	//
	// This member is required.
	AgentAliasId *string

	// The name of the alias.
	//
	// This member is required.
	AgentAliasName *string

	// The status of the alias.
	//
	// This member is required.
	AgentAliasStatus AgentAliasStatus

	// The time at which the alias of the agent was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time at which the alias was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The invocation state for the agent alias. If the agent alias is running, the
	// value is ACCEPT_INVOCATIONS . If the agent alias is paused, the value is
	// REJECT_INVOCATIONS . Use the UpdateAgentAlias operation to change the
	// invocation state.
	AliasInvocationState AliasInvocationState

	// The description of the alias.
	Description *string

	// Contains details about the version of the agent with which the alias is
	// associated.
	RoutingConfiguration []AgentAliasRoutingConfigurationListItem

	noSmithyDocumentSerde
}

// An agent collaborator.
type AgentCollaborator struct {

	// The collaborator's agent descriptor.
	//
	// This member is required.
	AgentDescriptor *AgentDescriptor

	// The collaborator's agent ID.
	//
	// This member is required.
	AgentId *string

	// The collaborator's agent version.
	//
	// This member is required.
	AgentVersion *string

	// The collaborator's instructions.
	//
	// This member is required.
	CollaborationInstruction *string

	// The collaborator's collaborator ID.
	//
	// This member is required.
	CollaboratorId *string

	// The collaborator's collaborator name.
	//
	// This member is required.
	CollaboratorName *string

	// When the collaborator was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// When the collaborator was updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The collaborator's client token.
	ClientToken *string

	// The collaborator's relay conversation history.
	RelayConversationHistory RelayConversationHistory

	noSmithyDocumentSerde
}

// An agent collaborator summary.
type AgentCollaboratorSummary struct {

	// The collaborator's agent descriptor.
	//
	// This member is required.
	AgentDescriptor *AgentDescriptor

	// The collaborator's agent ID.
	//
	// This member is required.
	AgentId *string

	// The collaborator's agent version.
	//
	// This member is required.
	AgentVersion *string

	// The collaborator's collaboration instruction.
	//
	// This member is required.
	CollaborationInstruction *string

	// The collaborator's ID.
	//
	// This member is required.
	CollaboratorId *string

	// The collaborator's name.
	//
	// This member is required.
	CollaboratorName *string

	// When the collaborator was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// When the collaborator was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The collaborator's relay conversation history.
	//
	// This member is required.
	RelayConversationHistory RelayConversationHistory

	noSmithyDocumentSerde
}

// An agent descriptor.
type AgentDescriptor struct {

	// The agent's alias ARN.
	AliasArn *string

	noSmithyDocumentSerde
}

// Defines an agent node in your flow. You specify the agent to invoke at this
// point in the flow. For more information, see [Node types in a flow]in the Amazon Bedrock User Guide.
//
// [Node types in a flow]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html
type AgentFlowNodeConfiguration struct {

	// The Amazon Resource Name (ARN) of the alias of the agent to invoke.
	//
	// This member is required.
	AgentAliasArn *string

	noSmithyDocumentSerde
}

// Contains details about a knowledge base that is associated with an agent.
type AgentKnowledgeBase struct {

	// The unique identifier of the agent with which the knowledge base is associated.
	//
	// This member is required.
	AgentId *string

	// The version of the agent with which the knowledge base is associated.
	//
	// This member is required.
	AgentVersion *string

	// The time at which the association between the agent and the knowledge base was
	// created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The description of the association between the agent and the knowledge base.
	//
	// This member is required.
	Description *string

	// The unique identifier of the association between the agent and the knowledge
	// base.
	//
	// This member is required.
	KnowledgeBaseId *string

	// Specifies whether to use the knowledge base or not when sending an [InvokeAgent] request.
	//
	// [InvokeAgent]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html
	//
	// This member is required.
	KnowledgeBaseState KnowledgeBaseState

	// The time at which the association between the agent and the knowledge base was
	// last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains details about a knowledge base associated with an agent.
type AgentKnowledgeBaseSummary struct {

	// The unique identifier of the knowledge base associated with an agent.
	//
	// This member is required.
	KnowledgeBaseId *string

	// Specifies whether the agent uses the knowledge base or not when sending an [InvokeAgent]
	// request.
	//
	// [InvokeAgent]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html
	//
	// This member is required.
	KnowledgeBaseState KnowledgeBaseState

	// The time at which the knowledge base associated with an agent was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the knowledge base associated with an agent.
	Description *string

	noSmithyDocumentSerde
}

// Contains details about an agent.
type AgentSummary struct {

	// The unique identifier of the agent.
	//
	// This member is required.
	AgentId *string

	// The name of the agent.
	//
	// This member is required.
	AgentName *string

	// The status of the agent.
	//
	// This member is required.
	AgentStatus AgentStatus

	// The time at which the agent was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the agent.
	Description *string

	// Details about the guardrail associated with the agent.
	GuardrailConfiguration *GuardrailConfiguration

	// The latest version of the agent.
	LatestAgentVersion *string

	noSmithyDocumentSerde
}

// Contains details about a version of an agent.
type AgentVersion struct {

	// The Amazon Resource Name (ARN) of the agent that the version belongs to.
	//
	// This member is required.
	AgentArn *string

	// The unique identifier of the agent that the version belongs to.
	//
	// This member is required.
	AgentId *string

	// The name of the agent that the version belongs to.
	//
	// This member is required.
	AgentName *string

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API
	// operations on the agent.
	//
	// This member is required.
	AgentResourceRoleArn *string

	// The status of the agent that the version belongs to.
	//
	// This member is required.
	AgentStatus AgentStatus

	// The time at which the version was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The number of seconds for which Amazon Bedrock keeps information about a user's
	// conversation with the agent.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Bedrock
	// deletes any data provided before the timeout.
	//
	// This member is required.
	IdleSessionTTLInSeconds *int32

	// The time at which the version was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The version number.
	//
	// This member is required.
	Version *string

	// The agent's collaboration settings.
	AgentCollaboration AgentCollaboration

	// The Amazon Resource Name (ARN) of the KMS key that encrypts the agent.
	CustomerEncryptionKeyArn *string

	// The description of the version.
	Description *string

	// A list of reasons that the API operation on the version failed.
	FailureReasons []string

	// The foundation model that the version invokes.
	FoundationModel *string

	// Details about the guardrail associated with the agent.
	GuardrailConfiguration *GuardrailConfiguration

	// The instructions provided to the agent.
	Instruction *string

	//  Contains details of the memory configuration on the version of the agent.
	MemoryConfiguration *MemoryConfiguration

	// Contains configurations to override prompt templates in different parts of an
	// agent sequence. For more information, see [Advanced prompts].
	//
	// [Advanced prompts]: https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html
	PromptOverrideConfiguration *PromptOverrideConfiguration

	// A list of recommended actions to take for the failed API operation on the
	// version to succeed.
	RecommendedActions []string

	noSmithyDocumentSerde
}

// Contains details about a version of an agent.
type AgentVersionSummary struct {

	// The name of the agent to which the version belongs.
	//
	// This member is required.
	AgentName *string

	// The status of the agent to which the version belongs.
	//
	// This member is required.
	AgentStatus AgentStatus

	// The version of the agent.
	//
	// This member is required.
	AgentVersion *string

	// The time at which the version was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The time at which the version was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the version of the agent.
	Description *string

	// Details about the guardrail associated with the agent.
	GuardrailConfiguration *GuardrailConfiguration

	noSmithyDocumentSerde
}

// Defines tools, at least one of which must be requested by the model. No text is
// generated but the results of tool use are sent back to the model to help
// generate a response. For more information, see [Use a tool to complete an Amazon Bedrock model response].
//
// [Use a tool to complete an Amazon Bedrock model response]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type AnyToolChoice struct {
	noSmithyDocumentSerde
}

// Contains details about the OpenAPI schema for the action group. For more
// information, see [Action group OpenAPI schemas]. You can either include the schema directly in the payload
// field or you can upload it to an S3 bucket and specify the S3 bucket location in
// the s3 field.
//
// The following types satisfy this interface:
//
//	APISchemaMemberPayload
//	APISchemaMemberS3
//
// [Action group OpenAPI schemas]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html
type APISchema interface {
	isAPISchema()
}

// The JSON or YAML-formatted payload defining the OpenAPI schema for the action
// group. For more information, see [Action group OpenAPI schemas].
//
// [Action group OpenAPI schemas]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html
type APISchemaMemberPayload struct {
	Value string

	noSmithyDocumentSerde
}

func (*APISchemaMemberPayload) isAPISchema() {}

// Contains details about the S3 object containing the OpenAPI schema for the
// action group. For more information, see [Action group OpenAPI schemas].
//
// [Action group OpenAPI schemas]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html
type APISchemaMemberS3 struct {
	Value S3Identifier

	noSmithyDocumentSerde
}

func (*APISchemaMemberS3) isAPISchema() {}

// Configuration settings for processing audio content in multimodal knowledge
// bases.
type AudioConfiguration struct {

	// Configuration for segmenting audio content during processing.
	//
	// This member is required.
	SegmentationConfiguration *AudioSegmentationConfiguration

	noSmithyDocumentSerde
}

// Configuration for segmenting audio content during multimodal knowledge base
// ingestion. Determines how audio files are divided into chunks for processing.
type AudioSegmentationConfiguration struct {

	// The duration in seconds for each audio segment. Audio files will be divided
	// into chunks of this length for processing.
	//
	// This member is required.
	FixedLengthDuration *int32

	noSmithyDocumentSerde
}

// Defines tools. The model automatically decides whether to call a tool or to
// generate text instead. For more information, see [Use a tool to complete an Amazon Bedrock model response].
//
// [Use a tool to complete an Amazon Bedrock model response]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type AutoToolChoice struct {
	noSmithyDocumentSerde
}

// Contains configurations for using Amazon Bedrock Data Automation as the parser
// for ingesting your data sources.
type BedrockDataAutomationConfiguration struct {

	// Specifies whether to enable parsing of multimodal data, including both text
	// and/or images.
	ParsingModality ParsingModality

	noSmithyDocumentSerde
}

// The vector configuration details for the Bedrock embeddings model.
type BedrockEmbeddingModelConfiguration struct {

	// Configuration settings for processing audio content in multimodal knowledge
	// bases.
	Audio []AudioConfiguration

	// The dimensions details for the vector configuration used on the Bedrock
	// embeddings model.
	Dimensions *int32

	// The data type for the vectors when using a model to convert text into vector
	// embeddings. The model must support the specified data type for vector
	// embeddings. Floating-point (float32) is the default data type, and is supported
	// by most models for vector embeddings. See [Supported embeddings models]for information on the available
	// models and their vector data types.
	//
	// [Supported embeddings models]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html
	EmbeddingDataType EmbeddingDataType

	// Configuration settings for processing video content in multimodal knowledge
	// bases.
	Video []VideoConfiguration

	noSmithyDocumentSerde
}

// Settings for a foundation model used to parse documents for a data source.
type BedrockFoundationModelConfiguration struct {

	// The ARN of the foundation model to use for parsing.
	//
	// This member is required.
	ModelArn *string

	// Specifies whether to enable parsing of multimodal data, including both text
	// and/or images.
	ParsingModality ParsingModality

	// Instructions for interpreting the contents of a document.
	ParsingPrompt *ParsingPrompt

	noSmithyDocumentSerde
}

// Context enrichment configuration is used to provide additional context to the
// RAG application using Amazon Bedrock foundation models.
type BedrockFoundationModelContextEnrichmentConfiguration struct {

	// The enrichment stategy used to provide additional context. For example, Neptune
	// GraphRAG uses Amazon Bedrock foundation models to perform chunk entity
	// extraction.
	//
	// This member is required.
	EnrichmentStrategyConfiguration *EnrichmentStrategyConfiguration

	// The Amazon Resource Name (ARN) of the model used to create vector embeddings
	// for the knowledge base.
	//
	// This member is required.
	ModelArn *string

	noSmithyDocumentSerde
}

// Contains information about content defined inline in bytes.
type ByteContentDoc struct {

	// The base64-encoded string of the content.
	//
	// This member is required.
	Data []byte

	// The MIME type of the content. For a list of MIME types, see [Media Types]. The following
	// MIME types are supported:
	//
	//   - text/plain
	//
	//   - text/html
	//
	//   - text/csv
	//
	//   - text/vtt
	//
	//   - message/rfc822
	//
	//   - application/xhtml+xml
	//
	//   - application/pdf
	//
	//   - application/msword
	//
	//   - application/vnd.ms-word.document.macroenabled.12
	//
	//   - application/vnd.ms-word.template.macroenabled.12
	//
	//   - application/vnd.ms-excel
	//
	//   - application/vnd.ms-excel.addin.macroenabled.12
	//
	//   - application/vnd.ms-excel.sheet.macroenabled.12
	//
	//   - application/vnd.ms-excel.template.macroenabled.12
	//
	//   - application/vnd.ms-excel.sheet.binary.macroenabled.12
	//
	//   - application/vnd.ms-spreadsheetml
	//
	//   - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
	//
	//   - application/vnd.openxmlformats-officedocument.spreadsheetml.template
	//
	//   - application/vnd.openxmlformats-officedocument.wordprocessingml.document
	//
	//   - application/vnd.openxmlformats-officedocument.wordprocessingml.template
	//
	// [Media Types]: https://www.iana.org/assignments/media-types/media-types.xhtml
	//
	// This member is required.
	MimeType *string

	noSmithyDocumentSerde
}

// Indicates where a cache checkpoint is located. All information before this
// checkpoint is cached to be accessed on subsequent requests.
type CachePointBlock struct {

	// Indicates that the CachePointBlock is of the default type
	//
	// This member is required.
	Type CachePointType

	noSmithyDocumentSerde
}

// Contains configurations to use a prompt in a conversational format. For more
// information, see [Create a prompt using Prompt management].
//
// [Create a prompt using Prompt management]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html
type ChatPromptTemplateConfiguration struct {

	// Contains messages in the chat for the prompt.
	//
	// This member is required.
	Messages []Message

	// An array of the variables in the prompt template.
	InputVariables []PromptInputVariable

	// Contains system prompts to provide context to the model or to describe how it
	// should behave.
	System []SystemContentBlock

	// Configuration information for the tools that the model can use when generating
	// a response.
	ToolConfiguration *ToolConfiguration

	noSmithyDocumentSerde
}

// Details about how to chunk the documents in the data source. A chunk refers to
// an excerpt from a data source that is returned when the knowledge base that it
// belongs to is queried.
type ChunkingConfiguration struct {

	// Knowledge base can split your source data into chunks. A chunk refers to an
	// excerpt from a data source that is returned when the knowledge base that it
	// belongs to is queried. You have the following options for chunking your data. If
	// you opt for NONE , then you may want to pre-process your files by splitting them
	// up such that each file corresponds to a chunk.
	//
	//   - FIXED_SIZE – Amazon Bedrock splits your source data into chunks of the
	//   approximate size that you set in the fixedSizeChunkingConfiguration .
	//
	//   - HIERARCHICAL – Split documents into layers of chunks where the first layer
	//   contains large chunks, and the second layer contains smaller chunks derived from
	//   the first layer.
	//
	//   - SEMANTIC – Split documents into chunks based on groups of similar content
	//   derived with natural language processing.
	//
	//   - NONE – Amazon Bedrock treats each file as one chunk. If you choose this
	//   option, you may want to pre-process your documents by splitting them into
	//   separate files.
	//
	// This member is required.
	ChunkingStrategy ChunkingStrategy

	// Configurations for when you choose fixed-size chunking. If you set the
	// chunkingStrategy as NONE , exclude this field.
	FixedSizeChunkingConfiguration *FixedSizeChunkingConfiguration

	// Settings for hierarchical document chunking for a data source. Hierarchical
	// chunking splits documents into layers of chunks where the first layer contains
	// large chunks, and the second layer contains smaller chunks derived from the
	// first layer.
	HierarchicalChunkingConfiguration *HierarchicalChunkingConfiguration

	// Settings for semantic document chunking for a data source. Semantic chunking
	// splits a document into into smaller documents based on groups of similar content
	// derived from the text with natural language processing.
	SemanticChunkingConfiguration *SemanticChunkingConfiguration

	noSmithyDocumentSerde
}

// Defines a collector node in your flow. This node takes an iteration of inputs
// and consolidates them into an array in the output. For more information, see [Node types in a flow]in
// the Amazon Bedrock User Guide.
//
// [Node types in a flow]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html
type CollectorFlowNodeConfiguration struct {
	noSmithyDocumentSerde
}

// Defines a condition node in your flow. You can specify conditions that
// determine which node comes next in the flow. For more information, see [Node types in a flow]in the
// Amazon Bedrock User Guide.
//
// [Node types in a flow]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html
type ConditionFlowNodeConfiguration struct {

	// An array of conditions. Each member contains the name of a condition and an
	// expression that defines the condition.
	//
	// This member is required.
	Conditions []FlowCondition

	noSmithyDocumentSerde
}

// The configuration of the Confluence content. For example, configuring specific
// types of Confluence content.
type ConfluenceCrawlerConfiguration struct {

	// The configuration of filtering the Confluence content. For example, configuring
	// regular expression patterns to include or exclude certain content.
	FilterConfiguration *CrawlFilterConfiguration

	noSmithyDocumentSerde
}

// The configuration information to connect to Confluence as your data source.
type ConfluenceDataSourceConfiguration struct {

	// The endpoint information to connect to your Confluence data source.
	//
	// This member is required.
	SourceConfiguration *ConfluenceSourceConfiguration

	// The configuration of the Confluence content. For example, configuring specific
	// types of Confluence content.
	CrawlerConfiguration *ConfluenceCrawlerConfiguration

	noSmithyDocumentSerde
}

// The endpoint information to connect to your Confluence data source.
type ConfluenceSourceConfiguration struct {

	// The supported authentication type to authenticate and connect to your
	// Confluence instance.
	//
	// This member is required.
	AuthType ConfluenceAuthType

	// The Amazon Resource Name of an Secrets Manager secret that stores your
	// authentication credentials for your Confluence instance URL. For more
	// information on the key-value pairs that must be included in your secret,
	// depending on your authentication type, see [Confluence connection configuration].
	//
	// [Confluence connection configuration]: https://docs.aws.amazon.com/bedrock/latest/userguide/confluence-data-source-connector.html#configuration-confluence-connector
	//
	// This member is required.
	CredentialsSecretArn *string

	// The supported host type, whether online/cloud or server/on-premises.
	//
	// This member is required.
	HostType ConfluenceHostType

	// The Confluence host URL or instance URL.
	//
	// This member is required.
	HostUrl *string

	noSmithyDocumentSerde
}

// Contains the content for the message you pass to, or receive from a model. For
// more information, see [Create a prompt using Prompt management].
//
// The following types satisfy this interface:
//
//	ContentBlockMemberCachePoint
//	ContentBlockMemberText
//
// [Create a prompt using Prompt management]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html
type ContentBlock interface {
	isContentBlock()
}

// Creates a cache checkpoint within a message.
type ContentBlockMemberCachePoint struct {
	Value CachePointBlock

	noSmithyDocumentSerde
}

func (*ContentBlockMemberCachePoint) isContentBlock() {}

// The text in the message.
type ContentBlockMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*ContentBlockMemberText) isContentBlock() {}

// Context enrichment configuration is used to provide additional context to the
// RAG application.
type ContextEnrichmentConfiguration struct {

	// The method used for context enrichment. It must be Amazon Bedrock foundation
	// models.
	//
	// This member is required.
	Type ContextEnrichmentType

	// The configuration of the Amazon Bedrock foundation model used for context
	// enrichment.
	BedrockFoundationModelConfiguration *BedrockFoundationModelContextEnrichmentConfiguration

	noSmithyDocumentSerde
}

// The configuration of filtering the data source content. For example,
// configuring regular expression patterns to include or exclude certain content.
type CrawlFilterConfiguration struct {

	// The type of filtering that you want to apply to certain objects or content of
	// the data source. For example, the PATTERN type is regular expression patterns
	// you can apply to filter your content.
	//
	// This member is required.
	Type CrawlFilterConfigurationType

	// The configuration of filtering certain objects or content types of the data
	// source.
	PatternObjectFilter *PatternObjectFilterConfiguration

	noSmithyDocumentSerde
}

// Contains configurations for a query, each of which defines information about
// example queries to help the query engine generate appropriate SQL queries.
type CuratedQuery struct {

	// An example natural language query.
	//
	// This member is required.
	NaturalLanguage *string

	// The SQL equivalent of the natural language query.
	//
	// This member is required.
	Sql *string

	noSmithyDocumentSerde
}

// Contains information about the content to ingest into a knowledge base
// connected to a custom data source. Choose a sourceType and include the field
// that corresponds to it.
type CustomContent struct {

	// A unique identifier for the document.
	//
	// This member is required.
	CustomDocumentIdentifier *CustomDocumentIdentifier

	// The source of the data to ingest.
	//
	// This member is required.
	SourceType CustomSourceType

	// Contains information about content defined inline to ingest into a knowledge
	// base.
	InlineContent *InlineContent

	// Contains information about the Amazon S3 location of the file from which to
	// ingest data.
	S3Location *CustomS3Location

	noSmithyDocumentSerde
}

// Contains information about the identifier of the document to ingest into a
// custom data source.
type CustomDocumentIdentifier struct {

	// The identifier of the document to ingest into a custom data source.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Details of custom orchestration.
type CustomOrchestration struct {

	//  The structure of the executor invoking the actions in custom orchestration.
	Executor OrchestrationExecutor

	noSmithyDocumentSerde
}

// Contains information about the Amazon S3 location of the file containing the
// content to ingest into a knowledge base connected to a custom data source.
type CustomS3Location struct {

	// The S3 URI of the file containing the content to ingest.
	//
	// This member is required.
	Uri *string

	// The identifier of the Amazon Web Services account that owns the S3 bucket
	// containing the content to ingest.
	BucketOwnerAccountId *string

	noSmithyDocumentSerde
}

// Settings for customizing steps in the data source content ingestion pipeline.
//
// You can configure the data source to process documents with a Lambda function
// after they are parsed and converted into chunks. When you add a post-chunking
// transformation, the service stores chunked documents in an S3 bucket and invokes
// a Lambda function to process them.
//
// To process chunked documents with a Lambda function, define an S3 bucket path
// for input and output objects, and a transformation that specifies the Lambda
// function to invoke. You can use the Lambda function to customize how chunks are
// split, and the metadata for each chunk.
type CustomTransformationConfiguration struct {

	// An S3 bucket path for input and output objects.
	//
	// This member is required.
	IntermediateStorage *IntermediateStorage

	// A Lambda function that processes documents.
	//
	// This member is required.
	Transformations []Transformation

	noSmithyDocumentSerde
}

// Details about a cyclic connection detected in the flow.
type CyclicConnectionFlowValidationDetails struct {

	// The name of the connection that causes the cycle in the flow.
	//
	// This member is required.
	Connection *string

	noSmithyDocumentSerde
}

// Contains details about a data source.
type DataSource struct {

	// The time at which the data source was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The connection configuration for the data source.
	//
	// This member is required.
	DataSourceConfiguration *DataSourceConfiguration

	// The unique identifier of the data source.
	//
	// This member is required.
	DataSourceId *string

	// The unique identifier of the knowledge base to which the data source belongs.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The name of the data source.
	//
	// This member is required.
	Name *string

	// The status of the data source. The following statuses are possible:
	//
	//   - Available – The data source has been created and is ready for ingestion
	//   into the knowledge base.
	//
	//   - Deleting – The data source is being deleted.
	//
	// This member is required.
	Status DataSourceStatus

	// The time at which the data source was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The data deletion policy for the data source.
	DataDeletionPolicy DataDeletionPolicy

	// The description of the data source.
	Description *string

	// The detailed reasons on the failure to delete a data source.
	FailureReasons []string

	// Contains details about the configuration of the server-side encryption.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration

	// Contains details about how to ingest the documents in the data source.
	VectorIngestionConfiguration *VectorIngestionConfiguration

	noSmithyDocumentSerde
}

// The connection configuration for the data source.
type DataSourceConfiguration struct {

	// The type of data source.
	//
	// This member is required.
	Type DataSourceType

	// The configuration information to connect to Confluence as your data source.
	//
	// Confluence data source connector is in preview release and is subject to change.
	ConfluenceConfiguration *ConfluenceDataSourceConfiguration

	// The configuration information to connect to Amazon S3 as your data source.
	S3Configuration *S3DataSourceConfiguration

	// The configuration information to connect to Salesforce as your data source.
	//
	// Salesforce data source connector is in preview release and is subject to change.
	SalesforceConfiguration *SalesforceDataSourceConfiguration

	// The configuration information to connect to SharePoint as your data source.
	//
	// SharePoint data source connector is in preview release and is subject to change.
	SharePointConfiguration *SharePointDataSourceConfiguration

	// The configuration of web URLs to crawl for your data source. You should be
	// authorized to crawl the URLs.
	//
	// Crawling web URLs as your data source is in preview release and is subject to
	// change.
	WebConfiguration *WebDataSourceConfiguration

	noSmithyDocumentSerde
}

// Contains details about a data source.
type DataSourceSummary struct {

	// The unique identifier of the data source.
	//
	// This member is required.
	DataSourceId *string

	// The unique identifier of the knowledge base to which the data source belongs.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The name of the data source.
	//
	// This member is required.
	Name *string

	// The status of the data source.
	//
	// This member is required.
	Status DataSourceStatus

	// The time at which the data source was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the data source.
	Description *string

	noSmithyDocumentSerde
}

// Contains information about the content of a document. Choose a dataSourceType
// and include the field that corresponds to it.
type DocumentContent struct {

	// The type of data source that is connected to the knowledge base to which to
	// ingest this document.
	//
	// This member is required.
	DataSourceType ContentDataSourceType

	// Contains information about the content to ingest into a knowledge base
	// connected to a custom data source.
	Custom *CustomContent

	// Contains information about the content to ingest into a knowledge base
	// connected to an Amazon S3 data source
	S3 *S3Content

	noSmithyDocumentSerde
}

// Contains information that identifies the document.
type DocumentIdentifier struct {

	// The type of data source connected to the knowledge base that contains the
	// document.
	//
	// This member is required.
	DataSourceType ContentDataSourceType

	// Contains information that identifies the document in a custom data source.
	Custom *CustomDocumentIdentifier

	// Contains information that identifies the document in an S3 data source.
	S3 *S3Location

	noSmithyDocumentSerde
}

// Contains information about the metadata associate with the content to ingest
// into a knowledge base. Choose a type and include the field that corresponds to
// it.
type DocumentMetadata struct {

	// The type of the source source from which to add metadata.
	//
	// This member is required.
	Type MetadataSourceType

	// An array of objects, each of which defines a metadata attribute to associate
	// with the content to ingest. You define the attributes inline.
	InlineAttributes []MetadataAttribute

	// The Amazon S3 location of the file containing metadata to associate with the
	// content to ingest.
	S3Location *CustomS3Location

	noSmithyDocumentSerde
}

// Details about duplicate condition expressions found in a condition node.
type DuplicateConditionExpressionFlowValidationDetails struct {

	// The duplicated condition expression.
	//
	// This member is required.
	Expression *string

	// The name of the node containing the duplicate condition expressions.
	//
	// This member is required.
	Node *string

	noSmithyDocumentSerde
}

// Details about duplicate connections found between two nodes in the flow.
type DuplicateConnectionsFlowValidationDetails struct {

	// The name of the source node where the duplicate connection starts.
	//
	// This member is required.
	Source *string

	// The name of the target node where the duplicate connection ends.
	//
	// This member is required.
	Target *string

	noSmithyDocumentSerde
}

// The configuration details for the embeddings model.
type EmbeddingModelConfiguration struct {

	// The vector configuration details on the Bedrock embeddings model.
	BedrockEmbeddingModelConfiguration *BedrockEmbeddingModelConfiguration

	noSmithyDocumentSerde
}

// The strategy used for performing context enrichment.
type EnrichmentStrategyConfiguration struct {

	// The method used for the context enrichment strategy.
	//
	// This member is required.
	Method EnrichmentStrategyMethod

	noSmithyDocumentSerde
}

// Specifies a metadata field to include or exclude during the reranking process.
type FieldForReranking struct {

	// The name of the metadata field to include or exclude during reranking.
	//
	// This member is required.
	FieldName *string

	noSmithyDocumentSerde
}

// Configurations for when you choose fixed-size chunking. If you set the
// chunkingStrategy as NONE , exclude this field.
type FixedSizeChunkingConfiguration struct {

	// The maximum number of tokens to include in a chunk.
	//
	// This member is required.
	MaxTokens *int32

	// The percentage of overlap between adjacent chunks of a data source.
	//
	// This member is required.
	OverlapPercentage *int32

	noSmithyDocumentSerde
}

// Determines how multiple nodes in a flow can run in parallel. Running nodes
// concurrently can improve your flow's performance.
type FlowAliasConcurrencyConfiguration struct {

	// The type of concurrency to use for parallel node execution. Specify one of the
	// following options:
	//
	//   - Automatic - Amazon Bedrock determines which nodes can be executed in
	//   parallel based on the flow definition and its dependencies.
	//
	//   - Manual - You specify which nodes can be executed in parallel.
	//
	// This member is required.
	Type ConcurrencyType

	// The maximum number of nodes that can be executed concurrently in the flow.
	MaxConcurrency *int32

	noSmithyDocumentSerde
}

// Contains information about a version that the alias maps to.
type FlowAliasRoutingConfigurationListItem struct {

	// The version that the alias maps to.
	FlowVersion *string

	noSmithyDocumentSerde
}

// Contains information about an alias of a flow.
//
// This data type is used in the following API operations:
//
// [ListFlowAliases response]
//
// [ListFlowAliases response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListFlowAliases.html#API_agent_ListFlowAliases_ResponseSyntax
type FlowAliasSummary struct {

	// The Amazon Resource Name (ARN) of the alias.
	//
	// This member is required.
	Arn *string

	// The time at which the alias was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the flow.
	//
	// This member is required.
	FlowId *string

	// The unique identifier of the alias of the flow.
	//
	// This member is required.
	Id *string

	// The name of the alias.
	//
	// This member is required.
	Name *string

	// A list of configurations about the versions that the alias maps to. Currently,
	// you can only specify one.
	//
	// This member is required.
	RoutingConfiguration []FlowAliasRoutingConfigurationListItem

	// The time at which the alias was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The configuration that specifies how nodes in the flow are executed
	// concurrently.
	ConcurrencyConfiguration *FlowAliasConcurrencyConfiguration

	// A description of the alias.
	Description *string

	noSmithyDocumentSerde
}

// Defines a condition in the condition node.
type FlowCondition struct {

	// A name for the condition that you can reference.
	//
	// This member is required.
	Name *string

	// Defines the condition. You must refer to at least one of the inputs in the
	// condition. For more information, expand the Condition node section in [Node types in prompt flows].
	//
	// [Node types in prompt flows]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html#flows-nodes
	Expression *string

	noSmithyDocumentSerde
}

// The configuration of a connection between a condition node and another node.
type FlowConditionalConnectionConfiguration struct {

	// The condition that triggers this connection. For more information about how to
	// write conditions, see the Condition node type in the [Node types]topic in the Amazon
	// Bedrock User Guide.
	//
	// [Node types]: https://docs.aws.amazon.com/bedrock/latest/userguide/node-types.html
	//
	// This member is required.
	Condition *string

	noSmithyDocumentSerde
}

// Contains information about a connection between two nodes in the flow.
type FlowConnection struct {

	// A name for the connection that you can reference.
	//
	// This member is required.
	Name *string

	// The node that the connection starts at.
	//
	// This member is required.
	Source *string

	// The node that the connection ends at.
	//
	// This member is required.
	Target *string

	// Whether the source node that the connection begins from is a condition node (
	// Conditional ) or not ( Data ).
	//
	// This member is required.
	Type FlowConnectionType

	// The configuration of the connection.
	Configuration FlowConnectionConfiguration

	noSmithyDocumentSerde
}

// The configuration of the connection.
//
// The following types satisfy this interface:
//
//	FlowConnectionConfigurationMemberConditional
//	FlowConnectionConfigurationMemberData
type FlowConnectionConfiguration interface {
	isFlowConnectionConfiguration()
}

// The configuration of a connection originating from a Condition node.
type FlowConnectionConfigurationMemberConditional struct {
	Value FlowConditionalConnectionConfiguration

	noSmithyDocumentSerde
}

func (*FlowConnectionConfigurationMemberConditional) isFlowConnectionConfiguration() {}

// The configuration of a connection originating from a node that isn't a
// Condition node.
type FlowConnectionConfigurationMemberData struct {
	Value FlowDataConnectionConfiguration

	noSmithyDocumentSerde
}

func (*FlowConnectionConfigurationMemberData) isFlowConnectionConfiguration() {}

// The configuration of a connection originating from a node that isn't a
// Condition node.
type FlowDataConnectionConfiguration struct {

	// The name of the output in the source node that the connection begins from.
	//
	// This member is required.
	SourceOutput *string

	// The name of the input in the target node that the connection ends at.
	//
	// This member is required.
	TargetInput *string

	noSmithyDocumentSerde
}

// The definition of the nodes and connections between nodes in the flow.
type FlowDefinition struct {

	// An array of connection definitions in the flow.
	Connections []FlowConnection

	// An array of node definitions in the flow.
	Nodes []FlowNode

	noSmithyDocumentSerde
}

// Contains configurations about a node in the flow.
type FlowNode struct {

	// A name for the node.
	//
	// This member is required.
	Name *string

	// The type of node. This value must match the name of the key that you provide in
	// the configuration you provide in the FlowNodeConfiguration field.
	//
	// This member is required.
	Type FlowNodeType

	// Contains configurations for the node.
	Configuration FlowNodeConfiguration

	// An array of objects, each of which contains information about an input into the
	// node.
	Inputs []FlowNodeInput

	// A list of objects, each of which contains information about an output from the
	// node.
	Outputs []FlowNodeOutput

	noSmithyDocumentSerde
}

// Contains configurations for a node in your flow. For more information, see [Node types in a flow] in
// the Amazon Bedrock User Guide.
//
// The following types satisfy this interface:
//
//	FlowNodeConfigurationMemberAgent
//	FlowNodeConfigurationMemberCollector
//	FlowNodeConfigurationMemberCondition
//	FlowNodeConfigurationMemberInlineCode
//	FlowNodeConfigurationMemberInput
//	FlowNodeConfigurationMemberIterator
//	FlowNodeConfigurationMemberKnowledgeBase
//	FlowNodeConfigurationMemberLambdaFunction
//	FlowNodeConfigurationMemberLex
//	FlowNodeConfigurationMemberLoop
//	FlowNodeConfigurationMemberLoopController
//	FlowNodeConfigurationMemberLoopInput
//	FlowNodeConfigurationMemberOutput
//	FlowNodeConfigurationMemberPrompt
//	FlowNodeConfigurationMemberRetrieval
//	FlowNodeConfigurationMemberStorage
//
// [Node types in a flow]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html
type FlowNodeConfiguration interface {
	isFlowNodeConfiguration()
}

// Contains configurations for an agent node in your flow. Invokes an alias of an
// agent and returns the response.
type FlowNodeConfigurationMemberAgent struct {
	Value AgentFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberAgent) isFlowNodeConfiguration() {}

// Contains configurations for a collector node in your flow. Collects an
// iteration of inputs and consolidates them into an array of outputs.
type FlowNodeConfigurationMemberCollector struct {
	Value CollectorFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberCollector) isFlowNodeConfiguration() {}

// Contains configurations for a condition node in your flow. Defines conditions
// that lead to different branches of the flow.
type FlowNodeConfigurationMemberCondition struct {
	Value ConditionFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberCondition) isFlowNodeConfiguration() {}

// Contains configurations for an inline code node in your flow. Inline code nodes
// let you write and execute code directly within your flow, enabling data
// transformations, custom logic, and integrations without needing an external
// Lambda function.
type FlowNodeConfigurationMemberInlineCode struct {
	Value InlineCodeFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberInlineCode) isFlowNodeConfiguration() {}

// Contains configurations for an input flow node in your flow. The first node in
// the flow. inputs can't be specified for this node.
type FlowNodeConfigurationMemberInput struct {
	Value InputFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberInput) isFlowNodeConfiguration() {}

// Contains configurations for an iterator node in your flow. Takes an input that
// is an array and iteratively sends each item of the array as an output to the
// following node. The size of the array is also returned in the output.
//
// The output flow node at the end of the flow iteration will return a response
// for each member of the array. To return only one response, you can include a
// collector node downstream from the iterator node.
type FlowNodeConfigurationMemberIterator struct {
	Value IteratorFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberIterator) isFlowNodeConfiguration() {}

// Contains configurations for a knowledge base node in your flow. Queries a
// knowledge base and returns the retrieved results or generated response.
type FlowNodeConfigurationMemberKnowledgeBase struct {
	Value KnowledgeBaseFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberKnowledgeBase) isFlowNodeConfiguration() {}

// Contains configurations for a Lambda function node in your flow. Invokes an
// Lambda function.
type FlowNodeConfigurationMemberLambdaFunction struct {
	Value LambdaFunctionFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberLambdaFunction) isFlowNodeConfiguration() {}

// Contains configurations for a Lex node in your flow. Invokes an Amazon Lex bot
// to identify the intent of the input and return the intent as the output.
type FlowNodeConfigurationMemberLex struct {
	Value LexFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberLex) isFlowNodeConfiguration() {}

// Contains configurations for a DoWhile loop in your flow.
type FlowNodeConfigurationMemberLoop struct {
	Value LoopFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberLoop) isFlowNodeConfiguration() {}

// Contains controller node configurations for a DoWhile loop in your flow.
type FlowNodeConfigurationMemberLoopController struct {
	Value LoopControllerFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberLoopController) isFlowNodeConfiguration() {}

// Contains input node configurations for a DoWhile loop in your flow.
type FlowNodeConfigurationMemberLoopInput struct {
	Value LoopInputFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberLoopInput) isFlowNodeConfiguration() {}

// Contains configurations for an output flow node in your flow. The last node in
// the flow. outputs can't be specified for this node.
type FlowNodeConfigurationMemberOutput struct {
	Value OutputFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberOutput) isFlowNodeConfiguration() {}

// Contains configurations for a prompt node in your flow. Runs a prompt and
// generates the model response as the output. You can use a prompt from Prompt
// management or you can configure one in this node.
type FlowNodeConfigurationMemberPrompt struct {
	Value PromptFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberPrompt) isFlowNodeConfiguration() {}

// Contains configurations for a retrieval node in your flow. Retrieves data from
// an Amazon S3 location and returns it as the output.
type FlowNodeConfigurationMemberRetrieval struct {
	Value RetrievalFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberRetrieval) isFlowNodeConfiguration() {}

// Contains configurations for a storage node in your flow. Stores an input in an
// Amazon S3 location.
type FlowNodeConfigurationMemberStorage struct {
	Value StorageFlowNodeConfiguration

	noSmithyDocumentSerde
}

func (*FlowNodeConfigurationMemberStorage) isFlowNodeConfiguration() {}

// Contains configurations for an input in an Amazon Bedrock Flows node.
type FlowNodeInput struct {

	// An expression that formats the input for the node. For an explanation of how to
	// create expressions, see [Expressions in Prompt flows in Amazon Bedrock].
	//
	// [Expressions in Prompt flows in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-expressions.html
	//
	// This member is required.
	Expression *string

	// Specifies a name for the input that you can reference.
	//
	// This member is required.
	Name *string

	// Specifies the data type of the input. If the input doesn't match this type at
	// runtime, a validation error will be thrown.
	//
	// This member is required.
	Type FlowNodeIODataType

	// Specifies how input data flows between iterations in a DoWhile loop.
	//
	//   - LoopCondition - Controls whether the loop continues by evaluating condition
	//   expressions against the input data. Use this category to define the condition
	//   that determines if the loop should continue.
	//
	//   - ReturnValueToLoopStart - Defines data to pass back to the start of the
	//   loop's next iteration. Use this category for variables that you want to update
	//   for each loop iteration.
	//
	//   - ExitLoop - Defines the value that's available once the loop ends. Use this
	//   category to expose loop results to nodes outside the loop.
	Category FlowNodeInputCategory

	noSmithyDocumentSerde
}

// Contains configurations for an output from a node.
type FlowNodeOutput struct {

	// A name for the output that you can reference.
	//
	// This member is required.
	Name *string

	// The data type of the output. If the output doesn't match this type at runtime,
	// a validation error will be thrown.
	//
	// This member is required.
	Type FlowNodeIODataType

	noSmithyDocumentSerde
}

// Contains the definition of a flow.
type FlowSummary struct {

	// The Amazon Resource Name (ARN) of the flow.
	//
	// This member is required.
	Arn *string

	// The time at which the flow was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the flow.
	//
	// This member is required.
	Id *string

	// The name of the flow.
	//
	// This member is required.
	Name *string

	// The status of the flow. The following statuses are possible:
	//
	//   - NotPrepared – The flow has been created or updated, but hasn't been
	//   prepared. If you just created the flow, you can't test it. If you updated the
	//   flow, the DRAFT version won't contain the latest changes for testing. Send a [PrepareFlow]
	//   request to package the latest changes into the DRAFT version.
	//
	//   - Preparing – The flow is being prepared so that the DRAFT version contains
	//   the latest changes for testing.
	//
	//   - Prepared – The flow is prepared and the DRAFT version contains the latest
	//   changes for testing.
	//
	//   - Failed – The last API operation that you invoked on the flow failed. Send a [GetFlow]
	//   request and check the error message in the validations field.
	//
	// [PrepareFlow]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html
	// [GetFlow]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html
	//
	// This member is required.
	Status FlowStatus

	// The time at which the flow was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The latest version of the flow.
	//
	// This member is required.
	Version *string

	// A description of the flow.
	Description *string

	noSmithyDocumentSerde
}

// Contains information about validation of the flow.
//
// This data type is used in the following API operations:
//
// [GetFlow response]
//
// [GetFlowVersion response]
//
// [GetFlow response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html#API_agent_GetFlow_ResponseSyntax
// [GetFlowVersion response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlowVersion.html#API_agent_GetFlowVersion_ResponseSyntax
type FlowValidation struct {

	// A message describing the validation error.
	//
	// This member is required.
	Message *string

	// The severity of the issue described in the message.
	//
	// This member is required.
	Severity FlowValidationSeverity

	// Specific details about the validation issue encountered in the flow.
	Details FlowValidationDetails

	// The type of validation issue encountered in the flow.
	Type FlowValidationType

	noSmithyDocumentSerde
}

// A union type containing various possible validation issues in the flow.
//
// The following types satisfy this interface:
//
//	FlowValidationDetailsMemberCyclicConnection
//	FlowValidationDetailsMemberDuplicateConditionExpression
//	FlowValidationDetailsMemberDuplicateConnections
//	FlowValidationDetailsMemberIncompatibleConnectionDataType
//	FlowValidationDetailsMemberInvalidLoopBoundary
//	FlowValidationDetailsMemberLoopIncompatibleNodeType
//	FlowValidationDetailsMemberMalformedConditionExpression
//	FlowValidationDetailsMemberMalformedNodeInputExpression
//	FlowValidationDetailsMemberMismatchedNodeInputType
//	FlowValidationDetailsMemberMismatchedNodeOutputType
//	FlowValidationDetailsMemberMissingConnectionConfiguration
//	FlowValidationDetailsMemberMissingDefaultCondition
//	FlowValidationDetailsMemberMissingEndingNodes
//	FlowValidationDetailsMemberMissingLoopControllerNode
//	FlowValidationDetailsMemberMissingLoopInputNode
//	FlowValidationDetailsMemberMissingNodeConfiguration
//	FlowValidationDetailsMemberMissingNodeInput
//	FlowValidationDetailsMemberMissingNodeOutput
//	FlowValidationDetailsMemberMissingStartingNodes
//	FlowValidationDetailsMemberMultipleLoopControllerNodes
//	FlowValidationDetailsMemberMultipleLoopInputNodes
//	FlowValidationDetailsMemberMultipleNodeInputConnections
//	FlowValidationDetailsMemberUnfulfilledNodeInput
//	FlowValidationDetailsMemberUnknownConnectionCondition
//	FlowValidationDetailsMemberUnknownConnectionSource
//	FlowValidationDetailsMemberUnknownConnectionSourceOutput
//	FlowValidationDetailsMemberUnknownConnectionTarget
//	FlowValidationDetailsMemberUnknownConnectionTargetInput
//	FlowValidationDetailsMemberUnknownNodeInput
//	FlowValidationDetailsMemberUnknownNodeOutput
//	FlowValidationDetailsMemberUnreachableNode
//	FlowValidationDetailsMemberUnsatisfiedConnectionConditions
//	FlowValidationDetailsMemberUnspecified
type FlowValidationDetails interface {
	isFlowValidationDetails()
}

// Details about a cyclic connection in the flow.
type FlowValidationDetailsMemberCyclicConnection struct {
	Value CyclicConnectionFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberCyclicConnection) isFlowValidationDetails() {}

// Details about duplicate condition expressions in a node.
type FlowValidationDetailsMemberDuplicateConditionExpression struct {
	Value DuplicateConditionExpressionFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberDuplicateConditionExpression) isFlowValidationDetails() {}

// Details about duplicate connections between nodes.
type FlowValidationDetailsMemberDuplicateConnections struct {
	Value DuplicateConnectionsFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberDuplicateConnections) isFlowValidationDetails() {}

// Details about incompatible data types in a connection.
type FlowValidationDetailsMemberIncompatibleConnectionDataType struct {
	Value IncompatibleConnectionDataTypeFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberIncompatibleConnectionDataType) isFlowValidationDetails() {}

// Details about a flow that includes connections that violate loop boundary rules.
type FlowValidationDetailsMemberInvalidLoopBoundary struct {
	Value InvalidLoopBoundaryFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberInvalidLoopBoundary) isFlowValidationDetails() {}

// Details about a flow that includes incompatible node types in a DoWhile loop.
type FlowValidationDetailsMemberLoopIncompatibleNodeType struct {
	Value LoopIncompatibleNodeTypeFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberLoopIncompatibleNodeType) isFlowValidationDetails() {}

// Details about a malformed condition expression in a node.
type FlowValidationDetailsMemberMalformedConditionExpression struct {
	Value MalformedConditionExpressionFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMalformedConditionExpression) isFlowValidationDetails() {}

// Details about a malformed input expression in a node.
type FlowValidationDetailsMemberMalformedNodeInputExpression struct {
	Value MalformedNodeInputExpressionFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMalformedNodeInputExpression) isFlowValidationDetails() {}

// Details about mismatched input data types in a node.
type FlowValidationDetailsMemberMismatchedNodeInputType struct {
	Value MismatchedNodeInputTypeFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMismatchedNodeInputType) isFlowValidationDetails() {}

// Details about mismatched output data types in a node.
type FlowValidationDetailsMemberMismatchedNodeOutputType struct {
	Value MismatchedNodeOutputTypeFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMismatchedNodeOutputType) isFlowValidationDetails() {}

// Details about missing configuration for a connection.
type FlowValidationDetailsMemberMissingConnectionConfiguration struct {
	Value MissingConnectionConfigurationFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMissingConnectionConfiguration) isFlowValidationDetails() {}

// Details about a missing default condition in a conditional node.
type FlowValidationDetailsMemberMissingDefaultCondition struct {
	Value MissingDefaultConditionFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMissingDefaultCondition) isFlowValidationDetails() {}

// Details about missing ending nodes in the flow.
type FlowValidationDetailsMemberMissingEndingNodes struct {
	Value MissingEndingNodesFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMissingEndingNodes) isFlowValidationDetails() {}

// Details about a flow that's missing a required LoopController node in a DoWhile
// loop.
type FlowValidationDetailsMemberMissingLoopControllerNode struct {
	Value MissingLoopControllerNodeFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMissingLoopControllerNode) isFlowValidationDetails() {}

// Details about a flow that's missing a required LoopInput node in a DoWhile loop.
type FlowValidationDetailsMemberMissingLoopInputNode struct {
	Value MissingLoopInputNodeFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMissingLoopInputNode) isFlowValidationDetails() {}

// Details about missing configuration for a node.
type FlowValidationDetailsMemberMissingNodeConfiguration struct {
	Value MissingNodeConfigurationFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMissingNodeConfiguration) isFlowValidationDetails() {}

// Details about a missing required input in a node.
type FlowValidationDetailsMemberMissingNodeInput struct {
	Value MissingNodeInputFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMissingNodeInput) isFlowValidationDetails() {}

// Details about a missing required output in a node.
type FlowValidationDetailsMemberMissingNodeOutput struct {
	Value MissingNodeOutputFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMissingNodeOutput) isFlowValidationDetails() {}

// Details about missing starting nodes in the flow.
type FlowValidationDetailsMemberMissingStartingNodes struct {
	Value MissingStartingNodesFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMissingStartingNodes) isFlowValidationDetails() {}

// Details about a flow that contains multiple LoopController nodes in a DoWhile
// loop.
type FlowValidationDetailsMemberMultipleLoopControllerNodes struct {
	Value MultipleLoopControllerNodesFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMultipleLoopControllerNodes) isFlowValidationDetails() {}

// Details about a flow that contains multiple LoopInput nodes in a DoWhile loop.
type FlowValidationDetailsMemberMultipleLoopInputNodes struct {
	Value MultipleLoopInputNodesFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMultipleLoopInputNodes) isFlowValidationDetails() {}

// Details about multiple connections to a single node input.
type FlowValidationDetailsMemberMultipleNodeInputConnections struct {
	Value MultipleNodeInputConnectionsFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberMultipleNodeInputConnections) isFlowValidationDetails() {}

// Details about an unfulfilled node input with no valid connections.
type FlowValidationDetailsMemberUnfulfilledNodeInput struct {
	Value UnfulfilledNodeInputFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberUnfulfilledNodeInput) isFlowValidationDetails() {}

// Details about an unknown condition for a connection.
type FlowValidationDetailsMemberUnknownConnectionCondition struct {
	Value UnknownConnectionConditionFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberUnknownConnectionCondition) isFlowValidationDetails() {}

// Details about an unknown source node for a connection.
type FlowValidationDetailsMemberUnknownConnectionSource struct {
	Value UnknownConnectionSourceFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberUnknownConnectionSource) isFlowValidationDetails() {}

// Details about an unknown source output for a connection.
type FlowValidationDetailsMemberUnknownConnectionSourceOutput struct {
	Value UnknownConnectionSourceOutputFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberUnknownConnectionSourceOutput) isFlowValidationDetails() {}

// Details about an unknown target node for a connection.
type FlowValidationDetailsMemberUnknownConnectionTarget struct {
	Value UnknownConnectionTargetFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberUnknownConnectionTarget) isFlowValidationDetails() {}

// Details about an unknown target input for a connection.
type FlowValidationDetailsMemberUnknownConnectionTargetInput struct {
	Value UnknownConnectionTargetInputFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberUnknownConnectionTargetInput) isFlowValidationDetails() {}

// Details about an unknown input for a node.
type FlowValidationDetailsMemberUnknownNodeInput struct {
	Value UnknownNodeInputFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberUnknownNodeInput) isFlowValidationDetails() {}

// Details about an unknown output for a node.
type FlowValidationDetailsMemberUnknownNodeOutput struct {
	Value UnknownNodeOutputFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberUnknownNodeOutput) isFlowValidationDetails() {}

// Details about an unreachable node in the flow.
type FlowValidationDetailsMemberUnreachableNode struct {
	Value UnreachableNodeFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberUnreachableNode) isFlowValidationDetails() {}

// Details about unsatisfied conditions for a connection.
type FlowValidationDetailsMemberUnsatisfiedConnectionConditions struct {
	Value UnsatisfiedConnectionConditionsFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberUnsatisfiedConnectionConditions) isFlowValidationDetails() {}

// Details about an unspecified validation.
type FlowValidationDetailsMemberUnspecified struct {
	Value UnspecifiedFlowValidationDetails

	noSmithyDocumentSerde
}

func (*FlowValidationDetailsMemberUnspecified) isFlowValidationDetails() {}

// Contains information about a version of a flow.
//
// This data type is used in the following API operations:
//
// [ListFlowVersions response]
//
// [ListFlowVersions response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListFlowVersions.html#API_agent_ListFlowVersions_ResponseSyntax
type FlowVersionSummary struct {

	// The Amazon Resource Name (ARN) of the flow that the version belongs to.
	//
	// This member is required.
	Arn *string

	// The time at the version was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the flow.
	//
	// This member is required.
	Id *string

	// The status of the flow.
	//
	// This member is required.
	Status FlowStatus

	// The version of the flow.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// Defines parameters that the agent needs to invoke from the user to complete the
// function. Corresponds to an action in an action group.
//
// This data type is used in the following API operations:
//
// [CreateAgentActionGroup request]
//
// [CreateAgentActionGroup response]
//
// [UpdateAgentActionGroup request]
//
// [UpdateAgentActionGroup response]
//
// [GetAgentActionGroup response]
//
// [CreateAgentActionGroup response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_ResponseSyntax
// [GetAgentActionGroup response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html#API_agent_GetAgentActionGroup_ResponseSyntax
// [UpdateAgentActionGroup request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_RequestSyntax
// [CreateAgentActionGroup request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_RequestSyntax
// [UpdateAgentActionGroup response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_ResponseSyntax
type Function struct {

	// A name for the function.
	//
	// This member is required.
	Name *string

	// A description of the function and its purpose.
	Description *string

	// The parameters that the agent elicits from the user to fulfill the function.
	Parameters map[string]ParameterDetail

	// Contains information if user confirmation is required to invoke the function.
	RequireConfirmation RequireConfirmation

	noSmithyDocumentSerde
}

// Defines functions that each define parameters that the agent needs to invoke
// from the user. Each function represents an action in an action group.
//
// This data type is used in the following API operations:
//
// [CreateAgentActionGroup request]
//
// [CreateAgentActionGroup response]
//
// [UpdateAgentActionGroup request]
//
// [UpdateAgentActionGroup response]
//
// [GetAgentActionGroup response]
//
// The following types satisfy this interface:
//
//	FunctionSchemaMemberFunctions
//
// [CreateAgentActionGroup response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_ResponseSyntax
// [GetAgentActionGroup response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html#API_agent_GetAgentActionGroup_ResponseSyntax
// [UpdateAgentActionGroup request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_RequestSyntax
// [CreateAgentActionGroup request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_RequestSyntax
// [UpdateAgentActionGroup response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_ResponseSyntax
type FunctionSchema interface {
	isFunctionSchema()
}

// A list of functions that each define an action in the action group.
type FunctionSchemaMemberFunctions struct {
	Value []Function

	noSmithyDocumentSerde
}

func (*FunctionSchemaMemberFunctions) isFunctionSchema() {}

// Details about a guardrail associated with a resource.
type GuardrailConfiguration struct {

	// The unique identifier of the guardrail.
	GuardrailIdentifier *string

	// The version of the guardrail.
	GuardrailVersion *string

	noSmithyDocumentSerde
}

// Settings for hierarchical document chunking for a data source. Hierarchical
// chunking splits documents into layers of chunks where the first layer contains
// large chunks, and the second layer contains smaller chunks derived from the
// first layer.
//
// You configure the number of tokens to overlap, or repeat across adjacent
// chunks. For example, if you set overlap tokens to 60, the last 60 tokens in the
// first chunk are also included at the beginning of the second chunk. For each
// layer, you must also configure the maximum number of tokens in a chunk.
type HierarchicalChunkingConfiguration struct {

	// Token settings for each layer.
	//
	// This member is required.
	LevelConfigurations []HierarchicalChunkingLevelConfiguration

	// The number of tokens to repeat across chunks in the same layer.
	//
	// This member is required.
	OverlapTokens *int32

	noSmithyDocumentSerde
}

// Token settings for a layer in a hierarchical chunking configuration.
type HierarchicalChunkingLevelConfiguration struct {

	// The maximum number of tokens that a chunk can contain in this layer.
	//
	// This member is required.
	MaxTokens *int32

	noSmithyDocumentSerde
}

// Details about incompatible data types in a connection between nodes.
type IncompatibleConnectionDataTypeFlowValidationDetails struct {

	// The name of the connection with incompatible data types.
	//
	// This member is required.
	Connection *string

	noSmithyDocumentSerde
}

// Contains inference parameters to use when the agent invokes a foundation model
// in the part of the agent sequence defined by the promptType . For more
// information, see [Inference parameters for foundation models].
//
// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
type InferenceConfiguration struct {

	// The maximum number of tokens to allow in the generated response.
	MaximumLength *int32

	// A list of stop sequences. A stop sequence is a sequence of characters that
	// causes the model to stop generating the response.
	StopSequences []string

	// The likelihood of the model selecting higher-probability options while
	// generating a response. A lower value makes the model more likely to choose
	// higher-probability options, while a higher value makes the model more likely to
	// choose lower-probability options.
	Temperature *float32

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for topK is
	// the number of most-likely candidates from which the model chooses the next token
	// in the sequence. For example, if you set topK to 50, the model selects the next
	// token from among the top 50 most likely choices.
	TopK *int32

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for Top P
	// determines the number of most-likely candidates from which the model chooses the
	// next token in the sequence. For example, if you set topP to 0.8, the model only
	// selects the next token from the top 80% of the probability distribution of next
	// tokens.
	TopP *float32

	noSmithyDocumentSerde
}

// Contains details about a data ingestion job. Data sources are ingested into a
// knowledge base so that Large Language Models (LLMs) can use your data.
//
// This data type is used in the following API operations:
//
// [StartIngestionJob response]
//
// [GetIngestionJob response]
//
// [ListIngestionJob response]
//
// [StartIngestionJob response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_StartIngestionJob.html#API_agent_StartIngestionJob_ResponseSyntax
// [ListIngestionJob response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListIngestionJobs.html#API_agent_ListIngestionJobs_ResponseSyntax
// [GetIngestionJob response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetIngestionJob.html#API_agent_GetIngestionJob_ResponseSyntax
type IngestionJob struct {

	// The unique identifier of the data source for the data ingestion job.
	//
	// This member is required.
	DataSourceId *string

	// The unique identifier of the data ingestion job.
	//
	// This member is required.
	IngestionJobId *string

	// The unique identifier of the knowledge for the data ingestion job.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The time the data ingestion job started.
	//
	// If you stop a data ingestion job, the startedAt time is the time the job was
	// started before the job was stopped.
	//
	// This member is required.
	StartedAt *time.Time

	// The status of the data ingestion job.
	//
	// This member is required.
	Status IngestionJobStatus

	// The time the data ingestion job was last updated.
	//
	// If you stop a data ingestion job, the updatedAt time is the time the job was
	// stopped.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the data ingestion job.
	Description *string

	// A list of reasons that the data ingestion job failed.
	FailureReasons []string

	// Contains statistics about the data ingestion job.
	Statistics *IngestionJobStatistics

	noSmithyDocumentSerde
}

// The definition of a filter to filter the data.
type IngestionJobFilter struct {

	// The name of field or attribute to apply the filter.
	//
	// This member is required.
	Attribute IngestionJobFilterAttribute

	// The operation to apply to the field or attribute.
	//
	// This member is required.
	Operator IngestionJobFilterOperator

	// A list of values that belong to the field or attribute.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The parameters of sorting the data.
type IngestionJobSortBy struct {

	// The name of field or attribute to apply sorting of data.
	//
	// This member is required.
	Attribute IngestionJobSortByAttribute

	// The order for sorting the data.
	//
	// This member is required.
	Order SortOrder

	noSmithyDocumentSerde
}

// Contains the statistics for the data ingestion job.
type IngestionJobStatistics struct {

	// The number of source documents that were deleted.
	NumberOfDocumentsDeleted int64

	// The number of source documents that failed to be ingested.
	NumberOfDocumentsFailed int64

	// The total number of source documents that were scanned. Includes new, updated,
	// and unchanged documents.
	NumberOfDocumentsScanned int64

	// The number of metadata files that were updated or deleted.
	NumberOfMetadataDocumentsModified int64

	// The total number of metadata files that were scanned. Includes new, updated,
	// and unchanged files.
	NumberOfMetadataDocumentsScanned int64

	// The number of modified source documents in the data source that were
	// successfully indexed.
	NumberOfModifiedDocumentsIndexed int64

	// The number of new source documents in the data source that were successfully
	// indexed.
	NumberOfNewDocumentsIndexed int64

	noSmithyDocumentSerde
}

// Contains details about a data ingestion job.
type IngestionJobSummary struct {

	// The unique identifier of the data source for the data ingestion job.
	//
	// This member is required.
	DataSourceId *string

	// The unique identifier of the data ingestion job.
	//
	// This member is required.
	IngestionJobId *string

	// The unique identifier of the knowledge base for the data ingestion job.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The time the data ingestion job started.
	//
	// This member is required.
	StartedAt *time.Time

	// The status of the data ingestion job.
	//
	// This member is required.
	Status IngestionJobStatus

	// The time the data ingestion job was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the data ingestion job.
	Description *string

	// Contains statistics for the data ingestion job.
	Statistics *IngestionJobStatistics

	noSmithyDocumentSerde
}

// Contains configurations for an inline code node in your flow. Inline code nodes
// let you write and execute code directly within your flow, enabling data
// transformations, custom logic, and integrations without needing an external
// Lambda function.
type InlineCodeFlowNodeConfiguration struct {

	// The code that's executed in your inline code node. The code can access input
	// data from previous nodes in the flow, perform operations on that data, and
	// produce output that can be used by other nodes in your flow.
	//
	// The code must be valid in the programming language that you specify.
	//
	// This member is required.
	Code *string

	// The programming language used by your inline code node.
	//
	// The code must be valid in the programming language that you specify. Currently,
	// only Python 3 ( Python_3 ) is supported.
	//
	// This member is required.
	Language SupportedLanguages

	noSmithyDocumentSerde
}

// Contains information about content defined inline to ingest into a data source.
// Choose a type and include the field that corresponds to it.
type InlineContent struct {

	// The type of inline content to define.
	//
	// This member is required.
	Type InlineContentType

	// Contains information about content defined inline in bytes.
	ByteContent *ByteContentDoc

	// Contains information about content defined inline in text.
	TextContent *TextContentDoc

	noSmithyDocumentSerde
}

// Contains configurations for the input flow node for a flow. This node takes the
// input from flow invocation and passes it to the next node in the data type that
// you specify.
type InputFlowNodeConfiguration struct {
	noSmithyDocumentSerde
}

// A location for storing content from data sources temporarily as it is processed
// by custom components in the ingestion pipeline.
type IntermediateStorage struct {

	// An S3 bucket path.
	//
	// This member is required.
	S3Location *S3Location

	noSmithyDocumentSerde
}

// Details about a flow that contains connections that violate loop boundary rules.
type InvalidLoopBoundaryFlowValidationDetails struct {

	// The name of the connection that violates loop boundary rules.
	//
	// This member is required.
	Connection *string

	// The source node of the connection that violates DoWhile loop boundary rules.
	//
	// This member is required.
	Source *string

	// The target node of the connection that violates DoWhile loop boundary rules.
	//
	// This member is required.
	Target *string

	noSmithyDocumentSerde
}

// Contains configurations for an iterator node in a flow. Takes an input that is
// an array and iteratively sends each item of the array as an output to the
// following node. The size of the array is also returned in the output.
//
// The output flow node at the end of the flow iteration will return a response
// for each member of the array. To return only one response, you can include a
// collector node downstream from the iterator node.
type IteratorFlowNodeConfiguration struct {
	noSmithyDocumentSerde
}

// Settings for an Amazon Kendra knowledge base.
type KendraKnowledgeBaseConfiguration struct {

	// The ARN of the Amazon Kendra index.
	//
	// This member is required.
	KendraIndexArn *string

	noSmithyDocumentSerde
}

// Contains information about a knowledge base.
type KnowledgeBase struct {

	// The time the knowledge base was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the knowledge base.
	//
	// This member is required.
	KnowledgeBaseArn *string

	// Contains details about the embeddings configuration of the knowledge base.
	//
	// This member is required.
	KnowledgeBaseConfiguration *KnowledgeBaseConfiguration

	// The unique identifier of the knowledge base.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The name of the knowledge base.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API
	// operations on the knowledge base.
	//
	// This member is required.
	RoleArn *string

	// The status of the knowledge base. The following statuses are possible:
	//
	//   - CREATING – The knowledge base is being created.
	//
	//   - ACTIVE – The knowledge base is ready to be queried.
	//
	//   - DELETING – The knowledge base is being deleted.
	//
	//   - UPDATING – The knowledge base is being updated.
	//
	//   - FAILED – The knowledge base API operation failed.
	//
	// This member is required.
	Status KnowledgeBaseStatus

	// The time the knowledge base was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the knowledge base.
	Description *string

	// A list of reasons that the API operation on the knowledge base failed.
	FailureReasons []string

	// Contains details about the storage configuration of the knowledge base.
	StorageConfiguration *StorageConfiguration

	noSmithyDocumentSerde
}

// Contains details about the vector embeddings configuration of the knowledge
// base.
type KnowledgeBaseConfiguration struct {

	// The type of data that the data source is converted into for the knowledge base.
	//
	// This member is required.
	Type KnowledgeBaseType

	// Settings for an Amazon Kendra knowledge base.
	KendraKnowledgeBaseConfiguration *KendraKnowledgeBaseConfiguration

	// Specifies configurations for a knowledge base connected to an SQL database.
	SqlKnowledgeBaseConfiguration *SqlKnowledgeBaseConfiguration

	// Contains details about the model that's used to convert the data source into
	// vector embeddings.
	VectorKnowledgeBaseConfiguration *VectorKnowledgeBaseConfiguration

	noSmithyDocumentSerde
}

// Contains information about a document to ingest into a knowledge base and
// metadata to associate with it.
type KnowledgeBaseDocument struct {

	// Contains the content of the document.
	//
	// This member is required.
	Content *DocumentContent

	// Contains the metadata to associate with the document.
	Metadata *DocumentMetadata

	noSmithyDocumentSerde
}

// Contains the details for a document that was ingested or deleted.
type KnowledgeBaseDocumentDetail struct {

	// The identifier of the data source connected to the knowledge base that the
	// document was ingested into or deleted from.
	//
	// This member is required.
	DataSourceId *string

	// Contains information that identifies the document.
	//
	// This member is required.
	Identifier *DocumentIdentifier

	// The identifier of the knowledge base that the document was ingested into or
	// deleted from.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The ingestion status of the document. The following statuses are possible:
	//
	//   - STARTING – You submitted the ingestion job containing the document.
	//
	//   - PENDING – The document is waiting to be ingested.
	//
	//   - IN_PROGRESS – The document is being ingested.
	//
	//   - INDEXED – The document was successfully indexed.
	//
	//   - PARTIALLY_INDEXED – The document was partially indexed.
	//
	//   - METADATA_PARTIALLY_INDEXED – You submitted metadata for an existing
	//   document and it was partially indexed.
	//
	//   - METADATA_UPDATE_FAILED – You submitted a metadata update for an existing
	//   document but it failed.
	//
	//   - FAILED – The document failed to be ingested.
	//
	//   - NOT_FOUND – The document wasn't found.
	//
	//   - IGNORED – The document was ignored during ingestion.
	//
	//   - DELETING – You submitted the delete job containing the document.
	//
	//   - DELETE_IN_PROGRESS – The document is being deleted.
	//
	// This member is required.
	Status DocumentStatus

	// The reason for the status. Appears alongside the status IGNORED .
	StatusReason *string

	// The date and time at which the document was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains configurations for a knowledge base node in a flow. This node takes a
// query as the input and returns, as the output, the retrieved responses directly
// (as an array) or a response generated based on the retrieved responses. For more
// information, see [Node types in a flow]in the Amazon Bedrock User Guide.
//
// [Node types in a flow]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html
type KnowledgeBaseFlowNodeConfiguration struct {

	// The unique identifier of the knowledge base to query.
	//
	// This member is required.
	KnowledgeBaseId *string

	// Contains configurations for a guardrail to apply during query and response
	// generation for the knowledge base in this configuration.
	GuardrailConfiguration *GuardrailConfiguration

	// Contains inference configurations for the prompt.
	InferenceConfiguration PromptInferenceConfiguration

	// The unique identifier of the model or [inference profile] to use to generate a response from the
	// query results. Omit this field if you want to return the retrieved results as an
	// array.
	//
	// [inference profile]: https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html
	ModelId *string

	// The number of results to retrieve from the knowledge base.
	NumberOfResults *int32

	// The configuration for orchestrating the retrieval and generation process in the
	// knowledge base node.
	OrchestrationConfiguration *KnowledgeBaseOrchestrationConfiguration

	// A custom prompt template to use with the knowledge base for generating
	// responses.
	PromptTemplate *KnowledgeBasePromptTemplate

	// The configuration for reranking the retrieved results from the knowledge base
	// to improve relevance.
	RerankingConfiguration *VectorSearchRerankingConfiguration

	noSmithyDocumentSerde
}

// Configures how the knowledge base orchestrates the retrieval and generation
// process, allowing for customization of prompts, inference parameters, and
// performance settings.
type KnowledgeBaseOrchestrationConfiguration struct {

	// The additional model-specific request parameters as key-value pairs to be
	// included in the request to the foundation model.
	AdditionalModelRequestFields map[string]document.Interface

	// Contains inference configurations for the prompt.
	InferenceConfig PromptInferenceConfiguration

	// The performance configuration options for the knowledge base retrieval and
	// generation process.
	PerformanceConfig *PerformanceConfiguration

	// A custom prompt template for orchestrating the retrieval and generation process.
	PromptTemplate *KnowledgeBasePromptTemplate

	noSmithyDocumentSerde
}

// Defines a custom prompt template for orchestrating the retrieval and generation
// process.
type KnowledgeBasePromptTemplate struct {

	// The text of the prompt template.
	TextPromptTemplate *string

	noSmithyDocumentSerde
}

// Contains details about a knowledge base.
type KnowledgeBaseSummary struct {

	// The unique identifier of the knowledge base.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The name of the knowledge base.
	//
	// This member is required.
	Name *string

	// The status of the knowledge base.
	//
	// This member is required.
	Status KnowledgeBaseStatus

	// The time the knowledge base was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the knowledge base.
	Description *string

	noSmithyDocumentSerde
}

// Contains configurations for a Lambda function node in the flow. You specify the
// Lambda function to invoke and the inputs into the function. The output is the
// response that is defined in the Lambda function. For more information, see [Node types in a flow]in
// the Amazon Bedrock User Guide.
//
// [Node types in a flow]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html
type LambdaFunctionFlowNodeConfiguration struct {

	// The Amazon Resource Name (ARN) of the Lambda function to invoke.
	//
	// This member is required.
	LambdaArn *string

	noSmithyDocumentSerde
}

// Contains configurations for a Lex node in the flow. You specify a Amazon Lex
// bot to invoke. This node takes an utterance as the input and returns as the
// output the intent identified by the Amazon Lex bot. For more information, see [Node types in a flow]
// in the Amazon Bedrock User Guide.
//
// [Node types in a flow]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html
type LexFlowNodeConfiguration struct {

	// The Amazon Resource Name (ARN) of the Amazon Lex bot alias to invoke.
	//
	// This member is required.
	BotAliasArn *string

	// The Region to invoke the Amazon Lex bot in.
	//
	// This member is required.
	LocaleId *string

	noSmithyDocumentSerde
}

// Contains configurations for the controller node of a DoWhile loop in the flow.
type LoopControllerFlowNodeConfiguration struct {

	// Specifies the condition that determines when the flow exits the DoWhile loop.
	// The loop executes until this condition evaluates to true.
	//
	// This member is required.
	ContinueCondition *FlowCondition

	// Specifies the maximum number of times the DoWhile loop can iterate before the
	// flow exits the loop.
	MaxIterations *int32

	noSmithyDocumentSerde
}

// Contains configurations for the nodes of a DoWhile loop in your flow.
//
// A DoWhile loop is made up of the following nodes:
//
//   - Loop - The container node that holds the loop's flow definition. This node
//     encompasses the entire loop structure.
//
//   - LoopInput - The entry point node for the loop. This node receives inputs
//     from nodes outside the loop and from previous loop iterations.
//
//   - Body nodes - The processing nodes that execute within each loop iteration.
//     These can be nodes for handling data in your flow, such as a prompt or Lambda
//     function nodes. Some node types aren't supported inside a DoWhile loop body. For
//     more information, see [LoopIncompatibleNodeTypeFlowValidationDetails].
//
//   - LoopController - The node that evaluates whether the loop should continue or
//     exit based on a condition.
//
// These nodes work together to create a loop that runs at least once and
// continues until a specified condition is met or a maximum number of iterations
// is reached.
//
// [LoopIncompatibleNodeTypeFlowValidationDetails]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_LoopIncompatibleNodeTypeFlowValidationDetails.html
type LoopFlowNodeConfiguration struct {

	// The definition of the DoWhile loop nodes and connections between nodes in the
	// flow.
	//
	// This member is required.
	Definition *FlowDefinition

	noSmithyDocumentSerde
}

// Details about a flow that contains an incompatible node in a DoWhile loop.
type LoopIncompatibleNodeTypeFlowValidationDetails struct {

	// The node that's incompatible in the DoWhile loop.
	//
	// This member is required.
	IncompatibleNodeName *string

	// The node type of the incompatible node in the DoWhile loop. Some node types,
	// like a condition node, aren't allowed in a DoWhile loop.
	//
	// This member is required.
	IncompatibleNodeType IncompatibleLoopNodeType

	// The Loop container node that contains an incompatible node.
	//
	// This member is required.
	Node *string

	noSmithyDocumentSerde
}

// Contains configurations for the input node of a DoWhile loop in the flow.
type LoopInputFlowNodeConfiguration struct {
	noSmithyDocumentSerde
}

// Details about a malformed condition expression in a node.
type MalformedConditionExpressionFlowValidationDetails struct {

	// The error message describing why the condition expression is malformed.
	//
	// This member is required.
	Cause *string

	// The name of the malformed condition.
	//
	// This member is required.
	Condition *string

	// The name of the node containing the malformed condition expression.
	//
	// This member is required.
	Node *string

	noSmithyDocumentSerde
}

// Details about a malformed input expression in a node.
type MalformedNodeInputExpressionFlowValidationDetails struct {

	// The error message describing why the input expression is malformed.
	//
	// This member is required.
	Cause *string

	// The name of the input with the malformed expression.
	//
	// This member is required.
	Input *string

	// The name of the node containing the malformed input expression.
	//
	// This member is required.
	Node *string

	noSmithyDocumentSerde
}

// Details of the memory configuration.
type MemoryConfiguration struct {

	// The type of memory that is stored.
	//
	// This member is required.
	EnabledMemoryTypes []MemoryType

	// Contains the configuration for SESSION_SUMMARY memory type enabled for the
	// agent.
	SessionSummaryConfiguration *SessionSummaryConfiguration

	// The number of days the agent is configured to retain the conversational context.
	StorageDays *int32

	noSmithyDocumentSerde
}

// A message input or response from a model. For more information, see [Create a prompt using Prompt management].
//
// [Create a prompt using Prompt management]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html
type Message struct {

	// The content in the message.
	//
	// This member is required.
	Content []ContentBlock

	// The role that the message belongs to.
	//
	// This member is required.
	Role ConversationRole

	noSmithyDocumentSerde
}

// Contains information about a metadata attribute.
type MetadataAttribute struct {

	// The key of the metadata attribute.
	//
	// This member is required.
	Key *string

	// Contains the value of the metadata attribute.
	//
	// This member is required.
	Value *MetadataAttributeValue

	noSmithyDocumentSerde
}

// Contains the value of the metadata attribute. Choose a type and include the
// field that corresponds to it.
type MetadataAttributeValue struct {

	// The type of the metadata attribute.
	//
	// This member is required.
	Type MetadataValueType

	// The value of the Boolean metadata attribute.
	BooleanValue *bool

	// The value of the numeric metadata attribute.
	NumberValue *float64

	// An array of strings that define the value of the metadata attribute.
	StringListValue []string

	// The value of the string metadata attribute.
	StringValue *string

	noSmithyDocumentSerde
}

// Specifies how metadata fields should be handled during the reranking process.
type MetadataConfigurationForReranking struct {

	// The mode for selecting metadata fields for reranking.
	//
	// This member is required.
	SelectionMode RerankingMetadataSelectionMode

	// The configuration for selective metadata field inclusion or exclusion during
	// reranking.
	SelectiveModeConfiguration RerankingMetadataSelectiveModeConfiguration

	noSmithyDocumentSerde
}

// Details about mismatched input data types in a node.
type MismatchedNodeInputTypeFlowValidationDetails struct {

	// The expected data type for the node input.
	//
	// This member is required.
	ExpectedType FlowNodeIODataType

	// The name of the input with the mismatched data type.
	//
	// This member is required.
	Input *string

	// The name of the node containing the input with the mismatched data type.
	//
	// This member is required.
	Node *string

	noSmithyDocumentSerde
}

// Details about mismatched output data types in a node.
type MismatchedNodeOutputTypeFlowValidationDetails struct {

	// The expected data type for the node output.
	//
	// This member is required.
	ExpectedType FlowNodeIODataType

	// The name of the node containing the output with the mismatched data type.
	//
	// This member is required.
	Node *string

	// The name of the output with the mismatched data type.
	//
	// This member is required.
	Output *string

	noSmithyDocumentSerde
}

// Details about a connection missing required configuration.
type MissingConnectionConfigurationFlowValidationDetails struct {

	// The name of the connection missing configuration.
	//
	// This member is required.
	Connection *string

	noSmithyDocumentSerde
}

// Details about a missing default condition in a conditional node.
type MissingDefaultConditionFlowValidationDetails struct {

	// The name of the node missing the default condition.
	//
	// This member is required.
	Node *string

	noSmithyDocumentSerde
}

// Details about missing ending nodes (such as FlowOutputNode) in the flow.
type MissingEndingNodesFlowValidationDetails struct {
	noSmithyDocumentSerde
}

// Details about a flow that's missing a required LoopController node in a DoWhile
// loop.
type MissingLoopControllerNodeFlowValidationDetails struct {

	// The DoWhile loop in a flow that's missing a required LoopController node.
	//
	// This member is required.
	LoopNode *string

	noSmithyDocumentSerde
}

// Details about a flow that's missing a required LoopInput node in a DoWhile loop.
type MissingLoopInputNodeFlowValidationDetails struct {

	// The DoWhile loop in a flow that's missing a required LoopInput node.
	//
	// This member is required.
	LoopNode *string

	noSmithyDocumentSerde
}

// Details about a node missing a required configuration.
type MissingNodeConfigurationFlowValidationDetails struct {

	// The name of the node missing a required configuration.
	//
	// This member is required.
	Node *string

	noSmithyDocumentSerde
}

// Details about a missing required input in a node.
type MissingNodeInputFlowValidationDetails struct {

	// The name of the missing input.
	//
	// This member is required.
	Input *string

	// The name of the node missing the required input.
	//
	// This member is required.
	Node *string

	noSmithyDocumentSerde
}

// Details about a missing required output in a node.
type MissingNodeOutputFlowValidationDetails struct {

	// The name of the node missing the required output.
	//
	// This member is required.
	Node *string

	// The name of the missing output.
	//
	// This member is required.
	Output *string

	noSmithyDocumentSerde
}

// Details about missing starting nodes (such as FlowInputNode) in the flow.
type MissingStartingNodesFlowValidationDetails struct {
	noSmithyDocumentSerde
}

// Contains details about the storage configuration of the knowledge base in
// MongoDB Atlas.
type MongoDbAtlasConfiguration struct {

	// The collection name of the knowledge base in MongoDB Atlas.
	//
	// This member is required.
	CollectionName *string

	// The Amazon Resource Name (ARN) of the secret that you created in Secrets
	// Manager that contains user credentials for your MongoDB Atlas cluster.
	//
	// This member is required.
	CredentialsSecretArn *string

	// The database name in your MongoDB Atlas cluster for your knowledge base.
	//
	// This member is required.
	DatabaseName *string

	// The endpoint URL of your MongoDB Atlas cluster for your knowledge base.
	//
	// This member is required.
	Endpoint *string

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// This member is required.
	FieldMapping *MongoDbAtlasFieldMapping

	// The name of the MongoDB Atlas vector search index.
	//
	// This member is required.
	VectorIndexName *string

	// The name of the VPC endpoint service in your account that is connected to your
	// MongoDB Atlas cluster.
	EndpointServiceName *string

	// The name of the text search index in the MongoDB collection. This is required
	// for using the hybrid search feature.
	TextIndexName *string

	noSmithyDocumentSerde
}

// Contains the names of the fields to which to map information about the vector
// store.
type MongoDbAtlasFieldMapping struct {

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// This member is required.
	MetadataField *string

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// This member is required.
	TextField *string

	// The name of the field in which Amazon Bedrock stores the vector embeddings for
	// your data sources.
	//
	// This member is required.
	VectorField *string

	noSmithyDocumentSerde
}

// Details about a flow that contains multiple LoopController nodes in a DoWhile
// loop.
type MultipleLoopControllerNodesFlowValidationDetails struct {

	// The DoWhile loop in a flow that contains multiple LoopController nodes.
	//
	// This member is required.
	LoopNode *string

	noSmithyDocumentSerde
}

// Details about a flow that contains multiple LoopInput nodes in a DoWhile loop.
type MultipleLoopInputNodesFlowValidationDetails struct {

	// The DoWhile loop in a flow that contains multiple LoopInput nodes.
	//
	// This member is required.
	LoopNode *string

	noSmithyDocumentSerde
}

// Details about multiple connections to a single node input.
type MultipleNodeInputConnectionsFlowValidationDetails struct {

	// The name of the input with multiple connections to it.
	//
	// This member is required.
	Input *string

	// The name of the node containing the input with multiple connections.
	//
	// This member is required.
	Node *string

	noSmithyDocumentSerde
}

// Contains details about the storage configuration of the knowledge base in
// Amazon Neptune Analytics. For more information, see [Create a vector index in Amazon Neptune Analytics].
//
// [Create a vector index in Amazon Neptune Analytics]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-neptune.html
type NeptuneAnalyticsConfiguration struct {

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// This member is required.
	FieldMapping *NeptuneAnalyticsFieldMapping

	// The Amazon Resource Name (ARN) of the Neptune Analytics vector store.
	//
	// This member is required.
	GraphArn *string

	noSmithyDocumentSerde
}

// Contains the names of the fields to which to map information about the vector
// store.
type NeptuneAnalyticsFieldMapping struct {

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// This member is required.
	MetadataField *string

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// This member is required.
	TextField *string

	noSmithyDocumentSerde
}

// Contains details about the Managed Cluster configuration of the knowledge base
// in Amazon OpenSearch Service. For more information, see [Create a vector index in OpenSearch Managed Cluster].
//
// [Create a vector index in OpenSearch Managed Cluster]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-osm.html
type OpenSearchManagedClusterConfiguration struct {

	// The Amazon Resource Name (ARN) of the OpenSearch domain.
	//
	// This member is required.
	DomainArn *string

	// The endpoint URL the OpenSearch domain.
	//
	// This member is required.
	DomainEndpoint *string

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// This member is required.
	FieldMapping *OpenSearchManagedClusterFieldMapping

	// The name of the vector store.
	//
	// This member is required.
	VectorIndexName *string

	noSmithyDocumentSerde
}

// Contains the names of the fields to which to map information about the vector
// store.
type OpenSearchManagedClusterFieldMapping struct {

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// This member is required.
	MetadataField *string

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// This member is required.
	TextField *string

	// The name of the field in which Amazon Bedrock stores the vector embeddings for
	// your data sources.
	//
	// This member is required.
	VectorField *string

	noSmithyDocumentSerde
}

// Contains details about the storage configuration of the knowledge base in
// Amazon OpenSearch Service. For more information, see [Create a vector index in Amazon OpenSearch Service].
//
// [Create a vector index in Amazon OpenSearch Service]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html
type OpenSearchServerlessConfiguration struct {

	// The Amazon Resource Name (ARN) of the OpenSearch Service vector store.
	//
	// This member is required.
	CollectionArn *string

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// This member is required.
	FieldMapping *OpenSearchServerlessFieldMapping

	// The name of the vector store.
	//
	// This member is required.
	VectorIndexName *string

	noSmithyDocumentSerde
}

// Contains the names of the fields to which to map information about the vector
// store.
type OpenSearchServerlessFieldMapping struct {

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// This member is required.
	MetadataField *string

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// This member is required.
	TextField *string

	// The name of the field in which Amazon Bedrock stores the vector embeddings for
	// your data sources.
	//
	// This member is required.
	VectorField *string

	noSmithyDocumentSerde
}

//	Contains details about the Lambda function containing the orchestration logic
//
// carried out upon invoking the custom orchestration.
//
// The following types satisfy this interface:
//
//	OrchestrationExecutorMemberLambda
type OrchestrationExecutor interface {
	isOrchestrationExecutor()
}

//	The Amazon Resource Name (ARN) of the Lambda function containing the business
//
// logic that is carried out upon invoking the action.
type OrchestrationExecutorMemberLambda struct {
	Value string

	noSmithyDocumentSerde
}

func (*OrchestrationExecutorMemberLambda) isOrchestrationExecutor() {}

// Contains configurations for an output flow node in the flow. You specify the
// data type expected for the input into the node in the type field and how to
// return the final output in the expression field.
type OutputFlowNodeConfiguration struct {
	noSmithyDocumentSerde
}

// Contains details about a parameter in a function for an action group.
//
// This data type is used in the following API operations:
//
// [CreateAgentActionGroup request]
//
// [CreateAgentActionGroup response]
//
// [UpdateAgentActionGroup request]
//
// [UpdateAgentActionGroup response]
//
// [GetAgentActionGroup response]
//
// [CreateAgentActionGroup response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_ResponseSyntax
// [GetAgentActionGroup response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html#API_agent_GetAgentActionGroup_ResponseSyntax
// [UpdateAgentActionGroup request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_RequestSyntax
// [CreateAgentActionGroup request]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_RequestSyntax
// [UpdateAgentActionGroup response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_ResponseSyntax
type ParameterDetail struct {

	// The data type of the parameter.
	//
	// This member is required.
	Type Type

	// A description of the parameter. Helps the foundation model determine how to
	// elicit the parameters from the user.
	Description *string

	// Whether the parameter is required for the agent to complete the function for
	// action group invocation.
	Required *bool

	noSmithyDocumentSerde
}

// Settings for parsing document contents. If you exclude this field, the default
// parser converts the contents of each document into text before splitting it into
// chunks. Specify the parsing strategy to use in the parsingStrategy field and
// include the relevant configuration, or omit it to use the Amazon Bedrock default
// parser. For more information, see [Parsing options for your data source].
//
// If you specify BEDROCK_DATA_AUTOMATION or BEDROCK_FOUNDATION_MODEL and it fails
// to parse a file, the Amazon Bedrock default parser will be used instead.
//
// [Parsing options for your data source]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-advanced-parsing.html
type ParsingConfiguration struct {

	// The parsing strategy for the data source.
	//
	// This member is required.
	ParsingStrategy ParsingStrategy

	// If you specify BEDROCK_DATA_AUTOMATION as the parsing strategy for ingesting
	// your data source, use this object to modify configurations for using the Amazon
	// Bedrock Data Automation parser.
	BedrockDataAutomationConfiguration *BedrockDataAutomationConfiguration

	// If you specify BEDROCK_FOUNDATION_MODEL as the parsing strategy for ingesting
	// your data source, use this object to modify configurations for using a
	// foundation model to parse documents.
	BedrockFoundationModelConfiguration *BedrockFoundationModelConfiguration

	noSmithyDocumentSerde
}

// Instructions for interpreting the contents of a document.
type ParsingPrompt struct {

	// Instructions for interpreting the contents of a document.
	//
	// This member is required.
	ParsingPromptText *string

	noSmithyDocumentSerde
}

// The specific filters applied to your data source content. You can filter out or
// include certain content.
type PatternObjectFilter struct {

	// The supported object type or content type of the data source.
	//
	// This member is required.
	ObjectType *string

	// A list of one or more exclusion regular expression patterns to exclude certain
	// object types that adhere to the pattern. If you specify an inclusion and
	// exclusion filter/pattern and both match a document, the exclusion filter takes
	// precedence and the document isn’t crawled.
	ExclusionFilters []string

	// A list of one or more inclusion regular expression patterns to include certain
	// object types that adhere to the pattern. If you specify an inclusion and
	// exclusion filter/pattern and both match a document, the exclusion filter takes
	// precedence and the document isn’t crawled.
	InclusionFilters []string

	noSmithyDocumentSerde
}

// The configuration of filtering certain objects or content types of the data
// source.
type PatternObjectFilterConfiguration struct {

	// The configuration of specific filters applied to your data source content. You
	// can filter out or include certain content.
	//
	// This member is required.
	Filters []PatternObjectFilter

	noSmithyDocumentSerde
}

// The performance-related configuration options for the knowledge base retrieval
// and generation process.
type PerformanceConfiguration struct {

	// The latency optimization setting.
	Latency PerformanceConfigLatency

	noSmithyDocumentSerde
}

// Contains details about the storage configuration of the knowledge base in
// Pinecone. For more information, see [Create a vector index in Pinecone].
//
// [Create a vector index in Pinecone]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-pinecone.html
type PineconeConfiguration struct {

	// The endpoint URL for your index management page.
	//
	// This member is required.
	ConnectionString *string

	// The Amazon Resource Name (ARN) of the secret that you created in Secrets
	// Manager that is linked to your Pinecone API key.
	//
	// This member is required.
	CredentialsSecretArn *string

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// This member is required.
	FieldMapping *PineconeFieldMapping

	// The namespace to be used to write new data to your database.
	Namespace *string

	noSmithyDocumentSerde
}

// Contains the names of the fields to which to map information about the vector
// store.
type PineconeFieldMapping struct {

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// This member is required.
	MetadataField *string

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// This member is required.
	TextField *string

	noSmithyDocumentSerde
}

// Contains specifications for an Amazon Bedrock agent with which to use the
// prompt. For more information, see [Create a prompt using Prompt management]and [Automate tasks in your application using conversational agents].
//
// [Automate tasks in your application using conversational agents]: https://docs.aws.amazon.com/bedrock/latest/userguide/agents.html
// [Create a prompt using Prompt management]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html
type PromptAgentResource struct {

	// The ARN of the agent with which to use the prompt.
	//
	// This member is required.
	AgentIdentifier *string

	noSmithyDocumentSerde
}

// Contains configurations to override a prompt template in one part of an agent
// sequence. For more information, see [Advanced prompts].
//
// [Advanced prompts]: https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html
type PromptConfiguration struct {

	// If the Converse or ConverseStream operations support the model,
	// additionalModelRequestFields contains additional inference parameters, beyond
	// the base set of inference parameters in the inferenceConfiguration field.
	//
	// For more information, see Inference request parameters and response fields for
	// foundation models in the Amazon Bedrock user guide.
	AdditionalModelRequestFields document.Interface

	// Defines the prompt template with which to replace the default prompt template.
	// You can use placeholder variables in the base prompt template to customize the
	// prompt. For more information, see [Prompt template placeholder variables]. For more information, see [Configure the prompt templates].
	//
	// [Configure the prompt templates]: https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts-configure.html
	// [Prompt template placeholder variables]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html
	BasePromptTemplate *string

	// The agent's foundation model.
	FoundationModel *string

	// Contains inference parameters to use when the agent invokes a foundation model
	// in the part of the agent sequence defined by the promptType . For more
	// information, see [Inference parameters for foundation models].
	//
	// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
	InferenceConfiguration *InferenceConfiguration

	// Specifies whether to override the default parser Lambda function when parsing
	// the raw foundation model output in the part of the agent sequence defined by the
	// promptType . If you set the field as OVERRIDDEN , the overrideLambda field in
	// the [PromptOverrideConfiguration]must be specified with the ARN of a Lambda function.
	//
	// [PromptOverrideConfiguration]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html
	ParserMode CreationMode

	// Specifies whether to override the default prompt template for this promptType .
	// Set this value to OVERRIDDEN to use the prompt that you provide in the
	// basePromptTemplate . If you leave it as DEFAULT , the agent uses a default
	// prompt template.
	PromptCreationMode CreationMode

	// Specifies whether to allow the agent to carry out the step specified in the
	// promptType . If you set this value to DISABLED , the agent skips that step. The
	// default state for each promptType is as follows.
	//
	//   - PRE_PROCESSING – DISABLED
	//
	//   - ORCHESTRATION – ENABLED
	//
	//   - KNOWLEDGE_BASE_RESPONSE_GENERATION – ENABLED
	//
	//   - POST_PROCESSING – DISABLED
	PromptState PromptState

	// The step in the agent sequence that this prompt configuration applies to.
	PromptType PromptType

	noSmithyDocumentSerde
}

// Contains configurations for a prompt node in the flow. You can use a prompt
// from Prompt management or you can define one in this node. If the prompt
// contains variables, the inputs into this node will fill in the variables. The
// output from this node is the response generated by the model. For more
// information, see [Node types in a flow]in the Amazon Bedrock User Guide.
//
// [Node types in a flow]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html
type PromptFlowNodeConfiguration struct {

	// Specifies whether the prompt is from Prompt management or defined inline.
	//
	// This member is required.
	SourceConfiguration PromptFlowNodeSourceConfiguration

	// Contains configurations for a guardrail to apply to the prompt in this node and
	// the response generated from it.
	GuardrailConfiguration *GuardrailConfiguration

	noSmithyDocumentSerde
}

// Contains configurations for a prompt defined inline in the node.
type PromptFlowNodeInlineConfiguration struct {

	// The unique identifier of the model or [inference profile] to run inference with.
	//
	// [inference profile]: https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html
	//
	// This member is required.
	ModelId *string

	// Contains a prompt and variables in the prompt that can be replaced with values
	// at runtime.
	//
	// This member is required.
	TemplateConfiguration PromptTemplateConfiguration

	// The type of prompt template.
	//
	// This member is required.
	TemplateType PromptTemplateType

	// Additional fields to be included in the model request for the Prompt node.
	AdditionalModelRequestFields document.Interface

	// Contains inference configurations for the prompt.
	InferenceConfiguration PromptInferenceConfiguration

	noSmithyDocumentSerde
}

// Contains configurations for a prompt from Prompt management to use in a node.
type PromptFlowNodeResourceConfiguration struct {

	// The Amazon Resource Name (ARN) of the prompt from Prompt management.
	//
	// This member is required.
	PromptArn *string

	noSmithyDocumentSerde
}

// Contains configurations for a prompt and whether it is from Prompt management
// or defined inline.
//
// The following types satisfy this interface:
//
//	PromptFlowNodeSourceConfigurationMemberInline
//	PromptFlowNodeSourceConfigurationMemberResource
type PromptFlowNodeSourceConfiguration interface {
	isPromptFlowNodeSourceConfiguration()
}

// Contains configurations for a prompt that is defined inline
type PromptFlowNodeSourceConfigurationMemberInline struct {
	Value PromptFlowNodeInlineConfiguration

	noSmithyDocumentSerde
}

func (*PromptFlowNodeSourceConfigurationMemberInline) isPromptFlowNodeSourceConfiguration() {}

// Contains configurations for a prompt from Prompt management.
type PromptFlowNodeSourceConfigurationMemberResource struct {
	Value PromptFlowNodeResourceConfiguration

	noSmithyDocumentSerde
}

func (*PromptFlowNodeSourceConfigurationMemberResource) isPromptFlowNodeSourceConfiguration() {}

// Contains specifications for a generative AI resource with which to use the
// prompt. For more information, see [Create a prompt using Prompt management].
//
// The following types satisfy this interface:
//
//	PromptGenAiResourceMemberAgent
//
// [Create a prompt using Prompt management]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html
type PromptGenAiResource interface {
	isPromptGenAiResource()
}

// Specifies an Amazon Bedrock agent with which to use the prompt.
type PromptGenAiResourceMemberAgent struct {
	Value PromptAgentResource

	noSmithyDocumentSerde
}

func (*PromptGenAiResourceMemberAgent) isPromptGenAiResource() {}

// Contains inference configurations for the prompt.
//
// The following types satisfy this interface:
//
//	PromptInferenceConfigurationMemberText
type PromptInferenceConfiguration interface {
	isPromptInferenceConfiguration()
}

// Contains inference configurations for a text prompt.
type PromptInferenceConfigurationMemberText struct {
	Value PromptModelInferenceConfiguration

	noSmithyDocumentSerde
}

func (*PromptInferenceConfigurationMemberText) isPromptInferenceConfiguration() {}

// Contains information about a variable in the prompt.
type PromptInputVariable struct {

	// The name of the variable.
	Name *string

	noSmithyDocumentSerde
}

// Contains a key-value pair that defines a metadata tag and value to attach to a
// prompt variant. For more information, see [Create a prompt using Prompt management].
//
// [Create a prompt using Prompt management]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html
type PromptMetadataEntry struct {

	// The key of a metadata tag for a prompt variant.
	//
	// This member is required.
	Key *string

	// The value of a metadata tag for a prompt variant.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Contains inference configurations related to model inference for a prompt. For
// more information, see [Inference parameters].
//
// [Inference parameters]: https://docs.aws.amazon.com/bedrock/latest/userguide/inference-parameters.html
type PromptModelInferenceConfiguration struct {

	// The maximum number of tokens to return in the response.
	MaxTokens *int32

	// A list of strings that define sequences after which the model will stop
	// generating.
	StopSequences []string

	// Controls the randomness of the response. Choose a lower value for more
	// predictable outputs and a higher value for more surprising outputs.
	Temperature *float32

	// The percentage of most-likely candidates that the model considers for the next
	// token.
	TopP *float32

	noSmithyDocumentSerde
}

// Contains configurations to override prompts in different parts of an agent
// sequence. For more information, see [Advanced prompts].
//
// [Advanced prompts]: https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html
type PromptOverrideConfiguration struct {

	// Contains configurations to override a prompt template in one part of an agent
	// sequence. For more information, see [Advanced prompts].
	//
	// [Advanced prompts]: https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html
	//
	// This member is required.
	PromptConfigurations []PromptConfiguration

	// The ARN of the Lambda function to use when parsing the raw foundation model
	// output in parts of the agent sequence. If you specify this field, at least one
	// of the promptConfigurations must contain a parserMode value that is set to
	// OVERRIDDEN . For more information, see [Parser Lambda function in Amazon Bedrock Agents].
	//
	// [Parser Lambda function in Amazon Bedrock Agents]: https://docs.aws.amazon.com/bedrock/latest/userguide/lambda-parser.html
	OverrideLambda *string

	noSmithyDocumentSerde
}

// Contains information about a prompt in your Prompt management tool.
//
// This data type is used in the following API operations:
//
// [ListPrompts response]
//
// [ListPrompts response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListPrompts.html#API_agent_ListPrompts_ResponseSyntax
type PromptSummary struct {

	// The Amazon Resource Name (ARN) of the prompt or the prompt version (if you
	// specified a version in the request).
	//
	// This member is required.
	Arn *string

	// The time at which the prompt was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the prompt.
	//
	// This member is required.
	Id *string

	// The name of the prompt.
	//
	// This member is required.
	Name *string

	// The time at which the prompt was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The version of the prompt that this summary applies to.
	//
	// This member is required.
	Version *string

	// The description of the prompt.
	Description *string

	noSmithyDocumentSerde
}

// Contains the message for a prompt. For more information, see [Construct and store reusable prompts with Prompt management in Amazon Bedrock].
//
// The following types satisfy this interface:
//
//	PromptTemplateConfigurationMemberChat
//	PromptTemplateConfigurationMemberText
//
// [Construct and store reusable prompts with Prompt management in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html
type PromptTemplateConfiguration interface {
	isPromptTemplateConfiguration()
}

// Contains configurations to use the prompt in a conversational format.
type PromptTemplateConfigurationMemberChat struct {
	Value ChatPromptTemplateConfiguration

	noSmithyDocumentSerde
}

func (*PromptTemplateConfigurationMemberChat) isPromptTemplateConfiguration() {}

// Contains configurations for the text in a message for a prompt.
type PromptTemplateConfigurationMemberText struct {
	Value TextPromptTemplateConfiguration

	noSmithyDocumentSerde
}

func (*PromptTemplateConfigurationMemberText) isPromptTemplateConfiguration() {}

// Contains details about a variant of the prompt.
type PromptVariant struct {

	// The name of the prompt variant.
	//
	// This member is required.
	Name *string

	// Contains configurations for the prompt template.
	//
	// This member is required.
	TemplateConfiguration PromptTemplateConfiguration

	// The type of prompt template to use.
	//
	// This member is required.
	TemplateType PromptTemplateType

	// Contains model-specific inference configurations that aren't in the
	// inferenceConfiguration field. To see model-specific inference parameters, see [Inference request parameters and response fields for foundation models].
	//
	// [Inference request parameters and response fields for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
	AdditionalModelRequestFields document.Interface

	// Specifies a generative AI resource with which to use the prompt.
	GenAiResource PromptGenAiResource

	// Contains inference configurations for the prompt variant.
	InferenceConfiguration PromptInferenceConfiguration

	// An array of objects, each containing a key-value pair that defines a metadata
	// tag and value to attach to a prompt variant.
	Metadata []PromptMetadataEntry

	// The unique identifier of the model or [inference profile] with which to run inference on the
	// prompt.
	//
	// [inference profile]: https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html
	ModelId *string

	noSmithyDocumentSerde
}

// Contains information about a column in the current table for the query engine
// to consider.
type QueryGenerationColumn struct {

	// A description of the column that helps the query engine understand the contents
	// of the column.
	Description *string

	// Specifies whether to include or exclude the column during query generation. If
	// you specify EXCLUDE , the column will be ignored. If you specify INCLUDE , all
	// other columns in the table will be ignored.
	Inclusion IncludeExclude

	// The name of the column for which the other fields in this object apply.
	Name *string

	noSmithyDocumentSerde
}

// Contains configurations for query generation. For more information, see [Build a knowledge base by connecting to a structured data source] in the
// Amazon Bedrock User Guide..
//
// [Build a knowledge base by connecting to a structured data source]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html
type QueryGenerationConfiguration struct {

	// The time after which query generation will time out.
	ExecutionTimeoutSeconds *int32

	// Specifies configurations for context to use during query generation.
	GenerationContext *QueryGenerationContext

	noSmithyDocumentSerde
}

// >Contains configurations for context to use during query generation.
type QueryGenerationContext struct {

	// An array of objects, each of which defines information about example queries to
	// help the query engine generate appropriate SQL queries.
	CuratedQueries []CuratedQuery

	// An array of objects, each of which defines information about a table in the
	// database.
	Tables []QueryGenerationTable

	noSmithyDocumentSerde
}

// Contains information about a table for the query engine to consider.
type QueryGenerationTable struct {

	// The name of the table for which the other fields in this object apply.
	//
	// This member is required.
	Name *string

	// An array of objects, each of which defines information about a column in the
	// table.
	Columns []QueryGenerationColumn

	// A description of the table that helps the query engine understand the contents
	// of the table.
	Description *string

	// Specifies whether to include or exclude the table during query generation. If
	// you specify EXCLUDE , the table will be ignored. If you specify INCLUDE , all
	// other tables will be ignored.
	Inclusion IncludeExclude

	noSmithyDocumentSerde
}

// Contains details about the storage configuration of the knowledge base in
// Amazon RDS. For more information, see [Create a vector index in Amazon RDS].
//
// [Create a vector index in Amazon RDS]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html
type RdsConfiguration struct {

	// The Amazon Resource Name (ARN) of the secret that you created in Secrets
	// Manager that is linked to your Amazon RDS database.
	//
	// This member is required.
	CredentialsSecretArn *string

	// The name of your Amazon RDS database.
	//
	// This member is required.
	DatabaseName *string

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// This member is required.
	FieldMapping *RdsFieldMapping

	// The Amazon Resource Name (ARN) of the vector store.
	//
	// This member is required.
	ResourceArn *string

	// The name of the table in the database.
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

// Contains the names of the fields to which to map information about the vector
// store.
type RdsFieldMapping struct {

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// This member is required.
	MetadataField *string

	// The name of the field in which Amazon Bedrock stores the ID for each entry.
	//
	// This member is required.
	PrimaryKeyField *string

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// This member is required.
	TextField *string

	// The name of the field in which Amazon Bedrock stores the vector embeddings for
	// your data sources.
	//
	// This member is required.
	VectorField *string

	// Provide a name for the universal metadata field where Amazon Bedrock will store
	// any custom metadata from your data source.
	CustomMetadataField *string

	noSmithyDocumentSerde
}

// Contains details about the storage configuration of the knowledge base in Redis
// Enterprise Cloud. For more information, see [Create a vector index in Redis Enterprise Cloud].
//
// [Create a vector index in Redis Enterprise Cloud]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html
type RedisEnterpriseCloudConfiguration struct {

	// The Amazon Resource Name (ARN) of the secret that you created in Secrets
	// Manager that is linked to your Redis Enterprise Cloud database.
	//
	// This member is required.
	CredentialsSecretArn *string

	// The endpoint URL of the Redis Enterprise Cloud database.
	//
	// This member is required.
	Endpoint *string

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// This member is required.
	FieldMapping *RedisEnterpriseCloudFieldMapping

	// The name of the vector index.
	//
	// This member is required.
	VectorIndexName *string

	noSmithyDocumentSerde
}

// Contains the names of the fields to which to map information about the vector
// store.
type RedisEnterpriseCloudFieldMapping struct {

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// This member is required.
	MetadataField *string

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// This member is required.
	TextField *string

	// The name of the field in which Amazon Bedrock stores the vector embeddings for
	// your data sources.
	//
	// This member is required.
	VectorField *string

	noSmithyDocumentSerde
}

// Contains configurations for an Amazon Redshift database. For more information,
// see [Build a knowledge base by connecting to a structured data source]in the Amazon Bedrock User Guide.
//
// [Build a knowledge base by connecting to a structured data source]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html
type RedshiftConfiguration struct {

	// Specifies configurations for an Amazon Redshift query engine.
	//
	// This member is required.
	QueryEngineConfiguration *RedshiftQueryEngineConfiguration

	// Specifies configurations for Amazon Redshift database storage.
	//
	// This member is required.
	StorageConfigurations []RedshiftQueryEngineStorageConfiguration

	// Specifies configurations for generating queries.
	QueryGenerationConfiguration *QueryGenerationConfiguration

	noSmithyDocumentSerde
}

// Contains configurations for authentication to an Amazon Redshift provisioned
// data warehouse. Specify the type of authentication to use in the type field and
// include the corresponding field. If you specify IAM authentication, you don't
// need to include another field.
type RedshiftProvisionedAuthConfiguration struct {

	// The type of authentication to use.
	//
	// This member is required.
	Type RedshiftProvisionedAuthType

	// The database username for authentication to an Amazon Redshift provisioned data
	// warehouse.
	DatabaseUser *string

	// The ARN of an Secrets Manager secret for authentication.
	UsernamePasswordSecretArn *string

	noSmithyDocumentSerde
}

// Contains configurations for a provisioned Amazon Redshift query engine.
type RedshiftProvisionedConfiguration struct {

	// Specifies configurations for authentication to Amazon Redshift.
	//
	// This member is required.
	AuthConfiguration *RedshiftProvisionedAuthConfiguration

	// The ID of the Amazon Redshift cluster.
	//
	// This member is required.
	ClusterIdentifier *string

	noSmithyDocumentSerde
}

// Contains configurations for storage in Glue Data Catalog.
type RedshiftQueryEngineAwsDataCatalogStorageConfiguration struct {

	// A list of names of the tables to use.
	//
	// This member is required.
	TableNames []string

	noSmithyDocumentSerde
}

// Contains configurations for an Amazon Redshift query engine. Specify the type
// of query engine in type and include the corresponding field. For more
// information, see [Build a knowledge base by connecting to a structured data source]in the Amazon Bedrock User Guide.
//
// [Build a knowledge base by connecting to a structured data source]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html
type RedshiftQueryEngineConfiguration struct {

	// The type of query engine.
	//
	// This member is required.
	Type RedshiftQueryEngineType

	// Specifies configurations for a provisioned Amazon Redshift query engine.
	ProvisionedConfiguration *RedshiftProvisionedConfiguration

	// Specifies configurations for a serverless Amazon Redshift query engine.
	ServerlessConfiguration *RedshiftServerlessConfiguration

	noSmithyDocumentSerde
}

// Contains configurations for storage in Amazon Redshift.
type RedshiftQueryEngineRedshiftStorageConfiguration struct {

	// The name of the Amazon Redshift database.
	//
	// This member is required.
	DatabaseName *string

	noSmithyDocumentSerde
}

// Contains configurations for Amazon Redshift data storage. Specify the data
// storage service to use in the type field and include the corresponding field.
// For more information, see [Build a knowledge base by connecting to a structured data source]in the Amazon Bedrock User Guide.
//
// [Build a knowledge base by connecting to a structured data source]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html
type RedshiftQueryEngineStorageConfiguration struct {

	// The data storage service to use.
	//
	// This member is required.
	Type RedshiftQueryEngineStorageType

	// Specifies configurations for storage in Glue Data Catalog.
	AwsDataCatalogConfiguration *RedshiftQueryEngineAwsDataCatalogStorageConfiguration

	// Specifies configurations for storage in Amazon Redshift.
	RedshiftConfiguration *RedshiftQueryEngineRedshiftStorageConfiguration

	noSmithyDocumentSerde
}

// Specifies configurations for authentication to a Redshift Serverless. Specify
// the type of authentication to use in the type field and include the
// corresponding field. If you specify IAM authentication, you don't need to
// include another field.
type RedshiftServerlessAuthConfiguration struct {

	// The type of authentication to use.
	//
	// This member is required.
	Type RedshiftServerlessAuthType

	// The ARN of an Secrets Manager secret for authentication.
	UsernamePasswordSecretArn *string

	noSmithyDocumentSerde
}

// Contains configurations for authentication to Amazon Redshift Serverless.
type RedshiftServerlessConfiguration struct {

	// Specifies configurations for authentication to an Amazon Redshift provisioned
	// data warehouse.
	//
	// This member is required.
	AuthConfiguration *RedshiftServerlessAuthConfiguration

	// The ARN of the Amazon Redshift workgroup.
	//
	// This member is required.
	WorkgroupArn *string

	noSmithyDocumentSerde
}

// Configures the metadata fields to include or exclude during the reranking
// process when using selective mode.
//
// The following types satisfy this interface:
//
//	RerankingMetadataSelectiveModeConfigurationMemberFieldsToExclude
//	RerankingMetadataSelectiveModeConfigurationMemberFieldsToInclude
type RerankingMetadataSelectiveModeConfiguration interface {
	isRerankingMetadataSelectiveModeConfiguration()
}

// Specifies the metadata fields to exclude from the reranking process.
type RerankingMetadataSelectiveModeConfigurationMemberFieldsToExclude struct {
	Value []FieldForReranking

	noSmithyDocumentSerde
}

func (*RerankingMetadataSelectiveModeConfigurationMemberFieldsToExclude) isRerankingMetadataSelectiveModeConfiguration() {
}

// Specifies the metadata fields to include in the reranking process.
type RerankingMetadataSelectiveModeConfigurationMemberFieldsToInclude struct {
	Value []FieldForReranking

	noSmithyDocumentSerde
}

func (*RerankingMetadataSelectiveModeConfigurationMemberFieldsToInclude) isRerankingMetadataSelectiveModeConfiguration() {
}

// Contains configurations for a Retrieval node in a flow. This node retrieves
// data from the Amazon S3 location that you specify and returns it as the output.
type RetrievalFlowNodeConfiguration struct {

	// Contains configurations for the service to use for retrieving data to return as
	// the output from the node.
	//
	// This member is required.
	ServiceConfiguration RetrievalFlowNodeServiceConfiguration

	noSmithyDocumentSerde
}

// Contains configurations for the Amazon S3 location from which to retrieve data
// to return as the output from the node.
type RetrievalFlowNodeS3Configuration struct {

	// The name of the Amazon S3 bucket from which to retrieve data.
	//
	// This member is required.
	BucketName *string

	noSmithyDocumentSerde
}

// Contains configurations for the service to use for retrieving data to return as
// the output from the node.
//
// The following types satisfy this interface:
//
//	RetrievalFlowNodeServiceConfigurationMemberS3
type RetrievalFlowNodeServiceConfiguration interface {
	isRetrievalFlowNodeServiceConfiguration()
}

// Contains configurations for the Amazon S3 location from which to retrieve data
// to return as the output from the node.
type RetrievalFlowNodeServiceConfigurationMemberS3 struct {
	Value RetrievalFlowNodeS3Configuration

	noSmithyDocumentSerde
}

func (*RetrievalFlowNodeServiceConfigurationMemberS3) isRetrievalFlowNodeServiceConfiguration() {}

// Contains information about the content to ingest into a knowledge base
// connected to an Amazon S3 data source.
type S3Content struct {

	// The S3 location of the file containing the content to ingest.
	//
	// This member is required.
	S3Location *S3Location

	noSmithyDocumentSerde
}

// The configuration information to connect to Amazon S3 as your data source.
type S3DataSourceConfiguration struct {

	// The Amazon Resource Name (ARN) of the S3 bucket that contains your data.
	//
	// This member is required.
	BucketArn *string

	// The account ID for the owner of the S3 bucket.
	BucketOwnerAccountId *string

	// A list of S3 prefixes to include certain files or content. For more
	// information, see [Organizing objects using prefixes].
	//
	// [Organizing objects using prefixes]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html
	InclusionPrefixes []string

	noSmithyDocumentSerde
}

// The identifier information for an Amazon S3 bucket.
type S3Identifier struct {

	// The name of the S3 bucket.
	S3BucketName *string

	// The S3 object key for the S3 resource.
	S3ObjectKey *string

	noSmithyDocumentSerde
}

// An Amazon S3 location.
type S3Location struct {

	// The location's URI. For example, s3://my-bucket/chunk-processor/ .
	//
	// This member is required.
	Uri *string

	noSmithyDocumentSerde
}

// Contains the storage configuration of the knowledge base for S3 vectors.
type S3VectorsConfiguration struct {

	// The Amazon Resource Name (ARN) of the vector index used for the knowledge base.
	// This ARN identifies the specific vector index resource within Amazon Bedrock.
	IndexArn *string

	// The name of the vector index used for the knowledge base. This name identifies
	// the vector index within the Amazon Bedrock service.
	IndexName *string

	// The Amazon Resource Name (ARN) of the S3 bucket where vector embeddings are
	// stored. This bucket contains the vector data used by the knowledge base.
	VectorBucketArn *string

	noSmithyDocumentSerde
}

// The configuration of the Salesforce content. For example, configuring specific
// types of Salesforce content.
type SalesforceCrawlerConfiguration struct {

	// The configuration of filtering the Salesforce content. For example, configuring
	// regular expression patterns to include or exclude certain content.
	FilterConfiguration *CrawlFilterConfiguration

	noSmithyDocumentSerde
}

// The configuration information to connect to Salesforce as your data source.
type SalesforceDataSourceConfiguration struct {

	// The endpoint information to connect to your Salesforce data source.
	//
	// This member is required.
	SourceConfiguration *SalesforceSourceConfiguration

	// The configuration of the Salesforce content. For example, configuring specific
	// types of Salesforce content.
	CrawlerConfiguration *SalesforceCrawlerConfiguration

	noSmithyDocumentSerde
}

// The endpoint information to connect to your Salesforce data source.
type SalesforceSourceConfiguration struct {

	// The supported authentication type to authenticate and connect to your
	// Salesforce instance.
	//
	// This member is required.
	AuthType SalesforceAuthType

	// The Amazon Resource Name of an Secrets Manager secret that stores your
	// authentication credentials for your Salesforce instance URL. For more
	// information on the key-value pairs that must be included in your secret,
	// depending on your authentication type, see [Salesforce connection configuration].
	//
	// [Salesforce connection configuration]: https://docs.aws.amazon.com/bedrock/latest/userguide/salesforce-data-source-connector.html#configuration-salesforce-connector
	//
	// This member is required.
	CredentialsSecretArn *string

	// The Salesforce host URL or instance URL.
	//
	// This member is required.
	HostUrl *string

	noSmithyDocumentSerde
}

// The seed or starting point URL. You should be authorized to crawl the URL.
type SeedUrl struct {

	// A seed or starting point URL.
	Url *string

	noSmithyDocumentSerde
}

// Settings for semantic document chunking for a data source. Semantic chunking
// splits a document into into smaller documents based on groups of similar content
// derived from the text with natural language processing.
//
// With semantic chunking, each sentence is compared to the next to determine how
// similar they are. You specify a threshold in the form of a percentile, where
// adjacent sentences that are less similar than that percentage of sentence pairs
// are divided into separate chunks. For example, if you set the threshold to 90,
// then the 10 percent of sentence pairs that are least similar are split. So if
// you have 101 sentences, 100 sentence pairs are compared, and the 10 with the
// least similarity are split, creating 11 chunks. These chunks are further split
// if they exceed the max token size.
//
// You must also specify a buffer size, which determines whether sentences are
// compared in isolation, or within a moving context window that includes the
// previous and following sentence. For example, if you set the buffer size to 1 ,
// the embedding for sentence 10 is derived from sentences 9, 10, and 11 combined.
type SemanticChunkingConfiguration struct {

	// The dissimilarity threshold for splitting chunks.
	//
	// This member is required.
	BreakpointPercentileThreshold *int32

	// The buffer size.
	//
	// This member is required.
	BufferSize *int32

	// The maximum number of tokens that a chunk can contain.
	//
	// This member is required.
	MaxTokens *int32

	noSmithyDocumentSerde
}

// Contains the configuration for server-side encryption.
type ServerSideEncryptionConfiguration struct {

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt the resource.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Configuration for SESSION_SUMMARY memory type enabled for the agent.
type SessionSummaryConfiguration struct {

	// Maximum number of recent session summaries to include in the agent's prompt
	// context.
	MaxRecentSessions *int32

	noSmithyDocumentSerde
}

// The configuration of the SharePoint content. For example, configuring specific
// types of SharePoint content.
type SharePointCrawlerConfiguration struct {

	// The configuration of filtering the SharePoint content. For example, configuring
	// regular expression patterns to include or exclude certain content.
	FilterConfiguration *CrawlFilterConfiguration

	noSmithyDocumentSerde
}

// The configuration information to connect to SharePoint as your data source.
type SharePointDataSourceConfiguration struct {

	// The endpoint information to connect to your SharePoint data source.
	//
	// This member is required.
	SourceConfiguration *SharePointSourceConfiguration

	// The configuration of the SharePoint content. For example, configuring specific
	// types of SharePoint content.
	CrawlerConfiguration *SharePointCrawlerConfiguration

	noSmithyDocumentSerde
}

// The endpoint information to connect to your SharePoint data source.
type SharePointSourceConfiguration struct {

	// The supported authentication type to authenticate and connect to your
	// SharePoint site/sites.
	//
	// This member is required.
	AuthType SharePointAuthType

	// The Amazon Resource Name of an Secrets Manager secret that stores your
	// authentication credentials for your SharePoint site/sites. For more information
	// on the key-value pairs that must be included in your secret, depending on your
	// authentication type, see [SharePoint connection configuration].
	//
	// [SharePoint connection configuration]: https://docs.aws.amazon.com/bedrock/latest/userguide/sharepoint-data-source-connector.html#configuration-sharepoint-connector
	//
	// This member is required.
	CredentialsSecretArn *string

	// The domain of your SharePoint instance or site URL/URLs.
	//
	// This member is required.
	Domain *string

	// The supported host type, whether online/cloud or server/on-premises.
	//
	// This member is required.
	HostType SharePointHostType

	// A list of one or more SharePoint site URLs.
	//
	// This member is required.
	SiteUrls []string

	// The identifier of your Microsoft 365 tenant.
	TenantId *string

	noSmithyDocumentSerde
}

// Defines a specific tool that the model must request. No text is generated but
// the results of tool use are sent back to the model to help generate a response.
// For more information, see [Use a tool to complete an Amazon Bedrock model response].
//
// [Use a tool to complete an Amazon Bedrock model response]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type SpecificToolChoice struct {

	// The name of the tool.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Contains configurations for a knowledge base connected to an SQL database.
// Specify the SQL database type in the type field and include the corresponding
// field. For more information, see [Build a knowledge base by connecting to a structured data source]in the Amazon Bedrock User Guide.
//
// [Build a knowledge base by connecting to a structured data source]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html
type SqlKnowledgeBaseConfiguration struct {

	// The type of SQL database to connect to the knowledge base.
	//
	// This member is required.
	Type QueryEngineType

	// Specifies configurations for a knowledge base connected to an Amazon Redshift
	// database.
	RedshiftConfiguration *RedshiftConfiguration

	noSmithyDocumentSerde
}

// Contains the storage configuration of the knowledge base.
type StorageConfiguration struct {

	// The vector store service in which the knowledge base is stored.
	//
	// This member is required.
	Type KnowledgeBaseStorageType

	// Contains the storage configuration of the knowledge base in MongoDB Atlas.
	MongoDbAtlasConfiguration *MongoDbAtlasConfiguration

	// Contains details about the Neptune Analytics configuration of the knowledge
	// base in Amazon Neptune. For more information, see [Create a vector index in Amazon Neptune Analytics.].
	//
	// [Create a vector index in Amazon Neptune Analytics.]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-neptune.html
	NeptuneAnalyticsConfiguration *NeptuneAnalyticsConfiguration

	// Contains details about the storage configuration of the knowledge base in
	// OpenSearch Managed Cluster. For more information, see [Create a vector index in Amazon OpenSearch Service].
	//
	// [Create a vector index in Amazon OpenSearch Service]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-osm.html
	OpensearchManagedClusterConfiguration *OpenSearchManagedClusterConfiguration

	// Contains the storage configuration of the knowledge base in Amazon OpenSearch
	// Service.
	OpensearchServerlessConfiguration *OpenSearchServerlessConfiguration

	// Contains the storage configuration of the knowledge base in Pinecone.
	PineconeConfiguration *PineconeConfiguration

	// Contains details about the storage configuration of the knowledge base in
	// Amazon RDS. For more information, see [Create a vector index in Amazon RDS].
	//
	// [Create a vector index in Amazon RDS]: https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html
	RdsConfiguration *RdsConfiguration

	// Contains the storage configuration of the knowledge base in Redis Enterprise
	// Cloud.
	RedisEnterpriseCloudConfiguration *RedisEnterpriseCloudConfiguration

	// The configuration settings for storing knowledge base data using S3 vectors.
	// This includes vector index information and S3 bucket details for vector storage.
	S3VectorsConfiguration *S3VectorsConfiguration

	noSmithyDocumentSerde
}

// Contains configurations for a Storage node in a flow. This node stores the
// input in an Amazon S3 location that you specify.
type StorageFlowNodeConfiguration struct {

	// Contains configurations for the service to use for storing the input into the
	// node.
	//
	// This member is required.
	ServiceConfiguration StorageFlowNodeServiceConfiguration

	noSmithyDocumentSerde
}

// Contains configurations for the Amazon S3 location in which to store the input
// into the node.
type StorageFlowNodeS3Configuration struct {

	// The name of the Amazon S3 bucket in which to store the input into the node.
	//
	// This member is required.
	BucketName *string

	noSmithyDocumentSerde
}

// Contains configurations for the service to use for storing the input into the
// node.
//
// The following types satisfy this interface:
//
//	StorageFlowNodeServiceConfigurationMemberS3
type StorageFlowNodeServiceConfiguration interface {
	isStorageFlowNodeServiceConfiguration()
}

// Contains configurations for the Amazon S3 location in which to store the input
// into the node.
type StorageFlowNodeServiceConfigurationMemberS3 struct {
	Value StorageFlowNodeS3Configuration

	noSmithyDocumentSerde
}

func (*StorageFlowNodeServiceConfigurationMemberS3) isStorageFlowNodeServiceConfiguration() {}

// Specifies configurations for the storage location of the images extracted from
// multimodal documents in your data source. These images can be retrieved and
// returned to the end user.
type SupplementalDataStorageConfiguration struct {

	// A list of objects specifying storage locations for images extracted from
	// multimodal documents in your data source.
	//
	// This member is required.
	StorageLocations []SupplementalDataStorageLocation

	noSmithyDocumentSerde
}

// Contains information about a storage location for images extracted from
// multimodal documents in your data source.
type SupplementalDataStorageLocation struct {

	// Specifies the storage service used for this location.
	//
	// This member is required.
	Type SupplementalDataStorageLocationType

	// Contains information about the Amazon S3 location for the extracted images.
	S3Location *S3Location

	noSmithyDocumentSerde
}

// Contains a system prompt to provide context to the model or to describe how it
// should behave. For more information, see [Create a prompt using Prompt management].
//
// The following types satisfy this interface:
//
//	SystemContentBlockMemberCachePoint
//	SystemContentBlockMemberText
//
// [Create a prompt using Prompt management]: https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html
type SystemContentBlock interface {
	isSystemContentBlock()
}

// Creates a cache checkpoint within a tool designation
type SystemContentBlockMemberCachePoint struct {
	Value CachePointBlock

	noSmithyDocumentSerde
}

func (*SystemContentBlockMemberCachePoint) isSystemContentBlock() {}

// The text in the system prompt.
type SystemContentBlockMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*SystemContentBlockMemberText) isSystemContentBlock() {}

// Contains information about content defined inline in text.
type TextContentDoc struct {

	// The text of the content.
	//
	// This member is required.
	Data *string

	noSmithyDocumentSerde
}

// Contains configurations for a text prompt template. To include a variable,
// enclose a word in double curly braces as in {{variable}} .
type TextPromptTemplateConfiguration struct {

	// The message for the prompt.
	//
	// This member is required.
	Text *string

	// A cache checkpoint within a template configuration.
	CachePoint *CachePointBlock

	// An array of the variables in the prompt template.
	InputVariables []PromptInputVariable

	noSmithyDocumentSerde
}

// Contains configurations for a tool that a model can use when generating a
// response. For more information, see [Use a tool to complete an Amazon Bedrock model response].
//
// The following types satisfy this interface:
//
//	ToolMemberCachePoint
//	ToolMemberToolSpec
//
// [Use a tool to complete an Amazon Bedrock model response]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type Tool interface {
	isTool()
}

// Creates a cache checkpoint within a tool designation
type ToolMemberCachePoint struct {
	Value CachePointBlock

	noSmithyDocumentSerde
}

func (*ToolMemberCachePoint) isTool() {}

// The specification for the tool.
type ToolMemberToolSpec struct {
	Value ToolSpecification

	noSmithyDocumentSerde
}

func (*ToolMemberToolSpec) isTool() {}

// Defines which tools the model should request when invoked. For more
// information, see [Use a tool to complete an Amazon Bedrock model response].
//
// The following types satisfy this interface:
//
//	ToolChoiceMemberAny
//	ToolChoiceMemberAuto
//	ToolChoiceMemberTool
//
// [Use a tool to complete an Amazon Bedrock model response]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolChoice interface {
	isToolChoice()
}

// Defines tools, at least one of which must be requested by the model. No text is
// generated but the results of tool use are sent back to the model to help
// generate a response.
type ToolChoiceMemberAny struct {
	Value AnyToolChoice

	noSmithyDocumentSerde
}

func (*ToolChoiceMemberAny) isToolChoice() {}

// Defines tools. The model automatically decides whether to call a tool or to
// generate text instead.
type ToolChoiceMemberAuto struct {
	Value AutoToolChoice

	noSmithyDocumentSerde
}

func (*ToolChoiceMemberAuto) isToolChoice() {}

// Defines a specific tool that the model must request. No text is generated but
// the results of tool use are sent back to the model to help generate a response.
type ToolChoiceMemberTool struct {
	Value SpecificToolChoice

	noSmithyDocumentSerde
}

func (*ToolChoiceMemberTool) isToolChoice() {}

// Configuration information for the tools that the model can use when generating
// a response. For more information, see [Use a tool to complete an Amazon Bedrock model response].
//
// [Use a tool to complete an Amazon Bedrock model response]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolConfiguration struct {

	// An array of tools to pass to a model.
	//
	// This member is required.
	Tools []Tool

	// Defines which tools the model should request when invoked.
	ToolChoice ToolChoice

	noSmithyDocumentSerde
}

// The input schema for the tool. For more information, see [Use a tool to complete an Amazon Bedrock model response].
//
// The following types satisfy this interface:
//
//	ToolInputSchemaMemberJson
//
// [Use a tool to complete an Amazon Bedrock model response]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolInputSchema interface {
	isToolInputSchema()
}

// A JSON object defining the input schema for the tool.
type ToolInputSchemaMemberJson struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*ToolInputSchemaMemberJson) isToolInputSchema() {}

// Contains a specification for a tool. For more information, see [Use a tool to complete an Amazon Bedrock model response].
//
// [Use a tool to complete an Amazon Bedrock model response]: https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html
type ToolSpecification struct {

	// The input schema for the tool.
	//
	// This member is required.
	InputSchema ToolInputSchema

	// The name of the tool.
	//
	// This member is required.
	Name *string

	// The description of the tool.
	Description *string

	noSmithyDocumentSerde
}

// A custom processing step for documents moving through a data source ingestion
// pipeline. To process documents after they have been converted into chunks, set
// the step to apply to POST_CHUNKING .
type Transformation struct {

	// When the service applies the transformation.
	//
	// This member is required.
	StepToApply StepType

	// A Lambda function that processes documents.
	//
	// This member is required.
	TransformationFunction *TransformationFunction

	noSmithyDocumentSerde
}

// A Lambda function that processes documents.
type TransformationFunction struct {

	// The Lambda function.
	//
	// This member is required.
	TransformationLambdaConfiguration *TransformationLambdaConfiguration

	noSmithyDocumentSerde
}

// A Lambda function that processes documents.
type TransformationLambdaConfiguration struct {

	// The function's ARN identifier.
	//
	// This member is required.
	LambdaArn *string

	noSmithyDocumentSerde
}

// Details about an unfulfilled node input with no valid connections.
type UnfulfilledNodeInputFlowValidationDetails struct {

	// The name of the unfulfilled input. An input is unfulfilled if there are no data
	// connections to it.
	//
	// This member is required.
	Input *string

	// The name of the node containing the unfulfilled input.
	//
	// This member is required.
	Node *string

	noSmithyDocumentSerde
}

// Details about an unknown condition for a connection.
type UnknownConnectionConditionFlowValidationDetails struct {

	// The name of the connection with the unknown condition.
	//
	// This member is required.
	Connection *string

	noSmithyDocumentSerde
}

// Details about an unknown source node for a connection.
type UnknownConnectionSourceFlowValidationDetails struct {

	// The name of the connection with the unknown source.
	//
	// This member is required.
	Connection *string

	noSmithyDocumentSerde
}

// Details about an unknown source output for a connection.
type UnknownConnectionSourceOutputFlowValidationDetails struct {

	// The name of the connection with the unknown source output.
	//
	// This member is required.
	Connection *string

	noSmithyDocumentSerde
}

// Details about an unknown target node for a connection.
type UnknownConnectionTargetFlowValidationDetails struct {

	// The name of the connection with the unknown target.
	//
	// This member is required.
	Connection *string

	noSmithyDocumentSerde
}

// Details about an unknown target input for a connection.
type UnknownConnectionTargetInputFlowValidationDetails struct {

	// The name of the connection with the unknown target input.
	//
	// This member is required.
	Connection *string

	noSmithyDocumentSerde
}

// Details about an unknown input for a node.
type UnknownNodeInputFlowValidationDetails struct {

	// The name of the node with the unknown input.
	//
	// This member is required.
	Input *string

	// The name of the unknown input.
	//
	// This member is required.
	Node *string

	noSmithyDocumentSerde
}

// Details about an unknown output for a node.
type UnknownNodeOutputFlowValidationDetails struct {

	// The name of the node with the unknown output.
	//
	// This member is required.
	Node *string

	// The name of the unknown output.
	//
	// This member is required.
	Output *string

	noSmithyDocumentSerde
}

// Details about an unreachable node in the flow. A node is unreachable when there
// are no paths to it from any starting node.
type UnreachableNodeFlowValidationDetails struct {

	// The name of the unreachable node.
	//
	// This member is required.
	Node *string

	noSmithyDocumentSerde
}

// Details about unsatisfied conditions for a connection. A condition is
// unsatisfied if it can never be true, for example two branches of condition node
// cannot be simultaneously true.
type UnsatisfiedConnectionConditionsFlowValidationDetails struct {

	// The name of the connection with unsatisfied conditions.
	//
	// This member is required.
	Connection *string

	noSmithyDocumentSerde
}

// Details about an unspecified validation that doesn't fit other categories.
type UnspecifiedFlowValidationDetails struct {
	noSmithyDocumentSerde
}

// The configuration of web URLs that you want to crawl. You should be authorized
// to crawl the URLs.
type UrlConfiguration struct {

	// One or more seed or starting point URLs.
	SeedUrls []SeedUrl

	noSmithyDocumentSerde
}

// Stores information about a field passed inside a request that resulted in an
// validation error.
type ValidationExceptionField struct {

	// A message describing why this field failed validation.
	//
	// This member is required.
	Message *string

	// The name of the field.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Contains details about how to ingest the documents in a data source.
type VectorIngestionConfiguration struct {

	// Details about how to chunk the documents in the data source. A chunk refers to
	// an excerpt from a data source that is returned when the knowledge base that it
	// belongs to is queried.
	ChunkingConfiguration *ChunkingConfiguration

	// The context enrichment configuration used for ingestion of the data into the
	// vector store.
	ContextEnrichmentConfiguration *ContextEnrichmentConfiguration

	// A custom document transformer for parsed data source documents.
	CustomTransformationConfiguration *CustomTransformationConfiguration

	// Configurations for a parser to use for parsing documents in your data source.
	// If you exclude this field, the default parser will be used.
	ParsingConfiguration *ParsingConfiguration

	noSmithyDocumentSerde
}

// Contains details about the model used to create vector embeddings for the
// knowledge base.
type VectorKnowledgeBaseConfiguration struct {

	// The Amazon Resource Name (ARN) of the model used to create vector embeddings
	// for the knowledge base.
	//
	// This member is required.
	EmbeddingModelArn *string

	// The embeddings model configuration details for the vector model used in
	// Knowledge Base.
	EmbeddingModelConfiguration *EmbeddingModelConfiguration

	// If you include multimodal data from your data source, use this object to
	// specify configurations for the storage location of the images extracted from
	// your documents. These images can be retrieved and returned to the end user. They
	// can also be used in generation when using [RetrieveAndGenerate].
	//
	// [RetrieveAndGenerate]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html
	SupplementalDataStorageConfiguration *SupplementalDataStorageConfiguration

	noSmithyDocumentSerde
}

// Configures the Amazon Bedrock reranker model to improve the relevance of
// retrieved results.
type VectorSearchBedrockRerankingConfiguration struct {

	// Specifies the configuration for the Amazon Bedrock reranker model.
	//
	// This member is required.
	ModelConfiguration *VectorSearchBedrockRerankingModelConfiguration

	// Specifies how metadata fields should be handled during the reranking process.
	MetadataConfiguration *MetadataConfigurationForReranking

	// Specifies the number of results to return after reranking.
	NumberOfRerankedResults *int32

	noSmithyDocumentSerde
}

// Configures the Amazon Bedrock model used for reranking retrieved results.
type VectorSearchBedrockRerankingModelConfiguration struct {

	// The Amazon Resource Name (ARN) of the Amazon Bedrock reranker model.
	//
	// This member is required.
	ModelArn *string

	// Specifies additional model-specific request parameters as key-value pairs that
	// are included in the request to the Amazon Bedrock reranker model.
	AdditionalModelRequestFields map[string]document.Interface

	noSmithyDocumentSerde
}

// Specifies how retrieved results from a knowledge base are reranked to improve
// relevance.
type VectorSearchRerankingConfiguration struct {

	// Specifies the type of reranking model to use. Currently, the only supported
	// value is BEDROCK_RERANKING_MODEL .
	//
	// This member is required.
	Type VectorSearchRerankingConfigurationType

	// Specifies the configuration for using an Amazon Bedrock reranker model to
	// rerank retrieved results.
	BedrockRerankingConfiguration *VectorSearchBedrockRerankingConfiguration

	noSmithyDocumentSerde
}

// Configuration settings for processing video content in multimodal knowledge
// bases.
type VideoConfiguration struct {

	// Configuration for segmenting video content during processing.
	//
	// This member is required.
	SegmentationConfiguration *VideoSegmentationConfiguration

	noSmithyDocumentSerde
}

// Configuration for segmenting video content during multimodal knowledge base
// ingestion. Determines how video files are divided into chunks for processing.
type VideoSegmentationConfiguration struct {

	// The duration in seconds for each video segment. Video files will be divided
	// into chunks of this length for processing.
	//
	// This member is required.
	FixedLengthDuration *int32

	noSmithyDocumentSerde
}

// The configuration of web URLs that you want to crawl. You should be authorized
// to crawl the URLs.
type WebCrawlerConfiguration struct {

	// The configuration of crawl limits for the web URLs.
	CrawlerLimits *WebCrawlerLimits

	// A list of one or more exclusion regular expression patterns to exclude certain
	// URLs. If you specify an inclusion and exclusion filter/pattern and both match a
	// URL, the exclusion filter takes precedence and the web content of the URL isn’t
	// crawled.
	ExclusionFilters []string

	// A list of one or more inclusion regular expression patterns to include certain
	// URLs. If you specify an inclusion and exclusion filter/pattern and both match a
	// URL, the exclusion filter takes precedence and the web content of the URL isn’t
	// crawled.
	InclusionFilters []string

	// The scope of what is crawled for your URLs.
	//
	// You can choose to crawl only web pages that belong to the same host or primary
	// domain. For example, only web pages that contain the seed URL
	// "https://docs.aws.amazon.com/bedrock/latest/userguide/" and no other domains.
	// You can choose to include sub domains in addition to the host or primary domain.
	// For example, web pages that contain "aws.amazon.com" can also include sub domain
	// "docs.aws.amazon.com".
	Scope WebScopeType

	// Returns the user agent suffix for your web crawler.
	UserAgent *string

	// A string used for identifying the crawler or bot when it accesses a web server.
	// The user agent header value consists of the bedrockbot , UUID, and a user agent
	// suffix for your crawler (if one is provided). By default, it is set to
	// bedrockbot_UUID . You can optionally append a custom suffix to bedrockbot_UUID
	// to allowlist a specific user agent permitted to access your source URLs.
	UserAgentHeader *string

	noSmithyDocumentSerde
}

// The rate limits for the URLs that you want to crawl. You should be authorized
// to crawl the URLs.
type WebCrawlerLimits struct {

	//  The max number of web pages crawled from your source URLs, up to 25,000 pages.
	// If the web pages exceed this limit, the data source sync will fail and no web
	// pages will be ingested.
	MaxPages *int32

	// The max rate at which pages are crawled, up to 300 per minute per host.
	RateLimit *int32

	noSmithyDocumentSerde
}

// The configuration details for the web data source.
type WebDataSourceConfiguration struct {

	// The source configuration details for the web data source.
	//
	// This member is required.
	SourceConfiguration *WebSourceConfiguration

	// The Web Crawler configuration details for the web data source.
	CrawlerConfiguration *WebCrawlerConfiguration

	noSmithyDocumentSerde
}

// The configuration of the URL/URLs for the web content that you want to crawl.
// You should be authorized to crawl the URLs.
type WebSourceConfiguration struct {

	// The configuration of the URL/URLs.
	//
	// This member is required.
	UrlConfiguration *UrlConfiguration

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isActionGroupExecutor()                         {}
func (*UnknownUnionMember) isAPISchema()                                   {}
func (*UnknownUnionMember) isContentBlock()                                {}
func (*UnknownUnionMember) isFlowConnectionConfiguration()                 {}
func (*UnknownUnionMember) isFlowNodeConfiguration()                       {}
func (*UnknownUnionMember) isFlowValidationDetails()                       {}
func (*UnknownUnionMember) isFunctionSchema()                              {}
func (*UnknownUnionMember) isOrchestrationExecutor()                       {}
func (*UnknownUnionMember) isPromptFlowNodeSourceConfiguration()           {}
func (*UnknownUnionMember) isPromptGenAiResource()                         {}
func (*UnknownUnionMember) isPromptInferenceConfiguration()                {}
func (*UnknownUnionMember) isPromptTemplateConfiguration()                 {}
func (*UnknownUnionMember) isRerankingMetadataSelectiveModeConfiguration() {}
func (*UnknownUnionMember) isRetrievalFlowNodeServiceConfiguration()       {}
func (*UnknownUnionMember) isStorageFlowNodeServiceConfiguration()         {}
func (*UnknownUnionMember) isSystemContentBlock()                          {}
func (*UnknownUnionMember) isTool()                                        {}
func (*UnknownUnionMember) isToolChoice()                                  {}
func (*UnknownUnionMember) isToolInputSchema()                             {}
