// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcore/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of browser sessions in Amazon Bedrock that match the specified
// criteria. This operation returns summary information about each session,
// including identifiers, status, and timestamps.
//
// You can filter the results by browser identifier and session status. The
// operation supports pagination to handle large result sets efficiently.
//
// We recommend using pagination to ensure that the operation returns quickly and
// successfully when retrieving large numbers of sessions.
//
// The following operations are related to ListBrowserSessions :
//
// [StartBrowserSession]
//
// [GetBrowserSession]
//
// [GetBrowserSession]: https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetBrowserSession.html
// [StartBrowserSession]: https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_StartBrowserSession.html
func (c *Client) ListBrowserSessions(ctx context.Context, params *ListBrowserSessionsInput, optFns ...func(*Options)) (*ListBrowserSessionsOutput, error) {
	if params == nil {
		params = &ListBrowserSessionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListBrowserSessions", params, optFns, c.addOperationListBrowserSessionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListBrowserSessionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListBrowserSessionsInput struct {

	// The unique identifier of the browser to list sessions for. If specified, only
	// sessions for this browser are returned. If not specified, sessions for all
	// browsers are returned.
	//
	// This member is required.
	BrowserIdentifier *string

	// The maximum number of results to return in a single call. The default value is
	// 10. Valid values range from 1 to 100. To retrieve the remaining results, make
	// another call with the returned nextToken value.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results. If not
	// specified, Amazon Bedrock returns the first page of results.
	NextToken *string

	// The status of the browser sessions to list. Valid values include ACTIVE,
	// STOPPING, and STOPPED. If not specified, sessions with any status are returned.
	Status types.BrowserSessionStatus

	noSmithyDocumentSerde
}

type ListBrowserSessionsOutput struct {

	// The list of browser sessions that match the specified criteria.
	//
	// This member is required.
	Items []types.BrowserSessionSummary

	// The token to use in a subsequent ListBrowserSessions request to get the next
	// set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListBrowserSessionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListBrowserSessions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListBrowserSessions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListBrowserSessions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListBrowserSessionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListBrowserSessions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListBrowserSessions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListBrowserSessions",
	}
}
