// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcore/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all long-term memory extraction jobs that are eligible to be started with
// optional filtering.
//
// To use this operation, you must have the
// bedrock-agentcore:ListMemoryExtractionJobs permission.
func (c *Client) ListMemoryExtractionJobs(ctx context.Context, params *ListMemoryExtractionJobsInput, optFns ...func(*Options)) (*ListMemoryExtractionJobsOutput, error) {
	if params == nil {
		params = &ListMemoryExtractionJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMemoryExtractionJobs", params, optFns, c.addOperationListMemoryExtractionJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMemoryExtractionJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMemoryExtractionJobsInput struct {

	// The unique identifier of the memory to list extraction jobs for.
	//
	// This member is required.
	MemoryId *string

	// Filter criteria to apply when listing extraction jobs.
	Filter *types.ExtractionJobFilterInput

	// The maximum number of results to return in a single call. The default value is
	// 20.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListMemoryExtractionJobsOutput struct {

	// List of extraction job metadata matching the specified criteria.
	//
	// This member is required.
	Jobs []types.ExtractionJobMetadata

	// Token to retrieve the next page of results, if available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMemoryExtractionJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListMemoryExtractionJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListMemoryExtractionJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMemoryExtractionJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListMemoryExtractionJobsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMemoryExtractionJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListMemoryExtractionJobsPaginatorOptions is the paginator options for
// ListMemoryExtractionJobs
type ListMemoryExtractionJobsPaginatorOptions struct {
	// The maximum number of results to return in a single call. The default value is
	// 20.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMemoryExtractionJobsPaginator is a paginator for ListMemoryExtractionJobs
type ListMemoryExtractionJobsPaginator struct {
	options   ListMemoryExtractionJobsPaginatorOptions
	client    ListMemoryExtractionJobsAPIClient
	params    *ListMemoryExtractionJobsInput
	nextToken *string
	firstPage bool
}

// NewListMemoryExtractionJobsPaginator returns a new
// ListMemoryExtractionJobsPaginator
func NewListMemoryExtractionJobsPaginator(client ListMemoryExtractionJobsAPIClient, params *ListMemoryExtractionJobsInput, optFns ...func(*ListMemoryExtractionJobsPaginatorOptions)) *ListMemoryExtractionJobsPaginator {
	if params == nil {
		params = &ListMemoryExtractionJobsInput{}
	}

	options := ListMemoryExtractionJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMemoryExtractionJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMemoryExtractionJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMemoryExtractionJobs page.
func (p *ListMemoryExtractionJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMemoryExtractionJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListMemoryExtractionJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListMemoryExtractionJobsAPIClient is a client that implements the
// ListMemoryExtractionJobs operation.
type ListMemoryExtractionJobsAPIClient interface {
	ListMemoryExtractionJobs(context.Context, *ListMemoryExtractionJobsInput, ...func(*Options)) (*ListMemoryExtractionJobsOutput, error)
}

var _ ListMemoryExtractionJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListMemoryExtractionJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMemoryExtractionJobs",
	}
}
