// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Terminates an active code interpreter session in Amazon Bedrock. This operation
// stops the session, releases associated resources, and makes the session
// unavailable for further use.
//
// To stop a code interpreter session, you must specify both the code interpreter
// identifier and the session ID. Once stopped, a session cannot be restarted; you
// must create a new session using StartCodeInterpreterSession .
//
// The following operations are related to StopCodeInterpreterSession :
//
// [StartCodeInterpreterSession]
//
// [GetCodeInterpreterSession]
//
// [StartCodeInterpreterSession]: https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_StartCodeInterpreterSession.html
// [GetCodeInterpreterSession]: https://docs.aws.amazon.com/bedrock-agentcore/latest/APIReference/API_GetCodeInterpreterSession.html
func (c *Client) StopCodeInterpreterSession(ctx context.Context, params *StopCodeInterpreterSessionInput, optFns ...func(*Options)) (*StopCodeInterpreterSessionOutput, error) {
	if params == nil {
		params = &StopCodeInterpreterSessionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StopCodeInterpreterSession", params, optFns, c.addOperationStopCodeInterpreterSessionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StopCodeInterpreterSessionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StopCodeInterpreterSessionInput struct {

	// The unique identifier of the code interpreter associated with the session.
	//
	// This member is required.
	CodeInterpreterIdentifier *string

	// The unique identifier of the code interpreter session to stop.
	//
	// This member is required.
	SessionId *string

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error.
	ClientToken *string

	// The trace identifier for request tracking.
	TraceId *string

	// The parent trace information for distributed tracing.
	TraceParent *string

	noSmithyDocumentSerde
}

type StopCodeInterpreterSessionOutput struct {

	// The identifier of the code interpreter.
	//
	// This member is required.
	CodeInterpreterIdentifier *string

	// The timestamp when the code interpreter session was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The identifier of the code interpreter session.
	//
	// This member is required.
	SessionId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStopCodeInterpreterSessionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStopCodeInterpreterSession{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStopCodeInterpreterSession{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StopCodeInterpreterSession"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStopCodeInterpreterSessionMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStopCodeInterpreterSessionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStopCodeInterpreterSession(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStopCodeInterpreterSession struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStopCodeInterpreterSession) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStopCodeInterpreterSession) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StopCodeInterpreterSessionInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StopCodeInterpreterSessionInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStopCodeInterpreterSessionMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStopCodeInterpreterSession{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStopCodeInterpreterSession(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StopCodeInterpreterSession",
	}
}
