// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a policy within the AgentCore Policy system. Policies provide
// real-time, deterministic control over agentic interactions with AgentCore
// Gateway. Using the Cedar policy language, you can define fine-grained policies
// that specify which interactions with Gateway tools are permitted based on input
// parameters and OAuth claims, ensuring agents operate within defined boundaries
// and business rules. The policy is validated during creation against the Cedar
// schema generated from the Gateway's tools' input schemas, which defines the
// available tools, their parameters, and expected data types. This is an
// asynchronous operation. Use the [GetPolicy]operation to poll the status field to track
// completion.
//
// [GetPolicy]: https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/API_GetPolicy.html
func (c *Client) CreatePolicy(ctx context.Context, params *CreatePolicyInput, optFns ...func(*Options)) (*CreatePolicyOutput, error) {
	if params == nil {
		params = &CreatePolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePolicy", params, optFns, c.addOperationCreatePolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePolicyInput struct {

	// The Cedar policy statement that defines the access control rules. This contains
	// the actual policy logic written in Cedar policy language, specifying effect
	// (permit or forbid), principals, actions, resources, and conditions for agent
	// behavior control.
	//
	// This member is required.
	Definition types.PolicyDefinition

	// The customer-assigned immutable name for the policy. Must be unique within the
	// account. This name is used for policy identification and cannot be changed after
	// creation.
	//
	// This member is required.
	Name *string

	// The identifier of the policy engine which contains this policy. Policy engines
	// group related policies and provide the execution context for policy evaluation.
	//
	// This member is required.
	PolicyEngineId *string

	// A unique, case-sensitive identifier to ensure the idempotency of the request.
	// The AWS SDK automatically generates this token, so you don't need to provide it
	// in most cases. If you retry a request with the same client token, the service
	// returns the same response without creating a duplicate policy.
	ClientToken *string

	// A human-readable description of the policy's purpose and functionality (1-4,096
	// characters). This helps policy administrators understand the policy's intent,
	// business rules, and operational scope. Use this field to document why the policy
	// exists, what business requirement it addresses, and any special considerations
	// for maintenance. Clear descriptions are essential for policy governance,
	// auditing, and troubleshooting.
	Description *string

	// The validation mode for the policy creation. Determines how Cedar analyzer
	// validation results are handled during policy creation. FAIL_ON_ANY_FINDINGS
	// (default) runs the Cedar analyzer to validate the policy against the Cedar
	// schema and tool context, failing creation if the analyzer detects any validation
	// issues to ensure strict conformance. IGNORE_ALL_FINDINGS runs the Cedar analyzer
	// but allows policy creation even if validation issues are detected, useful for
	// testing or when the policy schema is evolving. Use FAIL_ON_ANY_FINDINGS for
	// production policies to ensure correctness, and IGNORE_ALL_FINDINGS only when you
	// understand and accept the analyzer findings.
	ValidationMode types.PolicyValidationMode

	noSmithyDocumentSerde
}

type CreatePolicyOutput struct {

	// The timestamp when the policy was created. This is automatically set by the
	// service and used for auditing and lifecycle management.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Cedar policy statement that was created. This is the validated policy
	// definition that will be used for agent behavior control and access decisions.
	//
	// This member is required.
	Definition types.PolicyDefinition

	// The customer-assigned name of the created policy. This matches the name
	// provided in the request and serves as the human-readable identifier for the
	// policy.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the created policy. This globally unique
	// identifier can be used for cross-service references and IAM policy statements.
	//
	// This member is required.
	PolicyArn *string

	// The identifier of the policy engine that manages this policy. This confirms the
	// policy engine assignment and is used for policy evaluation routing.
	//
	// This member is required.
	PolicyEngineId *string

	// The unique identifier for the created policy. This is a system-generated
	// identifier consisting of the user name plus a 10-character generated suffix,
	// used for all subsequent policy operations.
	//
	// This member is required.
	PolicyId *string

	// The current status of the policy. A status of ACTIVE indicates the policy is
	// ready for use.
	//
	// This member is required.
	Status types.PolicyStatus

	// Additional information about the policy status. This provides details about any
	// failures or the current state of the policy creation process.
	//
	// This member is required.
	StatusReasons []string

	// The timestamp when the policy was last updated. For newly created policies,
	// this matches the createdAt timestamp.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The human-readable description of the policy's purpose and functionality. This
	// helps administrators understand and manage the policy.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreatePolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreatePolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreatePolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreatePolicyMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreatePolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreatePolicy struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreatePolicy) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreatePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreatePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreatePolicyInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreatePolicyMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreatePolicy{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreatePolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreatePolicy",
	}
}
