// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of policy engines within the AgentCore Policy system. This
// operation supports pagination to help administrators discover and manage policy
// engines across their account. Each policy engine serves as a container for
// related policies.
func (c *Client) ListPolicyEngines(ctx context.Context, params *ListPolicyEnginesInput, optFns ...func(*Options)) (*ListPolicyEnginesOutput, error) {
	if params == nil {
		params = &ListPolicyEnginesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPolicyEngines", params, optFns, c.addOperationListPolicyEnginesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPolicyEnginesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPolicyEnginesInput struct {

	// The maximum number of policy engines to return in a single response. If not
	// specified, the default is 10 policy engines per page, with a maximum of 100 per
	// page.
	MaxResults *int32

	// A pagination token returned from a previous [ListPolicyEngines] call. Use this token to retrieve
	// the next page of results when the response is paginated.
	//
	// [ListPolicyEngines]: https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/API_ListPolicyEngines.html
	NextToken *string

	noSmithyDocumentSerde
}

type ListPolicyEnginesOutput struct {

	// An array of policy engine objects that exist in the account. Each policy engine
	// object contains the engine metadata, status, and key identifiers for further
	// operations.
	//
	// This member is required.
	PolicyEngines []types.PolicyEngine

	// A pagination token that can be used in subsequent [ListPolicyEngines] calls to retrieve additional
	// results. This token is only present when there are more results available.
	//
	// [ListPolicyEngines]: https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/API_ListPolicyEngines.html
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPolicyEnginesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListPolicyEngines{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListPolicyEngines{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPolicyEngines"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPolicyEngines(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListPolicyEnginesPaginatorOptions is the paginator options for ListPolicyEngines
type ListPolicyEnginesPaginatorOptions struct {
	// The maximum number of policy engines to return in a single response. If not
	// specified, the default is 10 policy engines per page, with a maximum of 100 per
	// page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPolicyEnginesPaginator is a paginator for ListPolicyEngines
type ListPolicyEnginesPaginator struct {
	options   ListPolicyEnginesPaginatorOptions
	client    ListPolicyEnginesAPIClient
	params    *ListPolicyEnginesInput
	nextToken *string
	firstPage bool
}

// NewListPolicyEnginesPaginator returns a new ListPolicyEnginesPaginator
func NewListPolicyEnginesPaginator(client ListPolicyEnginesAPIClient, params *ListPolicyEnginesInput, optFns ...func(*ListPolicyEnginesPaginatorOptions)) *ListPolicyEnginesPaginator {
	if params == nil {
		params = &ListPolicyEnginesInput{}
	}

	options := ListPolicyEnginesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPolicyEnginesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPolicyEnginesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPolicyEngines page.
func (p *ListPolicyEnginesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPolicyEnginesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPolicyEngines(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPolicyEnginesAPIClient is a client that implements the ListPolicyEngines
// operation.
type ListPolicyEnginesAPIClient interface {
	ListPolicyEngines(context.Context, *ListPolicyEnginesInput, ...func(*Options)) (*ListPolicyEnginesOutput, error)
}

var _ ListPolicyEnginesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPolicyEngines(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPolicyEngines",
	}
}
