// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of policy generation requests within the AgentCore Policy
// system. This operation supports pagination and filtering to help track and
// manage AI-powered policy generation operations.
func (c *Client) ListPolicyGenerations(ctx context.Context, params *ListPolicyGenerationsInput, optFns ...func(*Options)) (*ListPolicyGenerationsOutput, error) {
	if params == nil {
		params = &ListPolicyGenerationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPolicyGenerations", params, optFns, c.addOperationListPolicyGenerationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPolicyGenerationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPolicyGenerationsInput struct {

	// The identifier of the policy engine whose policy generations to retrieve.
	//
	// This member is required.
	PolicyEngineId *string

	// The maximum number of policy generations to return in a single response.
	MaxResults *int32

	// A pagination token for retrieving additional policy generations when results
	// are paginated.
	NextToken *string

	noSmithyDocumentSerde
}

type ListPolicyGenerationsOutput struct {

	// An array of policy generation objects that match the specified criteria.
	//
	// This member is required.
	PolicyGenerations []types.PolicyGeneration

	// A pagination token for retrieving additional policy generations if more results
	// are available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPolicyGenerationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListPolicyGenerations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListPolicyGenerations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPolicyGenerations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListPolicyGenerationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPolicyGenerations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListPolicyGenerationsPaginatorOptions is the paginator options for
// ListPolicyGenerations
type ListPolicyGenerationsPaginatorOptions struct {
	// The maximum number of policy generations to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPolicyGenerationsPaginator is a paginator for ListPolicyGenerations
type ListPolicyGenerationsPaginator struct {
	options   ListPolicyGenerationsPaginatorOptions
	client    ListPolicyGenerationsAPIClient
	params    *ListPolicyGenerationsInput
	nextToken *string
	firstPage bool
}

// NewListPolicyGenerationsPaginator returns a new ListPolicyGenerationsPaginator
func NewListPolicyGenerationsPaginator(client ListPolicyGenerationsAPIClient, params *ListPolicyGenerationsInput, optFns ...func(*ListPolicyGenerationsPaginatorOptions)) *ListPolicyGenerationsPaginator {
	if params == nil {
		params = &ListPolicyGenerationsInput{}
	}

	options := ListPolicyGenerationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPolicyGenerationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPolicyGenerationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPolicyGenerations page.
func (p *ListPolicyGenerationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPolicyGenerationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPolicyGenerations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPolicyGenerationsAPIClient is a client that implements the
// ListPolicyGenerations operation.
type ListPolicyGenerationsAPIClient interface {
	ListPolicyGenerations(context.Context, *ListPolicyGenerationsInput, ...func(*Options)) (*ListPolicyGenerationsOutput, error)
}

var _ ListPolicyGenerationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPolicyGenerations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPolicyGenerations",
	}
}
