// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing policy within the AgentCore Policy system. This operation
// allows modification of the policy description and definition while maintaining
// the policy's identity. The updated policy is validated against the Cedar schema
// before being applied. This is an asynchronous operation. Use the GetPolicy
// operation to poll the status field to track completion.
func (c *Client) UpdatePolicy(ctx context.Context, params *UpdatePolicyInput, optFns ...func(*Options)) (*UpdatePolicyOutput, error) {
	if params == nil {
		params = &UpdatePolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdatePolicy", params, optFns, c.addOperationUpdatePolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdatePolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdatePolicyInput struct {

	// The new Cedar policy statement that defines the access control rules. This
	// replaces the existing policy definition with new logic while maintaining the
	// policy's identity.
	//
	// This member is required.
	Definition types.PolicyDefinition

	// The identifier of the policy engine that manages the policy to be updated. This
	// ensures the policy is updated within the correct policy engine context.
	//
	// This member is required.
	PolicyEngineId *string

	// The unique identifier of the policy to be updated. This must be a valid policy
	// ID that exists within the specified policy engine.
	//
	// This member is required.
	PolicyId *string

	// The new human-readable description for the policy. This optional field allows
	// updating the policy's documentation while keeping the same policy logic.
	Description *string

	// The validation mode for the policy update. Determines how Cedar analyzer
	// validation results are handled during policy updates. FAIL_ON_ANY_FINDINGS runs
	// the Cedar analyzer and fails the update if validation issues are detected,
	// ensuring the policy conforms to the Cedar schema and tool context.
	// IGNORE_ALL_FINDINGS runs the Cedar analyzer but allows updates despite
	// validation warnings. Use FAIL_ON_ANY_FINDINGS to ensure policy correctness
	// during updates, especially when modifying policy logic or conditions.
	ValidationMode types.PolicyValidationMode

	noSmithyDocumentSerde
}

type UpdatePolicyOutput struct {

	// The original creation timestamp of the policy.
	//
	// This member is required.
	CreatedAt *time.Time

	// The updated Cedar policy statement.
	//
	// This member is required.
	Definition types.PolicyDefinition

	// The name of the updated policy.
	//
	// This member is required.
	Name *string

	// The ARN of the updated policy.
	//
	// This member is required.
	PolicyArn *string

	// The identifier of the policy engine managing the updated policy.
	//
	// This member is required.
	PolicyEngineId *string

	// The unique identifier of the updated policy.
	//
	// This member is required.
	PolicyId *string

	// The current status of the updated policy.
	//
	// This member is required.
	Status types.PolicyStatus

	// Additional information about the update status.
	//
	// This member is required.
	StatusReasons []string

	// The timestamp when the policy was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The updated description of the policy.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdatePolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdatePolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdatePolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdatePolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdatePolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdatePolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdatePolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdatePolicy",
	}
}
