// Code generated by smithy-go-codegen DO NOT EDIT.

package chimesdkvoice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/chimesdkvoice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the voice profiles in a voice profile domain.
func (c *Client) ListVoiceProfiles(ctx context.Context, params *ListVoiceProfilesInput, optFns ...func(*Options)) (*ListVoiceProfilesOutput, error) {
	if params == nil {
		params = &ListVoiceProfilesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListVoiceProfiles", params, optFns, c.addOperationListVoiceProfilesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListVoiceProfilesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListVoiceProfilesInput struct {

	// The ID of the voice profile domain.
	//
	// This member is required.
	VoiceProfileDomainId *string

	// The maximum number of results in the request.
	MaxResults *int32

	// The token used to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListVoiceProfilesOutput struct {

	// The token used to retrieve the next page of results.
	NextToken *string

	// The list of voice profiles.
	VoiceProfiles []types.VoiceProfileSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListVoiceProfilesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListVoiceProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListVoiceProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListVoiceProfiles"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListVoiceProfilesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListVoiceProfiles(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListVoiceProfilesPaginatorOptions is the paginator options for ListVoiceProfiles
type ListVoiceProfilesPaginatorOptions struct {
	// The maximum number of results in the request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListVoiceProfilesPaginator is a paginator for ListVoiceProfiles
type ListVoiceProfilesPaginator struct {
	options   ListVoiceProfilesPaginatorOptions
	client    ListVoiceProfilesAPIClient
	params    *ListVoiceProfilesInput
	nextToken *string
	firstPage bool
}

// NewListVoiceProfilesPaginator returns a new ListVoiceProfilesPaginator
func NewListVoiceProfilesPaginator(client ListVoiceProfilesAPIClient, params *ListVoiceProfilesInput, optFns ...func(*ListVoiceProfilesPaginatorOptions)) *ListVoiceProfilesPaginator {
	if params == nil {
		params = &ListVoiceProfilesInput{}
	}

	options := ListVoiceProfilesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListVoiceProfilesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListVoiceProfilesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListVoiceProfiles page.
func (p *ListVoiceProfilesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListVoiceProfilesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListVoiceProfiles(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListVoiceProfilesAPIClient is a client that implements the ListVoiceProfiles
// operation.
type ListVoiceProfilesAPIClient interface {
	ListVoiceProfiles(context.Context, *ListVoiceProfilesInput, ...func(*Options)) (*ListVoiceProfilesOutput, error)
}

var _ ListVoiceProfilesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListVoiceProfiles(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListVoiceProfiles",
	}
}
