// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanrooms

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanrooms/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all change requests for a collaboration with pagination support. Returns
// change requests sorted by creation time.
func (c *Client) ListCollaborationChangeRequests(ctx context.Context, params *ListCollaborationChangeRequestsInput, optFns ...func(*Options)) (*ListCollaborationChangeRequestsOutput, error) {
	if params == nil {
		params = &ListCollaborationChangeRequestsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCollaborationChangeRequests", params, optFns, c.addOperationListCollaborationChangeRequestsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCollaborationChangeRequestsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCollaborationChangeRequestsInput struct {

	// The identifier of the collaboration that the change request is made against.
	//
	// This member is required.
	CollaborationIdentifier *string

	// The maximum number of results that are returned for an API request call.
	MaxResults *int32

	// The pagination token that's used to fetch the next set of results.
	NextToken *string

	// A filter to only return change requests with the specified status.
	Status types.ChangeRequestStatus

	noSmithyDocumentSerde
}

type ListCollaborationChangeRequestsOutput struct {

	// The list of collaboration change request summaries.
	//
	// This member is required.
	CollaborationChangeRequestSummaries []types.CollaborationChangeRequestSummary

	// The pagination token that's used to fetch the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCollaborationChangeRequestsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCollaborationChangeRequests{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCollaborationChangeRequests{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCollaborationChangeRequests"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListCollaborationChangeRequestsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCollaborationChangeRequests(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCollaborationChangeRequestsPaginatorOptions is the paginator options for
// ListCollaborationChangeRequests
type ListCollaborationChangeRequestsPaginatorOptions struct {
	// The maximum number of results that are returned for an API request call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCollaborationChangeRequestsPaginator is a paginator for
// ListCollaborationChangeRequests
type ListCollaborationChangeRequestsPaginator struct {
	options   ListCollaborationChangeRequestsPaginatorOptions
	client    ListCollaborationChangeRequestsAPIClient
	params    *ListCollaborationChangeRequestsInput
	nextToken *string
	firstPage bool
}

// NewListCollaborationChangeRequestsPaginator returns a new
// ListCollaborationChangeRequestsPaginator
func NewListCollaborationChangeRequestsPaginator(client ListCollaborationChangeRequestsAPIClient, params *ListCollaborationChangeRequestsInput, optFns ...func(*ListCollaborationChangeRequestsPaginatorOptions)) *ListCollaborationChangeRequestsPaginator {
	if params == nil {
		params = &ListCollaborationChangeRequestsInput{}
	}

	options := ListCollaborationChangeRequestsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCollaborationChangeRequestsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCollaborationChangeRequestsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCollaborationChangeRequests page.
func (p *ListCollaborationChangeRequestsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCollaborationChangeRequestsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCollaborationChangeRequests(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCollaborationChangeRequestsAPIClient is a client that implements the
// ListCollaborationChangeRequests operation.
type ListCollaborationChangeRequestsAPIClient interface {
	ListCollaborationChangeRequests(context.Context, *ListCollaborationChangeRequestsInput, ...func(*Options)) (*ListCollaborationChangeRequestsOutput, error)
}

var _ ListCollaborationChangeRequestsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCollaborationChangeRequests(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCollaborationChangeRequests",
	}
}
