// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanrooms

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanrooms/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a configured table.
func (c *Client) UpdateConfiguredTable(ctx context.Context, params *UpdateConfiguredTableInput, optFns ...func(*Options)) (*UpdateConfiguredTableOutput, error) {
	if params == nil {
		params = &UpdateConfiguredTableInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateConfiguredTable", params, optFns, c.addOperationUpdateConfiguredTableMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateConfiguredTableOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateConfiguredTableInput struct {

	// The identifier for the configured table to update. Currently accepts the
	// configured table ID.
	//
	// This member is required.
	ConfiguredTableIdentifier *string

	// The columns of the underlying table that can be used by collaborations or
	// analysis rules.
	AllowedColumns []string

	//  The analysis method for the configured table.
	//
	// DIRECT_QUERY allows SQL queries to be run directly on this table.
	//
	// DIRECT_JOB allows PySpark jobs to be run directly on this table.
	//
	// MULTIPLE allows both SQL queries and PySpark jobs to be run directly on this
	// table.
	AnalysisMethod types.AnalysisMethod

	// A new description for the configured table.
	Description *string

	// A new name for the configured table.
	Name *string

	//  The selected analysis methods for the table configuration update.
	SelectedAnalysisMethods []types.SelectedAnalysisMethod

	// A pointer to the dataset that underlies this table.
	TableReference types.TableReference

	noSmithyDocumentSerde
}

type UpdateConfiguredTableOutput struct {

	// The updated configured table.
	//
	// This member is required.
	ConfiguredTable *types.ConfiguredTable

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateConfiguredTableMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateConfiguredTable{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateConfiguredTable{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateConfiguredTable"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateConfiguredTableValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateConfiguredTable(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateConfiguredTable(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateConfiguredTable",
	}
}
