// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Defines the information necessary to begin a trained model inference job.
func (c *Client) StartTrainedModelInferenceJob(ctx context.Context, params *StartTrainedModelInferenceJobInput, optFns ...func(*Options)) (*StartTrainedModelInferenceJobOutput, error) {
	if params == nil {
		params = &StartTrainedModelInferenceJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartTrainedModelInferenceJob", params, optFns, c.addOperationStartTrainedModelInferenceJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartTrainedModelInferenceJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartTrainedModelInferenceJobInput struct {

	// Defines the data source that is used for the trained model inference job.
	//
	// This member is required.
	DataSource *types.ModelInferenceDataSource

	// The membership ID of the membership that contains the trained model inference
	// job.
	//
	// This member is required.
	MembershipIdentifier *string

	// The name of the trained model inference job.
	//
	// This member is required.
	Name *string

	// Defines the output configuration information for the trained model inference
	// job.
	//
	// This member is required.
	OutputConfiguration *types.InferenceOutputConfiguration

	// Defines the resource configuration for the trained model inference job.
	//
	// This member is required.
	ResourceConfig *types.InferenceResourceConfig

	// The Amazon Resource Name (ARN) of the trained model that is used for this
	// trained model inference job.
	//
	// This member is required.
	TrainedModelArn *string

	// The Amazon Resource Name (ARN) of the configured model algorithm association
	// that is used for this trained model inference job.
	ConfiguredModelAlgorithmAssociationArn *string

	// The execution parameters for the container.
	ContainerExecutionParameters *types.InferenceContainerExecutionParameters

	// The description of the trained model inference job.
	Description *string

	// The environment variables to set in the Docker container.
	Environment map[string]string

	// The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and
	// decrypt customer-owned data in the ML inference job and associated data.
	KmsKeyArn *string

	// The optional metadata that you apply to the resource to help you categorize and
	// organize them. Each tag consists of a key and an optional value, both of which
	// you define.
	//
	// The following basic restrictions apply to tags:
	//
	//   - Maximum number of tags per resource - 50.
	//
	//   - For each resource, each tag key must be unique, and each tag key can have
	//   only one value.
	//
	//   - Maximum key length - 128 Unicode characters in UTF-8.
	//
	//   - Maximum value length - 256 Unicode characters in UTF-8.
	//
	//   - If your tagging schema is used across multiple services and resources,
	//   remember that other services may have restrictions on allowed characters.
	//   Generally allowed characters are: letters, numbers, and spaces representable in
	//   UTF-8, and the following characters: + - = . _ : / @.
	//
	//   - Tag keys and values are case sensitive.
	//
	//   - Do not use aws:, AWS:, or any upper or lowercase combination of such as a
	//   prefix for keys as it is reserved for AWS use. You cannot edit or delete tag
	//   keys with this prefix. Values can have this prefix. If a tag value has aws as
	//   its prefix but the key does not, then Clean Rooms ML considers it to be a user
	//   tag and will count against the limit of 50 tags. Tags with only the key prefix
	//   of aws do not count against your tags per resource limit.
	Tags map[string]string

	// The version identifier of the trained model to use for inference. This
	// specifies which version of the trained model should be used to generate
	// predictions on the input data.
	TrainedModelVersionIdentifier *string

	noSmithyDocumentSerde
}

type StartTrainedModelInferenceJobOutput struct {

	// The Amazon Resource Name (ARN) of the trained model inference job.
	//
	// This member is required.
	TrainedModelInferenceJobArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartTrainedModelInferenceJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartTrainedModelInferenceJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartTrainedModelInferenceJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartTrainedModelInferenceJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartTrainedModelInferenceJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartTrainedModelInferenceJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartTrainedModelInferenceJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartTrainedModelInferenceJob",
	}
}
