// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Provides the information necessary to update a configured audience model.
// Updates that impact audience generation jobs take effect when a new job starts,
// but do not impact currently running jobs.
func (c *Client) UpdateConfiguredAudienceModel(ctx context.Context, params *UpdateConfiguredAudienceModelInput, optFns ...func(*Options)) (*UpdateConfiguredAudienceModelOutput, error) {
	if params == nil {
		params = &UpdateConfiguredAudienceModelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateConfiguredAudienceModel", params, optFns, c.addOperationUpdateConfiguredAudienceModelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateConfiguredAudienceModelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateConfiguredAudienceModelInput struct {

	// The Amazon Resource Name (ARN) of the configured audience model that you want
	// to update.
	//
	// This member is required.
	ConfiguredAudienceModelArn *string

	// The Amazon Resource Name (ARN) of the new audience model that you want to use.
	AudienceModelArn *string

	// The new audience size configuration.
	AudienceSizeConfig *types.AudienceSizeConfig

	// The new description of the configured audience model.
	Description *string

	// The minimum number of users from the seed audience that must match with users
	// in the training data of the audience model.
	MinMatchingSeedSize *int32

	// The new output configuration.
	OutputConfig *types.ConfiguredAudienceModelOutputConfig

	// The new value for whether to share audience metrics.
	SharedAudienceMetrics []types.SharedAudienceMetrics

	noSmithyDocumentSerde
}

type UpdateConfiguredAudienceModelOutput struct {

	// The Amazon Resource Name (ARN) of the configured audience model that was
	// updated.
	//
	// This member is required.
	ConfiguredAudienceModelArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateConfiguredAudienceModelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateConfiguredAudienceModel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateConfiguredAudienceModel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateConfiguredAudienceModel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateConfiguredAudienceModelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateConfiguredAudienceModel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateConfiguredAudienceModel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateConfiguredAudienceModel",
	}
}
