// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudtrail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudtrail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the event configuration settings for the specified event data store or
// trail. This operation supports updating the maximum event size, adding or
// modifying context key selectors for event data store, and configuring
// aggregation settings for the trail.
func (c *Client) PutEventConfiguration(ctx context.Context, params *PutEventConfigurationInput, optFns ...func(*Options)) (*PutEventConfigurationOutput, error) {
	if params == nil {
		params = &PutEventConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutEventConfiguration", params, optFns, c.addOperationPutEventConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutEventConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutEventConfigurationInput struct {

	// The list of aggregation configurations that you want to configure for the trail.
	AggregationConfigurations []types.AggregationConfiguration

	// A list of context key selectors that will be included to provide enriched event
	// data.
	ContextKeySelectors []types.ContextKeySelector

	// The Amazon Resource Name (ARN) or ID suffix of the ARN of the event data store
	// for which event configuration settings are updated.
	EventDataStore *string

	// The maximum allowed size for events to be stored in the specified event data
	// store. If you are using context key selectors, MaxEventSize must be set to
	// Large.
	MaxEventSize types.MaxEventSize

	// The name of the trail for which you want to update event configuration settings.
	TrailName *string

	noSmithyDocumentSerde
}

type PutEventConfigurationOutput struct {

	// A list of aggregation configurations that are configured for the trail.
	AggregationConfigurations []types.AggregationConfiguration

	// The list of context key selectors that are configured for the event data store.
	ContextKeySelectors []types.ContextKeySelector

	// The Amazon Resource Name (ARN) or ID suffix of the ARN of the event data store
	// for which the event configuration settings were updated.
	EventDataStoreArn *string

	// The maximum allowed size for events stored in the specified event data store.
	MaxEventSize types.MaxEventSize

	// The Amazon Resource Name (ARN) of the trail that has aggregation enabled.
	TrailARN *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutEventConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpPutEventConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpPutEventConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutEventConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPutEventConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutEventConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutEventConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutEventConfiguration",
	}
}
