// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies existing terms documents for the requested app client. When Terms and
// conditions and Privacy policy documents are configured, the app client displays
// links to them in the sign-up page of managed login for the app client.
//
// You can provide URLs for terms documents in the languages that are supported by [managed login localization]
// . Amazon Cognito directs users to the terms documents for their current
// language, with fallback to default if no document exists for the language.
//
// Each request accepts one type of terms document and a map of language-to-link
// for that document type. You must provide both types of terms documents in at
// least one language before Amazon Cognito displays your terms documents. Supply
// each type in separate requests.
//
// For more information, see [Terms documents].
//
// Amazon Cognito evaluates Identity and Access Management (IAM) policies in
// requests for this API operation. For this operation, you must use IAM
// credentials to authorize requests, and you must grant yourself the corresponding
// IAM permission in a policy.
//
// # Learn more
//
// [Signing Amazon Web Services API Requests]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html
// [Terms documents]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html#managed-login-terms-documents
// [managed login localization]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html#managed-login-localization
// [Signing Amazon Web Services API Requests]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html
func (c *Client) UpdateTerms(ctx context.Context, params *UpdateTermsInput, optFns ...func(*Options)) (*UpdateTermsOutput, error) {
	if params == nil {
		params = &UpdateTermsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateTerms", params, optFns, c.addOperationUpdateTermsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateTermsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateTermsInput struct {

	// The ID of the terms document that you want to update.
	//
	// This member is required.
	TermsId *string

	// The ID of the user pool that contains the terms that you want to update.
	//
	// This member is required.
	UserPoolId *string

	// This parameter is reserved for future use and currently accepts only one value.
	Enforcement types.TermsEnforcementType

	// A map of URLs to languages. For each localized language that will view the
	// requested TermsName , assign a URL. A selection of cognito:default displays for
	// all languages that don't have a language-specific URL.
	//
	// For example, "cognito:default": "https://terms.example.com", "cognito:spanish":
	// "https://terms.example.com/es" .
	Links map[string]string

	// The new name that you want to apply to the requested terms documents.
	TermsName *string

	// This parameter is reserved for future use and currently accepts only one value.
	TermsSource types.TermsSourceType

	noSmithyDocumentSerde
}

type UpdateTermsOutput struct {

	// A summary of the updates to your terms documents.
	Terms *types.TermsType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateTermsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateTerms{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateTerms{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateTerms"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateTermsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateTerms(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateTerms(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateTerms",
	}
}
