// Code generated by smithy-go-codegen DO NOT EDIT.

package computeoptimizer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns idle resource recommendations. Compute Optimizer generates
// recommendations for idle resources that meet a specific set of requirements. For
// more information, see [Resource requirements]in the Compute Optimizer User Guide
//
// [Resource requirements]: https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html
func (c *Client) GetIdleRecommendations(ctx context.Context, params *GetIdleRecommendationsInput, optFns ...func(*Options)) (*GetIdleRecommendationsOutput, error) {
	if params == nil {
		params = &GetIdleRecommendationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetIdleRecommendations", params, optFns, c.addOperationGetIdleRecommendationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetIdleRecommendationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetIdleRecommendationsInput struct {

	// Return the idle resource recommendations to the specified Amazon Web Services
	// account IDs.
	//
	// If your account is the management account or the delegated administrator of an
	// organization, use this parameter to return the idle resource recommendations to
	// specific member accounts.
	//
	// You can only specify one account ID per request.
	AccountIds []string

	// An array of objects to specify a filter that returns a more specific list of
	// idle resource recommendations.
	Filters []types.IdleRecommendationFilter

	// The maximum number of idle resource recommendations to return with a single
	// request.
	//
	// To retrieve the remaining results, make another request with the returned
	// nextToken value.
	MaxResults *int32

	// The token to advance to the next page of idle resource recommendations.
	NextToken *string

	// The order to sort the idle resource recommendations.
	OrderBy *types.OrderBy

	// The ARN that identifies the idle resource.
	ResourceArns []string

	noSmithyDocumentSerde
}

type GetIdleRecommendationsOutput struct {

	// An array of objects that describe errors of the request.
	Errors []types.IdleRecommendationError

	// An array of objects that describe the idle resource recommendations.
	IdleRecommendations []types.IdleRecommendation

	// The token to advance to the next page of idle resource recommendations.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetIdleRecommendationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetIdleRecommendations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetIdleRecommendations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetIdleRecommendations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetIdleRecommendations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetIdleRecommendations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetIdleRecommendations",
	}
}
