// Code generated by smithy-go-codegen DO NOT EDIT.

package computeoptimizerautomation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizerautomation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves details about a specific automation event.
func (c *Client) GetAutomationEvent(ctx context.Context, params *GetAutomationEventInput, optFns ...func(*Options)) (*GetAutomationEventOutput, error) {
	if params == nil {
		params = &GetAutomationEventInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAutomationEvent", params, optFns, c.addOperationGetAutomationEventMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAutomationEventOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAutomationEventInput struct {

	//  The ID of the automation event to retrieve.
	//
	// This member is required.
	EventId *string

	noSmithyDocumentSerde
}

type GetAutomationEventOutput struct {

	// The Amazon Web Services account ID associated with the automation event.
	AccountId *string

	// The timestamp when the automation event completed.
	CompletedTimestamp *time.Time

	// The timestamp when the automation event was created.
	CreatedTimestamp *time.Time

	//  Contains information about estimated monthly cost savings.
	EstimatedMonthlySavings *types.EstimatedMonthlySavings

	// A description of the automation event.
	EventDescription *string

	// The ID of the automation event to retrieve.
	EventId *string

	// The current status of the automation event.
	EventStatus types.EventStatus

	// The reason for the current event status.
	EventStatusReason *string

	// The type of automation event.
	EventType types.EventType

	// The ID of the recommended action associated with this automation event.
	RecommendedActionId *string

	// The Amazon Web Services Region where the automation event occurred.
	Region *string

	// The Amazon Resource Name (ARN) of the resource affected by the automation event.
	ResourceArn *string

	// The ID of the resource affected by the automation event.
	ResourceId *string

	// The type of resource affected by the automation event.
	ResourceType types.ResourceType

	// The ID of the automation rule that triggered this event.
	RuleId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAutomationEventMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetAutomationEvent{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetAutomationEvent{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAutomationEvent"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetAutomationEventValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAutomationEvent(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAutomationEvent(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAutomationEvent",
	}
}
