// Code generated by smithy-go-codegen DO NOT EDIT.

package computeoptimizerautomation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizerautomation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves details about a specific automation rule.
func (c *Client) GetAutomationRule(ctx context.Context, params *GetAutomationRuleInput, optFns ...func(*Options)) (*GetAutomationRuleOutput, error) {
	if params == nil {
		params = &GetAutomationRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAutomationRule", params, optFns, c.addOperationGetAutomationRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAutomationRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAutomationRuleInput struct {

	//  The ARN of the rule to retrieve.
	//
	// This member is required.
	RuleArn *string

	noSmithyDocumentSerde
}

type GetAutomationRuleOutput struct {

	// The 12-digit Amazon Web Services account ID that owns this automation rule.
	AccountId *string

	// The timestamp when the automation rule was created.
	CreatedTimestamp *time.Time

	//  A set of conditions that specify which recommended action qualify for
	// implementation. When a rule is active and a recommended action matches these
	// criteria, Compute Optimizer implements the action at the scheduled run time. You
	// can specify up to 20 conditions per filter criteria and 20 values per condition.
	Criteria *types.Criteria

	// A description of the automation rule.
	Description *string

	// The timestamp when the automation rule was last updated.
	LastUpdatedTimestamp *time.Time

	// The name of the automation rule.
	Name *string

	// Configuration settings for organization-wide automation rules.
	OrganizationConfiguration *types.OrganizationConfiguration

	// A string representation of a decimal number between 0 and 1 (having up to 30
	// digits after the decimal point) that determines the priority of the rule.
	Priority *string

	// List of recommended action types that this rule can execute.
	RecommendedActionTypes []types.RecommendedActionType

	// The Amazon Resource Name (ARN) of the automation rule.
	RuleArn *string

	// The unique identifier of the automation rule.
	RuleId *string

	// The revision number of the automation rule.
	RuleRevision *int64

	// The type of automation rule.
	RuleType types.RuleType

	// Configuration for scheduling when automation rules should execute, including
	// timing and execution windows.
	Schedule *types.Schedule

	// The current status of the automation rule (Active or Inactive).
	Status types.RuleStatus

	// The tags associated with the automation rule.
	Tags []types.Tag

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAutomationRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetAutomationRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetAutomationRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAutomationRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetAutomationRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAutomationRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAutomationRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAutomationRule",
	}
}
